/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.system.settings;

import com.hello2morrow.sonargraph.core.model.system.settings.IPreferencePersistence;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFilePersistence
implements IPreferencePersistence {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyFilePersistence.class);
    private final TFile m_file;
    private final List<String> m_keys;
    private final Properties m_properties;

    protected PropertyFilePersistence() {
        this.m_file = null;
        this.m_keys = null;
        this.m_properties = null;
    }

    public PropertyFilePersistence(TFile file, String[] keys) {
        assert (file != null) : "Parameter 'dir' of method 'PropertyFilePersistence' must not be null";
        assert (keys != null && keys.length > 0) : "Parameter 'propertyName' of method 'PropertyFilePersistence' must not be empty";
        this.m_file = file;
        this.m_keys = Arrays.asList(keys);
        this.m_properties = new Properties();
    }

    @Override
    public void load(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'load' must not be null";
        if (!this.m_file.exists()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "Configuration file '" + this.m_file.getNormalizedAbsolutePath() + "' has not been found.", new Object[0]);
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (TFileInputStream inStream = new TFileInputStream((File)this.m_file);){
                this.m_properties.load((InputStream)inStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String errorMsg = "Failed to load configuration: " + ExceptionUtility.collectFirstAndLast((Throwable)e);
            LOGGER.warn(errorMsg, (Throwable)e);
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, (Throwable)e, errorMsg, new Object[0]);
            return;
        }
    }

    @Override
    public final List<String> getKeys() {
        return Collections.unmodifiableList(this.m_keys);
    }

    @Override
    public String getValue(String key) {
        if (this.m_properties == null) {
            return null;
        }
        return this.m_properties.getProperty(key);
    }

    @Override
    public final String setValue(String key, String value) {
        assert (key != null) : "Parameter 'key' of method 'setValue' must not be null";
        assert (value != null) : "Parameter 'value' of method 'setValue' must not be null";
        assert (this.m_keys.contains(key)) : "Property key must be present in the supported keys";
        Object previous = this.m_properties.put(key, value);
        return previous == null ? null : (String)previous;
    }

    @Override
    public void save(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        TFile file = new TFile((File)this.m_file);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (TFileOutputStream outStream = new TFileOutputStream((File)file);){
                this.m_properties.store((OutputStream)outStream, "Configuration file for Sonargraph. Do not edit!");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            String errorMsg = "Failed to save properties to file: " + e.getMessage();
            LOGGER.warn(errorMsg, (Throwable)e);
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)e, errorMsg, new Object[0]);
        }
    }
}

