/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.base;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlRootElementDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlRootElementDetector.class);
    private static SAXParserFactory s_factory;
    private static SAXParser s_saxParser;
    private static DefaultHandler s_processor;

    private XmlRootElementDetector() {
    }

    public static String process(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'process' must not be null";
        try {
            Throwable throwable = null;
            Object var2_9 = null;
            try (TFileInputStream is = new TFileInputStream((File)file);){
                if (s_factory == null) {
                    s_factory = SAXParserFactory.newInstance();
                }
                if (s_saxParser == null) {
                    s_saxParser = s_factory.newSAXParser();
                }
                if (s_processor == null) {
                    s_processor = new DefaultHandler(){

                        @Override
                        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                            throw new RootElementProcessedException(qName);
                        }
                    };
                }
                s_saxParser.parse((InputStream)is, s_processor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RootElementProcessedException ex) {
            return ex.getMessage();
        }
        catch (SAXParseException ex) {
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            LOGGER.error("Failed to determine root element of " + file.getAbsolutePath(), (Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            LOGGER.error("Fatal configuration exception", (Throwable)ex);
        }
        catch (SAXException ex) {
            LOGGER.error("Generic SAXException while processing " + file.getAbsolutePath(), (Throwable)ex);
        }
        return null;
    }

    private static class RootElementProcessedException
    extends SAXException {
        private static final long serialVersionUID = 2126363921505871938L;

        public RootElementProcessedException(String rootElement) {
            super(rootElement);
        }
    }
}

