/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.workspaceimport;

import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportCandidate;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportRootDirectoryPathCandidate;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ImportModuleCandidate
extends ImportCandidate {
    private String m_name;
    private Set<String> m_dependencies;
    private Set<String> m_exportedDependencies;
    private List<ImportRootDirectoryPathCandidate> m_rootPaths;
    private String m_description;

    public ImportModuleCandidate(TFile file, String name) {
        super(file);
        assert (name != null) : "Parameter 'name' of method 'EclipseImportModuleCandidate' must not be null";
        this.m_name = name.trim();
    }

    public final void setName(String name) {
        assert (name != null) : "Parameter 'name' of method 'setName' must not be null";
        this.m_name = name.trim();
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    public String getModulePath() {
        return this.getFile().getAbsolutePath();
    }

    @Override
    public final String getImageResourceName() {
        return "JavaModule";
    }

    public final void addRootPath(ImportRootDirectoryPathCandidate pathCandidate) {
        assert (pathCandidate != null) : "Parameter 'pathCandidate' of method 'addRootPath' must not be null";
        if (this.m_rootPaths == null) {
            this.m_rootPaths = new ArrayList<ImportRootDirectoryPathCandidate>();
        }
        this.m_rootPaths.add(pathCandidate);
        if (pathCandidate.hasContent() && !this.isIncluded()) {
            this.setIncluded(true);
        }
    }

    public final boolean hasRootPath(String rootPath, boolean isSourceRoot) {
        assert (rootPath != null) : "Parameter 'rootPath' of method 'hasRootPath' must not be null";
        if (this.m_rootPaths != null) {
            for (ImportRootDirectoryPathCandidate pathCandidate : this.m_rootPaths) {
                if (!rootPath.equals(pathCandidate.getFile().getAbsolutePath()) || pathCandidate.hasSource() != isSourceRoot) continue;
                return true;
            }
        }
        return false;
    }

    public final List<ImportRootDirectoryPathCandidate> getRootPaths() {
        return this.m_rootPaths != null ? this.m_rootPaths : Collections.emptyList();
    }

    public final void addDependency(String dependency) {
        assert (dependency != null && dependency.length() > 0) : "Parameter 'dependency' of method 'addDependency' must not be empty";
        if (this.m_dependencies == null) {
            this.m_dependencies = new LinkedHashSet<String>();
        }
        this.m_dependencies.add(dependency);
    }

    public final List<String> getDependencies() {
        return this.m_dependencies != null ? new ArrayList<String>(this.m_dependencies) : Collections.emptyList();
    }

    public final void addExportedDependency(String dependency) {
        assert (dependency != null && !dependency.isEmpty()) : "Parameter 'dependency' of method 'addExportedDependency' must not be empty";
        if (this.m_exportedDependencies == null) {
            this.m_exportedDependencies = new LinkedHashSet<String>();
        }
        this.m_exportedDependencies.add(dependency);
    }

    public final List<String> getExportedDependencies() {
        return this.m_exportedDependencies != null ? new ArrayList<String>(this.m_exportedDependencies) : Collections.emptyList();
    }

    public final void setDescription(String description) {
        this.m_description = description;
    }

    public final String getDescription() {
        return this.m_description;
    }

    public final String toString() {
        return this.m_name;
    }

    public static void checkDuplicates(Set<ImportModuleCandidate> moduleCandidates) {
        assert (moduleCandidates != null) : "Parameter 'moduleCandidates' of method 'checkDuplicates' must not be null";
        if (moduleCandidates.isEmpty()) {
            return;
        }
        HashSet classRoots = new HashSet();
        HashSet<TFile> sourceRoots = new HashSet<TFile>();
        for (ImportModuleCandidate nextModuleCandidate : moduleCandidates) {
            for (ImportRootDirectoryPathCandidate nextRootDirectoryPathCandidate : nextModuleCandidate.getRootPaths()) {
                HashSet<Object> alreadySeen = nextRootDirectoryPathCandidate.hasSource() ? sourceRoots : classRoots;
                boolean noDuplicate = alreadySeen.add(nextRootDirectoryPathCandidate.getFile());
                if (noDuplicate) continue;
                nextRootDirectoryPathCandidate.setAlreadyInWorkspace(true);
            }
        }
    }
}

