/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.settings;

import com.hello2morrow.sonargraph.core.model.system.settings.IVisualStudioProjectType;
import com.hello2morrow.sonargraph.core.model.system.settings.UnsupportedProjectType;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;

public final class VisualStudioProjectType
extends Enum<VisualStudioProjectType>
implements IVisualStudioProjectType {
    public static final /* enum */ VisualStudioProjectType XAMARIN_ANDROID = new VisualStudioProjectType("{EFBA0AD7-5A72-4C68-AF49-83D382785DCF}", "Xamarin Android C# Project");
    public static final /* enum */ VisualStudioProjectType MONOTOUCH_CSHARP_PROJECT = new VisualStudioProjectType("{6BC8ED88-2882-458C-8E55-DFD12B67127B}", "Monotouch C# Project");
    public static final /* enum */ VisualStudioProjectType STANDARD_CSHARP_PROJECT = new VisualStudioProjectType("{FAE04EC0-301F-11D3-BF4B-00C04F79EFBC}", "Standard C# Project");
    public static final /* enum */ VisualStudioProjectType STANDARD_CPLUSPLUS_PROJECT = new VisualStudioProjectType("{8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942}", "Standard C,C++ Project");
    public static final /* enum */ VisualStudioProjectType STORE_APP_WINDOWS_PHONE_8_1 = new VisualStudioProjectType("{76F1466A-8B6D-4E39-A767-685A06062A39}", "Store App Windows Phone 8.1");
    public static final /* enum */ VisualStudioProjectType STORE_APP_WINDOWS_PHONE_8_1_SILVERLIGHT = new VisualStudioProjectType("{C089C8C0-30E0-4E22-80C0-CE093F111A43}", "Store App Windows Phone 8.1");
    public static final /* enum */ VisualStudioProjectType STORE_APP_WINDOWS_8_1 = new VisualStudioProjectType("{BC8A1FFA-BEE3-4634-8014-F334798102B3}", "Store App Windows 8.1");
    public static final /* enum */ VisualStudioProjectType STORE_APP_UNIVERSAL = new VisualStudioProjectType("{D954291E-2A0B-460D-934E-DC6B0785DB48}", "Store App Universal");
    public static final /* enum */ VisualStudioProjectType STORE_APP_PORTABLE_UNIVERSAL = new VisualStudioProjectType("{786C830F-07A1-408B-BD7F-6EE04809D6DB}", "Store App Portable Universal");
    public static final /* enum */ VisualStudioProjectType WPF = new VisualStudioProjectType("{60DC8134-EBA5-43B8-BCC9-BB4BC16C2548}", "Windows Presentation Foundation");
    public static final /* enum */ VisualStudioProjectType SOLUTION_FOLDER = new VisualStudioProjectType("{2150E333-8FDC-42A3-9474-1A3956D46DE8}", "Solution Folder");
    public static final /* enum */ VisualStudioProjectType ASP_DOTNET_CORE_PROJECT = new VisualStudioProjectType("{9A19103F-16F7-4668-BE54-9A1E7A4F7556}", "ASP.NET Core Project");
    public static final /* enum */ VisualStudioProjectType ASP_DOTNET_5 = new VisualStudioProjectType("{8BB2217D-0F2D-49D1-97BC-3654ED321F3B}", "ASP.NET 5");
    public static final /* enum */ VisualStudioProjectType ASP_DOTNET_MVC_1 = new VisualStudioProjectType("{603C0E0B-DB56-11DC-BE95-000D561079B0}", "ASP.NET MVC 1");
    public static final /* enum */ VisualStudioProjectType ASP_DOTNET_MVC_2 = new VisualStudioProjectType("{F85E285D-A4E0-4152-9332-AB1D724D3325}", "ASP.NET MVC 2");
    public static final /* enum */ VisualStudioProjectType ASP_DOTNET_MVC_3 = new VisualStudioProjectType("{E53F8FEA-EAE0-44A6-8774-FFD645390401}", "ASP.NET MVC 3");
    public static final /* enum */ VisualStudioProjectType ASP_DOTNET_MVC_4 = new VisualStudioProjectType("{E3E379DF-F4C6-4180-9B81-6769533ABE47}", "ASP.NET MVC 4");
    public static final /* enum */ VisualStudioProjectType ASP_DOTNET_MVC_5 = new VisualStudioProjectType("{349C5851-65DF-11DA-9384-00065B846F21}", "ASP.NET MVC 5");
    private final String m_projectTypeId;
    private final String m_presentationName;
    private static final /* synthetic */ VisualStudioProjectType[] ENUM$VALUES;

    static {
        ENUM$VALUES = new VisualStudioProjectType[]{XAMARIN_ANDROID, MONOTOUCH_CSHARP_PROJECT, STANDARD_CSHARP_PROJECT, STANDARD_CPLUSPLUS_PROJECT, STORE_APP_WINDOWS_PHONE_8_1, STORE_APP_WINDOWS_PHONE_8_1_SILVERLIGHT, STORE_APP_WINDOWS_8_1, STORE_APP_UNIVERSAL, STORE_APP_PORTABLE_UNIVERSAL, WPF, SOLUTION_FOLDER, ASP_DOTNET_CORE_PROJECT, ASP_DOTNET_5, ASP_DOTNET_MVC_1, ASP_DOTNET_MVC_2, ASP_DOTNET_MVC_3, ASP_DOTNET_MVC_4, ASP_DOTNET_MVC_5};
    }

    public static VisualStudioProjectType fromStandardName(String standardName) throws IllegalArgumentException {
        assert (standardName != null) : "'standardName' must not be null";
        assert (standardName.length() > 0) : "'standardName' must not be empty";
        String name = StringUtility.convertStandardNameToConstantName((String)standardName);
        return VisualStudioProjectType.valueOf(name);
    }

    public static IVisualStudioProjectType getType(String id) {
        VisualStudioProjectType[] visualStudioProjectTypeArray = VisualStudioProjectType.values();
        int n = visualStudioProjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            VisualStudioProjectType next = visualStudioProjectTypeArray[n2];
            if (next.getProjectTypeId().equals(id)) {
                return next;
            }
            ++n2;
        }
        return new UnsupportedProjectType(id);
    }

    private VisualStudioProjectType(String projectTypeId, String presentationName) {
        assert (projectTypeId != null && projectTypeId.length() > 0) : "Parameter 'projectTypeId' of method 'CSharpVisualStudioProjectType' must not be empty";
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'CSharpVisualStudioProjectType' must not be empty";
        this.m_projectTypeId = projectTypeId;
        this.m_presentationName = presentationName;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    @Override
    public String getProjectTypeId() {
        return this.m_projectTypeId;
    }

    public static VisualStudioProjectType[] values() {
        VisualStudioProjectType[] visualStudioProjectTypeArray = ENUM$VALUES;
        int n = visualStudioProjectTypeArray.length;
        VisualStudioProjectType[] visualStudioProjectTypeArray2 = new VisualStudioProjectType[n];
        System.arraycopy(ENUM$VALUES, 0, visualStudioProjectTypeArray2, 0, n);
        return visualStudioProjectTypeArray2;
    }

    public static VisualStudioProjectType valueOf(String string) {
        return Enum.valueOf(VisualStudioProjectType.class, string);
    }
}

