/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.qualitygate;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.Operator;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import java.util.ArrayList;
import java.util.stream.Collectors;

public final class MetricValueDiffQualityGateCondition
extends AbstractQualityGateElement
implements IQualityGateCondition {
    private final Float m_diffThreshold;
    private final String m_metricId;
    private final Float m_diffThresholdRelative;
    private final Operator m_operator;

    public MetricValueDiffQualityGateCondition(NamedElement parent, String metricId, Operator operator, Float diffThreshold, Float diffThresholdRelative) {
        super(parent);
        assert (operator != null) : "Parameter 'operator' of method 'MetricValueDiffQualityGateCondition' must not be null";
        assert (metricId != null && metricId.length() > 0) : "Parameter 'metricId' of method 'MetricValueDiffQualityGateCondition' must not be empty";
        assert (diffThreshold != null || diffThresholdRelative != null) : "One of 'diffThreshold' or 'diffThresholdRelative' must not be null";
        this.m_metricId = metricId;
        this.m_operator = operator;
        this.m_diffThreshold = diffThreshold;
        this.m_diffThresholdRelative = diffThresholdRelative;
    }

    public String getMetricId() {
        return this.m_metricId;
    }

    public Operator getOperator() {
        return this.m_operator;
    }

    public Float getDiffThreshold() {
        return this.m_diffThreshold;
    }

    public Float getDiffThresholdRelative() {
        return this.m_diffThresholdRelative;
    }

    @Override
    public String getShortName() {
        return this.getPresentationName(true);
    }

    @Override
    public String getImageResourceName() {
        return "QualityGateCondition";
    }

    @Override
    public String getDebugInfo() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(Element.escapeSpecialCharacters(this.m_metricId));
        result.add(this.m_operator.getSymbol());
        if (this.m_diffThreshold != null) {
            result.add(NumberUtility.format((Number)this.m_diffThreshold));
        } else {
            result.add("n/a");
        }
        if (this.m_diffThresholdRelative != null) {
            result.add(NumberUtility.format((Number)this.m_diffThresholdRelative));
        } else {
            result.add("n/a");
        }
        return result.stream().collect(Collectors.joining(Element.INNER_NAME_PARTS_SEPARATOR));
    }

    @Override
    public String getPresentationName(boolean shortName) {
        if (shortName) {
            ArrayList<String> builder = new ArrayList<String>();
            builder.add("BaselineMetricCondition");
            builder.add(this.getMetricId());
            builder.add(this.getOperator().getStandardName());
            if (this.m_diffThreshold != null) {
                builder.add(this.m_diffThreshold.toString());
            } else {
                builder.add("n/a");
            }
            if (this.m_diffThresholdRelative != null) {
                builder.add(this.m_diffThresholdRelative.toString());
            } else {
                builder.add("n/a");
            }
            return builder.stream().collect(Collectors.joining(INNER_NAME_PARTS_SEPARATOR));
        }
        return MetricValueDiffQualityGateCondition.createPresentationNameLong(this.getMetricId(), this.getOperator(), this.getDiffThreshold(), this.getDiffThresholdRelative());
    }

    public static String createPresentationNameLong(String metricId, Operator operator, Float thresholdAbsolute, Float thresholdRelative) {
        assert (metricId != null && metricId.length() > 0) : "Parameter 'metricId' of method 'createPresentationNameLong' must not be empty";
        assert (operator != null) : "Parameter 'operator' of method 'createPresentationNameLong' must not be null";
        StringBuilder builder = new StringBuilder("Change of metric value for ");
        builder.append("'").append(metricId).append("' must be ");
        if (thresholdAbsolute != null) {
            builder.append(operator.getPresentationName()).append(" ");
            builder.append(NumberUtility.format((Number)thresholdAbsolute)).append(" (absolute)");
            if (thresholdRelative != null) {
                builder.append(" and ");
            }
        }
        if (thresholdRelative != null) {
            builder.append(operator.getPresentationName()).append(" ");
            builder.append(NumberUtility.format((Number)Float.valueOf(thresholdRelative.floatValue() * 100.0f))).append("%");
        }
        return builder.toString();
    }
}

