/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.PhysicalImpactDependencyEndpointCollector;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.Collection;
import java.util.Collections;

final class TwoEndpoints
extends PhysicalImpactDependencyEndpointCollector
implements IWorkerContext {
    private final NamedElement m_from;
    private final NamedElement m_to;
    private final Mode m_mode;
    private final boolean m_flat;
    private final boolean m_toIsProgrammingElement;
    private final boolean m_firstDependencyOnly;
    private boolean m_firstDependencyAdded;

    TwoEndpoints(NamedElement from, NamedElement to, Mode mode, boolean flat, boolean firstDependencyOnly) {
        assert (from != null) : "Parameter 'from' of method 'TwoEndpoints' must not be null";
        assert (to != null) : "Parameter 'to' of method 'TwoEndpoints' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'TwoEndpoints' must not be null";
        this.m_from = from;
        this.m_to = to;
        this.m_mode = mode;
        this.m_flat = flat;
        this.m_toIsProgrammingElement = to instanceof ProgrammingElement;
        this.m_firstDependencyOnly = firstDependencyOnly;
    }

    @Override
    public NamedElement getNextCandidateForNodeAdapterLookUp(NamedElement element) {
        if (this.m_toIsProgrammingElement && element instanceof ProgrammingElement) {
            return null;
        }
        NamedElement nextCandidate = super.getNextCandidateForNodeAdapterLookUp(element);
        if (nextCandidate != null && this.m_flat && TwoEndpoints.isRecursiveElement(nextCandidate) && nextCandidate != this.m_from && nextCandidate != this.m_to) {
            return null;
        }
        return nextCandidate;
    }

    @Override
    public Collection<ProgrammingElement> getProgrammingElements(NamedElement forNamedElement) {
        if (this.m_toIsProgrammingElement && forNamedElement instanceof ProgrammingElement) {
            return Collections.singleton((ProgrammingElement)forNamedElement);
        }
        if (this.m_flat && TwoEndpoints.isRecursiveElement(forNamedElement)) {
            return TwoEndpoints.getProgrammingElementsFlat(forNamedElement);
        }
        return super.getProgrammingElements(forNamedElement);
    }

    private boolean internalAddDependency(NamedElement from, NamedElement to) {
        assert (from != null) : "Parameter 'from' of method 'internalAddDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'internalAddDependency' must not be null";
        switch (this.m_mode) {
            case EXTERNAL_BY_INSTANCE: 
            case INTERNAL_BY_INSTANCE: {
                if (from == this.m_from) break;
                return false;
            }
            case EXTERNAL_BY_NAME: 
            case INTERNAL_BY_NAME: {
                if (from.getName().equals(this.m_from.getName())) break;
                return false;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf((Object)this.m_mode);
                break;
            }
        }
        switch (this.m_mode) {
            case EXTERNAL_BY_INSTANCE: {
                return from != to;
            }
            case EXTERNAL_BY_NAME: {
                return !from.getName().equals(to.getName());
            }
            case INTERNAL_BY_INSTANCE: {
                return from == to;
            }
            case INTERNAL_BY_NAME: {
                return from.getName().equals(to.getName());
            }
        }
        assert (false) : "Unhandled mode: " + String.valueOf((Object)this.m_mode);
        return false;
    }

    @Override
    public boolean addDependency(NamedElement from, NamedElement to, Dependency dependency) {
        assert (from != null) : "Parameter 'from' of method 'addDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'addDependency' must not be null";
        boolean add = this.internalAddDependency(from, to);
        this.m_firstDependencyAdded |= add;
        return add;
    }

    public boolean hasBeenCanceled() {
        if (this.m_firstDependencyOnly) {
            return this.m_firstDependencyAdded;
        }
        return false;
    }

    static enum Mode {
        EXTERNAL_BY_INSTANCE,
        EXTERNAL_BY_NAME,
        INTERNAL_BY_INSTANCE,
        INTERNAL_BY_NAME;

    }
}

