/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.IWorkspace;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotComponentContainer;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.system.IFiles;
import com.hello2morrow.sonargraph.core.model.system.MetricValues;
import com.hello2morrow.sonargraph.core.model.system.NeedsReparse;
import com.hello2morrow.sonargraph.core.model.system.ParserModel;
import com.hello2morrow.sonargraph.core.model.system.Root;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.integration.access.foundation.AggregatingClassLoader;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class SoftwareSystem
extends Root
implements IBaseDirectory,
IModelServiceProvider {
    public static final String DEFAULT_MODIFIABLE_MODEL = "./Modifiable" + CoreFileType.MODEL.getDefaultExtension();
    private final Map<String, String> m_metaData = new THashMap();
    private final Properties m_systemProperties;
    private SoftwareSystemMode m_mode = SoftwareSystemMode.SYSTEM;
    private SoftwareSystemState m_state = SoftwareSystemState.UNDEFINED;
    private NeedsReparse m_needsReparseFlagModification = NeedsReparse.NONE;
    private AggregatingClassLoader m_classLoader;
    private VirtualModel m_currentModel;
    private TFile m_externalQualityModel;
    private String m_id;
    private String m_name;
    private String m_description;
    private boolean m_needsReparse;
    private boolean m_isClearable;
    private int m_numberOfInternalComponents;
    private Version m_versionOfAssociatedSnapshot;
    private TFile m_snapshot;

    public SoftwareSystem() {
        this.m_systemProperties = new Properties();
        this.addChild(new MetricValues(this));
    }

    public SoftwareSystem(String id, String name, Version version, Properties systemProperties) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'SoftwareSystem' must not be empty";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'SoftwareSystem' must not be empty";
        assert (version != null) : "Parameter 'version' of method 'SoftwareSystem' must not be null";
        assert (systemProperties != null) : "Parameter 'systemProperties' of method 'SoftwareSystem' must not be null";
        this.m_id = id;
        this.m_name = name;
        this.m_versionOfAssociatedSnapshot = version;
        this.m_description = "";
        this.m_systemProperties = systemProperties;
        this.addChild(new MetricValues(this));
    }

    public void setMetaData(String key, String value) {
        assert (key != null && key.length() > 0) : "Parameter 'key' of method 'setMetaData' must not be empty";
        if (value == null || value.isEmpty()) {
            this.m_metaData.remove(key);
        } else {
            this.m_metaData.put(key, value);
        }
    }

    public String getMetaData(String key) {
        assert (key != null && key.length() > 0) : "Parameter 'key' of method 'getMetaData' must not be empty";
        return this.m_metaData.get(key);
    }

    public Map<String, String> getMetaData() {
        return Collections.unmodifiableMap(this.m_metaData);
    }

    @Override
    @Property
    public String getInformation() {
        if (this.m_metaData.isEmpty()) {
            return "";
        }
        StringBuilder info = new StringBuilder();
        for (Map.Entry<String, String> next : this.m_metaData.entrySet()) {
            info.append(StringUtility.convertConstantNameToPresentationName((String)next.getKey())).append(" '").append(next.getValue()).append("'").append("\n");
        }
        info.deleteCharAt(info.length() - 1);
        return info.toString();
    }

    @Property
    public String state() {
        String state = StringUtility.capitalize((String)this.m_state.getPresentationName().toLowerCase());
        switch (this.m_state) {
            case UNDEFINED: 
            case CLOSED: {
                return state;
            }
            case OPENED: {
                return state + (this.needsReparse() ? " <needs refresh>" : "");
            }
            case MODEL_LOADED: {
                switch (this.m_mode) {
                    case SYSTEM: {
                        return state + (this.m_snapshot != null ? " (applied snapshot)" : "") + (this.needsReparse() ? " <needs refresh>" : "");
                    }
                    case SYSTEM_LOADED_FROM_SNAPSHOT: 
                    case SYSTEM_ATTACHED_TO_SNAPSHOT: 
                    case SYSTEM_EXTRACTED_AND_ATTACHED_TO_SNAPSHOT: {
                        return state + " (" + this.m_mode.getPresentationName().toLowerCase() + ")" + (this.needsReparse() ? " <needs refresh>" : "");
                    }
                }
                assert (false) : "Unhandled mode: " + String.valueOf((Object)this.m_mode);
                return "";
            }
        }
        assert (false) : "Unhandled state: " + String.valueOf((Object)this.m_state);
        return "";
    }

    @Property
    public String snapshotInfo() {
        return this.m_snapshot != null ? FileUtility.getCanonicalFilePath((TFile)this.m_snapshot) + "\n" + StringUtility.getDateTimeStringFromLocale((Date)new Date(this.m_snapshot.lastModified())) : "";
    }

    public String getSystemProperty(String key) {
        assert (key != null && key.length() > 0) : "Parameter 'key' of method 'getProperty' must not be empty";
        return this.m_systemProperties.getProperty(key);
    }

    public void setSystemProperty(String key, String value) {
        assert (key != null && key.length() > 0) : "Parameter 'key' of method 'setProperty' must not be empty";
        if (value == null) {
            this.m_systemProperties.remove(key);
        } else {
            assert (value != null && value.length() > 0) : "Parameter 'value' of method 'setProperty' must not be empty";
            this.m_systemProperties.setProperty(key, value);
        }
    }

    public Properties getSystemProperties() {
        return this.m_systemProperties;
    }

    public ParserModel getParserModel() {
        return this.getUniqueExistingChild(IFiles.class).getParserModel();
    }

    public SoftwareSystemMode getMode() {
        return this.m_mode;
    }

    public void setAttachedToSnapshot(TFile snapshot, boolean systemExtracted) {
        assert (snapshot != null) : "Parameter 'snapshot' of method 'setAttachedToSnapshot' must not be null";
        this.m_mode = systemExtracted ? SoftwareSystemMode.SYSTEM_EXTRACTED_AND_ATTACHED_TO_SNAPSHOT : SoftwareSystemMode.SYSTEM_ATTACHED_TO_SNAPSHOT;
        this.m_snapshot = snapshot;
    }

    public void setLoadedFromSnapshot(TFile snapshot) {
        assert (snapshot != null) : "Parameter 'snapshot' of method 'setLoadedFromSnapshot' must not be null";
        this.m_mode = SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT;
        this.m_snapshot = snapshot;
    }

    public void setLastAppliedSnapshot(TFile snapshot) {
        this.m_snapshot = snapshot;
    }

    public TFile getSnapshot() {
        return this.m_snapshot;
    }

    public void initializeNumberOfInternalComponents() {
        this.m_numberOfInternalComponents = 0;
    }

    public void clearNumberOfInternalComponents() {
        this.m_numberOfInternalComponents = -1;
    }

    public void incrementNumberOfInternalComponents() {
        assert (this.m_numberOfInternalComponents != -1) : "Has not been initialized";
        ++this.m_numberOfInternalComponents;
    }

    @IntProperty(undefinedValue=-1)
    public int getNumberOfComponents() {
        return this.m_numberOfInternalComponents;
    }

    public void setNumberOfInternalComponents(int numberOfInternalComponents) {
        this.m_numberOfInternalComponents = numberOfInternalComponents;
    }

    public String setName(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
        if (!this.m_name.equals(name)) {
            String oldName = this.m_name;
            this.m_name = name;
            return oldName;
        }
        return null;
    }

    public void setClassLoader(AggregatingClassLoader classLoader) {
        assert (classLoader != null) : "Parameter 'classLoader' of method 'setClassLoader' must not be null";
        assert (this.m_classLoader == null) : "'m_classLoader' of method 'setClassLoader' must  be null";
        this.m_classLoader = classLoader;
    }

    public AggregatingClassLoader getClassLoader() {
        assert (this.m_classLoader != null) : "'m_classLoader' of method 'getClassLoader' must not be null";
        return this.m_classLoader;
    }

    public void setModel(VirtualModel virtualModel) {
        assert (virtualModel != null) : "Parameter 'virtualModel' of method 'setVirtualModel' must not be null";
        this.m_currentModel = virtualModel;
    }

    @Override
    public VirtualModel getCurrentModel() {
        assert (this.m_currentModel != null) : "'m_currentModel' of method 'getCurrentModel' must not be null";
        return this.m_currentModel;
    }

    @Override
    public ElementWithIssues.IIssueManager getIssueManager() {
        assert (this.m_currentModel != null) : "'m_currentModel' of method 'getIssueManager' must not be null";
        return this.m_currentModel;
    }

    public MetricValues getMetricValues() {
        return this.getUniqueExistingChild(MetricValues.class);
    }

    public <T extends IVirtualModel> T getCurrentModel(Class<T> modelClass) {
        assert (modelClass != null) : "Parameter 'modelClass' of method 'getCurrentModel' must not be null";
        assert (this.m_currentModel != null) : "'m_currentModel' of method 'getCurrentModel' must not be null";
        if (modelClass.isAssignableFrom(this.m_currentModel.getClass())) {
            return (T)this.m_currentModel;
        }
        return null;
    }

    public List<VirtualModel> getAvailableVirtualModels() {
        return this.getUniqueExistingChild(IFiles.class).getAvailableVirtualModels();
    }

    public void removeIssuesOfInvalidElements() {
        this.getAvailableVirtualModels().forEach(vm -> vm.removeIssuesOfInvalidElements());
    }

    public void setExternalQualityModel(TFile qualityModel) {
        this.m_externalQualityModel = qualityModel;
    }

    public TFile getExternalQualityModel() {
        return this.m_externalQualityModel;
    }

    public Set<Language> getUsedLanguages() {
        return this.getUniqueExistingChild(IWorkspace.class).getUsedLanguages();
    }

    public Set<String> getUsedLanguageStandardNames() {
        Set<Language> usedLanguages = this.getUsedLanguages();
        HashSet<String> usedLanguageStandardNames = new HashSet<String>(usedLanguages.size());
        usedLanguages.forEach(l -> {
            boolean bl = usedLanguageStandardNames.add(l.getStandardName());
        });
        return usedLanguageStandardNames;
    }

    public List<? extends ISnapshotComponentContainer> getComponentContainer() {
        return this.getUniqueExistingChild(IWorkspace.class).getComponentContainer();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_id);
        writer.writeString(this.m_name);
        writer.writeString(this.m_description);
        for (Map.Entry<String, String> entry : this.m_metaData.entrySet()) {
            String key = entry.getKey();
            assert (key != null) : "'key' of method 'store' must not be null";
            writer.writeString(key);
            writer.writeString(entry.getValue());
        }
        writer.writeString(null);
        writer.writeString(this.m_versionOfAssociatedSnapshot.toString());
        writer.writeBoolean(this.m_isClearable);
        writer.writeBoolean(this.m_needsReparse);
        writer.writeInt(this.m_numberOfInternalComponents);
        this.getParserModel().store(writer);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_id = reader.readString();
        this.m_name = reader.readString();
        this.m_description = reader.readString();
        if (reader.getVersion() > 10) {
            String key;
            while ((key = reader.readString()) != null) {
                String value = reader.readString();
                this.m_metaData.put(key, value);
            }
        }
        this.m_versionOfAssociatedSnapshot = Version.create((String)reader.readString());
        this.m_isClearable = reader.readBoolean();
        this.m_needsReparse = reader.readBoolean();
        this.m_numberOfInternalComponents = reader.readInt();
        this.getParserModel().retrieve(reader);
    }

    public TFile getSystemDirectoryFile() {
        return this.getUniqueExistingChild(IFiles.class).getSystemDirectoryFile();
    }

    @Property
    public String getAbsolutePath() {
        return this.getUniqueExistingChild(IFiles.class).getSystemDirectoryFile().getAbsolutePath();
    }

    public String getSystemFileAbsolutePath() {
        return this.getUniqueExistingChild(IFiles.class).getSystemFile().getAbsolutePath();
    }

    public String getBaseDirectory() {
        return this.getUniqueExistingChild(IFiles.class).getSystemBaseDirectory().getAbsolutePath();
    }

    public TFile getHiddenDataDirectory() {
        return this.getUniqueExistingChild(IFiles.class).getHiddenDataDirectory();
    }

    @Override
    public String getImageResourceName() {
        return SoftwareSystem.class.getSimpleName();
    }

    public void setNeedsSave(boolean needsSave) {
        this.getUniqueExistingChild(IFiles.class).setSystemNeedsSave(needsSave);
    }

    public boolean needsSave() {
        return this.getUniqueExistingChild(IFiles.class).systemNeedsSave();
    }

    public boolean modifiableFilesNeedSave() {
        return this.getUniqueExistingChild(IFiles.class).modifiableFilesNeedSave();
    }

    public void setNeedsReparse(boolean needsReparse) {
        this.m_needsReparse = needsReparse;
        this.m_needsReparseFlagModification = needsReparse ? NeedsReparse.REQUIRED : NeedsReparse.NOT_REQUIRED;
    }

    public boolean needsReparse() {
        return this.m_needsReparse;
    }

    public NeedsReparse consumeNeedsReparseModification() {
        NeedsReparse result = this.m_needsReparseFlagModification;
        this.m_needsReparseFlagModification = NeedsReparse.NONE;
        return result;
    }

    public void setIsClearable(boolean isClearable) {
        this.m_isClearable = isClearable;
    }

    public boolean isClearable() {
        return this.m_isClearable;
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    @Override
    public TFile getDirectoryFile() {
        return this.getUniqueExistingChild(IFiles.class).getSystemBaseDirectory();
    }

    @Override
    public boolean isValid() {
        return this.m_state != SoftwareSystemState.CLOSED;
    }

    @Override
    public NamedElement getParent() {
        return null;
    }

    public void setId(String systemId) {
        assert (systemId != null && systemId.length() > 0) : "Parameter 'systemId' of method 'setId' must not be empty";
        this.m_id = systemId;
        this.getUniqueExistingChild(IFiles.class).setSystemId(systemId);
    }

    public String getId() {
        return this.m_id;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getShortName() {
        return this.m_name;
    }

    public void setDescription(String description) {
        assert (description != null) : "'name' must not be null";
        this.m_description = description;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public String getPresentationKind() {
        return "System";
    }

    public synchronized void setState(SoftwareSystemState state) {
        assert (state != null) : "'state' must not be null";
        this.m_state = state;
    }

    public synchronized SoftwareSystemState getState() {
        return this.m_state;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitSoftwareSystem(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Absolute path: ");
        builder.append(this.getAbsolutePath());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Last modified: ");
        builder.append(Iso8601DateFormat.formatDateAndTime((Date)new Date(this.getUniqueExistingChild(IFiles.class).getSystemFileTimestamp())));
        return builder.toString();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitSoftwareSystem(SoftwareSystem var1);
    }
}

