/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.representation;

import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationUtility;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class PEToLPECacheCreator
extends NamedElementVisitor
implements LogicalProgrammingElement.IVisitor,
AssignedElement.IVisitor {
    private final Map<ProgrammingElement, LogicalProgrammingElement> m_programmingElementToLogicalProgrammingElement = new HashMap<ProgrammingElement, LogicalProgrammingElement>();

    @Override
    public void visitLogicalProgrammingElement(LogicalProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitLogicalProgrammingElement' must not be null";
        for (ProgrammingElement programmingElement : element.getProgrammingElements()) {
            this.m_programmingElementToLogicalProgrammingElement.put(programmingElement, element);
        }
        this.visitChildrenOf(element);
    }

    @Override
    public void visitAssignedElement(AssignedElement element) {
        assert (element.getRepresentedElement() instanceof LogicalModuleProgrammingElement);
        LogicalProgrammingElement lpe = (LogicalProgrammingElement)element.getRepresentedElement();
        for (ProgrammingElement programmingElement : lpe.getProgrammingElements()) {
            this.m_programmingElementToLogicalProgrammingElement.put(programmingElement, lpe);
        }
    }

    @Override
    public final void visitChildrenOf(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
        for (NamedElement namedElement : element.getAllChildren(RepresentationUtility.REPRESENTATION_FILTER)) {
            namedElement.accept(this);
        }
    }

    public Map<ProgrammingElement, LogicalProgrammingElement> getPEToLPECache() {
        return Collections.unmodifiableMap(this.m_programmingElementToLogicalProgrammingElement);
    }
}

