/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.report;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.LastScriptRunnerExecutionStatus;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerData;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPattern;
import com.hello2morrow.sonargraph.core.model.metrics.ThresholdViolationIssue;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.report.IBasicReport;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.report.MetricRow;
import com.hello2morrow.sonargraph.core.model.report.Report;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResult;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SystemReport
implements IReport {
    private final Report m_report;
    private TFile m_targetFile;
    private final List<IBasicReport> m_moduleReports = new ArrayList<IBasicReport>();

    public SystemReport(Report report) {
        assert (report != null) : "Parameter 'report' of method 'SystemReport' must not be null";
        this.m_report = report;
    }

    public void addModuleReport(IBasicReport report) {
        assert (report != null) : "Parameter 'report' of method 'addModuleReport' must not be null";
        this.m_moduleReports.add(report);
    }

    @Override
    public IBasicReport.Focus getFocus() {
        return IBasicReport.Focus.SYSTEM_LEVEL;
    }

    @Override
    public String getTitle() {
        return this.m_report.getTitle();
    }

    @Override
    public String getElementName() {
        return this.m_report.getElementName();
    }

    @Override
    public String getQualityModelPath() {
        return this.m_report.getQualityModelPath();
    }

    @Override
    public long getTimestamp() {
        return this.m_report.getTimestamp();
    }

    @Override
    public List<Language> getUsedLanguages() {
        return this.m_report.getUsedLanguages();
    }

    @Override
    public Version getVersion() {
        return this.m_report.getVersion();
    }

    @Override
    public AnalyzerExecutionLevel getAnalyzerExecutionLevel() {
        return this.m_report.getAnalyzerExecutionLevel();
    }

    @Override
    public String getCurrentVirtualModel() {
        return this.m_report.getCurrentVirtualModel();
    }

    @Override
    public String getActiveProfile() {
        return this.m_report.getActiveProfile();
    }

    @Override
    public List<IMetricId> getMetricIds() {
        return this.m_report.getMetricIds();
    }

    @Override
    public Map<IMetricId, List<IMetricLevel>> getMetricIdsAsMap() {
        return this.m_report.getMetricIdsAsMap();
    }

    @Override
    public List<IMetricLevel> getLevels() {
        return this.m_report.getLevels();
    }

    @Override
    public Map<IMetricCategory, Map<IMetricDescriptor, IMetricValue>> getSystemLevelMetrics() {
        return this.m_report.getSystemLevelMetrics();
    }

    @Override
    public Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>> getSystemElementMetrics() {
        return this.m_report.getSystemElementMetrics();
    }

    @Override
    public SoftwareSystem getSoftwareSystem() {
        return this.m_report.getSoftwareSystem();
    }

    @Override
    public String getSystemDirectoryPath() {
        return this.m_report.getSystemDirectoryPath();
    }

    @Override
    public List<WildcardPattern> getWorkspaceFilters() {
        return this.m_report.getWorkspaceFilters();
    }

    @Override
    public List<WildcardPattern> getProductionCodeFilters() {
        return this.m_report.getProductionCodeFilters();
    }

    @Override
    public List<WildcardPattern> getIssueFilters() {
        return this.m_report.getIssueFilters();
    }

    @Override
    public Map<Module, Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>>> getModuleMetrics() {
        return Collections.emptyMap();
    }

    @Override
    public Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, Collection<MetricRow>>>> getElementMetricsForPrint(int maxMetricValueRowCountPerMetric) {
        Set<NamedElement> systemElements = this.getSystemElements();
        Set<IMetricLevel> systemLevels = this.getSystemElementMetrics().keySet();
        LinkedHashMap metricMap = new LinkedHashMap();
        this.m_report.getElementMetricsForPrint(maxMetricValueRowCountPerMetric).entrySet().stream().filter(entry -> systemLevels.contains(entry.getKey())).forEach(entry -> {
            Map map2 = metricMap.put((IMetricLevel)entry.getKey(), (Map)entry.getValue());
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry nextLevel : metricMap.entrySet()) {
            LinkedHashMap levelMap = new LinkedHashMap();
            for (Map.Entry nextCat : ((Map)nextLevel.getValue()).entrySet()) {
                LinkedHashMap catMap = new LinkedHashMap();
                for (Map.Entry nextDescriptor : ((Map)nextCat.getValue()).entrySet()) {
                    ArrayList<MetricRow> rows = new ArrayList<MetricRow>();
                    for (MetricRow nextRow : (Collection)nextDescriptor.getValue()) {
                        if (!systemElements.contains(nextRow.getAssociatedElement())) continue;
                        rows.add(nextRow);
                    }
                    if (rows.isEmpty()) continue;
                    catMap.put((IMetricDescriptor)nextDescriptor.getKey(), rows);
                }
                if (catMap.isEmpty()) continue;
                levelMap.put((IMetricCategory)nextCat.getKey(), catMap);
            }
            if (levelMap.isEmpty()) continue;
            result.put((IMetricLevel)nextLevel.getKey(), levelMap);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Set<NamedElement> getSystemElements() {
        return this.m_report.getSystemElements();
    }

    @Override
    public Map<Module, Set<NamedElement>> getModuleElements() {
        return Collections.emptyMap();
    }

    @Override
    public Map<External, Set<NamedElement>> getExternalSystemScopeElements() {
        return this.m_report.getExternalSystemScopeElements();
    }

    @Override
    public Map<External, Set<NamedElement>> getExternalModuleScopeElements() {
        return Collections.emptyMap();
    }

    @Override
    public int getTotalNumberOfIssues() {
        return this.m_report.getTotalNumberOfIssues();
    }

    @Override
    public List<Issue> getUnresolvedIssues() {
        return this.m_report.getUnresolvedIssues();
    }

    @Override
    public List<NamedElementIssue> getNamedElementIssues() {
        return this.m_report.getNamedElementIssues();
    }

    @Override
    public Map<IAnalyzerId, List<CycleGroupIssue>> getCycleIssues() {
        return this.m_report.getCycleIssues();
    }

    @Override
    public Map<IAnalyzerId, List<CycleGroupIssue>> getUnresolvedCycleIssues() {
        return this.m_report.getUnresolvedCycleIssues();
    }

    @Override
    public Set<IProviderId> getIssueProviderIds() {
        return this.m_report.getIssueProviderIds();
    }

    @Override
    public Set<IssueCategory> getIssueCategories() {
        return this.m_report.getIssueCategories();
    }

    @Override
    public Set<IIssueId> getIssueIds() {
        return this.m_report.getIssueIds();
    }

    @Override
    public List<DependencyIssue> getDependencyIssues() {
        return this.m_report.getDependencyIssues();
    }

    @Override
    public int getNumberOfResolutions() {
        return this.m_report.getNumberOfResolutions();
    }

    @Override
    public List<Resolution> getResolutions() {
        return this.m_report.getResolutions();
    }

    @Override
    public TFile getTargetFile() {
        return this.m_targetFile;
    }

    @Override
    public String getTimestampString() {
        return this.m_report.getTimestampString();
    }

    @Override
    public List<Module> getModules() {
        return this.m_report.getModules();
    }

    @Override
    public List<Module> getModulesSorted() {
        return this.m_report.getModulesSorted();
    }

    @Override
    public List<External> getExternal() {
        return this.m_report.getExternal();
    }

    @Override
    public ScriptRunnerConfiguration getScriptRunnerConfiguration() {
        return this.m_report.getScriptRunnerConfiguration();
    }

    @Override
    public List<ScriptRunnerData> getAutomatedScriptConfigurations() {
        return this.m_report.getAutomatedScriptConfigurations();
    }

    @Override
    public String getDate(Date date) {
        return this.m_report.getDate(date);
    }

    @Override
    public int getNumberOfUnresolvedCycleGroups() {
        return this.m_report.getNumberOfUnresolvedCycleGroups();
    }

    @Override
    public String getElementOrFrom(Issue issue) {
        return this.m_report.getElementOrFrom(issue);
    }

    @Override
    public String getTo(Issue issue) {
        return this.m_report.getTo(issue);
    }

    @Override
    public LastScriptRunnerExecutionStatus getScriptRunnerStatus() {
        return this.m_report.getScriptRunnerStatus();
    }

    @Override
    public List<DuplicateCodeBlockIssue> getUnresolvedDuplicateIssues() {
        return this.m_report.getUnresolvedDuplicateIssues();
    }

    @Override
    public List<DuplicateCodeBlockIssue> getDuplicateIssues() {
        return this.m_report.getDuplicateIssues();
    }

    @Override
    public List<SonargraphFeature> getAvailableFeatures() {
        return this.m_report.getAvailableFeatures();
    }

    @Override
    public List<SonargraphFeature> getUnavailableFeatures() {
        return this.m_report.getUnavailableFeatures();
    }

    @Override
    public List<IAnalyzerId> getUnlicensedAnalyzers() {
        return this.m_report.getUnlicensedAnalyzers();
    }

    @Override
    public List<IAnalyzerId> getLicensedAnalyzers() {
        return this.m_report.getLicensedAnalyzers();
    }

    @Override
    public List<IMetricThreshold> getThresholds() {
        return this.m_report.getThresholds();
    }

    @Override
    public Map<IMetricThreshold, List<ThresholdViolationIssue>> getThresholdViolationIssues() {
        return this.m_report.getThresholdViolationIssues();
    }

    @Override
    public int getNumberOfThresholdViolations() {
        return this.m_report.getNumberOfThresholdViolations();
    }

    @Override
    public void setTargetFile(TFile targetFile) {
        this.m_targetFile = targetFile;
    }

    @Override
    public int getNumberOfNamedElementIssues() {
        return this.m_report.getNumberOfNamedElementIssues();
    }

    @Override
    public int getNumberOfThresholds() {
        return this.m_report.getNumberOfThresholds();
    }

    @Override
    public int getTotalNumberOfCycleIssues() {
        return this.m_report.getTotalNumberOfCycleIssues();
    }

    @Override
    public List<IBasicReport> getModuleReports() {
        return Collections.unmodifiableList(this.m_moduleReports);
    }

    @Override
    public int getNumberOfUnresolvedIssues() {
        return this.m_report.getNumberOfUnresolvedIssues();
    }

    @Override
    public List<String> getDuplicateCodeConfigurationEntries() {
        return this.m_report.getDuplicateCodeConfigurationEntries();
    }

    @Override
    public List<String> getScriptRunnerConfigurationEntries() {
        return this.m_report.getScriptRunnerConfigurationEntries();
    }

    @Override
    public List<String> getArchitectureCheckConfigurationEntries() {
        return this.m_report.getArchitectureCheckConfigurationEntries();
    }

    @Override
    public List<Pair<SonargraphPlugin, IAnalyzerId>> getAnalyzerPlugins() {
        return this.m_report.getAnalyzerPlugins();
    }

    @Override
    public List<SonargraphPlugin> getModelPlugins() {
        return this.m_report.getModelPlugins();
    }

    @Override
    public List<IAnalyzerId> getAnalyzers(boolean executed) {
        return this.m_report.getAnalyzers(executed);
    }

    @Override
    public boolean isExecuted(AnalyzerExecutionLevel level) {
        return this.m_report.isExecuted(level);
    }

    @Override
    public List<CycleAnalyzerConfiguration> getCycleGroupAnalyzerConfigurations() {
        return this.m_report.getCycleGroupAnalyzerConfigurations();
    }

    @Override
    public Map<SonargraphPlugin, Pair<PluginConfigurationFile, List<Pair<SonargraphPluginAttribute, String>>>> getPluginConfigurations() {
        return this.m_report.getPluginConfigurations();
    }

    @Override
    public String getReportContextInfo() {
        return this.m_report.getReportContextInfo();
    }

    @Override
    public List<StrictPair<ArchitectureFile, String>> getCheckedArchitectureFiles() {
        return this.m_report.getCheckedArchitectureFiles();
    }

    @Override
    public String getBaseline() {
        return this.m_report.getBaseline();
    }

    @Override
    public List<String> getQualityGateCheckConfigurationEntries() {
        return this.m_report.getQualityGateCheckConfigurationEntries();
    }

    @Override
    public Map<QualityGate, QualityGateResult> getQualityGateToResultMap() {
        return this.m_report.getQualityGateToResultMap();
    }

    @Override
    public long getNumberOfFailedQualityGates() {
        return this.m_report.getNumberOfFailedQualityGates();
    }

    @Override
    public boolean isQualityGateCheckActive() {
        return this.m_report.isQualityGateCheckActive();
    }

    @Override
    public boolean issueAffectingQualityGates(Issue issue) {
        return this.m_report.issueAffectingQualityGates(issue);
    }

    @Override
    public boolean metricValueAffectingQualityGates(IMetricValue value) {
        return this.m_report.metricValueAffectingQualityGates(value);
    }

    @Override
    public List<IssueRank> getIssueRankings() {
        return this.m_report.getIssueRankings();
    }
}

