/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependencyNodeAdapter;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Map;

public final class WorkspaceDependencyNodeAdapterSet
extends NodeAdapterSet<WorkspaceDependencyNodeAdapter> {
    private final Map<NamedElement, WorkspaceDependencyNodeAdapter> m_namedElementToNodeAdapter;

    public WorkspaceDependencyNodeAdapterSet(IWorkerContext workerContext, Collection<? extends NamedElement> namedElements, DependencyEndpointCollector collector) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'WorkspaceDependencyNodeAdapterSet' must not be null";
        assert (namedElements != null) : "Parameter 'namedElements' of method 'WorkspaceDependencyNodeAdapterSet' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'WorkspaceDependencyNodeAdapterSet' must not be null";
        workerContext.setNumberOfSteps(1);
        this.m_namedElementToNodeAdapter = new THashMap(namedElements.size());
        for (NamedElement namedElement : namedElements) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            WorkspaceDependencyNodeAdapter adapter = new WorkspaceDependencyNodeAdapter(namedElement);
            WorkspaceDependencyNodeAdapter previous = this.m_namedElementToNodeAdapter.put(namedElement, adapter);
            assert (previous == null) : "'previous' of method 'WorkspaceDependencyNodeAdapterSet' must be null: " + String.valueOf(adapter);
        }
        workerContext.beginBlockOfWork(this.m_namedElementToNodeAdapter.size());
        for (Map.Entry entry : this.m_namedElementToNodeAdapter.entrySet()) {
            NamedElement nextNamedElement = (NamedElement)entry.getKey();
            WorkspaceDependencyNodeAdapter fromNodeAdapter = (WorkspaceDependencyNodeAdapter)entry.getValue();
            assert (nextNamedElement != null && nextNamedElement instanceof IWorkspaceDependencyElement) : "Unexpected class in method 'WorkspaceDependencyNodeAdapterSet': " + String.valueOf(nextNamedElement);
            IWorkspaceDependencyElement element = (IWorkspaceDependencyElement)((Object)nextNamedElement);
            for (WorkspaceDependency dependency : element.getOutgoingWorkspaceDependencies()) {
                IWorkspaceDependencyElement to;
                WorkspaceDependencyNodeAdapter toNodeAdapter;
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                if (dependency.isExcluded() || (toNodeAdapter = WorkspaceDependencyNodeAdapterSet.getNodeAdapter((NamedElement)((Object)(to = dependency.getTo())), collector, this.m_namedElementToNodeAdapter)) == null || !collector.addDependency(fromNodeAdapter.getUnderlyingObject(), toNodeAdapter.getUnderlyingObject(), null)) continue;
                Object edgeAdapter = fromNodeAdapter.findOutgoingEdge(toNodeAdapter);
                if (edgeAdapter == null) {
                    edgeAdapter = new WorkspaceDependencyEdgeAdapter<WorkspaceDependencyNodeAdapter>(fromNodeAdapter, toNodeAdapter);
                    fromNodeAdapter.addOutgoindEdge((EdgeAdapter<? extends NodeAdapter>)edgeAdapter);
                }
                ((EdgeAdapter)edgeAdapter).addDependency(dependency);
            }
            workerContext.workItemCompleted();
        }
        workerContext.endStep();
    }

    @Override
    protected Map<NamedElement, WorkspaceDependencyNodeAdapter> getNamedElementToNodeAdapter() {
        return this.m_namedElementToNodeAdapter;
    }

    @Override
    protected WorkspaceDependencyNodeAdapter createNodeAdapter(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'createNodeAdapter' must not be null";
        return new WorkspaceDependencyNodeAdapter(namedElement);
    }

    @Override
    protected EdgeAdapter<? extends NodeAdapter> createEdgeAdapter(WorkspaceDependencyNodeAdapter from, WorkspaceDependencyNodeAdapter to) {
        assert (from != null) : "Parameter 'from' of method 'createEdgeAdapter' must not be null";
        assert (to != null) : "Parameter 'to' of method 'createEdgeAdapter' must not be null";
        return new WorkspaceDependencyEdgeAdapter<WorkspaceDependencyNodeAdapter>(from, to);
    }
}

