/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class NodeAdapterSet<T extends NodeAdapter> {
    protected abstract Map<NamedElement, T> getNamedElementToNodeAdapter();

    protected abstract T createNodeAdapter(NamedElement var1);

    protected abstract EdgeAdapter<? extends NodeAdapter> createEdgeAdapter(T var1, T var2);

    public final Iterator<T> iterator() {
        final Iterator<Map.Entry<NamedElement, T>> iterator = this.getNamedElementToNodeAdapter().entrySet().iterator();
        return new Iterator<T>(){
            private T m_current;

            @Override
            public void remove() {
                if (!$assertionsDisabled && this.m_current == null) {
                    throw new AssertionError((Object)"'m_current' of method 'remove' must not be null");
                }
                ((NodeAdapter)this.m_current).removeEdges(false);
                iterator.remove();
            }

            @Override
            public T next() {
                this.m_current = (NodeAdapter)((Map.Entry)iterator.next()).getValue();
                return this.m_current;
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }
        };
    }

    public final void remove(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'remove' must not be null";
        NodeAdapter toBeRemoved = (NodeAdapter)this.getNamedElementToNodeAdapter().get(namedElement);
        if (toBeRemoved != null) {
            toBeRemoved.removeEdges(false);
            this.getNamedElementToNodeAdapter().remove(namedElement);
        }
    }

    public final T getNodeAdapterFor(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getNodeAdapterFor' must not be null";
        return (T)((NodeAdapter)this.getNamedElementToNodeAdapter().get(namedElement));
    }

    public final Collection<T> getNodes() {
        return Collections.unmodifiableCollection(this.getNamedElementToNodeAdapter().values());
    }

    protected static <T extends NodeAdapter> T getNodeAdapter(NamedElement forElement, DependencyEndpointCollector collector, Map<NamedElement, T> namedElementToNodeAdapter) {
        assert (forElement != null) : "Parameter 'forProgrammingElement' of method 'getNodeAdapter' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'getNodeAdapter' must not be null";
        NamedElement currentNamedElement = collector.getFirstCandidateForNodeAdapterLookUp(forElement);
        while (currentNamedElement != null) {
            NodeAdapter found = (NodeAdapter)namedElementToNodeAdapter.get(currentNamedElement);
            if (found != null) {
                return (T)found;
            }
            currentNamedElement = collector.getNextCandidateForNodeAdapterLookUp(currentNamedElement);
        }
        return null;
    }

    public T combine(NamedElement underlyingElement, Set<NodeAdapter> nodeAdapters) {
        assert (underlyingElement != null) : "Parameter 'underlyingElement' of method 'create' must not be null";
        assert (nodeAdapters != null && !nodeAdapters.isEmpty()) : "Parameter 'nodeAdapters' of method 'create' must not be empty";
        T combined = this.createNodeAdapter(underlyingElement);
        for (NodeAdapter nextNodeAdapter : nodeAdapters) {
            THashSet nextAlreadyPresent;
            for (EdgeAdapter<? extends NodeAdapter> edgeAdapter : new ArrayList<EdgeAdapter<? extends NodeAdapter>>(nextNodeAdapter.getIncomingEdges())) {
                NodeAdapter nextFrom = edgeAdapter.getFrom();
                if (nodeAdapters.contains(nextFrom)) continue;
                nextFrom.removeOutgoingEdge(edgeAdapter);
                nextNodeAdapter.removeIncomingEdge(edgeAdapter);
                Object nextCombinedIncoming = nextFrom.findOutgoingEdge((INode<?>)combined);
                if (nextCombinedIncoming == null) {
                    nextCombinedIncoming = this.createEdgeAdapter(nextFrom, combined);
                    nextFrom.addOutgoindEdge((EdgeAdapter<? extends NodeAdapter>)nextCombinedIncoming);
                }
                assert (nextCombinedIncoming != null);
                nextAlreadyPresent = new THashSet(((EdgeAdapter)nextCombinedIncoming).getDependencies());
                for (Dependency nextDependency : edgeAdapter.getDependencies()) {
                    if (!nextAlreadyPresent.add(nextDependency)) continue;
                    ((EdgeAdapter)nextCombinedIncoming).addDependency(nextDependency);
                }
            }
            for (EdgeAdapter<? extends NodeAdapter> edgeAdapter : new ArrayList<EdgeAdapter<? extends NodeAdapter>>(nextNodeAdapter.getOutgoingEdges())) {
                NodeAdapter nextTo = edgeAdapter.getTo();
                if (nodeAdapters.contains(nextTo)) continue;
                nextNodeAdapter.removeOutgoingEdge(edgeAdapter);
                nextTo.removeIncomingEdge(edgeAdapter);
                Object nextCombinedOutgoing = ((NodeAdapter)combined).findOutgoingEdge(nextTo);
                if (nextCombinedOutgoing == null) {
                    nextCombinedOutgoing = this.createEdgeAdapter(combined, nextTo);
                    ((NodeAdapter)combined).addOutgoindEdge((EdgeAdapter<NodeAdapter>)nextCombinedOutgoing);
                }
                assert (nextCombinedOutgoing != null);
                nextAlreadyPresent = new THashSet(((EdgeAdapter)nextCombinedOutgoing).getDependencies());
                for (Dependency nextDependency : edgeAdapter.getDependencies()) {
                    if (!nextAlreadyPresent.add(nextDependency)) continue;
                    ((EdgeAdapter)nextCombinedOutgoing).addDependency(nextDependency);
                }
            }
            NodeAdapter nodeAdapter = (NodeAdapter)this.getNamedElementToNodeAdapter().remove(nextNodeAdapter.getUnderlyingObject());
            assert (nodeAdapter != null) : "'previousNodeAdapter' of method 'combine' must not be null";
        }
        this.getNamedElementToNodeAdapter().put(underlyingElement, combined);
        return combined;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<NamedElement, T> nextEntry : this.getNamedElementToNodeAdapter().entrySet()) {
            builder.append(nextEntry.getKey().getName()).append("\n");
        }
        return builder.toString();
    }
}

