/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path.scm;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingLink;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingNode;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class TemporalCouplingModel
extends NamedElement {
    private static final String NODES = "nodes";
    private TemporalCouplingNode[] m_nodes;

    public TemporalCouplingModel(NamedElement parent) {
        super(parent);
    }

    public TemporalCouplingModel(NamedElement parent, TemporalCouplingNode[] nodes) {
        super(parent);
        assert (nodes != null) : "Parameter 'nodes' of method 'TemporalCouplingModel' must not be null";
        this.m_nodes = nodes;
    }

    public List<TemporalCouplingLink> getTemporalCouplingFor(SourceFile sourceFile) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'getTemporalCouplingFor' must not be null";
        TemporalCouplingNode targetNode = null;
        TemporalCouplingNode[] temporalCouplingNodeArray = this.m_nodes;
        int n = this.m_nodes.length;
        int n2 = 0;
        while (n2 < n) {
            TemporalCouplingNode node = temporalCouplingNodeArray[n2];
            if (node.getSourceFile() == sourceFile) {
                targetNode = node;
                break;
            }
            ++n2;
        }
        if (targetNode == null) {
            return null;
        }
        int[] links = targetNode.getLinks();
        ArrayList<TemporalCouplingLink> result = new ArrayList<TemporalCouplingLink>(links.length / 2);
        int i = 0;
        while (i < links.length) {
            SourceFile targetSource = this.m_nodes[links[i]].getSourceFile();
            TemporalCouplingLink link = new TemporalCouplingLink(targetSource, links[i + 1]);
            result.add(link);
            i += 2;
        }
        if (result.size() == 0) {
            return null;
        }
        result.sort((a, b) -> b.getWeight() - a.getWeight());
        return result;
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeOwnedObjects(NODES, (IPersistable[])this.m_nodes);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        this.m_nodes = (TemporalCouplingNode[])reader.readOwnedObjects(NODES, TemporalCouplingNode.class);
    }

    @Override
    public String getShortName() {
        return "TemporalCouplingModel";
    }
}

