/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.QualityModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class ExportQualityModel
extends QualityModel {
    private final List<ExportQualityModelCandidate> m_candidates = new ArrayList<ExportQualityModelCandidate>();
    private String m_filePath;

    public ExportQualityModel(List<IModifiableFile> availableFiles) {
        super(availableFiles);
    }

    public void addCandidate(IModifiableFile file, String description) {
        assert (file != null) : "Parameter 'file' of method 'addCandidate' must not be null";
        this.m_candidates.add(new ExportQualityModelCandidate(file, true, description));
    }

    public String getFilePath() {
        return this.m_filePath;
    }

    public void setFilePath(String filePath) {
        assert (filePath != null && filePath.length() > 0) : "Parameter 'filePath' of method 'setFilePath' must not be empty";
        this.m_filePath = filePath;
    }

    public List<ExportQualityModelCandidate> getCandidates() {
        Comparator<IModifiableFile> comparator = ExportQualityModel.getModifiableFileComparator();
        Collections.sort(this.m_candidates, (c1, c2) -> comparator.compare(c1.getModifiableFile(), c2.getModifiableFile()));
        return this.m_candidates;
    }

    public boolean hasContent() {
        for (ExportQualityModelCandidate next : this.m_candidates) {
            if (!next.isIncluded()) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        return this.hasContent() && this.m_filePath != null && this.m_filePath.length() > 0;
    }

    public static final class ExportQualityModelCandidate {
        private final IModifiableFile m_modifiableFile;
        private boolean m_isIncluded = true;
        private final String m_description;

        public ExportQualityModelCandidate(IModifiableFile modifiableFile, boolean isIncluded, String description) {
            assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'ExportQualityModelCandidate' must not be null";
            this.m_modifiableFile = modifiableFile;
            this.m_isIncluded = isIncluded;
            this.m_description = description;
        }

        public IModifiableFile getModifiableFile() {
            return this.m_modifiableFile;
        }

        public String getIdentifyingPath() {
            return this.m_modifiableFile.getIdentifyingPath();
        }

        public boolean isIncluded() {
            return this.m_isIncluded;
        }

        public void setIncluded(boolean isIncluded) {
            this.m_isIncluded = isIncluded;
        }

        public void toggleIncludedState() {
            this.m_isIncluded = !this.m_isIncluded;
        }

        public String getDescription() {
            return this.m_description;
        }
    }
}

