/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.graphview;

import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DependenciesViewDependencyInfo;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DeprecationInfo;
import com.hello2morrow.sonargraph.core.model.dependenciesview.ViolationInfo;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IDependency;
import com.hello2morrow.sonargraph.core.model.element.IDependencyAdapter;
import com.hello2morrow.sonargraph.core.model.element.IDependencyWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.INamedElementAdapter;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewElement;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNodeDependencyFlags;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNodeFlags;
import com.hello2morrow.sonargraph.core.model.graphview.IGraphViewDependencyInfoProvider;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependenciesProvidingEdge;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependenciesProvidingNode;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.foundation.collections.HashBag;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class GraphViewNode
extends GraphViewElement
implements IParserDependenciesProvidingNode,
INamedElementAdapter,
INode<NamedElement> {
    private Map<GraphViewNode, GraphViewDependency> m_fromToIncomingDependencies;
    private Map<GraphViewNode, GraphViewDependency> m_toToOutgoingDependencies;
    private final int m_level;
    private byte m_flags;

    public static Set<GraphViewDependency> getViolations(Set<GraphViewNode> nodes) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'getViolations' must not be empty";
        LinkedHashSet<GraphViewDependency> violations = new LinkedHashSet<GraphViewDependency>(nodes.stream().flatMap(n -> n.getOutgoingDependencies().stream()).filter(edge -> edge.getNumberOfParserDependenciesViolating() > 0).collect(Collectors.toList()));
        return violations;
    }

    public GraphViewNode(GraphViewElement parent, int level) {
        super(parent);
        this.m_level = level;
        this.setVisible(true);
    }

    public final int getLevel() {
        return this.m_level;
    }

    protected final byte getFlags() {
        return this.m_flags;
    }

    protected final void setFlags(byte flags) {
        this.m_flags = flags;
    }

    public abstract boolean isCyclic();

    public abstract boolean isExpandable();

    public final void setExpanded(boolean expanded) {
        assert (!expanded || this.isExpandable()) : "Not expandable: " + String.valueOf(this);
        this.m_flags = GraphViewNodeFlags.setEnabled(expanded, this.m_flags, (byte)8);
    }

    public final boolean isExpanded() {
        return GraphViewNodeFlags.isEnabled(this.m_flags, (byte)8);
    }

    public final void setSelected(boolean selected) {
        this.m_flags = GraphViewNodeFlags.setEnabled(selected, this.m_flags, (byte)2);
    }

    public final boolean isSelected() {
        return GraphViewNodeFlags.isEnabled(this.m_flags, (byte)2);
    }

    public final void setVisible(boolean visible) {
        this.m_flags = GraphViewNodeFlags.setEnabled(visible, this.m_flags, (byte)1);
    }

    public final boolean isVisible() {
        return GraphViewNodeFlags.isEnabled(this.m_flags, (byte)1);
    }

    public final void setAdded(boolean added) {
        this.m_flags = GraphViewNodeFlags.setEnabled(added, this.m_flags, (byte)16);
    }

    public final boolean isAdded() {
        return GraphViewNodeFlags.isEnabled(this.m_flags, (byte)16);
    }

    protected abstract List<IDependency> getDependencyAdapters(GraphViewNode var1);

    @Override
    public final List<ParserDependency> getIncomingParserDependencies() {
        if (this.m_fromToIncomingDependencies == null) {
            return Collections.emptyList();
        }
        ArrayList<ParserDependency> parserDependencies = new ArrayList<ParserDependency>();
        this.m_fromToIncomingDependencies.values().forEach(d -> {
            boolean bl = parserDependencies.addAll(d.getParserDependencies());
        });
        return parserDependencies;
    }

    @Override
    public final List<ParserDependency> getOutgoingParserDependencies() {
        if (this.m_toToOutgoingDependencies == null) {
            return Collections.emptyList();
        }
        ArrayList<ParserDependency> parserDependencies = new ArrayList<ParserDependency>();
        this.m_toToOutgoingDependencies.values().forEach(d -> {
            boolean bl = parserDependencies.addAll(d.getParserDependencies());
        });
        return parserDependencies;
    }

    public final GraphViewDependency getOutgoingDependency(GraphViewNode to) {
        assert (to != null) : "Parameter 'to' of method 'getOutgoingDependency' must not be null";
        return this.m_toToOutgoingDependencies == null ? null : this.m_toToOutgoingDependencies.get(to);
    }

    private void addDependencyFrom(GraphViewDependency fromDependency) {
        assert (fromDependency != null) : "Parameter 'fromDependency' of method 'addDependencyFrom' must not be null";
        if (this.m_fromToIncomingDependencies == null) {
            this.m_fromToIncomingDependencies = Collections.synchronizedMap(new THashMap());
        }
        this.m_fromToIncomingDependencies.put(fromDependency.getFrom(), fromDependency);
    }

    private void addDependencyTo(GraphViewDependency toDependency) {
        assert (toDependency != null) : "Parameter 'toDependency' of method 'addDependencyTo' must not be null";
        if (this.m_toToOutgoingDependencies == null) {
            this.m_toToOutgoingDependencies = Collections.synchronizedMap(new THashMap());
        }
        this.m_toToOutgoingDependencies.put(toDependency.getTo(), toDependency);
    }

    public void addDependendencyFrom(GraphViewNode from, Collection<ParserDependency> parserDependencies, IGraphViewDependencyInfoProvider provider) {
        GraphViewDependency dependency;
        assert (from != null) : "Parameter 'to' of method 'addDependendencyFrom' must not be null";
        assert (parserDependencies != null && !parserDependencies.isEmpty()) : "Parameter 'parserDependencies' of method 'addDependendencyFrom' must not be empty";
        assert (provider != null) : "Parameter 'provider' of method 'addDependendencyFrom' must not be null";
        if (this.m_fromToIncomingDependencies == null) {
            this.m_fromToIncomingDependencies = Collections.synchronizedMap(new THashMap());
        }
        if ((dependency = this.m_fromToIncomingDependencies.get(from)) == null) {
            dependency = new GraphViewDependency(from, this);
            this.m_fromToIncomingDependencies.put(from, dependency);
            from.addDependencyTo(dependency);
        }
        for (ParserDependency nextParserDependency : parserDependencies) {
            dependency.addParserDependency(nextParserDependency, provider.isViolation(nextParserDependency), provider.isDeprecation(nextParserDependency), provider.getIssues(nextParserDependency));
        }
    }

    public void addDependendencyTo(GraphViewNode to, Collection<ParserDependency> parserDependencies, IGraphViewDependencyInfoProvider provider) {
        GraphViewDependency dependency;
        assert (to != null) : "Parameter 'to' of method 'addDependendencyTo' must not be null";
        assert (parserDependencies != null && !parserDependencies.isEmpty()) : "Parameter 'parserDependencies' of method 'addDependendencyTo' must not be empty";
        assert (provider != null) : "Parameter 'provider' of method 'addDependendencyTo' must not be null";
        if (this.m_toToOutgoingDependencies == null) {
            this.m_toToOutgoingDependencies = Collections.synchronizedMap(new THashMap());
        }
        if ((dependency = this.m_toToOutgoingDependencies.get(to)) == null) {
            dependency = new GraphViewDependency(this, to);
            this.m_toToOutgoingDependencies.put(to, dependency);
            to.addDependencyFrom(dependency);
        }
        for (ParserDependency nextParserDependency : parserDependencies) {
            dependency.addParserDependency(nextParserDependency, provider.isViolation(nextParserDependency), provider.isDeprecation(nextParserDependency), provider.getIssues(nextParserDependency));
        }
    }

    public boolean hasDependencyTo(GraphViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'hasDependencyTo' must not be null";
        return this.m_toToOutgoingDependencies != null ? this.m_toToOutgoingDependencies.containsKey(node) : false;
    }

    public void removeDependencies() {
        if (this.m_toToOutgoingDependencies != null) {
            for (GraphViewDependency nextOut : this.m_toToOutgoingDependencies.values()) {
                nextOut.getTo().removeDependencyFrom(nextOut);
            }
            this.m_toToOutgoingDependencies = null;
        }
        if (this.m_fromToIncomingDependencies != null) {
            for (GraphViewDependency nextIn : this.m_fromToIncomingDependencies.values()) {
                nextIn.getFrom().removeDependencyTo(nextIn);
            }
            this.m_fromToIncomingDependencies = null;
        }
    }

    public void removeDependencyFrom(GraphViewDependency fromDependency) {
        assert (fromDependency != null) : "Parameter 'fromDependency' of method 'addDependencyFrom' must not be null";
        assert (this.m_fromToIncomingDependencies != null) : "'m_fromToIncomingDependencies' of method 'removeDependencyFrom' must not be null";
        GraphViewDependency previous = this.m_fromToIncomingDependencies.remove(fromDependency.getFrom());
        assert (previous != null) : "'previous' of method 'removeDependencyFrom' must not be null";
        if (this.m_fromToIncomingDependencies.isEmpty()) {
            this.m_fromToIncomingDependencies = null;
        }
    }

    public void removeDependencyTo(GraphViewDependency toDependency) {
        assert (toDependency != null) : "Parameter 'toDependency' of method 'addDependencyTo' must not be null";
        assert (this.m_toToOutgoingDependencies != null) : "'m_toToOutgoingoDependencies' of method 'removeDependencyTo' must not be null";
        GraphViewDependency previous = this.m_toToOutgoingDependencies.remove(toDependency.getTo());
        assert (previous != null) : "'previous' of method 'removeDependencyTo' must not be null";
        if (this.m_toToOutgoingDependencies.isEmpty()) {
            this.m_toToOutgoingDependencies = null;
        }
    }

    public final boolean hasDependencies() {
        return this.m_fromToIncomingDependencies != null && !this.m_fromToIncomingDependencies.isEmpty() || this.m_toToOutgoingDependencies != null && !this.m_toToOutgoingDependencies.isEmpty();
    }

    public final synchronized Collection<GraphViewDependency> getIncomingDependencies() {
        return this.m_fromToIncomingDependencies == null ? Collections.emptyList() : new ArrayList<GraphViewDependency>(this.m_fromToIncomingDependencies.values());
    }

    public final synchronized Collection<GraphViewDependency> getOutgoingDependencies() {
        return this.m_toToOutgoingDependencies == null ? Collections.emptyList() : new ArrayList<GraphViewDependency>(this.m_toToOutgoingDependencies.values());
    }

    @Override
    public final Collection<? extends INode.IEdge> getIncomingEdges() {
        return this.getIncomingDependencies();
    }

    @Override
    public final Collection<? extends INode.IEdge> getOutgoingEdges() {
        return this.getOutgoingDependencies();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitGraphViewNode(this);
        } else {
            super.accept(visitor);
        }
    }

    public static final class GraphViewDependency
    extends Element
    implements IParserDependenciesProvidingEdge,
    IDependencyWithIssues,
    IDependencyAdapter,
    INode.IEdge {
        private final GraphViewNode m_from;
        private final GraphViewNode m_to;
        private Collection<ParserDependency> m_dependencies = new HashBag(50);
        private DependenciesViewDependencyInfo m_info;
        private byte m_flags;

        public static final Set<Pair<String, String>> getDescriptors(Collection<GraphViewDependency> dependencies, IElementResolver resolver) {
            assert (dependencies != null) : "Parameter 'dependencies' of method 'getDescriptors' must not be null";
            assert (resolver != null) : "Parameter 'resolver' of method 'getDescriptors' must not be null";
            THashSet descriptors = new THashSet(dependencies.size());
            descriptors.clear();
            for (GraphViewDependency next : dependencies) {
                GraphViewNode from = next.getFromEndPoint();
                GraphViewNode to = next.getToEndPoint();
                String fromDescriptor = resolver.getDescriptor(from);
                String toDescriptor = resolver.getDescriptor(to);
                if (fromDescriptor == null || toDescriptor == null) continue;
                descriptors.add(new Pair((Object)fromDescriptor, (Object)toDescriptor));
            }
            return descriptors;
        }

        GraphViewDependency(GraphViewNode from, GraphViewNode to) {
            assert (from != null) : "Parameter 'from' of method 'GraphViewDependency' must not be null";
            assert (to != null) : "Parameter 'to' of method 'GraphViewDependency' must not be null";
            this.m_from = from;
            this.m_to = to;
            this.setVisible(true);
        }

        @Override
        public String getName() {
            return this.getFrom().getName() + " -> " + this.getTo().getName();
        }

        public GraphViewNode getFrom() {
            return this.m_from;
        }

        public GraphViewNode getTo() {
            return this.m_to;
        }

        @Override
        public GraphViewNode getFromEndPoint() {
            return this.m_from;
        }

        @Override
        public GraphViewNode getToEndPoint() {
            return this.m_to;
        }

        @Override
        public boolean isExternal() {
            return this.m_from.isExternal();
        }

        @Override
        public String getShortName() {
            return this.m_from.getShortName() + " -> " + this.m_to.getShortName();
        }

        @Override
        public Element.IPropertiesManager getPropertiesManager() {
            return this.m_from.getPropertiesManager();
        }

        @Override
        public synchronized boolean isValid() {
            return this.m_dependencies != null && this.m_from.isValid() && this.m_to.isValid();
        }

        public boolean isVisible() {
            return GraphViewNodeDependencyFlags.isEnabled(this.m_flags, (byte)1);
        }

        public void setVisible(boolean visible) {
            this.m_flags = GraphViewNodeDependencyFlags.setEnabled(visible, this.m_flags, (byte)1);
        }

        public boolean isSelected() {
            return GraphViewNodeDependencyFlags.isEnabled(this.m_flags, (byte)2);
        }

        public void setSelected(boolean selected) {
            this.m_flags = GraphViewNodeDependencyFlags.setEnabled(selected, this.m_flags, (byte)2);
        }

        @Override
        @IntProperty
        public synchronized int getNumberOfParserDependencies() {
            return this.m_dependencies != null ? this.m_dependencies.size() : 0;
        }

        @IntProperty(undefinedValue=0)
        public synchronized int getNumberOfParserDependenciesViolating() {
            return this.m_info == null ? 0 : this.m_info.getNumberOfParserDependenciesViolating();
        }

        @IntProperty(undefinedValue=0)
        public synchronized int getNumberOfParserDependenciesViolatingToBeFixed() {
            return this.m_info == null ? 0 : this.m_info.getNumberOfParserDependenciesViolatingToBeFixed();
        }

        @IntProperty(undefinedValue=0)
        public synchronized int getNumberOfParserDependenciesViolatingIgnored() {
            return this.m_info == null ? 0 : this.m_info.getNumberOfParserDependenciesViolatingIgnored();
        }

        @Property
        public synchronized String getViolationInfo() {
            return this.m_info == null ? null : this.m_info.getViolationInfo();
        }

        @Property
        public synchronized String getViolationInfoToBeFixed() {
            return this.m_info == null ? null : this.m_info.getViolationInfoToBeFixed();
        }

        @Property
        public synchronized String getViolationInfoIgnored() {
            return this.m_info == null ? null : this.m_info.getViolationInfoIgnored();
        }

        @IntProperty(undefinedValue=0)
        public synchronized int getNumberOfParserDependenciesDeprecated() {
            return this.m_info == null ? 0 : this.m_info.getNumberOfParserDependenciesDeprecated();
        }

        @IntProperty(undefinedValue=0)
        public synchronized int getNumberOfParserDependenciesDeprecatedIgnored() {
            return this.m_info == null ? 0 : this.m_info.getNumberOfParserDependenciesDeprecatedIgnored();
        }

        @IntProperty(undefinedValue=0)
        public synchronized int getNumberOfParserDependenciesDeprecatedToBeFixed() {
            return this.m_info == null ? 0 : this.m_info.getNumberOfParserDependenciesDeprecatedToBeFixed();
        }

        @Property
        public synchronized String getDeprecationInfo() {
            return this.m_info == null ? null : this.m_info.getDeprecationInfo();
        }

        @Property
        public synchronized String getDeprecationInfoIgnored() {
            return this.m_info == null ? null : this.m_info.getDeprecationInfoIgnored();
        }

        @Property
        public synchronized String getDeprecationInfoToBeFixed() {
            return this.m_info == null ? null : this.m_info.getDeprecationInfoToBeFixed();
        }

        @Override
        public Collection<Issue> getRelevantIssues() {
            return this.m_info == null ? Collections.emptyList() : this.m_info.getIssues();
        }

        @Override
        public synchronized String getImageResourceName() {
            if (this.isValid()) {
                int number = this.getNumberOfParserDependenciesViolating();
                return number == 0 ? "NonViolatingDependency" : (number == this.m_dependencies.size() ? "FullViolatingDependency" : "PartiallyViolatingDependency");
            }
            return "InvalidDependency";
        }

        private void process(ViolationInfo violationInfo, DeprecationInfo deprecationInfo, Collection<Issue> issues) {
            if (violationInfo != null || deprecationInfo != null || issues != null) {
                if (this.m_info == null) {
                    this.m_info = new DependenciesViewDependencyInfo();
                }
                this.m_info.processInfo(violationInfo, deprecationInfo, issues);
            }
        }

        public void update(IGraphViewDependencyInfoProvider provider) {
            assert (provider != null) : "Parameter 'provider' of method 'update' must not be null";
            assert (this.isValid()) : "Not valid: " + String.valueOf(this);
            this.m_info = null;
            this.m_dependencies.forEach(d -> this.process(provider.isViolation((ParserDependency)d), provider.isDeprecation((ParserDependency)d), provider.getIssues((ParserDependency)d)));
        }

        public synchronized void removed() {
            assert (this.isValid()) : "Not valid: " + String.valueOf(this);
            this.m_dependencies.clear();
            this.m_dependencies = null;
        }

        public Iterator<ParserDependency> getParserDependenciesIterator() {
            assert (this.isValid()) : "Not valid: " + String.valueOf(this);
            return this.m_dependencies.iterator();
        }

        private synchronized void addParserDependency(ParserDependency dependency, ViolationInfo violationInfo, DeprecationInfo deprecationInfo, Collection<Issue> issues) {
            assert (dependency != null) : "Parameter 'addParserDependency' of method 'add' must not be null";
            assert (this.isValid()) : "Not valid";
            if (!this.m_dependencies.contains(dependency)) {
                this.m_dependencies.add(dependency);
                this.process(violationInfo, deprecationInfo, issues);
            }
        }

        @Override
        public synchronized Collection<ParserDependency> getParserDependencies() {
            return this.isValid() ? new ArrayList<ParserDependency>(this.m_dependencies) : Collections.emptyList();
        }

        @Property
        public synchronized String getParserDependency() {
            return this.isValid() && this.m_dependencies.size() == 1 ? this.m_dependencies.iterator().next().getPresentationName(false) : null;
        }

        @Override
        public int getWeight() {
            return this.getNumberOfParserDependencies();
        }

        @Override
        public ParserDependency getFirstParserDependency() {
            return this.isValid() && !this.m_dependencies.isEmpty() ? this.m_dependencies.iterator().next() : null;
        }

        @Override
        public synchronized List<IDependency> getAdaptedTo() {
            if (this.isValid()) {
                return this.m_from.getDependencyAdapters(this.m_to);
            }
            return Collections.emptyList();
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitGraphViewNode(GraphViewNode var1);
    }
}

