/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferArchitectureExecutionInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferRefactoringsExecutionInfo;

public final class TransferExecutionInfo {
    private final ArchitecturalViewFile m_file;
    private final TransferArchitectureExecutionInfo m_architectureExecutionInfo;
    private final TransferRefactoringsExecutionInfo m_refactoringsExecutionInfo;
    private final String m_warningInfo;

    public TransferExecutionInfo(ArchitecturalViewFile file, TransferArchitectureExecutionInfo architectureExecutionInfo, TransferRefactoringsExecutionInfo refactoringsExecutionInfo, String warningInfo) {
        assert (file != null) : "Parameter 'file' of method 'TransferArchitecturalViewInfo' must not be null";
        assert (architectureExecutionInfo != null || refactoringsExecutionInfo != null) : "At least 1 execution info expected";
        assert (warningInfo != null) : "Parameter 'warningInfo' of method 'TransferExecutionInfo' must not be null";
        this.m_file = file;
        this.m_architectureExecutionInfo = architectureExecutionInfo;
        this.m_refactoringsExecutionInfo = refactoringsExecutionInfo;
        this.m_warningInfo = warningInfo;
    }

    public ArchitecturalViewFile getFile() {
        return this.m_file;
    }

    public TransferArchitectureExecutionInfo getArchitectureExecutionInfo() {
        return this.m_architectureExecutionInfo;
    }

    public TransferRefactoringsExecutionInfo getRefactoringsExecutionInfo() {
        return this.m_refactoringsExecutionInfo;
    }

    public boolean isTransferPossible() {
        return this.m_architectureExecutionInfo != null && this.m_architectureExecutionInfo.transfer() && this.m_architectureExecutionInfo.isValid() || this.m_refactoringsExecutionInfo != null && this.m_refactoringsExecutionInfo.transfer() && this.m_refactoringsExecutionInfo.isValid();
    }

    public String getWarningInfo() {
        return this.m_warningInfo;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.m_file.getIdentifyingPath()).append(this.isTransferPossible() ? " [Transfer Possible]" : " [Transfer Not Possible]");
        if (this.m_architectureExecutionInfo != null) {
            builder.append("\n").append(this.m_architectureExecutionInfo.toString());
        }
        if (this.m_refactoringsExecutionInfo != null) {
            builder.append("\n").append(this.m_refactoringsExecutionInfo.toString());
        }
        if (!this.m_warningInfo.isEmpty()) {
            builder.append("\n").append("Warning info: ").append(this.m_warningInfo);
        }
        return builder.toString();
    }
}

