/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.ImageDecoratorInfo;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactAssignmentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactIncomingDependencyMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactOutgoingDependencyMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactVisibility;
import com.hello2morrow.sonargraph.core.model.explorationview.EmptyNodeProgrammingElement;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableContainer;
import com.hello2morrow.sonargraph.core.model.explorationview.ImageSupport;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementAggregatingNode;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.collections.HashBag;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;

public abstract class ArtifactPropertiesNode
extends ProgrammingElementAggregatingNode
implements IAssignableContainer {
    public static final NamedElement.IFilter EXCLUDE_ARTIFACT_PROPERTY_NODES = new NamedElement.IFilter(){

        @Override
        public boolean accept(NamedElement namedElement) {
            if (!($assertionsDisabled || namedElement != null && namedElement instanceof ArchitecturalViewNode)) {
                throw new AssertionError((Object)("Unexpected class in method 'accept': " + String.valueOf(namedElement)));
            }
            return !(namedElement instanceof ArtifactPropertiesNode);
        }
    };
    private static final String RELATIVE_PATH_PREFIX = "A" + INNER_NAME_PARTS_SEPARATOR;
    private ArtifactProperties m_properties;

    public ArtifactPropertiesNode(ArchitecturalViewElement parent, PresentationMode presentationMode, boolean isReadOnly, ArtifactProperties properties) {
        super(parent, presentationMode, isReadOnly, (Collection<ProgrammingElement>)new HashBag(250));
        assert (properties != null) : "Parameter 'properties' of method 'ArtifactPropertiesNode' must not be null";
        this.m_properties = properties;
    }

    @Override
    public final void finishModification() {
        Collection<ProgrammingElement> collection = this.getProgrammingElementsCollection();
        assert (collection != null && collection instanceof HashBag) : "Unexpected class in method 'finishModification': " + String.valueOf(collection);
        ((HashBag)collection).trimToSize();
        super.finishModification();
    }

    @Override
    public final ArchitecturalViewElement getArchitecturalViewElement() {
        return this;
    }

    public final boolean isPublic() {
        return this.m_properties.getIncomingDependencyMode().equals(ArtifactIncomingDependencyMode.PUBLIC);
    }

    public final ArtifactIncomingDependencyMode getIncomingDependencyMode() {
        return this.m_properties.getIncomingDependencyMode();
    }

    public final ArtifactOutgoingDependencyMode getOutgoingDependencyMode() {
        return this.m_properties.getOutgoingDependencyMode();
    }

    public final ArtifactAssignmentMode getAssignmentMode() {
        return this.m_properties.getAssignmentMode();
    }

    public final EnumSet<ArtifactVisibility> getVisibility() {
        return this.m_properties.getVisibility();
    }

    public final boolean setArtifactProperties(ArtifactProperties properties) {
        assert (properties != null) : "Parameter 'properties' of method 'setArtifactProperties' must not be null";
        if (!this.m_properties.equals(properties)) {
            this.m_properties = properties;
            return true;
        }
        return false;
    }

    public final ArtifactProperties getArtifactProperties() {
        return this.m_properties;
    }

    @Override
    public final Language getLanguage() {
        return null;
    }

    @Override
    public final String getFullyQualifiedNamePart() {
        return RELATIVE_PATH_PREFIX + super.getFullyQualifiedNamePart();
    }

    @Override
    public final int getRelativeIndex() {
        if (super.getRelativeIndex() == -1) {
            ArchitecturalViewElement parent = this.getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (parent != null) : "'parent' of method 'getIndexRelativeToParent' must not be null";
            int index = parent.getChildrenList().indexOf(this) - parent.getRelativeIndexOffset();
            assert (index != -1) : "Invalid parent-relative-index for: " + String.valueOf(this);
            return index;
        }
        return super.getRelativeIndex();
    }

    @Override
    public final String getName() {
        ArrayList<String> allShortNames = new ArrayList<String>(5);
        ArtifactPropertiesNode current = this;
        while (current != null) {
            allShortNames.add(current.getShortName());
            current = current.getParent(ArtifactPropertiesNode.class, ParentMode.ONLY_DIRECT_PARENT);
        }
        assert (!allShortNames.isEmpty()) : "'allShortNames' must not be empty for: " + String.valueOf(this);
        if (allShortNames.size() == 1) {
            return (String)allShortNames.get(0);
        }
        Collections.reverse(allShortNames);
        StringBuilder builder = new StringBuilder((String)allShortNames.get(0));
        int i = 1;
        while (i < allShortNames.size()) {
            builder.append(':').append((String)allShortNames.get(i));
            ++i;
        }
        return builder.toString();
    }

    @Override
    public final ArchitecturalViewNode copy(ArchitecturalViewElement parent) {
        assert (this.supportsCopy()) : "Not supported";
        return null;
    }

    @Override
    public final String getImageResourceName() {
        return ImageSupport.getImageResourceName(this.m_properties.getOutgoingDependencyMode());
    }

    @Override
    public final ImageDecoratorInfo getImageResourceDecoratorInfo() {
        ImageSupport.Marker marker = ImageSupport.Marker.NONE;
        if (this.hasViolation()) {
            marker = ImageSupport.Marker.HAS_VIOLATION;
        } else if (this.hasIssues(new IIssueId[0])) {
            marker = ImageSupport.Marker.HAS_WARNING;
        }
        return ImageSupport.getImageResourceDecoratorInfo(this.m_properties.getIncomingDependencyMode(), this.m_properties.getVisibility(), marker, this.hasPartialElements(), this.hasPartialDependencies());
    }

    @Property
    public final String getStereotypes() {
        StringBuilder builder = new StringBuilder();
        if (!this.m_properties.getIncomingDependencyMode().equals(ArtifactIncomingDependencyMode.NONE)) {
            builder.append(this.m_properties.getIncomingDependencyMode().getPresentationName()).append(',');
        }
        builder.append(this.m_properties.getOutgoingDependencyMode().getPresentationName()).append(',');
        if (this.m_properties.getAssignmentMode() != ArtifactAssignmentMode.STANDARD) {
            builder.append(this.m_properties.getAssignmentMode().getPresentationName()).append(',');
        }
        for (ArtifactVisibility next : this.m_properties.getVisibility()) {
            builder.append(next.getPresentationName()).append(',');
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitArtifactPropertiesNode(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String getDebugInfo() {
        EmptyNodeProgrammingElement emptyNodeProgrammingElement = this.getEmptyNodeProgrammingElement();
        assert (emptyNodeProgrammingElement != null) : "'emptyNodeProgrammingElement' of method 'getDebugInfo' must not be null";
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n").append(emptyNodeProgrammingElement.getClass().getSimpleName()).append(": ").append(emptyNodeProgrammingElement.getShortName()).append(" [").append(Integer.toHexString(emptyNodeProgrammingElement.hashCode())).append("]");
        return builder.toString();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitArtifactPropertiesNode(ArtifactPropertiesNode var1);
    }
}

