/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.event;

import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.event.MultipleModifiableFileEvent;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.file.IPathType;
import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public final class MultipleModifiableFileModifiedEvent
extends MultipleModifiableFileEvent {
    private final Map<IModifiableFile, Info> m_modifiableFileToInfo = new THashMap();
    private final INavigationState m_navigationState;
    private final boolean m_isRestore;

    public MultipleModifiableFileModifiedEvent(ISoftwareSystemProvider provider) {
        super(provider);
        this.m_navigationState = null;
        this.m_isRestore = false;
    }

    public MultipleModifiableFileModifiedEvent(ISoftwareSystemProvider provider, INavigationState navigationState) {
        super(provider);
        this.m_navigationState = navigationState;
        this.m_isRestore = true;
    }

    public void add(IModifiableFile modifiableFile) {
        assert (this.m_isRestore) : "Must be restore event";
        this.m_modifiableFileToInfo.put(modifiableFile, new Info(null, EnumSet.of(Aspect.RESTORED_FROM_HISTORY)));
    }

    public void add(IModifiableFile modifiableFile, IOriginator trigger, EnumSet<Aspect> aspects) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'add' must not be null";
        assert (!this.m_isRestore) : "Must not be restore event";
        this.m_modifiableFileToInfo.put(modifiableFile, new Info(trigger, aspects));
    }

    public INavigationState getNavigationState() {
        assert (this.isRestoredFromHistory()) : "event is not restored from history";
        return this.m_navigationState;
    }

    public boolean isRestoredFromHistory() {
        return this.m_isRestore;
    }

    public Set<IModifiableFile> getModifiableFiles() {
        return Collections.unmodifiableSet(this.m_modifiableFileToInfo.keySet());
    }

    public IOriginator getModificationTrigger(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'getModificationTrigger' must not be null";
        Info info = this.m_modifiableFileToInfo.get(modifiableFile);
        assert (info != null) : "'info' of method 'getModificationTrigger' must not be null";
        return info.getModificationTrigger();
    }

    public EnumSet<Aspect> getAspects(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'getAspects' must not be null";
        Info info = this.m_modifiableFileToInfo.get(modifiableFile);
        assert (info != null) : "'info' of method 'getAspects' must not be null";
        return info.getAspects();
    }

    @Override
    public boolean containsPathOfType(IPathType ... pathTypes) {
        for (IModifiableFile nextModifiableFile : this.m_modifiableFileToInfo.keySet()) {
            IPathType[] iPathTypeArray = pathTypes;
            int n = pathTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IPathType nextPathType = iPathTypeArray[n2];
                if (nextPathType.equals(nextModifiableFile.getFileType())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static enum Aspect {
        RESTORED_FROM_HISTORY,
        CONTENT_MODIFIED,
        ADDITIONAL_INFO_MODIFIED,
        SAVED;

    }

    public static final class Info {
        private final IOriginator m_modificationTrigger;
        private final EnumSet<Aspect> m_aspects = EnumSet.noneOf(Aspect.class);

        public Info(IOriginator trigger, EnumSet<Aspect> aspects) {
            this.m_modificationTrigger = trigger;
            this.m_aspects.addAll(aspects);
        }

        public IOriginator getModificationTrigger() {
            return this.m_modificationTrigger;
        }

        public EnumSet<Aspect> getAspects() {
            return EnumSet.copyOf(this.m_aspects);
        }
    }
}

