/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.element;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.ILanguageScope;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRoot;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.NamedElementHelper;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.CollectionUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public abstract class NamedElement
extends ElementWithIssues {
    public static final IFilter ACCEPT_ALL = new IFilter(){

        @Override
        public boolean accept(NamedElement namedElement) {
            return true;
        }
    };
    private NamedElement m_parent;

    protected NamedElement(NamedElement parent) {
        this.m_parent = parent;
    }

    public String getFullyQualifiedNamePart() {
        return this.getShortName();
    }

    @Override
    @Property
    public String getName() {
        return super.getName();
    }

    private void appendFullyQualifiedNamePart(StringBuilder builder, boolean original) {
        assert (builder != null) : "Parameter 'builder' of method 'appendFullyQualifiedNamePart' must not be null";
        NamedElement parent = this.getParent();
        if (parent != null) {
            NamedElement namedElement = parent = original ? parent.getOriginal() : parent;
            if (parent != null && !(parent instanceof IRoot)) {
                parent.appendFullyQualifiedNamePart(builder, original);
                builder.append(Element.DESCRIPTOR_NAME_PARTS_SEPARATOR);
            }
        }
        builder.append(Element.escapeSpecialCharacters(this.getFullyQualifiedNamePart()));
    }

    public String getFullyQualifiedName() {
        StringBuilder builder = new StringBuilder();
        this.appendFullyQualifiedNamePart(builder, false);
        return builder.toString();
    }

    public String getOriginalFullyQualifiedName() {
        StringBuilder builder = new StringBuilder();
        this.getOriginal().appendFullyQualifiedNamePart(builder, true);
        return builder.toString();
    }

    @Property
    public String fullyQualifiedName() {
        String fqName = this.getFullyQualifiedName();
        return !this.getName().equals(fqName) ? fqName : null;
    }

    @Property
    public String originalFullyQualifiedName() {
        String originalFullyQualifiedName = this.getOriginalFullyQualifiedName();
        String fullyQualifiedName = this.getFullyQualifiedName();
        return fullyQualifiedName != null && !fullyQualifiedName.equals(originalFullyQualifiedName) ? originalFullyQualifiedName : null;
    }

    public NamedElement resolveByFullyQualifiedNamePart(String fqNamePart) {
        assert (fqNamePart != null && fqNamePart.length() > 0) : "Parameter 'fqNamePart' of method 'resolveByFullyQualifiedNamePart' must not be empty";
        for (NamedElement namedElement : this.getAllChildren()) {
            if (!fqNamePart.equals(namedElement.getFullyQualifiedNamePart())) continue;
            return namedElement;
        }
        return null;
    }

    public NamedElement resolveOriginalByFullyQualifiedNamePart(String namePart) {
        assert (namePart != null) : "Parameter 'namePart' of method 'resolveOriginalByFullyQualifiedNamePart' must not be null";
        NamedElement original = this.getOriginal();
        for (NamedElement namedElement : original.getAllChildren()) {
            if (!namePart.equals(namedElement.getOriginal().getFullyQualifiedNamePart())) continue;
            return namedElement;
        }
        if (original != this) {
            for (NamedElement namedElement : this.getAllChildren()) {
                if (!namePart.equals(namedElement.getOriginal().getFullyQualifiedNamePart())) continue;
                return namedElement;
            }
        }
        return null;
    }

    @Override
    public Element.IPropertiesManager getPropertiesManager() {
        NamedElement parent = this.getParent();
        if (parent != null) {
            return parent.getPropertiesManager();
        }
        return null;
    }

    @Override
    public ElementWithIssues.IIssueManager getIssueManager() {
        NamedElement parent = this.getParent();
        if (parent != null) {
            return parent.getIssueManager();
        }
        assert (false) : "Unable to find issue manager for element '" + this.getClass().getName() + "'";
        return null;
    }

    public IVirtualModel getCurrentModel() {
        NamedElement parent = this.getParent();
        if (parent != null) {
            return parent.getCurrentModel();
        }
        assert (false) : "Unable to find current virtual model for element '" + this.getClass().getName() + "'";
        return null;
    }

    public void setModelServiceProvider(IModelServiceProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'setModelServiceProvider' must not be null";
    }

    public IDomainRoot.Domain getDomain() {
        IDomainRoot domainRoot = this.getParent(IDomainRoot.class, new Class[0]);
        return domainRoot != null ? domainRoot.getDomain() : null;
    }

    @Override
    public NamedElement clone() {
        NamedElement result = (NamedElement)super.clone();
        ArrayList<NamedElement> children = result.getModifiableChildrenList();
        if (children != null) {
            result.setModifiableChildrenList((ArrayList)children.clone());
        }
        return result;
    }

    @Override
    public RefactoringState getRefactoringState() {
        return this.getCurrentModel().getRefactoringState(this);
    }

    @Override
    public boolean hasBeenDirectlyRefactored() {
        return this.hasIssues(IssueCategory.REFACTORING);
    }

    @Override
    public boolean isExcluded() {
        NamedElement parent = this.getParent();
        return parent != null ? parent.isExcluded() : false;
    }

    @Override
    @Property
    public boolean ignoreIssues() {
        NamedElement parent = this.getParent();
        return parent != null ? parent.ignoreIssues() : false;
    }

    public Language getLanguage() {
        ILanguageScope languageScope = this.getParent(ILanguageScope.class, new Class[0]);
        return languageScope != null ? languageScope.getLanguage() : null;
    }

    @Override
    public boolean isValid() {
        NamedElement parent = this.getParent();
        return parent != null ? parent.isValid() : false;
    }

    public void setParent(NamedElement parent) {
        this.m_parent = parent;
    }

    @Override
    public NamedElement getElement() {
        return this;
    }

    @Override
    public NamedElement getOriginal() {
        return this;
    }

    @Override
    public NamedElement getRepresentative() {
        return this;
    }

    public boolean isDefinedInEnclosingElement() {
        return true;
    }

    public boolean isCompilerGenerated() {
        return false;
    }

    public NamedElement getParent() {
        return this.m_parent;
    }

    protected final NamedElement getParent(IModelServiceProvider msp) {
        return msp == null ? this.m_parent : msp.getCurrentModel().mapElement(this.m_parent);
    }

    protected final List<NamedElement> getChildren(IModelServiceProvider msp) {
        List<NamedElement> children = this.getChildrenList();
        if (children.isEmpty()) {
            return children;
        }
        if (msp != null) {
            ArrayList<NamedElement> result = new ArrayList<NamedElement>(children.size());
            IVirtualModel currentModel = msp.getCurrentModel();
            children.forEach(c -> {
                boolean bl = result.add(currentModel.mapElement(c));
            });
            return result;
        }
        return new ArrayList<NamedElement>(children);
    }

    protected final NamedElement getOriginal(IModelServiceProvider msp) {
        return msp != null ? msp.getCurrentModel().getOriginal(this) : this;
    }

    protected final NamedElement getRepresentative(IModelServiceProvider msp) {
        return msp != null ? msp.getCurrentModel().mapElement(this) : this;
    }

    public final <T> T getParent(Class<T> clazz, Class<?> ... stopClasses) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getParent' must not be null";
        NamedElement parent = this.getParent();
        while (parent != null) {
            if (clazz.isAssignableFrom(parent.getClass())) {
                return (T)parent;
            }
            if (stopClasses != null) {
                Class<?>[] classArray = stopClasses;
                int n = stopClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> stopper = classArray[n2];
                    if (stopper.isAssignableFrom(parent.getClass())) {
                        return null;
                    }
                    ++n2;
                }
            }
            parent = parent.getParent();
        }
        return null;
    }

    public final <T> T getOriginalParent(Class<T> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getOrignalParent' must not be null";
        NamedElement nextParent = this.getOriginal().getParent();
        NamedElement originalParent = nextParent != null ? nextParent.getOriginal() : null;
        while (originalParent != null) {
            if (clazz.isAssignableFrom(originalParent.getClass())) {
                return (T)originalParent;
            }
            nextParent = originalParent.getParent();
            NamedElement namedElement = originalParent = nextParent != null ? nextParent.getOriginal() : null;
        }
        return null;
    }

    public final <T> T getParent(Class<T> clazz, ParentMode mode) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getParent' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'getParent' must not be null";
        NamedElement parentMatchingClass = null;
        if (mode.includeSelf() && clazz.isAssignableFrom(this.getClass())) {
            parentMatchingClass = this;
            if (ParentMode.SELF_OR_FIRST_PARENT == mode) {
                return (T)parentMatchingClass;
            }
        }
        NamedElement parent = this.getParent();
        while (parent != null) {
            if (clazz.isAssignableFrom(parent.getClass())) {
                parentMatchingClass = parent;
                if (ParentMode.TOPMOST_PARENT_OR_SELF != mode) {
                    return (T)parentMatchingClass;
                }
            }
            parent = mode != ParentMode.ONLY_DIRECT_PARENT ? parent.getParent() : null;
        }
        return (T)parentMatchingClass;
    }

    public final <T> T getFirstParent(Class<T> clazz, Predicate<T> predicate) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getFirstParent' must not be null";
        assert (predicate != null) : "Parameter 'predicate' of method 'getFirstParent' must not be null";
        NamedElement parent = this.getParent();
        while (parent != null) {
            if (clazz.isAssignableFrom(parent.getClass()) && predicate.test(parent)) {
                return (T)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public final <T> List<T> getParents(Class<T> clazz, Class<?> ... stopClasses) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getParent' must not be null";
        ArrayList<NamedElement> parents = new ArrayList<NamedElement>();
        NamedElement parent = this.getParent();
        while (parent != null) {
            boolean stop = false;
            if (stopClasses != null) {
                Class<?>[] classArray = stopClasses;
                int n = stopClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> stopper = classArray[n2];
                    if (stopper.isAssignableFrom(parent.getClass())) {
                        stop = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (stop) {
                parents.trimToSize();
                return parents;
            }
            if (clazz.isAssignableFrom(parent.getClass())) {
                parents.add(parent);
            }
            parent = parent.getParent();
        }
        parents.trimToSize();
        return parents;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean hasAsParent(NamedElement potentialParent, boolean onlyDirectParent) {
        if (!NamedElement.$assertionsDisabled && potentialParent == null) {
            throw new AssertionError((Object)"Parameter 'potentialParent' of method 'hasAsParent' must not be null");
        }
        parent = this.getParent();
        if (!onlyDirectParent) ** GOTO lbl13
        if (parent == potentialParent) {
            return true;
        }
        if (!parent.isGhost()) {
            return false;
        }
        return parent.hasAsParent(potentialParent, true);
lbl-1000:
        // 1 sources

        {
            if (parent == potentialParent) {
                return true;
            }
            parent = parent.getParent();
lbl13:
            // 2 sources

            ** while (parent != null)
        }
lbl14:
        // 1 sources

        return false;
    }

    public boolean changeParent(NamedElement parent, boolean updateChildRelationship) {
        assert (parent != null) : "Parameter 'parent' of method 'changeParent' must not be null";
        NamedElement oldParent = this.m_parent;
        if (this.m_parent != parent) {
            this.m_parent = parent;
            if (updateChildRelationship) {
                parent.addChild(this);
                if (oldParent != null) {
                    oldParent.removeChild(this);
                }
            }
            return true;
        }
        return false;
    }

    protected ArrayList<NamedElement> getModifiableChildrenList() {
        return null;
    }

    public boolean hasChildren() {
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        return children != null && !children.isEmpty();
    }

    protected void setModifiableChildrenList(ArrayList<NamedElement> children) {
        assert (false) : this.getClass().getName() + " cannot have children";
        assert (children != null) : "Parameter 'children' of method 'setModifiableChildrenList' must not be null";
    }

    public void dispose() {
        this.setParent(null);
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children != null) {
            children.clear();
            this.setModifiableChildrenList(null);
        }
    }

    public void addChild(NamedElement child) {
        assert (child != null) : "'child' must not be null";
        assert (child.getParent() == this) : "'child' has wrong parent";
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children == null) {
            children = new ArrayList();
            this.setModifiableChildrenList(children);
        }
        children.add(child);
    }

    public final <T> int getIndexOf(Class<T> clazz, NamedElement child) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getIndexOf' must not be null";
        assert (child != null) : "Parameter 'child' of method 'getIndexOf' must not be null";
        assert (this.getChildren().contains(child)) : "Not a child: " + String.valueOf(child);
        assert (clazz.isAssignableFrom(child.getClass())) : "'child' is not a subtype of: " + String.valueOf(clazz);
        return this.getChildren(clazz).indexOf(child);
    }

    public final <T> void moveChild(Class<T> clazz, NamedElement child, int index) {
        assert (clazz != null) : "Parameter 'clazz' of method 'addChild' must not be null";
        assert (child != null) : "'child' must not be null";
        assert (clazz.isAssignableFrom(child.getClass())) : "'child' is not a subtype of: " + String.valueOf(clazz);
        assert (index >= 0) : "Parameter 'index' must be positive, but is " + index;
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children == null) {
            child.changeParent(this, true);
            return;
        }
        int currentIndex = 0;
        int realCurrentIndex = 0;
        int realFromIndex = children.indexOf(child);
        int realToIndex = -1;
        if (realFromIndex == -1) {
            child.getParent().removeChild(child);
            child.setParent(this);
        }
        for (NamedElement nextChild : children) {
            if (clazz.isAssignableFrom(nextChild.getClass())) {
                if (child == nextChild) {
                    realFromIndex = realCurrentIndex;
                }
                if (index == currentIndex) {
                    realToIndex = realCurrentIndex;
                }
                ++currentIndex;
            }
            ++realCurrentIndex;
        }
        if (realToIndex == -1) {
            children.add(child);
            if (realFromIndex > -1) {
                children.remove(realFromIndex);
            }
        } else if (realToIndex != realFromIndex) {
            children.add(realToIndex, child);
            if (realFromIndex > -1) {
                children.remove(realToIndex < realFromIndex ? realFromIndex + 1 : realFromIndex);
            }
        }
    }

    public final boolean performRemoveChild(NamedElement child) {
        assert (child != null) : "Parameter 'child' of method 'performRemoveChild' must not be null";
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children != null && children.remove(child) && children.isEmpty()) {
            this.setModifiableChildrenList(null);
            return true;
        }
        return false;
    }

    public void removeChild(NamedElement child) {
        assert (child != null) : "Parameter 'child' of method 'removeChild' must not be null";
        if (this.performRemoveChild(child)) {
            this.lastChildRemoved();
        }
    }

    public final boolean removeChildren(Class<?> ... clazzes) {
        List<NamedElement> children = this.getChildren();
        if (!children.isEmpty()) {
            ArrayList<NamedElement> toBeRemoved = new ArrayList<NamedElement>(children.size());
            for (NamedElement nextChild : children) {
                boolean remove = false;
                if (clazzes == null || clazzes.length == 0) {
                    remove = true;
                } else {
                    Class<?>[] classArray = clazzes;
                    int n = clazzes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> nextClazz = classArray[n2];
                        if (nextClazz.isAssignableFrom(nextChild.getClass())) {
                            remove = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!remove) continue;
                toBeRemoved.add(nextChild);
            }
            toBeRemoved.forEach(r -> r.remove());
            return !toBeRemoved.isEmpty();
        }
        return false;
    }

    public final boolean hasChildrenExcept(Class<?> ... clazzes) {
        List<NamedElement> children = this.getChildren();
        if (!children.isEmpty()) {
            for (NamedElement nextChild : children) {
                Class<?>[] classArray = clazzes;
                int n = clazzes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> nextClazz = classArray[n2];
                    if (!nextClazz.isAssignableFrom(nextChild.getClass())) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    public void parentRemoved() {
        this.getChildrenList().forEach(c -> c.parentRemoved());
    }

    public void remove() {
        if (this.m_parent != null) {
            this.m_parent.removeChild(this);
            this.m_parent = null;
        }
        this.getChildrenList().forEach(c -> c.parentRemoved());
    }

    public final int getNumberOfChildren() {
        return this.getChildren().size();
    }

    public List<? extends NamedElement> getAllChildren() {
        return this.getChildren();
    }

    public List<? extends NamedElement> getAllChildrenExceptGhosts() {
        ArrayList<? extends NamedElement> result = new ArrayList<NamedElement>();
        for (NamedElement namedElement : this.getAllChildren()) {
            if (namedElement.isGhost()) {
                result.addAll(namedElement.getAllChildrenExceptGhosts());
                continue;
            }
            result.add(namedElement);
        }
        return result;
    }

    public List<? extends NamedElement> getAllChildren(IFilter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'getAllChildren' must not be null";
        return CollectionUtility.select(this.getAllChildren(), namedElement -> filter.accept((NamedElement)namedElement));
    }

    public List<? extends NamedElement> getAllChildrenExceptGhosts(IFilter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'getAllChildrenExceptGhosts' must not be null";
        return CollectionUtility.select(this.getAllChildrenExceptGhosts(), namedElement -> filter.accept((NamedElement)namedElement));
    }

    protected void lastChildRemoved() {
    }

    public boolean removeOnLastChildRemoval() {
        return false;
    }

    public final boolean hasChildren(boolean exactClass, Class<?> ... clazzes) {
        assert (clazzes != null) : "Parameter 'clazzes' of method 'hasChildren' must not be null";
        List<NamedElement> children = this.getChildren();
        if (clazzes.length == 0) {
            return !children.isEmpty();
        }
        for (NamedElement nextChild : children) {
            Class<?>[] classArray = clazzes;
            int n = clazzes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> nextClazz = classArray[n2];
                if (exactClass ? nextClazz.equals(nextChild.getClass()) : nextClazz.isAssignableFrom(nextChild.getClass())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public final boolean hasChildren(IFilter filter, Class<?> clazz) {
        assert (filter != null) : "Parameter 'filter' of method 'hasChildren' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'hasChildren' must not be null";
        for (NamedElement nextChild : this.getChildren()) {
            if (!filter.accept(nextChild) || !clazz.isAssignableFrom(nextChild.getClass())) continue;
            return true;
        }
        return false;
    }

    public final boolean hasChildrenRecursively(Class<?> ... clazzes) {
        assert (clazzes != null) : "Parameter 'clazzes' of method 'hasChildren' must not be null";
        List<NamedElement> children = this.getChildren();
        for (NamedElement nextChild : children) {
            Class<?>[] classArray = clazzes;
            int n = clazzes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> nextClazz = classArray[n2];
                if (nextClazz.isAssignableFrom(nextChild.getClass())) {
                    return true;
                }
                ++n2;
            }
        }
        for (NamedElement nextChild : children) {
            if (!nextChild.hasChildrenRecursively(clazzes)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasAllChildren(boolean exactClass, Class<?> ... clazzes) {
        assert (clazzes != null) : "Parameter 'clazzes' of method 'hasAllChildren' must not be null";
        for (NamedElement namedElement : this.getAllChildren()) {
            Class<?>[] classArray = clazzes;
            int n = clazzes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> nextClazz = classArray[n2];
                if (exactClass ? nextClazz.equals(namedElement.getClass()) : nextClazz.isAssignableFrom(namedElement.getClass())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public final boolean hasAllChildrenRecursively(Class<?> ... clazzes) {
        assert (clazzes != null) : "Parameter 'clazzes' of method 'hasChildren' must not be null";
        List<? extends NamedElement> children = this.getAllChildren();
        for (NamedElement namedElement : children) {
            Class<?>[] classArray = clazzes;
            int n = clazzes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> nextClazz = classArray[n2];
                if (nextClazz.isAssignableFrom(namedElement.getClass())) {
                    return true;
                }
                ++n2;
            }
        }
        for (NamedElement namedElement : children) {
            if (!namedElement.hasAllChildrenRecursively(clazzes)) continue;
            return true;
        }
        return false;
    }

    public final List<NamedElement> forgetChildren(boolean setParentToNull) {
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children != null) {
            if (setParentToNull) {
                children.forEach(c -> c.setParent(null));
            }
            this.setModifiableChildrenList(null);
            this.lastChildRemoved();
        }
        return children;
    }

    public boolean persistChildren(ISnapshotProcessor.Mode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'persistChildren' must not be null";
        return true;
    }

    public List<NamedElement> getChildrenList() {
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        return children == null ? Collections.emptyList() : Collections.unmodifiableList(children);
    }

    public List<NamedElement> getChildren() {
        return this.getChildrenList();
    }

    private <T> List<T> getChildren(Class<T> clazz, boolean exactClass, boolean originals) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getChildren' must not be null";
        List<NamedElement> children = this.getChildren();
        ArrayList<NamedElement> filtered = new ArrayList<NamedElement>(children.size());
        for (NamedElement nextChild : children) {
            if (!(exactClass ? clazz.equals(nextChild.getClass()) : clazz.isAssignableFrom(nextChild.getClass()))) continue;
            filtered.add(originals ? nextChild.getOriginal() : nextChild);
        }
        filtered.trimToSize();
        return filtered;
    }

    public final <T> List<T> getChildren(Class<T> clazz, boolean exactClass) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getChildren' must not be null";
        return this.getChildren(clazz, exactClass, false);
    }

    public final <T> List<T> getChildren(Class<T> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getChildren' must not be null";
        return this.getChildren(clazz, false);
    }

    public final <T> List<T> getChildren(IFilter filter, Class<T> clazz) {
        assert (filter != null) : "Parameter 'filter' of method 'getChildren' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'getChildren' must not be null";
        ArrayList<T> result = new ArrayList<T>();
        for (T next : this.getChildren(clazz)) {
            if (!filter.accept((NamedElement)next)) continue;
            result.add(next);
        }
        return result;
    }

    private <T> void getChildrenRecursively(IFilter filter, List<T> collector, boolean originals, Class<T> clazz, Class<?> ... stopClasses) {
        assert (filter != null) : "Parameter 'filter' of method 'getChildrenRecursively' must not be null";
        for (NamedElement nextChild : this.getChildren()) {
            Class<?> nextChildClass;
            if (originals) {
                nextChild = nextChild.getOriginal();
            }
            if (clazz.isAssignableFrom(nextChildClass = nextChild.getClass()) && filter.accept(nextChild)) {
                collector.add(nextChild);
            }
            if (NamedElementHelper.isStopElement(nextChildClass, stopClasses)) continue;
            nextChild.getChildrenRecursively(filter, collector, originals, clazz, stopClasses);
        }
    }

    public final <T> List<T> getChildrenRecursively(Class<T> clazz, Class<?> ... stopClasses) {
        ArrayList collector = new ArrayList();
        this.getChildrenRecursively(ACCEPT_ALL, collector, false, clazz, stopClasses);
        return collector;
    }

    public final <T extends NamedElement> List<T> getOriginalChildren(Class<T> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getOriginalChildren' must not be null";
        return this.getChildren(clazz, false, true);
    }

    public final <T> List<T> getOriginalChildrenRecursively(Class<T> clazz, Class<?> ... stopClasses) {
        ArrayList collector = new ArrayList();
        this.getChildrenRecursively(ACCEPT_ALL, collector, true, clazz, stopClasses);
        return collector;
    }

    public final <T> List<T> getChildrenRecursively(IFilter filter, Class<T> clazz, Class<?> ... stopClasses) {
        ArrayList collector = new ArrayList();
        this.getChildrenRecursively(filter, collector, false, clazz, stopClasses);
        return collector;
    }

    public final <T> T getFirstChild(IFilter filter, Class<T> clazz) {
        assert (filter != null) : "Parameter 'filter' of method 'findFirstChild' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'findFirstChildByShortNameAndLineNumber' must not be null";
        for (NamedElement nextChild : this.getChildren()) {
            if (!clazz.isAssignableFrom(nextChild.getClass()) || !filter.accept(nextChild)) continue;
            return (T)nextChild;
        }
        return null;
    }

    public final <T> T getFirstChildRecursively(IFilter filter, Class<T> clazz, Class<?> ... stopClasses) {
        assert (filter != null) : "Parameter 'filter' of method 'findFirstChildRecursively' must not be null";
        NamedElement result = null;
        for (NamedElement nextChild : this.getChildren()) {
            boolean stop = false;
            if (clazz.isAssignableFrom(nextChild.getClass())) {
                result = filter.accept(nextChild) ? nextChild : nextChild.getFirstChildRecursively(filter, clazz, stopClasses);
            } else {
                if (stopClasses != null) {
                    Class<?>[] classArray = stopClasses;
                    int n = stopClasses.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> stopper = classArray[n2];
                        if (stopper.isAssignableFrom(nextChild.getClass())) {
                            stop = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!stop) {
                    result = nextChild.getFirstChildRecursively(filter, clazz, stopClasses);
                }
            }
            if (result != null) break;
        }
        return (T)result;
    }

    public final <T> T getFirstChild(Class<T> clazz) {
        return this.getFirstChild(ACCEPT_ALL, clazz);
    }

    public final <T> T getUniqueChild(IFilter filter, Class<T> clazz) {
        assert (filter != null) : "Parameter 'filter' of method 'getUniqueChild' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'getUniqueChild' must not be null";
        List<T> children = this.getChildren(filter, clazz);
        if (!children.isEmpty()) {
            if (children.size() == 1) {
                return children.get(0);
            }
            assert (false) : "Only one child matching the filter '" + String.valueOf(filter) + "' of type '" + clazz.getName() + "' expected, but found " + children.size();
        }
        return null;
    }

    public final <T> T getUniqueChild(Class<T> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getUniqueChild' must not be null";
        return this.getUniqueChild(ACCEPT_ALL, clazz);
    }

    public final <T> T getUniqueExistingChild(Class<T> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getUniqueExistingChild' must not be null";
        T child = this.getUniqueChild(ACCEPT_ALL, clazz);
        assert (child != null) : "Parameter 'child' of method 'getUniqueExistingChild' must not be null for class '" + clazz.getName() + "' in parent: " + String.valueOf(this);
        return child;
    }

    public void finishModification() {
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children != null) {
            children.trimToSize();
        }
    }

    public boolean ignoreInModelSearch() {
        return this.isGhost();
    }

    public boolean ignoreInModelRepresentation() {
        return true;
    }

    public IStructureItem getStructureItem() {
        assert (this.ignoreInModelRepresentation()) : "Element allowed in Representation does not have IStructureItem: " + String.valueOf(this.getClass());
        return null;
    }

    public boolean isOfStructureItem(IStructureItem structureItem) {
        assert (structureItem != null) : "Parameter 'structureItem' of method 'isOfStructureItem' must not be null";
        return this.getStructureItem() == structureItem;
    }

    public final List<? extends IPersistable> getPersistableChildren() {
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        return children != null && children.size() > 0 ? Collections.unmodifiableList(children) : Collections.emptyList();
    }

    public final boolean hasPersistableChildren() {
        return this.hasChildren();
    }

    public void accept(INamedElementVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        visitor.visitNamedElement(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("\nFully qualified name: '");
        try {
            builder.append(this.getFullyQualifiedName());
        }
        catch (Throwable exception) {
            builder.append("<unable to determine>");
        }
        builder.append("'");
        return builder.toString();
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        NamedElement original = this.getOriginal();
        NamedElement representative = this.getRepresentative();
        builder.append("\n");
        builder.append(this == original ? "Is Original" : "Is Clone");
        builder.append("\n");
        builder.append("This: ").append(Integer.toHexString(this.hashCode()));
        builder.append("\n");
        builder.append("Original: ").append(Integer.toHexString(original.hashCode()));
        builder.append("\n");
        builder.append("Representative: ").append(Integer.toHexString(representative.hashCode()));
        builder.append("\n");
        builder.append("Original fully qualified name: ");
        builder.append(this.getOriginalFullyQualifiedName());
        builder.append("\n");
        builder.append("Original fully qualified name (part): ");
        builder.append(this.getOriginal().getFullyQualifiedNamePart());
        builder.append("\n");
        builder.append("Fully qualified name: ");
        builder.append(this.getFullyQualifiedName());
        builder.append("\n");
        builder.append("Fully qualified name (part): ");
        builder.append(this.getFullyQualifiedNamePart());
        NamedElement current = this.getParent();
        while (current != null && current.isValid()) {
            builder.append("\n");
            builder.append("Parent: ");
            builder.append(current.getName());
            builder.append(" (Class: ");
            builder.append(current.getClass().getName());
            builder.append(")");
            current = current.getParent();
        }
        return builder.toString();
    }

    @FunctionalInterface
    public static interface IFilter {
        public boolean accept(NamedElement var1);
    }

    public static interface INamedElementVisitor {
        public void visitNamedElement(NamedElement var1);

        public void visitChildrenOf(NamedElement var1);
    }
}

