/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.common;

import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;

public abstract class SonargraphException
extends Exception {
    private final Severity m_severity;

    public SonargraphException(String message) {
        super(message);
        this.m_severity = Severity.ERROR;
    }

    public SonargraphException(String message, Throwable cause) {
        this(message, cause, Severity.ERROR);
    }

    public SonargraphException(String message, Throwable cause, Severity severity) {
        super(message, cause);
        assert (severity != null) : "Parameter 'severity' of method 'SonargraphException' must not be null";
        this.m_severity = severity;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        Throwable cause = this.getCause();
        if (cause != null) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append(ExceptionUtility.collectAll((Throwable)cause));
        }
        return builder.toString();
    }

    public final Severity getSeverity() {
        return this.m_severity;
    }

    public static enum Severity {
        ERROR,
        WARNING;

    }
}

