/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableFilter;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.CustomPattern;
import java.util.Arrays;
import java.util.Set;

abstract class AssignableFilter
extends NamedElement
implements IAssignableFilter {
    private final IAssignableAttributeRetriever m_retriever;
    private final boolean m_isStrong;
    private final boolean m_isOptional;
    private final String[] m_params;
    private final String m_originalPattern;
    protected final int m_lineNumber;
    protected int m_matchingCount;

    protected AssignableFilter(NamedElement parent, IAssignableAttributeRetriever retriever, boolean isStrong, boolean isOptional, String originalPattern, String[] params, int lineNumber) {
        super(parent);
        assert (retriever != null) : "Parameter 'retriever' of method 'AssignableFilter' must not be null";
        assert (originalPattern != null && originalPattern.length() > 0) : "Parameter 'originalPattern' of method 'AssignableFilter' must not be empty";
        this.m_retriever = retriever;
        this.m_originalPattern = originalPattern;
        this.m_isStrong = isStrong;
        this.m_params = params;
        this.m_lineNumber = lineNumber;
        this.m_isOptional = isOptional;
    }

    protected AssignableFilter(IAssignableAttributeRetriever retriever, boolean isStrong, boolean isOptional, String originalPattern, String[] params, int lineNumber) {
        this(null, retriever, isStrong, isOptional, originalPattern, params, lineNumber);
    }

    @Override
    public final String getShortName() {
        return this.m_originalPattern + (String)(this.isStrong() ? Element.INNER_NAME_PARTS_SEPARATOR + "strong" : "");
    }

    @Override
    public final void reset() {
        this.m_matchingCount = 0;
    }

    @Override
    public final int getMatchingCount() {
        return this.m_matchingCount;
    }

    @Override
    public int getLineNumber() {
        return this.m_lineNumber;
    }

    protected final void setMatchingCount(int count) {
        this.m_matchingCount = count;
    }

    protected abstract boolean isMatching(String var1);

    @Override
    public final boolean matches(IWorkerContext workerContext, IAssignableToArtifact assignable, String context, Set<String> multipleAttributeInfoCollector) {
        block14: {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'matches' must not be null";
            assert (assignable != null) : "Parameter 'assignable' of method 'matches' must not be null";
            assert (context != null) : "Parameter 'context' of method 'matches' must not be null";
            Language language = this.m_retriever.getLanguage();
            if (language != null && !language.equals(assignable.getNamedElement().getLanguage())) {
                return false;
            }
            String attribute = this.m_retriever.getAttribute(workerContext, assignable, this.m_params);
            if (attribute == null || attribute.isEmpty()) break block14;
            String multipleAttributeInfo = this.m_retriever.getMultipleAttributeInfo();
            if (multipleAttributeInfo == null) {
                return this.isMatching(attribute);
            }
            if (multipleAttributeInfoCollector != null) {
                assert (context != null && context.length() > 0) : "Parameter 'context' of method 'matches' must not be empty";
                String[] stringArray = attribute.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String nextValue = stringArray[n2];
                    if (workerContext.hasBeenCanceled()) {
                        return false;
                    }
                    if (this.isMatching(nextValue)) {
                        multipleAttributeInfoCollector.add(multipleAttributeInfo + ": " + nextValue + " [" + context + "]");
                        return true;
                    }
                    ++n2;
                }
            } else {
                String[] stringArray = attribute.split(";");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String nextValue = stringArray[n3];
                    if (workerContext.hasBeenCanceled()) {
                        return false;
                    }
                    if (this.isMatching(nextValue)) {
                        return true;
                    }
                    ++n3;
                }
            }
        }
        return false;
    }

    @Override
    public final boolean matches(IWorkerContext workerContext, IAssignableToArtifact assignable) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'matches' must not be null";
        assert (assignable != null) : "Parameter 'assignable' of method 'matches' must not be null";
        return this.matches(workerContext, assignable, "", null);
    }

    public final IAssignableAttributeRetriever getRetriever() {
        return this.m_retriever;
    }

    @Override
    public final boolean isStrong() {
        return this.m_isStrong;
    }

    @Override
    public boolean isOptional() {
        return this.m_isOptional;
    }

    public final String[] getParams() {
        return this.m_params == null ? null : Arrays.copyOf(this.m_params, this.m_params.length);
    }

    @Override
    public final String getOriginalPattern() {
        return this.m_originalPattern;
    }

    @Override
    public String[] getLastCaptureGroups() {
        return CustomPattern.NO_MATCH;
    }

    @Override
    public AssignableFilter clone() {
        return (AssignableFilter)super.clone();
    }
}

