/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Collection;

public final class OnDemandCycleGroup
extends CycleGroup {
    private final Collection<Pair<NamedElement, NamedElement>> m_incomingRealEdges = new ArrayList<Pair<NamedElement, NamedElement>>();
    private final Collection<Pair<NamedElement, NamedElement>> m_outgoingRealEdges = new ArrayList<Pair<NamedElement, NamedElement>>();
    private final IDomainRoot.Domain m_domain;

    public OnDemandCycleGroup(NamedElement parent, IDomainRoot.Domain domain) {
        super(parent, false);
        assert (domain != null) : "Parameter 'domain' of method 'OnDemandCycleGroup' must not be null";
        this.m_domain = domain;
    }

    @Override
    public final String getShortName() {
        return "Cycle";
    }

    public void addIncomingRealEdges(Collection<? extends EdgeAdapter<? extends NodeAdapter>> edges) {
        assert (edges != null) : "Parameter 'edge' of method 'addRealEdge' must not be null";
        for (EdgeAdapter<? extends NodeAdapter> edgeAdapter : edges) {
            this.m_incomingRealEdges.add((Pair<NamedElement, NamedElement>)new Pair((Object)edgeAdapter.getFrom().getUnderlyingObject(), (Object)edgeAdapter.getTo().getUnderlyingObject()));
        }
    }

    public void addOutgoingRealEdges(Collection<? extends EdgeAdapter<? extends NodeAdapter>> edges) {
        assert (edges != null) : "Parameter 'edge' of method 'addRealEdge' must not be null";
        for (EdgeAdapter<? extends NodeAdapter> edgeAdapter : edges) {
            this.m_outgoingRealEdges.add((Pair<NamedElement, NamedElement>)new Pair((Object)edgeAdapter.getFrom().getUnderlyingObject(), (Object)edgeAdapter.getTo().getUnderlyingObject()));
        }
    }

    public Collection<Pair<NamedElement, NamedElement>> getIncomingRealEdges() {
        return this.m_incomingRealEdges;
    }

    public Collection<Pair<NamedElement, NamedElement>> getOutgoingRealEdges() {
        return this.m_outgoingRealEdges;
    }

    @Override
    public IDomainRoot.Domain getDomain() {
        return this.m_domain;
    }

    @Override
    public String getInformation() {
        int cyclicElements = this.getNumberOfCyclicElements();
        if (cyclicElements > 0) {
            StringBuilder info = new StringBuilder("Elements in cycle: ");
            int i = 0;
            for (NamedElement next : this.getCyclicNamedElements()) {
                info.append(StringUtility.LINE_SEPARATOR);
                info.append(next.getPresentationName(false));
                if (++i == 10) break;
            }
            if (i < cyclicElements) {
                info.append(StringUtility.LINE_SEPARATOR);
                info.append(cyclicElements - i);
                info.append(" element(s) omitted ...");
            }
            return info.toString();
        }
        return super.getInformation();
    }

    @Override
    public String getPresentationName(boolean parentIsPresented) {
        return "Cycle of " + this.getNumberOfCyclicElements();
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    @Override
    @Property
    public boolean isExternal() {
        for (NamedElement cyclicElement : this.getCyclicNamedElements()) {
            if (!cyclicElement.isExternal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Cycle of: ");
        builder.append(this.getNumberOfCyclicElements());
        for (NamedElement nextCyclic : this.getCyclicNamedElements()) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append(nextCyclic.getName());
        }
        return builder.toString();
    }
}

