/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.DuplicateBlockInfo;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.text.IntBasedHash;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import java.io.IOException;

public final class DuplicateCodeBlockOccurrence
extends NamedElement {
    private static final String BLOCK_INFO = "blockInfo";
    private DuplicateBlockInfo m_blockInfo;

    public DuplicateCodeBlockOccurrence(NamedElement parent) {
        super(parent);
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeObjectReference(BLOCK_INFO, (IPersistable)this.m_blockInfo);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        reader.readObjectReference(BLOCK_INFO, DuplicateBlockInfo.class, info -> {
            DuplicateBlockInfo duplicateBlockInfo = this.m_blockInfo = info;
        });
    }

    public DuplicateCodeBlockOccurrence(NamedElement parent, DuplicateBlockInfo blockInfo) {
        super(parent);
        assert (blockInfo != null) : "Parameter 'blockInfo' of method 'DuplicateCodeBlockOccurence' must not be null";
        this.m_blockInfo = blockInfo;
    }

    @Override
    public String getShortName() {
        return this.getSourceFile().getIdentifyingPath() + " (" + this.m_blockInfo.getBlockBegin() + "-" + this.m_blockInfo.getBlockEnd() + ")";
    }

    public String getBlockHash() {
        return this.m_blockInfo.getHash();
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public SourceFile getSourceFile() {
        return (SourceFile)this.m_blockInfo.getFile();
    }

    @Override
    public int getLineNumber() {
        return this.m_blockInfo.getBlockBegin();
    }

    @Property
    public int getBlockSize() {
        return this.m_blockInfo.getMatchedLineCount();
    }

    @Property
    public int getBlockSizeWithoutIgnored() {
        return this.m_blockInfo.getLogicalMatchedLineCount();
    }

    @Property
    public String getLineRange() {
        StringBuilder builder = new StringBuilder();
        builder.append(NumberUtility.format((Number)this.m_blockInfo.getBlockBegin()));
        builder.append('-');
        builder.append(NumberUtility.format((Number)this.m_blockInfo.getBlockEnd()));
        return builder.toString();
    }

    @Property
    public String getTolerance() {
        return String.valueOf(this.m_blockInfo.getTolerance());
    }

    public int getToleranceAsInt() {
        return this.m_blockInfo.getTolerance();
    }

    public int getBlockBegin() {
        return this.m_blockInfo.getBlockBegin();
    }

    @Override
    public String getImageResourceName() {
        return this.getSourceFile().getImageResourceName();
    }

    public String composeDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getSourceFile().getFile().getName());
        builder.append(" [");
        builder.append(this.getLineRange());
        builder.append("]");
        return builder.toString();
    }

    public int getBlockEnd() {
        return this.m_blockInfo.getBlockEnd();
    }

    public IntBasedHash getHashRepresentation() {
        return this.m_blockInfo.getHashCodesRepresentingLines();
    }
}

