/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CycleGroupIssueSourceFilesParticipationInfo
extends NamedElement {
    private final THashMap<CycleGroupIssue, List<SourceFile>> m_cycleGroupToInvolvedSourceFiles = new THashMap();
    private final IIssueId m_issueId;
    private boolean m_processed;

    public CycleGroupIssueSourceFilesParticipationInfo(NamedElement parent, IIssueId issueId) {
        super(parent);
        assert (issueId != null) : "Parameter 'issueId' of method 'CycleGroupIssueSourceFilesParticipationInfo' must not be null";
        this.m_issueId = issueId;
    }

    public IIssueId getIssueId() {
        return this.m_issueId;
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public boolean persist() {
        return false;
    }

    @Override
    public String getImageResourceName() {
        return "Cache";
    }

    @Override
    public String getShortName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void finishModification() {
        this.m_processed = true;
    }

    public boolean isProcessed() {
        return this.m_processed;
    }

    public synchronized void add(CycleGroupIssue cycle, Set<SourceFile> sourceFiles) {
        assert (cycle != null) : "Parameter 'cycle' of method 'add' must not be null";
        assert (sourceFiles != null && !sourceFiles.isEmpty()) : "Parameter 'sourceFiles' of method 'add' must not be empty";
        this.m_cycleGroupToInvolvedSourceFiles.put((Object)cycle, new ArrayList<SourceFile>(sourceFiles));
    }

    public Map<CycleGroupIssue, List<SourceFile>> getCycleGroupToSourceFiles() {
        return Collections.unmodifiableMap(this.m_cycleGroupToInvolvedSourceFiles);
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        int size = this.m_cycleGroupToInvolvedSourceFiles.size();
        builder.append("\n").append("Involved source files in ").append(size).append(" cycles: ");
        for (Map.Entry nextEntry : this.m_cycleGroupToInvolvedSourceFiles.entrySet()) {
            builder.append("\nIn cycle ").append(((CycleGroupIssue)nextEntry.getKey()).getName()).append(" are  ").append(((List)nextEntry.getValue()).size()).append(" issue(s)");
        }
        return builder.toString();
    }
}

