/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.foundation.common.graph.ICycleAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public final class CycleAnalyzerAdapter
implements ICycleAnalyzerAdapter {
    private final NodeAdapterSet<? extends NodeAdapter> m_nodeAdapterSet;
    private final Set<NodeAdapter> m_cyclicNodes = new THashSet();
    private final Map<NodeAdapter, Integer> m_nodeToGroup = new THashMap();

    public CycleAnalyzerAdapter(NodeAdapterSet<? extends NodeAdapter> nodeAdapterSet) {
        assert (nodeAdapterSet != null) : "Parameter 'nodeAdapterSet' of method 'GraphCycleAnalysisAdapter' must not be null";
        this.m_nodeAdapterSet = nodeAdapterSet;
    }

    public NodeAdapterSet<? extends NodeAdapter> getNodeAdapterSet() {
        return this.m_nodeAdapterSet;
    }

    public Collection<? extends NodeAdapter> getCyclicNodes() {
        return Collections.unmodifiableCollection(this.m_cyclicNodes);
    }

    public Integer getGroup(NodeAdapter nodeAdapter) {
        assert (nodeAdapter != null) : "Parameter 'nodeAdapter' of method 'getGroup' must not be null";
        Integer group = this.m_nodeToGroup.get(nodeAdapter);
        assert (group != null) : "'group' of method 'getGroup' must not be null";
        return group;
    }

    @Override
    public Collection<? extends INode<?>> getNodes() {
        return this.m_nodeAdapterSet.getNodes();
    }

    @Override
    public boolean isCyclic(INode<?> node) {
        assert (node != null) : "Parameter 'node' of method 'isCyclic' must not be null";
        return this.m_cyclicNodes.contains(node);
    }

    @Override
    public void setGroupIndex(INode<?> node, int cycleGroupIndex, boolean isCyclic) {
        assert (node != null) : "Parameter 'node' of method 'setCycleGroup' must not be null";
        this.m_nodeToGroup.put((NodeAdapter)node, cycleGroupIndex);
        if (isCyclic) {
            this.m_cyclicNodes.add((NodeAdapter)node);
        }
    }

    @Override
    public int getGroupIndex(INode<?> node) {
        assert (node != null) : "Parameter 'node' of method 'getCycleGroup' must not be null";
        Integer group = this.m_nodeToGroup.get(node);
        return group != null ? group : -1;
    }

    @Override
    public void setLevel(INode<?> node, int level) {
        assert (node != null && node instanceof NodeAdapter) : "Unexpected class in method 'setLevel': " + String.valueOf(node);
        ((NodeAdapter)node).setLevel(level);
    }
}

