/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class HistoryTable<T extends ITableEntry> {
    private final List<T> m_undoEntries = new ArrayList<T>();
    private final List<T> m_redoEntries = new ArrayList<T>();

    public final List<T> addEntry(T entry) {
        assert (entry != null) : "Parameter 'entry' of method 'addEntry' must not be null";
        this.m_undoEntries.add(entry);
        ArrayList<T> entriesToDelete = new ArrayList<T>(this.m_redoEntries);
        this.m_redoEntries.clear();
        return entriesToDelete;
    }

    public boolean isUndoPossible() {
        return !this.m_undoEntries.isEmpty();
    }

    public final boolean isRedoPossible() {
        return !this.m_redoEntries.isEmpty();
    }

    public final List<T> getUndoEntries() {
        return Collections.unmodifiableList(this.m_undoEntries);
    }

    public final List<T> getRedoEntries() {
        return Collections.unmodifiableList(this.m_redoEntries);
    }

    protected final List<T> getModifiableUndoEntries() {
        return this.m_undoEntries;
    }

    protected final List<T> getModifiableRedoEntries() {
        return this.m_redoEntries;
    }

    public final List<T> undo() {
        assert (this.isUndoPossible()) : "Undo not possible";
        ArrayList<ITableEntry> result = new ArrayList<ITableEntry>();
        int last = this.m_undoEntries.size();
        long id = -1L;
        do {
            ITableEntry entry = (ITableEntry)this.m_undoEntries.remove(--last);
            this.m_redoEntries.add(0, entry);
            result.add(entry);
            id = entry.getTransactionId();
        } while (last > 0 && ((ITableEntry)this.m_undoEntries.get(last - 1)).getTransactionId() == id);
        Collections.reverse(result);
        return Collections.unmodifiableList(result);
    }

    public final List<T> redo() {
        assert (this.isRedoPossible()) : "Redo not possible";
        ArrayList<ITableEntry> result = new ArrayList<ITableEntry>();
        long id = -1L;
        do {
            ITableEntry entry = (ITableEntry)this.m_redoEntries.remove(0);
            this.m_undoEntries.add(entry);
            result.add(entry);
            id = entry.getTransactionId();
        } while (this.m_redoEntries.size() > 0 && ((ITableEntry)this.m_redoEntries.get(0)).getTransactionId() == id);
        return Collections.unmodifiableList(result);
    }

    public final int getSize() {
        return this.m_undoEntries.size() + this.m_redoEntries.size();
    }

    public final void clear() {
        this.m_undoEntries.clear();
        this.m_redoEntries.clear();
    }

    public final List<T> getEntries() {
        ArrayList<T> result = new ArrayList<T>(this.m_undoEntries);
        result.addAll(this.m_redoEntries);
        return Collections.unmodifiableList(result);
    }

    public final T getLastAddedEntry() {
        if (this.m_undoEntries.isEmpty()) {
            return null;
        }
        return (T)((ITableEntry)this.m_undoEntries.get(this.m_undoEntries.size() - 1));
    }

    public T getNextEntryForUndo() {
        return this.getLastAddedEntry();
    }

    public T getNextEntryForRedo() {
        return (T)((ITableEntry)this.m_redoEntries.get(0));
    }

    public final int getUndoEntriesSize() {
        return this.m_undoEntries.size();
    }

    public final int getRedoEntriesSize() {
        return this.m_redoEntries.size();
    }

    public final boolean removeEntry(T entry) {
        boolean removedFromUndo = this.m_undoEntries.remove(entry);
        boolean removedFromRedo = this.m_redoEntries.remove(entry);
        return removedFromUndo || removedFromRedo;
    }

    public static interface IHistoryEntryChangedListener {
        public void entryChanged(ITableEntry var1);
    }

    public static interface ITableEntry {
        public long getTransactionId();
    }
}

