/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.sonargraph.core.foundation.common.graph.DependencyCumulator;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IIncomingDependencyCumulatorAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.BitSet;
import java.util.Collection;

public final class IncomingDependencyCumulator
extends DependencyCumulator {
    public IncomingDependencyCumulator(Collection<? extends INode<?>> nodes, IWorkerContext workerContext, IIncomingDependencyCumulatorAdapter adapter) {
        super(nodes, workerContext, adapter);
        this.m_workerContext.beginBlockOfWork(this.m_numberOfNodes);
        int numberOfIncluded = 0;
        int index = 0;
        for (INode<?> nextNode : nodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            if (this.m_included.get(index)) {
                int usedFrom;
                ++numberOfIncluded;
                BitSet reachable = this.m_reachable[index];
                if (reachable == null) {
                    reachable = new BitSet(this.m_numberOfNodes);
                    this.computeReachebleNodes(nextNode, index, reachable);
                    reachable.and(this.m_included);
                    this.m_reachable[index] = reachable;
                }
                this.m_cumulatedDependencies[index] = usedFrom = reachable.cardinality();
                adapter.setUsedFrom(nextNode, usedFrom);
            }
            this.m_workerContext.workItemCompleted();
            ++index;
        }
        index = 0;
        for (INode<?> nextNode : nodes) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            if (this.m_included.get(index)) {
                int usedFrom = this.m_cumulatedDependencies[index];
                float fanIn = numberOfIncluded == 0 ? 0.0f : (float)(100.0 * (double)usedFrom / (double)numberOfIncluded);
                adapter.setFanIn(nextNode, fanIn);
            }
            ++index;
        }
        this.m_workerContext.endStep();
    }

    @Override
    protected INode<?> getEndpoint(INode.IEdge edge) {
        return edge.getFrom();
    }

    @Override
    protected Collection<? extends INode.IEdge> getEdges(INode<?> node) {
        return node.getIncomingEdges();
    }
}

