/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.base;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import java.util.Objects;

public class NameValidator
implements ITextValidator {
    private final String m_extraCharsAllowed;

    public NameValidator() {
        this("");
    }

    public NameValidator(String extraCharsAllowed) {
        assert (extraCharsAllowed != null);
        this.m_extraCharsAllowed = extraCharsAllowed;
    }

    @Override
    public ValidationResult isValid(String currentInput, String newInput) {
        ValidationResult result = new ValidationResult(!Objects.equals(currentInput, newInput));
        if (newInput == null) {
            result.addError("Cannot be empty");
        } else if ((newInput = newInput.trim()).isEmpty()) {
            result.addError("Cannot be empty");
        } else if (!Character.isJavaIdentifierStart(newInput.charAt(0))) {
            result.addError("Must start with a letter");
        } else {
            int i = 1;
            while (i < newInput.length()) {
                char c = newInput.charAt(i);
                if (!Character.isJavaIdentifierPart(c) && this.m_extraCharsAllowed.indexOf(c) < 0) {
                    result.addError("Invalid character at index " + i);
                }
                ++i;
            }
        }
        return result;
    }
}

