/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.treemap;

import com.hello2morrow.sonargraph.core.controller.system.treemap.ColorValueAccessor;
import com.hello2morrow.sonargraph.core.controller.system.treemap.ComponentMetricFloatValueAdapter;
import com.hello2morrow.sonargraph.core.controller.system.treemap.ComponentMetricIntValueAdapter;
import com.hello2morrow.sonargraph.core.controller.system.treemap.FloatMetricBasedColorProvider;
import com.hello2morrow.sonargraph.core.controller.system.treemap.FloatValueAdapter;
import com.hello2morrow.sonargraph.core.controller.system.treemap.IntMetricBasedColorProvider;
import com.hello2morrow.sonargraph.core.controller.system.treemap.IntValueAdapter;
import com.hello2morrow.sonargraph.core.controller.system.treemap.NoScriptMetricFoundColorProvider;
import com.hello2morrow.sonargraph.core.controller.system.treemap.SourceFileMetricFloatValueAdapter;
import com.hello2morrow.sonargraph.core.controller.system.treemap.SourceFileMetricIntValueAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptMetricProvider;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.treemap.ILeafColorInfoProvider;
import com.hello2morrow.sonargraph.core.model.treemap.ScriptMetricValueSource;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapLeafElement;
import gnu.trove.map.hash.THashMap;
import java.util.Map;

public final class ColorScriptMetricValueAccessor
extends ColorValueAccessor {
    private final Map<Integer, IntMetricBasedColorProvider> m_intValueToColorProvider = new THashMap();
    private final Map<Float, FloatMetricBasedColorProvider> m_floatValueToColorProvider = new THashMap();
    private final NoScriptMetricFoundColorProvider m_noScriptMetricFoundColorProvider;
    private final Installation m_installation;
    private final SoftwareSystem m_softwareSystem;
    private final ScriptMetricValueSource m_valueSource;
    private IMetricDescriptor m_metricDescriptor;
    private IntValueAdapter m_intValueAdapter;
    private FloatValueAdapter m_floatValueAdapter;

    public ColorScriptMetricValueAccessor(Installation installation, SoftwareSystem softwareSystem, ScriptMetricValueSource valueSource) {
        assert (installation != null) : "Parameter 'installation' of method 'ColorScriptMetricValueAccessor' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ColorScriptMetricValueAccessor' must not be null";
        assert (valueSource != null) : "Parameter 'valueSource' of method 'ColorScriptMetricValueAccessor' must not be null";
        this.m_noScriptMetricFoundColorProvider = new NoScriptMetricFoundColorProvider(valueSource.getPresentationName());
        this.m_installation = installation;
        this.m_softwareSystem = softwareSystem;
        this.m_valueSource = valueSource;
    }

    private void checkAvailability() {
        block15: {
            IMetricAccessor metricAccessor;
            block16: {
                if (this.m_metricDescriptor != null) {
                    return;
                }
                assert (this.m_floatValueAdapter == null) : "Parameter 'm_floatValueAdapter' of method 'checkAvailability' must be null";
                assert (this.m_intValueAdapter == null) : "Parameter 'm_intValueAdapter' of method 'checkAvailability' must  be null";
                block8: for (ScriptMetricProvider next : this.m_installation.getMetricProviders().getChildren(ScriptMetricProvider.class)) {
                    if (!next.getProvider().getStandardName().equals(this.m_valueSource.getProvider())) continue;
                    for (IMetricDescriptor nextMetricDescriptor : next.getChildren(IMetricDescriptor.class)) {
                        IMetricLevel nextLevel;
                        if (!nextMetricDescriptor.getMetricId().getStandardName().equals(this.m_valueSource.getMetricId()) || ((nextLevel = nextMetricDescriptor.getLevel()) != CoreMetricLevel.COMPONENT || this.m_valueSource.getLeafElement() != TreeMapLeafElement.PHYSICAL_COMPONENT) && (nextLevel != CoreMetricLevel.SOURCE_FILE || this.m_valueSource.getLeafElement() != TreeMapLeafElement.PHYSICAL_SOURCE_FILE)) continue;
                        this.m_metricDescriptor = nextMetricDescriptor;
                        continue block8;
                    }
                }
                if (this.m_metricDescriptor == null) break block15;
                metricAccessor = this.m_installation.getExtension(IMetricAccessor.class);
                if (!this.m_metricDescriptor.isFloat()) break block16;
                switch (this.m_valueSource.getLeafElement()) {
                    case PHYSICAL_COMPONENT: {
                        this.m_floatValueAdapter = new ComponentMetricFloatValueAdapter(this.m_softwareSystem, metricAccessor, this.m_metricDescriptor);
                        break block15;
                    }
                    case PHYSICAL_SOURCE_FILE: {
                        this.m_floatValueAdapter = new SourceFileMetricFloatValueAdapter(this.m_softwareSystem, metricAccessor, this.m_metricDescriptor);
                        break block15;
                    }
                    default: {
                        assert (false) : "Unhandled leaf element: " + String.valueOf((Object)this.m_valueSource.getLeafElement());
                        break block15;
                    }
                }
            }
            switch (this.m_valueSource.getLeafElement()) {
                case PHYSICAL_COMPONENT: {
                    this.m_intValueAdapter = new ComponentMetricIntValueAdapter(this.m_softwareSystem, metricAccessor, this.m_metricDescriptor);
                    break;
                }
                case PHYSICAL_SOURCE_FILE: {
                    this.m_intValueAdapter = new SourceFileMetricIntValueAdapter(this.m_softwareSystem, metricAccessor, this.m_metricDescriptor);
                    break;
                }
                default: {
                    assert (false) : "Unhandled leaf element: " + String.valueOf((Object)this.m_valueSource.getLeafElement());
                    break;
                }
            }
        }
    }

    @Override
    ILeafColorInfoProvider getColorInfoProvider(NamedElement element) {
        this.checkAvailability();
        if (this.m_floatValueAdapter != null) {
            assert (this.m_metricDescriptor != null) : "'metricDescriptor' of method 'getColorInfoProvider' must not be null";
            float value = this.m_floatValueAdapter.getValue(element);
            float forcedValue = value < 0.0f ? 0.0f : value;
            this.getValueRange().process(0, (int)Math.ceil(forcedValue));
            Float valueAsFloat = Float.valueOf(forcedValue);
            FloatMetricBasedColorProvider provider = this.m_floatValueToColorProvider.get(valueAsFloat);
            if (provider == null) {
                provider = new FloatMetricBasedColorProvider(this.m_metricDescriptor.getMetricId(), valueAsFloat);
                this.m_floatValueToColorProvider.put(valueAsFloat, provider);
            }
            return provider;
        }
        if (this.m_intValueAdapter != null) {
            assert (this.m_metricDescriptor != null) : "'metricDescriptor' of method 'getColorInfoProvider' must not be null";
            int value = this.m_intValueAdapter.getValue(element);
            int forcedValue = value < 0 ? 0 : value;
            this.getValueRange().process(0, forcedValue);
            Integer valueAsInteger = forcedValue;
            IntMetricBasedColorProvider provider = this.m_intValueToColorProvider.get(valueAsInteger);
            if (provider == null) {
                provider = new IntMetricBasedColorProvider(this.m_metricDescriptor.getMetricId(), valueAsInteger);
                this.m_intValueToColorProvider.put(valueAsInteger, provider);
            }
            return provider;
        }
        return this.m_noScriptMetricFoundColorProvider;
    }
}

