/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.treemap;

import com.hello2morrow.sonargraph.core.controller.system.treemap.ColorOrHeightValueAccessor;
import com.hello2morrow.sonargraph.core.controller.system.treemap.ComponentAggregatorIntValueAdapter;
import com.hello2morrow.sonargraph.core.controller.system.treemap.ComponentMetricIntValueAdapter;
import com.hello2morrow.sonargraph.core.controller.system.treemap.IntMetricProvider;
import com.hello2morrow.sonargraph.core.controller.system.treemap.IntValueAdapter;
import com.hello2morrow.sonargraph.core.controller.system.treemap.SourceFileMetricIntValueAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.treemap.ILeafInfoProvider;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapLeafElement;
import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class ColorOrHeightIntMetricValueAccessor
extends ColorOrHeightValueAccessor {
    private static final Map<TreeMapLeafElement, List<IMetricId>> SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS = new LinkedHashMap<TreeMapLeafElement, List<IMetricId>>();
    private static final Map<TreeMapLeafElement, List<IMetricId>> SUPPORTED_COMPONENT_LEVEL_METRIC_IDS = new LinkedHashMap<TreeMapLeafElement, List<IMetricId>>();
    private final Map<Integer, IntMetricProvider> m_valueToColorProvider = new THashMap();
    private final IMetricDescriptor m_metricDescriptor;
    private final IntValueAdapter m_valueAdapter;

    static {
        SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS.put(TreeMapLeafElement.PHYSICAL_SOURCE_FILE, Arrays.asList(CoreMetricId.CORE_MAX_NESTING, CoreMetricId.CORE_CODE_CHURN_30, CoreMetricId.CORE_CODE_CHURN_90, CoreMetricId.CORE_CODE_CHURN_365, CoreMetricId.CORE_CODE_CHURN_2Y, CoreMetricId.CORE_CODE_CHURN_5Y, CoreMetricId.CORE_CHANGES_30, CoreMetricId.CORE_CHANGES_90, CoreMetricId.CORE_CHANGES_365, CoreMetricId.CORE_CHANGES_2Y, CoreMetricId.CORE_CHANGES_5Y, CoreMetricId.CORE_NUMBER_OF_AUTHORS_30, CoreMetricId.CORE_NUMBER_OF_AUTHORS_90, CoreMetricId.CORE_NUMBER_OF_AUTHORS, CoreMetricId.CORE_NUMBER_OF_AUTHORS_2Y, CoreMetricId.CORE_NUMBER_OF_AUTHORS_5Y, CoreMetricId.CORE_DAYS_SINCE_LAST_COMMIT));
        SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS.put(TreeMapLeafElement.PHYSICAL_COMPONENT, Arrays.asList(CoreMetricId.CORE_MAX_NESTING, CoreMetricId.CORE_CODE_CHURN_30, CoreMetricId.CORE_CODE_CHURN_90, CoreMetricId.CORE_CODE_CHURN_365, CoreMetricId.CORE_CODE_CHURN_2Y, CoreMetricId.CORE_CODE_CHURN_5Y, CoreMetricId.CORE_CHANGES_30, CoreMetricId.CORE_CHANGES_90, CoreMetricId.CORE_CHANGES_365, CoreMetricId.CORE_CHANGES_2Y, CoreMetricId.CORE_CHANGES_5Y, CoreMetricId.CORE_NUMBER_OF_AUTHORS_30, CoreMetricId.CORE_NUMBER_OF_AUTHORS_90, CoreMetricId.CORE_NUMBER_OF_AUTHORS, CoreMetricId.CORE_NUMBER_OF_AUTHORS_2Y, CoreMetricId.CORE_NUMBER_OF_AUTHORS_5Y, CoreMetricId.CORE_DAYS_SINCE_LAST_COMMIT));
        SUPPORTED_COMPONENT_LEVEL_METRIC_IDS.put(TreeMapLeafElement.PHYSICAL_COMPONENT, Arrays.asList(CoreMetricId.CORE_VIOLATIONS_COMPONENT_DEPENDENCIES, CoreMetricId.CORE_VIOLATIONS_PARSER_DEPENDENCIES, CoreMetricId.CORE_PHYSICAL_COHESION, CoreMetricId.CORE_PHYSICAL_COUPLING, CoreMetricId.CORE_DEPENDS_UPON_SYSTEM, CoreMetricId.CORE_DEPENDS_UPON_MODULE, CoreMetricId.CORE_USED_FROM_SYSTEM, CoreMetricId.CORE_USED_FROM_MODULE, CoreMetricId.CORE_INCOMING_DEPENDENCIES_SYSTEM, CoreMetricId.CORE_INCOMING_DEPENDENCIES_MODULE, CoreMetricId.CORE_OUTGOING_DEPENDENCIES_SYSTEM, CoreMetricId.CORE_OUTGOING_DEPENDENCIES_MODULE, CoreMetricId.CORE_TYPES));
    }

    static Map<TreeMapLeafElement, List<IMetricId>> getSupportedSourceFileLevelMetricIds() {
        return Collections.unmodifiableMap(SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS);
    }

    static Map<TreeMapLeafElement, List<IMetricId>> getSupportedComponentLevelMetricIds() {
        return Collections.unmodifiableMap(SUPPORTED_COMPONENT_LEVEL_METRIC_IDS);
    }

    ColorOrHeightIntMetricValueAccessor(IMetricAccessor metricAccessor, SoftwareSystem softwareSystem, IMetricDescriptor metricDescriptor, TreeMapLeafElement leafElement) {
        assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'ColorMetricValueAccessor' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ColorMetricValueAccessor' must not be null";
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'ColorMetricIntValueAccessor' must not be null";
        assert (leafElement != null) : "Parameter 'leafElement' of method 'ColorMetricValueAccessor' must not be null";
        this.m_metricDescriptor = metricDescriptor;
        IMetricId metricId = this.m_metricDescriptor.getMetricId();
        List<IMetricId> metricIds = SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS.get((Object)leafElement);
        if (metricIds != null && !metricIds.isEmpty() && metricIds.contains(metricId)) {
            assert (!metricId.isFloat()) : "Int metric expected";
            switch (leafElement) {
                case PHYSICAL_COMPONENT: {
                    this.m_valueAdapter = new ComponentAggregatorIntValueAdapter(new SourceFileMetricIntValueAdapter(softwareSystem, metricAccessor, this.m_metricDescriptor));
                    break;
                }
                case PHYSICAL_SOURCE_FILE: {
                    this.m_valueAdapter = new SourceFileMetricIntValueAdapter(softwareSystem, metricAccessor, this.m_metricDescriptor);
                    break;
                }
                default: {
                    assert (false) : "Unhandled leaf element: " + String.valueOf((Object)leafElement);
                    this.m_valueAdapter = null;
                }
            }
            return;
        }
        metricIds = SUPPORTED_COMPONENT_LEVEL_METRIC_IDS.get((Object)leafElement);
        if (metricIds != null && !metricIds.isEmpty() && metricIds.contains(metricId)) {
            assert (!metricId.isFloat()) : "Int metric expected";
            switch (leafElement) {
                case PHYSICAL_COMPONENT: {
                    this.m_valueAdapter = new ComponentMetricIntValueAdapter(softwareSystem, metricAccessor, this.m_metricDescriptor);
                    break;
                }
                case PHYSICAL_SOURCE_FILE: {
                    assert (false) : "Unexpected leaf element: " + String.valueOf((Object)leafElement);
                    this.m_valueAdapter = null;
                    break;
                }
                default: {
                    assert (false) : "Unhandled leaf element: " + String.valueOf((Object)leafElement);
                    this.m_valueAdapter = null;
                }
            }
            return;
        }
        assert (false) : "Unhandled metric id: " + String.valueOf(metricId);
        this.m_valueAdapter = null;
    }

    @Override
    ILeafInfoProvider getInfoProvider(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getColorInfoProvider' must not be null";
        int value = this.m_valueAdapter.getValue(element);
        int forcedValue = value < 0 ? 0 : value;
        this.getValueRange().process(0, forcedValue);
        Integer valueAsInteger = forcedValue;
        IntMetricProvider provider = this.m_valueToColorProvider.get(valueAsInteger);
        if (provider == null) {
            provider = new IntMetricProvider(this.m_metricDescriptor.getMetricId(), valueAsInteger);
            this.m_valueToColorProvider.put(valueAsInteger, provider);
        }
        return provider;
    }
}

