/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.controller.system.representation.ArchitectureRepresentationDescriptorCalculator;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.NodeType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ArchitectureNodeAndEdgeRepresentationDescriptorCalculator
extends ArchitectureRepresentationDescriptorCalculator<NodeAndEdgeRepresentation> {
    private Map<String, List<String>> m_mainNodesPhysicalElementToComponentsDescriptors;
    private Map<String, List<String>> m_additionalNodesPhysicalElementToComponentsDescriptors;

    public ArchitectureNodeAndEdgeRepresentationDescriptorCalculator(NodeAndEdgeRepresentation representation) {
        super(representation);
    }

    @Override
    protected void finishInitialization() {
        super.finishInitialization();
        this.m_mainNodesPhysicalElementToComponentsDescriptors = new HashMap<String, List<String>>();
        this.m_additionalNodesPhysicalElementToComponentsDescriptors = new HashMap<String, List<String>>();
    }

    @Override
    public Map<String, List<String>> getDescriptorsForArchitectureBaseElements(NodeType nodeType) {
        return switch (nodeType) {
            case NodeType.ORIGINAL -> super.getDescriptorsForArchitectureBaseElements(nodeType);
            case NodeType.MAIN -> this.m_mainNodesPhysicalElementToComponentsDescriptors;
            case NodeType.ADDITIONAL -> this.m_additionalNodesPhysicalElementToComponentsDescriptors;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected 'nodeType': " + String.valueOf((Object)nodeType)));
                }
                yield null;
            }
        };
    }

    @Override
    protected void saveDescriptors(NodeAndEdgeRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'saveDescriptors' must not be null";
        super.saveDescriptors(representation);
        this.saveDescriptors(representation.getMainNodes(), this.m_mainNodesPhysicalElementToComponentsDescriptors, NodeType.MAIN);
        this.saveDescriptors(representation.getAdditionalNodes(), this.m_additionalNodesPhysicalElementToComponentsDescriptors, NodeType.ADDITIONAL);
    }
}

