/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.migration;

import com.hello2morrow.sonargraph.core.controller.system.migration.RegexBasedFileMigration;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.integration.access.foundation.MigrationCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QualityGateConditionSeverityResolutionMigration
extends RegexBasedFileMigration {
    private static final Pattern RESOLUTION_ANY_PATTERN = Pattern.compile("<(.*)resolution=\"any\"(.*)>", 2);
    private static final String RESOLUTION_ANY_REPLACEMENT = "<$1resolution=\"None, Ignore, Task\"$2>";
    private static final Pattern SEVERITY_ANY_PATTERN = Pattern.compile("<(.*)severity=\"any\"(.*)>", 2);
    private static final String SEVERITY_ANY_REPLACEMENT = "<$1severity=\"Error, Warning, Info\"$2>";

    public QualityGateConditionSeverityResolutionMigration(boolean writeToDisk, boolean migrateVersion) {
        super(CoreFileType.QUALITY_GATE, "qualityGate", writeToDisk, migrateVersion);
    }

    @Override
    protected boolean needsMigration(String version) {
        assert (version != null && version.length() > 0) : "Parameter 'version' of method 'needsMigration' must not be empty";
        return MigrationCheck.isPreMultipleValueForSeverityAndResolutionInQualityGateConditions((String)version);
    }

    @Override
    protected String migrateContent(String original, OperationResult result) {
        assert (original != null && original.length() > 0) : "Parameter 'original' of method 'migrateContent' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'migrateContent' must not be null";
        Matcher matcher = RESOLUTION_ANY_PATTERN.matcher(original);
        String migrated = matcher.replaceAll(RESOLUTION_ANY_REPLACEMENT);
        Matcher matcher2 = SEVERITY_ANY_PATTERN.matcher(migrated);
        migrated = matcher2.replaceAll(SEVERITY_ANY_REPLACEMENT);
        return migrated;
    }
}

