/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.EmptyNodeProgrammingElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyEndPoints;
import com.hello2morrow.sonargraph.core.model.explorationview.ReadOnlyArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StructureIntegrityChecker
extends ArchitecturalViewVisitor
implements ArchitecturalViewNode.IVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StructureIntegrityChecker.class);
    private static final Set<ArchitecturalViewNode> s_alreadyPerformedProgrammingElementIntegrityCheck = new THashSet();
    private static final Set<ProgrammingElement> s_checkProgrammingElements = new THashSet();
    private static ArchitecturalViewElement s_lastFailedFor;
    private static int s_numberOfDetectedErrors;
    private final Set<ParserDependency> m_allParserDependenciesContainedInNodeDependencies = new THashSet();
    private final List<ArchitecturalViewNode> m_leafsCollector;
    private final List<AssignableToArtifactNode> m_assignableToArtifactNodesCollector;
    private final boolean m_programmingElementsChanged;

    private static void logError(ArchitecturalViewElement element, String error) {
        assert (element != null) : "Parameter 'element' of method 'logError' must not be null";
        assert (error != null && error.length() > 0) : "Parameter 'error' of method 'logError' must not be empty";
        if (s_lastFailedFor == null || s_lastFailedFor != element) {
            LOGGER.error("Integrity check failed for '" + (element instanceof ExplorationViewRepresentation ? "Representation" : element.getRelativePath()) + "' (" + element.getElementInfo(false, true) + ")");
            s_lastFailedFor = element;
        }
        LOGGER.error(error);
        ++s_numberOfDetectedErrors;
    }

    private static void logError(String error) {
        assert (error != null && error.length() > 0) : "Parameter 'error' of method 'logError' must not be empty";
        LOGGER.error(error);
        ++s_numberOfDetectedErrors;
    }

    private static void checkProgrammingElementIntegrity(ArchitecturalViewNode node, Collection<ProgrammingElement> programmingElements, Collection<ProgrammingElement> relevantProgrammingElements) {
        assert (node != null) : "Parameter 'node' of method 'checkProgrammingElementIntegrity' must not be null";
        assert (relevantProgrammingElements != null) : "Parameter 'relevantProgrammingElements' of method 'checkProgrammingElementIntegrity' must not be null";
        if (s_alreadyPerformedProgrammingElementIntegrityCheck.add(node)) {
            ArchitecturalViewElement nextParent;
            for (ProgrammingElement nextProgrammingElement : node.getRelevantProgrammingElements()) {
                if (s_checkProgrammingElements.add(nextProgrammingElement)) continue;
                StructureIntegrityChecker.logError(node, "Contains duplicate relevant programming element: " + nextProgrammingElement.getFullyQualifiedName() + " [" + nextProgrammingElement.getClass().getName() + "]");
            }
            s_checkProgrammingElements.clear();
            if (programmingElements != null) {
                for (ProgrammingElement nextProgrammingElement : node.getProgrammingElements()) {
                    if (s_checkProgrammingElements.add(nextProgrammingElement)) continue;
                    StructureIntegrityChecker.logError(node, "Contains duplicate programming element: " + nextProgrammingElement.getFullyQualifiedName() + " [" + nextProgrammingElement.getClass().getName() + "]");
                }
                s_checkProgrammingElements.clear();
            }
            if ((nextParent = node.getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT)) == null) {
                StructureIntegrityChecker.logError(node, "Has no parent");
            } else if (nextParent instanceof ArchitecturalViewNode) {
                if (!(node.isSuppressed() || nextParent.isSuppressed() || node.getPresentationMode() == PresentationMode.FLAT && node.isRecursive() && nextParent.isRecursive())) {
                    s_checkProgrammingElements.addAll(((ArchitecturalViewNode)nextParent).getRelevantProgrammingElements());
                    if (!s_checkProgrammingElements.containsAll(relevantProgrammingElements)) {
                        StructureIntegrityChecker.logError(node, "Parent does not contain all relevant programming elements: " + nextParent.getElementInfo());
                    }
                    s_checkProgrammingElements.clear();
                }
                if (programmingElements != null) {
                    s_checkProgrammingElements.addAll(((ArchitecturalViewNode)nextParent).getProgrammingElements());
                    if (!s_checkProgrammingElements.containsAll(programmingElements)) {
                        StructureIntegrityChecker.logError(node, "Parent does not contain all programming elements: " + nextParent.getElementInfo());
                    }
                    s_checkProgrammingElements.clear();
                }
                StructureIntegrityChecker.checkProgrammingElementIntegrity((ArchitecturalViewNode)nextParent, programmingElements, relevantProgrammingElements);
            }
        }
    }

    private static String getChildrenList(Collection<? extends NamedElement> children) {
        assert (children != null && !children.isEmpty()) : "Parameter 'children' of method 'getChildrenList' must not be empty";
        StringBuilder builder = new StringBuilder();
        int i = 1;
        for (NamedElement namedElement : children) {
            builder.append("\n[").append(i).append("] ");
            builder.append(namedElement.getName());
            builder.append(" (").append(namedElement.getClass().getSimpleName()).append(")");
            ++i;
        }
        return builder.toString();
    }

    private StructureIntegrityChecker(List<ArchitecturalViewNode> leafsCollector, List<AssignableToArtifactNode> assignableToArtifactNodesCollector, boolean programmingElementsChanged) {
        assert (leafsCollector != null) : "Parameter 'leafsCollector' of method 'StructureIntegrityChecker' must not be null";
        this.m_leafsCollector = leafsCollector;
        this.m_assignableToArtifactNodesCollector = assignableToArtifactNodesCollector;
        this.m_programmingElementsChanged = programmingElementsChanged;
    }

    private void checkElement(ArchitecturalViewElement element) {
        List<NamedElement> children;
        assert (element != null) : "Parameter 'element' of method 'checkElement' must not be null";
        if (!element.isValid()) {
            StructureIntegrityChecker.logError(element, "Element is not valid");
        }
        if (element.isVisible() && !element.isSuppressed() && element.getRelativeIndex() == -1) {
            StructureIntegrityChecker.logError(element, "Has no relative index");
        }
        if ((element instanceof ExplorationViewRepresentation || element instanceof ArtifactPropertiesNode) && !(children = element.getChildren()).isEmpty()) {
            int startIndex = 0;
            if (element instanceof ArtifactNode) {
                if (!(children.get(0) instanceof ArtifactNodeFilter)) {
                    StructureIntegrityChecker.logError(element, "Inconsistent child order: " + StructureIntegrityChecker.getChildrenList(children));
                } else {
                    startIndex = 1;
                }
            } else if (element instanceof ReadOnlyArtifactNode) {
                startIndex = 0;
            }
            boolean inArtifactSection = true;
            int i = startIndex;
            while (i < children.size()) {
                NamedElement next = children.get(i);
                if (next instanceof ArtifactPropertiesNode) {
                    if (!inArtifactSection) {
                        StructureIntegrityChecker.logError(element, "Inconsistent child order: " + StructureIntegrityChecker.getChildrenList(children));
                        break;
                    }
                } else {
                    inArtifactSection = false;
                }
                ++i;
            }
        }
    }

    @Override
    public void visitArchitecturalViewElement(ArchitecturalViewElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewElement' must not be null";
        this.checkElement(element);
        this.visitChildrenOf(element);
    }

    private void checkNode(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'checkNode' must not be null";
        this.checkElement(node);
        ArchitecturalViewNode nodeParent = node.getNodeParent();
        if (nodeParent != null) {
            if (nodeParent.isSuppressed()) {
                StructureIntegrityChecker.logError(node, "Node parent must not be suppressed");
            }
        } else {
            ArchitecturalViewElement elementParent = node.getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT);
            if (elementParent == null) {
                StructureIntegrityChecker.logError(node, "Has no element parent");
            } else if (elementParent instanceof ArchitecturalViewNode && !node.isDeleted()) {
                StructureIntegrityChecker.logError(node, "Non-top-level node may only return a null-node-parent if it has been deleted");
            }
        }
        if (node.isExpanded() && !node.isExpandable()) {
            StructureIntegrityChecker.logError(node, "Node is expanded but is not expandable");
        }
        if (node.isExpanded() && !node.isVisible()) {
            StructureIntegrityChecker.logError(node, "Node is expanded but not visible");
        }
        if (node.isSelected() && !node.isVisible()) {
            StructureIntegrityChecker.logError(node, "Node is selected but not visible");
        }
        if (node.isVisible() && nodeParent != null) {
            if (!nodeParent.isExpanded()) {
                StructureIntegrityChecker.logError(node, "Node is visible but parent is not expanded");
            }
            if (nodeParent.isSuppressed()) {
                StructureIntegrityChecker.logError(node, "Node is visible but parent is suppressed");
            }
            if (nodeParent.isRemovedByFocus()) {
                StructureIntegrityChecker.logError(node, "Node is visible but parent is removed by focus");
            }
            if (nodeParent.isDeleted()) {
                StructureIntegrityChecker.logError(node, "Node is visible but parent is deleted");
            }
        }
    }

    private void checkNodeDependencies(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'checkNodeDependencies' must not be null";
        Collection<ArchitecturalViewNode.ArchitecturalViewDependency> outgoing = node.getOutgoingDependencies();
        if (!outgoing.isEmpty()) {
            for (ArchitecturalViewNode.ArchitecturalViewDependency nextOut : outgoing) {
                for (ParserDependency nextOutParserDependency : nextOut.getParserDependencies()) {
                    if (this.m_allParserDependenciesContainedInNodeDependencies.add(nextOutParserDependency)) continue;
                    StructureIntegrityChecker.logError(node, "Outgoing parser dependency already found: " + String.valueOf(nextOutParserDependency));
                }
            }
            if (!node.isVisible()) {
                StructureIntegrityChecker.logError(node, "Node with outgoing dependencies not visible");
            }
            for (ArchitecturalViewNode.ArchitecturalViewDependency nextOut : outgoing) {
                int nextNumberOfParserDependencies;
                ArchitecturalViewNode nextTo = nextOut.getTo();
                if (!nextTo.isVisible()) {
                    StructureIntegrityChecker.logError(node, "Has dependency to '" + nextTo.getElementInfo() + "' but 'to' is not visible");
                }
                if ((nextNumberOfParserDependencies = nextOut.getNumberOfParserDependencies()) <= 0) {
                    StructureIntegrityChecker.logError(node, "Has dependency to '" + nextTo.getElementInfo() + "' but number of parser dependencies are: " + nextNumberOfParserDependencies);
                    continue;
                }
                int nextNumberOfParserDependenciesViolating = nextOut.getNumberOfParserDependenciesViolating();
                if (nextNumberOfParserDependencies >= nextNumberOfParserDependenciesViolating) continue;
                StructureIntegrityChecker.logError(node, "Has dependency to '" + nextTo.getElementInfo() + "' but number of violating parser dependencies are more than the total: " + nextNumberOfParserDependencies + "/" + nextNumberOfParserDependenciesViolating);
            }
        }
    }

    private void checkRecursiveNode(RecursiveNode recursiveNode) {
        ArchitecturalViewNode parentOfRecursiveNode;
        assert (recursiveNode != null) : "Parameter 'recursiveNode' of method 'checkRecursiveNode' must not be null";
        if (recursiveNode.isSuppressed()) {
            ArchitecturalViewNode parent = recursiveNode.getParent(ArchitecturalViewNode.class, new Class[0]);
            if (parent == null) {
                StructureIntegrityChecker.logError(recursiveNode, "Suppressed node has no direct parent");
            }
            if (recursiveNode.isVisible()) {
                StructureIntegrityChecker.logError(recursiveNode, "Suppressed node is visible");
            }
            if (recursiveNode.isExpanded()) {
                StructureIntegrityChecker.logError(recursiveNode, "Suppressed node is expanded");
            }
            if (recursiveNode.isSelected()) {
                StructureIntegrityChecker.logError(recursiveNode, "Suppressed node is selected");
            }
        }
        if ((parentOfRecursiveNode = recursiveNode.getNodeParent()) != null && recursiveNode.getPresentationMode() == PresentationMode.FLAT && parentOfRecursiveNode.isRecursive()) {
            StructureIntegrityChecker.logError(recursiveNode, "Recursive node has a recursive node parent in 'Flat' mode: " + parentOfRecursiveNode.getElementInfo());
        }
    }

    private void checkSharedChildren(ArchitecturalViewNode node) {
        StringBuilder info;
        THashSet nextSharedProgrammingElements;
        List<ArchitecturalViewNode> nodeChildren;
        assert (node != null) : "Parameter 'node' of method 'checkSharedChildren' must not be null";
        if (this.m_programmingElementsChanged) {
            nodeChildren = node.getAllNodeChildren(n -> true, false);
            for (ArchitecturalViewNode nextChild : nodeChildren) {
                for (ArchitecturalViewNode nextChildToCheckAgainst : nodeChildren) {
                    if (nextChild == nextChildToCheckAgainst) continue;
                    nextSharedProgrammingElements = new THashSet(nextChild.getProgrammingElements());
                    nextSharedProgrammingElements.retainAll(nextChildToCheckAgainst.getProgrammingElements());
                    if (nextSharedProgrammingElements.isEmpty()) continue;
                    info = new StringBuilder("Children in same parent share programming elements\n");
                    info.append("Shares with: ").append(nextChildToCheckAgainst.getElementInfo()).append("\n");
                    info.append(nextSharedProgrammingElements.size()).append(" shared programming element(s): ");
                    info.append(StructureIntegrityChecker.getChildrenList((Collection<? extends NamedElement>)nextSharedProgrammingElements));
                    StructureIntegrityChecker.logError(nextChild, info.toString());
                }
            }
        }
        nodeChildren = node.getNodeChildren(n -> true, false);
        for (ArchitecturalViewNode nextChild : nodeChildren) {
            for (ArchitecturalViewNode nextChildToCheckAgainst : nodeChildren) {
                if (nextChild == nextChildToCheckAgainst) continue;
                nextSharedProgrammingElements = new THashSet(nextChild.getRelevantProgrammingElements());
                nextSharedProgrammingElements.retainAll(nextChildToCheckAgainst.getRelevantProgrammingElements());
                if (nextSharedProgrammingElements.isEmpty()) continue;
                info = new StringBuilder("Children in same parent share relevant programming elements\n");
                info.append("Shares with: ").append(nextChildToCheckAgainst.getElementInfo()).append("\n");
                info.append(nextSharedProgrammingElements.size()).append(" shared programming element(s): ");
                info.append(StructureIntegrityChecker.getChildrenList((Collection<? extends NamedElement>)nextSharedProgrammingElements));
                StructureIntegrityChecker.logError(nextChild, info.toString());
            }
        }
    }

    @Override
    public void visitArchitecturalViewNode(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'visitArchitecturalViewNode' must not be null";
        this.checkNode(node);
        this.checkNodeDependencies(node);
        if (node.isRecursive()) {
            if (!(node instanceof RecursiveNode)) {
                StructureIntegrityChecker.logError(node, "Is recursive but is of class: " + node.getClass().getSimpleName());
            } else {
                this.checkRecursiveNode((RecursiveNode)node);
            }
        } else {
            if (node instanceof RecursiveNode) {
                StructureIntegrityChecker.logError(node, "Is not recursive but is of class: " + node.getClass().getSimpleName());
            }
            if (node.isSuppressed()) {
                StructureIntegrityChecker.logError(node, "Suppressed node is not a recursive node: " + node.getClass().getSimpleName());
            }
            if (node.isPart()) {
                StructureIntegrityChecker.logError(node, "Part node is not a recursive node: " + node.getClass().getSimpleName());
            }
            if (node.isDeletedFlat()) {
                StructureIntegrityChecker.logError(node, "Deleted flat node is not a recursive node: " + node.getClass().getSimpleName());
            }
        }
        this.checkSharedChildren(node);
        if (this.m_assignableToArtifactNodesCollector != null && node instanceof AssignableToArtifactNode) {
            this.m_assignableToArtifactNodesCollector.add((AssignableToArtifactNode)node);
        }
        if (!node.hasChildren()) {
            this.m_leafsCollector.add(node);
        }
        this.visitChildrenOf(node);
    }

    static void checkAfterInitialCreation(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'checkAfterInitialCreation' must not be null";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Check after initial creation");
            TreeSet<String> missingProgrammingElements = new TreeSet<String>();
            ParserDependencyEndPoints endPoints = new ParserDependencyEndPoints();
            for (ProgrammingElement nextProgrammingElement : representation.getProgrammingElements()) {
                Iterator<ParserDependency> nextIterator = nextProgrammingElement.getDependencyIterator();
                while (nextIterator.hasNext()) {
                    ParserDependency nextParserDependency = nextIterator.next();
                    if (!representation.includeParserDependency(nextParserDependency, endPoints)) continue;
                    ArchitecturalViewNode nextFromNode = representation.getLeafNode(endPoints.getFrom());
                    ArchitecturalViewNode nextToNode = representation.getLeafNode(endPoints.getTo());
                    if (nextFromNode == null || nextToNode == null) {
                        if (endPoints.getFrom() == nextProgrammingElement) {
                            if (nextFromNode == null) {
                                StructureIntegrityChecker.logError("Missing leaf node for 'from' of outgoing dependency:\n<MISSING> " + endPoints.getFrom().getFullyQualifiedName() + " -> " + endPoints.getTo().getFullyQualifiedName());
                                missingProgrammingElements.add(endPoints.getFrom().getFullyQualifiedName());
                            }
                            if (nextToNode == null) {
                                StructureIntegrityChecker.logError("Missing leaf node for 'to' of outgoing dependency:\n" + endPoints.getFrom().getFullyQualifiedName() + " -> <MISSING> " + endPoints.getTo().getFullyQualifiedName());
                                missingProgrammingElements.add(endPoints.getTo().getFullyQualifiedName());
                            }
                        } else {
                            if (nextFromNode == null) {
                                StructureIntegrityChecker.logError("Missing leaf node for 'from' of incoming dependency:\n<MISSING> " + endPoints.getFrom().getFullyQualifiedName() + " -> " + endPoints.getTo().getFullyQualifiedName());
                                missingProgrammingElements.add(endPoints.getFrom().getFullyQualifiedName());
                            }
                            if (nextToNode == null) {
                                StructureIntegrityChecker.logError("Missing leaf node for 'to' of incoming dependency:\n" + endPoints.getFrom().getFullyQualifiedName() + " -> <MISSING> " + endPoints.getTo().getFullyQualifiedName());
                                missingProgrammingElements.add(endPoints.getTo().getFullyQualifiedName());
                            }
                        }
                    }
                    endPoints.reset();
                }
            }
            if (!missingProgrammingElements.isEmpty()) {
                for (String next : missingProgrammingElements) {
                    StructureIntegrityChecker.logError("Missing programming element: " + next);
                }
            }
            LOGGER.debug("Check after initial creation - done");
        }
    }

    static void check(ExplorationViewRepresentation representation, boolean programmingElementsChanged) {
        assert (representation != null) : "Parameter 'representation' of method 'check' must not be null";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Check structure integrity" + (programmingElementsChanged ? " [programming elements changed]" : ""));
            ArrayList<ArchitecturalViewNode> leafs = new ArrayList<ArchitecturalViewNode>();
            ArrayList<AssignableToArtifactNode> assignableToArtifactNodesCollector = programmingElementsChanged ? new ArrayList<AssignableToArtifactNode>() : null;
            ((ArchitecturalViewElement)representation).accept(new StructureIntegrityChecker(leafs, assignableToArtifactNodesCollector, programmingElementsChanged));
            if (programmingElementsChanged) {
                Collection<ProgrammingElement> allRepresentationProgrammingElements = representation.getProgrammingElements();
                int numberOfProgrammingElements = 0;
                for (ArchitecturalViewNode nextNode : representation.getChildren(ArchitecturalViewNode.class)) {
                    numberOfProgrammingElements += nextNode.getNumberOfProgrammingElements();
                }
                if (allRepresentationProgrammingElements.size() != numberOfProgrammingElements) {
                    StructureIntegrityChecker.logError(representation, "Different number of programnming elements (representation/cumulated): " + allRepresentationProgrammingElements.size() + "/" + numberOfProgrammingElements);
                }
                THashSet checkProgrammingElements = new THashSet();
                for (ArchitecturalViewNode next : leafs) {
                    Collection<ProgrammingElement> nextProgrammingElements = next.getProgrammingElements();
                    Collection<ProgrammingElement> nextVisibleProgrammingElements = next.getRelevantProgrammingElements();
                    checkProgrammingElements.addAll(nextVisibleProgrammingElements);
                    checkProgrammingElements.removeAll(nextProgrammingElements);
                    if (!checkProgrammingElements.isEmpty()) {
                        StructureIntegrityChecker.logError(next, "Not all relevant programming elements found: " + StructureIntegrityChecker.getChildrenList((Collection<? extends NamedElement>)checkProgrammingElements));
                    }
                    checkProgrammingElements.clear();
                }
                THashSet all = new THashSet(allRepresentationProgrammingElements);
                THashSet notFound = new THashSet();
                for (AssignableToArtifactNode next : assignableToArtifactNodesCollector) {
                    Collection<ProgrammingElement> nextProgrammingElements = next.getProgrammingElements();
                    Collection<ProgrammingElement> nextVisibleProgrammingElements = next.getRelevantProgrammingElements();
                    for (ProgrammingElement remove : nextProgrammingElements) {
                        if (all.remove(remove) || remove instanceof EmptyNodeProgrammingElement) continue;
                        notFound.add(remove);
                    }
                    StructureIntegrityChecker.checkProgrammingElementIntegrity(next, nextProgrammingElements, nextVisibleProgrammingElements);
                }
                if (!all.isEmpty()) {
                    StructureIntegrityChecker.logError(representation, "Not all programming elements found: " + StructureIntegrityChecker.getChildrenList((Collection<? extends NamedElement>)all));
                }
                if (!notFound.isEmpty()) {
                    StructureIntegrityChecker.logError(representation, "To many programming elements found: " + StructureIntegrityChecker.getChildrenList((Collection<? extends NamedElement>)notFound));
                }
            } else {
                for (ArchitecturalViewNode next : leafs) {
                    Collection<ProgrammingElement> nextVisibleProgrammingElements = next.getRelevantProgrammingElements();
                    StructureIntegrityChecker.checkProgrammingElementIntegrity(next, null, nextVisibleProgrammingElements);
                }
            }
            int numberOfDetectedErrors = s_numberOfDetectedErrors;
            s_alreadyPerformedProgrammingElementIntegrityCheck.clear();
            s_checkProgrammingElements.clear();
            s_numberOfDetectedErrors = 0;
            s_lastFailedFor = null;
            if (numberOfDetectedErrors == 0) {
                LOGGER.debug("Check structure integrity" + (programmingElementsChanged ? " [programming elements changed]" : "") + " - done [errors: 0]");
            } else {
                LOGGER.error("Check structure integrity" + (programmingElementsChanged ? " [programming elements changed]" : "") + " - done [errors: " + numberOfDetectedErrors + "]");
                if (LOGGER.isTraceEnabled()) assert (false) : "Integrity check failed with " + numberOfDetectedErrors + " error(s)";
            }
        }
    }
}

