/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IExplorationViewRepresentationHandler;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementNode;
import com.hello2morrow.sonargraph.core.model.programming.SearchCriteria;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.CustomPattern;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchHandler
implements IExplorationViewRepresentationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchHandler.class);

    private SearchHandler() {
    }

    private static CustomPattern createCustomPattern(String pattern, boolean autoMatchTrailing, boolean ignoreCase) {
        assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'createCustomPattern' must not be empty";
        try {
            if (autoMatchTrailing) {
                return CustomPattern.compileWildcardPattern((String)(StringUtility.removeTrailingChar((String)pattern, (char)'*') + "**"), (boolean)ignoreCase);
            }
            return CustomPattern.compileWildcardPattern((String)pattern, (boolean)ignoreCase);
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    public static boolean isSearchPatternValid(String pattern, EnumSet<SearchCriteria> criteria) {
        assert (pattern != null) : "Parameter 'pattern' of method 'isSearchPatternValid' must not be null";
        assert (criteria != null) : "Parameter 'criteria' of method 'isSearchPatternValid' must not be null";
        if (pattern.isEmpty()) {
            return false;
        }
        return SearchHandler.createCustomPattern(pattern, criteria.contains((Object)SearchCriteria.AUTO_MATCH_TRAILING_CHARACTERS), criteria.contains((Object)SearchCriteria.IGNORE_CASE)) != null;
    }

    public static List<ArchitecturalViewNode> search(IWorkerContext workerContext, String pattern, EnumSet<SearchCriteria> criteria, List<ArchitecturalViewNode> nodes, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'search' must not be null";
        assert (pattern != null) : "Parameter 'pattern' of method 'search' must not be null";
        assert (criteria != null) : "Parameter 'criteria' of method 'search' must not be null";
        assert (nodes != null) : "Parameter 'nodes' of method 'search' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'search' must not be null";
        LOGGER.debug("Search nodes");
        CustomPattern customPattern = SearchHandler.createCustomPattern(pattern, criteria.contains((Object)SearchCriteria.AUTO_MATCH_TRAILING_CHARACTERS), criteria.contains((Object)SearchCriteria.IGNORE_CASE));
        assert (customPattern != null) : "Parameter 'customPattern' of method 'search' must not be null";
        SearchVisitor visitor = new SearchVisitor(workerContext, customPattern, criteria.contains((Object)SearchCriteria.FULL_NAME));
        if (nodes.isEmpty()) {
            representation.accept(visitor);
        } else {
            for (ArchitecturalViewNode nextNode : nodes) {
                nextNode.accept(visitor);
            }
        }
        LOGGER.debug("Search nodes - done");
        return visitor.getMatched();
    }

    public static List<ArchitecturalViewNode> search(IWorkerContext workerContext, String pattern, EnumSet<SearchCriteria> criteria, Predicate<ArchitecturalViewNode> include, List<ArchitecturalViewNode> nodes, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'search' must not be null";
        assert (pattern != null) : "Parameter 'pattern' of method 'search' must not be null";
        assert (criteria != null) : "Parameter 'criteria' of method 'search' must not be null";
        assert (include != null) : "Parameter 'include' of method 'search' must not be null";
        assert (nodes != null) : "Parameter 'nodes' of method 'search' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'search' must not be null";
        LOGGER.debug("Search nodes with classes");
        CustomPattern customPattern = SearchHandler.createCustomPattern(pattern, criteria.contains((Object)SearchCriteria.AUTO_MATCH_TRAILING_CHARACTERS), criteria.contains((Object)SearchCriteria.IGNORE_CASE));
        assert (customPattern != null) : "Parameter 'customPattern' of method 'search' must not be null";
        SearchVisitorWithFilter visitor = new SearchVisitorWithFilter(workerContext, customPattern, criteria.contains((Object)SearchCriteria.FULL_NAME), include);
        if (nodes.isEmpty()) {
            representation.accept(visitor);
        } else {
            for (ArchitecturalViewNode nextNode : nodes) {
                nextNode.accept(visitor);
            }
        }
        LOGGER.debug("Search nodes with classes - done");
        return visitor.getMatched();
    }

    private static class SearchVisitor
    extends ArchitecturalViewVisitor
    implements ArchitecturalViewNode.IVisitor {
        private final List<ArchitecturalViewNode> m_matched = new ArrayList<ArchitecturalViewNode>();
        private final IWorkerContext m_workerContext;
        private final CustomPattern m_customPattern;
        private final boolean m_fullName;

        SearchVisitor(IWorkerContext workerContext, CustomPattern customPattern, boolean fullName) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'SearchVisitor' must not be null";
            assert (customPattern != null) : "Parameter 'customPattern' of method 'SearchVisitor' must not be null";
            this.m_workerContext = workerContext;
            this.m_customPattern = customPattern;
            this.m_fullName = fullName;
        }

        @Override
        protected final boolean done() {
            return this.m_workerContext.hasBeenCanceled();
        }

        protected boolean matches(ArchitecturalViewNode node) {
            assert (node != null) : "Parameter 'node' of method 'matches' must not be null";
            return !node.isDeleted() && !node.isSuppressed();
        }

        @Override
        public final void visitArchitecturalViewNode(ArchitecturalViewNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
            if (!(element instanceof ProgrammingElementNode)) {
                if (this.matches(element) && this.m_customPattern.matches((CharSequence)element.getRawPresentationName(!this.m_fullName))) {
                    this.m_matched.add(element);
                }
                this.visitChildrenOf(element);
            }
        }

        final List<ArchitecturalViewNode> getMatched() {
            return this.m_matched;
        }
    }

    private static final class SearchVisitorWithFilter
    extends SearchVisitor {
        private final Predicate<ArchitecturalViewNode> m_include;

        SearchVisitorWithFilter(IWorkerContext workerContext, CustomPattern customPattern, boolean fullName, Predicate<ArchitecturalViewNode> include) {
            super(workerContext, customPattern, fullName);
            assert (include != null) : "Parameter 'include' of method 'SearchVisitorWithFilter' must not be null";
            this.m_include = include;
        }

        @Override
        protected boolean matches(ArchitecturalViewNode node) {
            assert (node != null) : "Parameter 'node' of method 'matches' must not be null";
            return this.m_include.test(node);
        }
    }
}

