/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNodesInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ExplorationViewLogger;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FindingHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusApplyVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusResetVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusTransitivelyCollector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusTransitivelyCollectorLeafBased;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusTransitivelyCollectorProgrammingElementBased;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IExplorationViewRepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NodeHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationHandler;
import com.hello2morrow.sonargraph.core.model.dependenciesview.ViolationInfo;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewModifiedEvent;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFinding;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.DescriptorCache;
import com.hello2morrow.sonargraph.core.model.explorationview.EmptyNodeProgrammingElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ExpandCollapseRequest;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusRequest;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyEndPoints;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyState;
import com.hello2morrow.sonargraph.core.model.explorationview.PartialAlternativeInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RevealRequest;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FocusHandler
implements IExplorationViewRepresentationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FocusHandler.class);

    private static boolean includedByProperties(ParserDependency parserDependency, ExplorationViewFocusProperties properties, ExplorationViewRepresentation representation) {
        assert (parserDependency != null) : "Parameter 'parserDependency' of method 'includedByProperties' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'includedByProperties' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'includedByProperties' must not be null";
        if (!properties.includesAllDependencies()) {
            switch (properties.getDependencyInclusionMode()) {
                case NON_VIOLATING_DEPENDENCIES_ONLY: {
                    ViolationInfo info = representation.isViolation(parserDependency);
                    if (info == null || info.isIgnored()) break;
                    return false;
                }
                case VIOLATING_DEPENDENCIES_ONLY: {
                    ViolationInfo info = representation.isViolation(parserDependency);
                    if (info != null && !info.isIgnored()) break;
                    return false;
                }
                case ALL_DEPENDENCIES: {
                    break;
                }
                default: {
                    assert (false) : "Unhandled dependency inclusion mode: " + String.valueOf((Object)properties.getDependencyInclusionMode());
                    break;
                }
            }
            return properties.getParserDependencyTypes().contains(parserDependency.getGenericDependencyType());
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static void processTransitively(FocusTransitivelyCollector transitivelyCollector, ExplorationViewFocusProperties properties, ExplorationViewFocus focus, ExplorationViewRepresentation representation) {
        block22: {
            if (!FocusHandler.$assertionsDisabled && transitivelyCollector == null) {
                throw new AssertionError((Object)"Parameter 'transitivelyCollector' of method 'processTransitively' must not be null");
            }
            if (!FocusHandler.$assertionsDisabled && properties == null) {
                throw new AssertionError((Object)"Parameter 'properties' of method 'processTransitively' must not be null");
            }
            if (!FocusHandler.$assertionsDisabled && focus == null) {
                throw new AssertionError((Object)"Parameter 'focus' of method 'processTransitively' must not be null");
            }
            if (!FocusHandler.$assertionsDisabled && representation == null) {
                throw new AssertionError((Object)"Parameter 'representation' of method 'processTransitively' must not be null");
            }
            endPoints = new ParserDependencyEndPoints();
            if (!properties.includesAllDependencies()) ** GOTO lbl60
            while (!transitivelyCollector.isEmpty()) {
                for (ProgrammingElement nextProgrammingElement : transitivelyCollector.consumeIn()) {
                    depIter = nextProgrammingElement.getDependencyIterator();
                    while (depIter.hasNext()) {
                        nextParserDependency = depIter.next();
                        if (representation.includeIncomingParserDependency(nextProgrammingElement, nextParserDependency, false, endPoints).isIncluded()) {
                            focus.addParserDependency(nextParserDependency);
                            transitivelyCollector.addIn(endPoints.getFrom());
                        }
                        endPoints.reset();
                    }
                }
                for (ProgrammingElement nextProgrammingElement : transitivelyCollector.consumeOut()) {
                    depIter = nextProgrammingElement.getDependencyIterator();
                    while (depIter.hasNext()) {
                        nextParserDependency = depIter.next();
                        if (representation.includeOutgoingParserDependency(nextProgrammingElement, nextParserDependency, false, endPoints).isIncluded()) {
                            focus.addParserDependency(nextParserDependency);
                            transitivelyCollector.addOut(endPoints.getTo());
                        }
                        endPoints.reset();
                    }
                }
            }
            break block22;
lbl-1000:
            // 2 sources

            {
                for (ProgrammingElement nextProgrammingElement : transitivelyCollector.consumeIn()) {
                    depIter = nextProgrammingElement.getDependencyIterator();
                    while (depIter.hasNext()) {
                        nextParserDependency = depIter.next();
                        if (representation.includeIncomingParserDependency(nextProgrammingElement, nextParserDependency, false, endPoints).isIncluded()) {
                            if (FocusHandler.includedByProperties(nextParserDependency, properties, representation)) {
                                focus.addParserDependency(nextParserDependency);
                                transitivelyCollector.addIn(endPoints.getFrom());
                            } else {
                                focus.removeParserDependency(nextParserDependency);
                            }
                        }
                        endPoints.reset();
                    }
                }
                for (ProgrammingElement nextProgrammingElement : transitivelyCollector.consumeOut()) {
                    depIter = nextProgrammingElement.getDependencyIterator();
                    while (depIter.hasNext()) {
                        nextParserDependency = depIter.next();
                        if (representation.includeOutgoingParserDependency(nextProgrammingElement, nextParserDependency, false, endPoints).isIncluded()) {
                            if (FocusHandler.includedByProperties(nextParserDependency, properties, representation)) {
                                focus.addParserDependency(nextParserDependency);
                                transitivelyCollector.addOut(endPoints.getTo());
                            } else {
                                focus.removeParserDependency(nextParserDependency);
                            }
                        }
                        endPoints.reset();
                    }
                }
lbl60:
                // 2 sources

                ** while (!transitivelyCollector.isEmpty())
            }
        }
    }

    private static void processNodesForFocus(ExplorationViewFocusProperties properties, Collection<ProgrammingElement> programmingElements, ExplorationViewFocus focus, ExplorationViewFocus.Mode mode, ExplorationViewRepresentation representation, FocusTransitivelyCollector transitivelyCollector) {
        block23: {
            ParserDependencyEndPoints endPoints;
            block22: {
                assert (properties != null) : "Parameter 'properties' of method 'processNodesForFocus' must not be null";
                assert (programmingElements != null) : "Parameter 'programmingElements' of method 'processNodesForFocus' must not be null";
                assert (focus != null) : "Parameter 'focus' of method 'processNodesForFocus' must not be null";
                assert (mode != null) : "Parameter 'mode' of method 'processNodesForFocus' must not be null";
                assert (!mode.equals((Object)ExplorationViewFocus.Mode.NO_ADDITIONAL)) : "'mode' not supported: " + String.valueOf((Object)mode);
                assert (representation != null) : "Parameter 'representation' of method 'processNodesForFocus' must not be null";
                endPoints = new ParserDependencyEndPoints();
                focus.addProgrammingElements(programmingElements, mode);
                if (!properties.includesAllDependencies()) break block22;
                if (transitivelyCollector == null) break block23;
                for (ProgrammingElement nextProgrammingElement : programmingElements) {
                    Iterator<ParserDependency> depIter = nextProgrammingElement.getDependencyIterator();
                    while (depIter.hasNext()) {
                        ParserDependency nextParserDependency = depIter.next();
                        if (mode.includeIn() && representation.includeIncomingParserDependency(nextProgrammingElement, nextParserDependency, false, endPoints).isIncluded()) {
                            transitivelyCollector.addIn(endPoints.getFrom());
                        } else if (mode.includeOut() && representation.includeOutgoingParserDependency(nextProgrammingElement, nextParserDependency, false, endPoints).isIncluded()) {
                            transitivelyCollector.addOut(endPoints.getTo());
                        }
                        endPoints.reset();
                    }
                }
                break block23;
            }
            for (ProgrammingElement nextProgrammingElement : programmingElements) {
                Iterator<ParserDependency> depIter = nextProgrammingElement.getDependencyIterator();
                while (depIter.hasNext()) {
                    ParserDependency nextParserDependency = depIter.next();
                    if (mode.includeIn() && representation.includeIncomingParserDependency(nextProgrammingElement, nextParserDependency, false, endPoints).isIncluded()) {
                        if (FocusHandler.includedByProperties(nextParserDependency, properties, representation)) {
                            if (transitivelyCollector != null) {
                                focus.addParserDependency(nextParserDependency);
                                transitivelyCollector.addIn(endPoints.getFrom());
                            }
                        } else {
                            focus.removeParserDependency(nextParserDependency);
                        }
                    } else if (mode.includeOut() && representation.includeOutgoingParserDependency(nextProgrammingElement, nextParserDependency, false, endPoints).isIncluded()) {
                        if (FocusHandler.includedByProperties(nextParserDependency, properties, representation)) {
                            if (transitivelyCollector != null) {
                                focus.addParserDependency(nextParserDependency);
                                transitivelyCollector.addOut(endPoints.getTo());
                            }
                        } else {
                            focus.removeParserDependency(nextParserDependency);
                        }
                    }
                    endPoints.reset();
                }
            }
        }
    }

    private static void addToFocus(ExplorationViewFocusProperties properties, ExplorationViewFocusRequest add, ExplorationViewRepresentation representation) {
        Set<ParserDependency> parserDependencies;
        assert (properties != null) : "Parameter 'properties' of method 'addToFocus' must not be null";
        assert (add != null) : "Parameter 'add' of method 'addToFocus' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'addToFocus' must not be null";
        ExplorationViewFocus focus = representation.getFocus();
        List<ArchitecturalViewNode> nodes = add.getNodes();
        if (!nodes.isEmpty()) {
            switch (properties.getNodeInclusionMode()) {
                case NO_ADDITONAL_NODES: {
                    if (properties.includesAllDependencies()) {
                        nodes.forEach(n -> focus.addProgrammingElements(n.getRelevantProgrammingElements(), ExplorationViewFocus.Mode.NO_ADDITIONAL));
                        break;
                    }
                    THashSet allRelevantProgrammingElements = new THashSet();
                    for (ArchitecturalViewNode nextNode : nodes) {
                        Collection<ProgrammingElement> nextRelevantProgrammingElements = nextNode.getRelevantProgrammingElements();
                        focus.addProgrammingElements(nextRelevantProgrammingElements, ExplorationViewFocus.Mode.NO_ADDITIONAL);
                        allRelevantProgrammingElements.addAll(nextRelevantProgrammingElements);
                    }
                    ParserDependencyEndPoints endPoints = new ParserDependencyEndPoints();
                    for (ProgrammingElement nextProgrammingElement : allRelevantProgrammingElements) {
                        Iterator<ParserDependency> depIter = nextProgrammingElement.getDependencyIterator();
                        while (depIter.hasNext()) {
                            ParserDependency nextParserDependency = depIter.next();
                            ParserDependencyState includeOutgoing = representation.includeOutgoingParserDependency(nextProgrammingElement, nextParserDependency, false, endPoints);
                            if (includeOutgoing.isIncluded()) {
                                if (allRelevantProgrammingElements.contains(endPoints.getTo()) && !FocusHandler.includedByProperties(nextParserDependency, properties, representation)) {
                                    focus.removeParserDependency(nextParserDependency);
                                }
                            } else if (includeOutgoing == ParserDependencyState.EXCLUDED_BY_DIRECTION && representation.includeIncomingParserDependency(nextProgrammingElement, nextParserDependency, false, endPoints).isIncluded() && allRelevantProgrammingElements.contains(endPoints.getFrom()) && !FocusHandler.includedByProperties(nextParserDependency, properties, representation)) {
                                focus.removeParserDependency(nextParserDependency);
                            }
                            endPoints.reset();
                        }
                    }
                    break;
                }
                case NODES_IN_AND_OUT: {
                    nodes.forEach(n -> FocusHandler.processNodesForFocus(properties, n.getRelevantProgrammingElements(), focus, ExplorationViewFocus.Mode.IN_OUT, representation, null));
                    break;
                }
                case NODES_IN: {
                    nodes.forEach(n -> FocusHandler.processNodesForFocus(properties, n.getRelevantProgrammingElements(), focus, ExplorationViewFocus.Mode.IN, representation, null));
                    break;
                }
                case NODES_OUT: {
                    nodes.forEach(n -> FocusHandler.processNodesForFocus(properties, n.getRelevantProgrammingElements(), focus, ExplorationViewFocus.Mode.OUT, representation, null));
                    break;
                }
                case NODES_IN_AND_OUT_TRANSITIVELY: {
                    FocusTransitivelyCollectorLeafBased transitivelyCollector = new FocusTransitivelyCollectorLeafBased(representation);
                    nodes.forEach(n -> FocusHandler.processNodesForFocus(properties, n.getRelevantProgrammingElements(), focus, ExplorationViewFocus.Mode.IN_OUT, representation, transitivelyCollector));
                    FocusHandler.processTransitively(transitivelyCollector, properties, focus, representation);
                    break;
                }
                case NODES_IN_TRANSITIVELY: {
                    FocusTransitivelyCollectorLeafBased inCollector = new FocusTransitivelyCollectorLeafBased(representation);
                    nodes.forEach(n -> FocusHandler.processNodesForFocus(properties, n.getRelevantProgrammingElements(), focus, ExplorationViewFocus.Mode.IN, representation, inCollector));
                    FocusHandler.processTransitively(inCollector, properties, focus, representation);
                    break;
                }
                case NODES_OUT_TRANSITIVELY: {
                    FocusTransitivelyCollectorLeafBased outCollector = new FocusTransitivelyCollectorLeafBased(representation);
                    nodes.forEach(n -> FocusHandler.processNodesForFocus(properties, n.getRelevantProgrammingElements(), focus, ExplorationViewFocus.Mode.OUT, representation, outCollector));
                    FocusHandler.processTransitively(outCollector, properties, focus, representation);
                    break;
                }
                case NODES_IN_AND_OUT_TRANSITIVELY_PEB: {
                    FocusTransitivelyCollectorProgrammingElementBased transitivelyCollectorPeb = new FocusTransitivelyCollectorProgrammingElementBased();
                    nodes.forEach(n -> FocusHandler.processNodesForFocus(properties, n.getRelevantProgrammingElements(), focus, ExplorationViewFocus.Mode.IN_OUT, representation, transitivelyCollectorPeb));
                    FocusHandler.processTransitively(transitivelyCollectorPeb, properties, focus, representation);
                    break;
                }
                case NODES_IN_TRANSITIVELY_PEB: {
                    FocusTransitivelyCollectorProgrammingElementBased inCollectorPeb = new FocusTransitivelyCollectorProgrammingElementBased();
                    nodes.forEach(n -> FocusHandler.processNodesForFocus(properties, n.getRelevantProgrammingElements(), focus, ExplorationViewFocus.Mode.IN, representation, inCollectorPeb));
                    FocusHandler.processTransitively(inCollectorPeb, properties, focus, representation);
                    break;
                }
                case NODES_OUT_TRANSITIVELY_PEB: {
                    FocusTransitivelyCollectorProgrammingElementBased outCollectorPeb = new FocusTransitivelyCollectorProgrammingElementBased();
                    nodes.forEach(n -> FocusHandler.processNodesForFocus(properties, n.getRelevantProgrammingElements(), focus, ExplorationViewFocus.Mode.OUT, representation, outCollectorPeb));
                    FocusHandler.processTransitively(outCollectorPeb, properties, focus, representation);
                    break;
                }
                default: {
                    assert (false) : "Unhandled focus node dependencies: " + String.valueOf((Object)properties.getNodeInclusionMode());
                    break;
                }
            }
        }
        if (!(parserDependencies = add.getParserDependencies()).isEmpty()) {
            if (properties.includesAllDependencies()) {
                parserDependencies.forEach(d -> focus.addParserDependency((ParserDependency)d));
            } else {
                for (ParserDependency nextParserDependency : parserDependencies) {
                    if (!FocusHandler.includedByProperties(nextParserDependency, properties, representation)) continue;
                    focus.addParserDependency(nextParserDependency);
                }
            }
        }
    }

    private static void removeFromFocus(ExplorationViewFocusProperties properties, ExplorationViewFocusRequest remove, ExplorationViewRepresentation representation) {
        assert (properties != null) : "Parameter 'properties' of method 'removeFromFocus' must not be null";
        assert (remove != null) : "Parameter 'remove' of method 'removeFromFocus' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'removeFromFocus' must not be null";
        ExplorationViewFocusProperties.NodeInclusionMode nodeInclusionMode = properties.getNodeInclusionMode();
        assert (nodeInclusionMode == ExplorationViewFocusProperties.NodeInclusionMode.NODES_IN_AND_OUT) : "Unexpected 'nodeInclusionMode' in 'removeFromFocus': " + String.valueOf((Object)nodeInclusionMode);
        boolean includeAllDependencies = properties.includesAllDependencies();
        assert (includeAllDependencies) : "Unexpected 'includeAllDependencies' in 'removeFromFocus': " + includeAllDependencies;
        ExplorationViewFocus focus = representation.getFocus();
        if (properties.includesAllDependencies()) {
            for (ArchitecturalViewNode nextNode : remove.getNodes()) {
                Collection<ProgrammingElement> nextRelevantProgrammingElements = nextNode.getRelevantProgrammingElements();
                focus.removeProgrammingElements(nextRelevantProgrammingElements);
            }
            remove.getParserDependencies().forEach(d -> focus.removeParserDependency((ParserDependency)d));
        } else {
            for (ArchitecturalViewNode nextNode : remove.getNodes()) {
                Collection<ProgrammingElement> nextRelevantProgrammingElements = nextNode.getRelevantProgrammingElements();
                focus.removeProgrammingElements(nextRelevantProgrammingElements);
                for (ProgrammingElement nextProgrammingElement : nextRelevantProgrammingElements) {
                    Iterator<ParserDependency> depIter = nextProgrammingElement.getDependencyIterator();
                    while (depIter.hasNext()) {
                        ParserDependency nextParserDependency = depIter.next();
                        if (representation.includeIncomingParserDependency(nextProgrammingElement, nextParserDependency, false, null).isIncluded()) {
                            if (!FocusHandler.includedByProperties(nextParserDependency, properties, representation)) continue;
                            focus.removeParserDependency(nextParserDependency);
                            continue;
                        }
                        if (!representation.includeOutgoingParserDependency(nextProgrammingElement, nextParserDependency, false, null).isIncluded() || !FocusHandler.includedByProperties(nextParserDependency, properties, representation)) continue;
                        focus.removeParserDependency(nextParserDependency);
                    }
                }
            }
            for (ParserDependency nextParserDependency : remove.getParserDependencies()) {
                if (FocusHandler.includedByProperties(nextParserDependency, properties, representation)) continue;
                focus.removeParserDependency(nextParserDependency);
            }
        }
    }

    private static ExplorationViewRepresentation getRepresentation(List<ArchitecturalViewNode> nodes, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, List<ArchitecturalViewFinding> findings) {
        assert (nodes != null) : "Parameter 'nodes' of method 'getRepresentation' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'getRepresentation' must not be null";
        assert (findings != null) : "Parameter 'findings' of method 'getRepresentation' must not be null";
        assert (!(nodes.isEmpty() && dependencies.isEmpty() && findings.isEmpty())) : "All is empty";
        if (findings.isEmpty()) {
            return RepresentationHandler.getRepresentation(nodes, dependencies);
        }
        ExplorationViewRepresentation common = RepresentationHandler.getRepresentation(nodes, dependencies);
        for (ArchitecturalViewFinding next : findings) {
            ArchitecturalViewFile nextFile = next.getParent(ArchitecturalViewFile.class, new Class[0]);
            if (nextFile == null) {
                return null;
            }
            ExplorationViewRepresentation nextRepresentation = nextFile.getUniqueChild(ExplorationViewRepresentation.class);
            if (nextRepresentation == null) {
                return null;
            }
            if (common == null) {
                common = nextRepresentation;
                continue;
            }
            if (common == nextRepresentation) continue;
            return null;
        }
        return common;
    }

    public static ExplorationViewFocusRequest isApplyFocusPossible(ExplorationViewFocusProperties.FocusType focusType, List<ArchitecturalViewNode> nodes, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, List<ArchitecturalViewFinding> findings) {
        ExplorationViewRepresentation representation;
        assert (focusType != null) : "Parameter 'focusType' of method 'isApplyFocusPossible' must not be null";
        assert (nodes != null) : "Parameter 'nodes' of method 'isApplyFocusPossible' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'isApplyFocusPossible' must not be null";
        if (!(nodes.isEmpty() && dependencies.isEmpty() && findings.isEmpty() || (representation = FocusHandler.getRepresentation(nodes, dependencies, findings)) == null)) {
            Set<ParserDependency> parserDependencies = FindingHandler.getParserDependencies(findings, representation);
            if (!(nodes.isEmpty() && dependencies.isEmpty() && parserDependencies.isEmpty())) {
                ExplorationViewFocus focus = representation.getFocus();
                switch (focusType) {
                    case ADD_TO_FOCUS: {
                        if (focus.isEmpty() || nodes.isEmpty()) break;
                        return new ExplorationViewFocusRequest(representation, NodeHandler.getNormalizedNodes(nodes), Collections.emptyList(), parserDependencies);
                    }
                    case REMOVE_FROM_FOCUS: {
                        return new ExplorationViewFocusRequest(representation, NodeHandler.getNormalizedNodes(nodes), dependencies, parserDependencies);
                    }
                    case SET_FOCUS: {
                        return new ExplorationViewFocusRequest(representation, NodeHandler.getNormalizedNodes(nodes), dependencies, parserDependencies);
                    }
                    default: {
                        assert (false) : "Unhandled focus operation: " + String.valueOf((Object)focusType);
                        break;
                    }
                }
            }
        }
        return null;
    }

    private static PartialAlternativeInfo calculatePartialAlternative(List<ArchitecturalViewNode> nodes) {
        ArchitecturalViewNodesInfo info;
        assert (nodes != null) : "Parameter 'nodes' of method 'calculatePartialAlternative' must not be null";
        if (!nodes.isEmpty() && (info = NodeHandler.createArchitecturalViewNodesInfo(nodes.get(0).getPresentationMode(), nodes, true)).getNumberOfNodes() > 0) {
            return RepresentationHandler.calculatePartialAlternativeInfo(nodes, Collections.emptyList());
        }
        return null;
    }

    private static String getFocusPropertiesInfo(int allNodes, int nodesRemovedByFocus) {
        if (nodesRemovedByFocus > 0) {
            if (allNodes == 1) {
                return "The specified node is hidden due to the current focus.\nYou can modify your focus!";
            }
            return "The specified nodes contain hidden nodes due to the current focus.\nYou can modify your focus!";
        }
        return "";
    }

    public static ExplorationViewFocusProperties createFocusProperties(ExplorationViewFocusProperties.FocusType focusType, ExplorationViewFocusRequest request) {
        assert (focusType != null) : "Parameter 'focusType' of method 'createFocusProperties' must not be null";
        assert (request != null) : "Parameter 'request' of method 'createFocusProperties' must not be null";
        List<ArchitecturalViewNode> nodes = request.getNodes();
        boolean offerNodeInclusionModes = !nodes.isEmpty();
        boolean offerDependencyInclusionModes = false;
        int renovedNodesByFocus = 0;
        for (ArchitecturalViewNode next : nodes) {
            if (next.isRemovedByFocus()) {
                ++renovedNodesByFocus;
            }
            if (next.hasViolation() || next.hasIncomingViolation()) {
                offerDependencyInclusionModes = true;
            }
            if (offerNodeInclusionModes && offerDependencyInclusionModes) break;
        }
        Set<ParserDependency> parserDependencies = request.getParserDependencies();
        if (!offerDependencyInclusionModes) {
            ExplorationViewRepresentation representation = request.getRepresentation();
            for (ParserDependency nextParserDependency : parserDependencies) {
                ViolationInfo info = representation.isViolation(nextParserDependency);
                if (info == null || info.isIgnored()) continue;
                offerDependencyInclusionModes = true;
                break;
            }
        }
        THashSet availableParserDependencyTypes = null;
        if (nodes.isEmpty() && !parserDependencies.isEmpty()) {
            availableParserDependencyTypes = new THashSet();
            THashSet all = new THashSet(Arrays.asList(CoreParserDependencyType.values()));
            for (ParserDependency nextParserDependency : parserDependencies) {
                IParserDependencyType nextParserDependencyType = nextParserDependency.getGenericDependencyType();
                availableParserDependencyTypes.add(nextParserDependencyType);
                all.remove(nextParserDependencyType);
                if (!all.isEmpty()) {
                    continue;
                }
                break;
            }
        } else {
            availableParserDependencyTypes = new THashSet(Arrays.asList(CoreParserDependencyType.values()));
        }
        return new ExplorationViewFocusProperties(focusType, EnumSet.of(focusType), offerNodeInclusionModes, offerDependencyInclusionModes, (Collection<IParserDependencyType>)availableParserDependencyTypes, FocusHandler.getFocusPropertiesInfo(nodes.size(), renovedNodesByFocus), FocusHandler.calculatePartialAlternative(nodes));
    }

    static ExplorationViewFocus resetFocus(boolean resetExistingFocus, ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'resetFocus' must not be null";
        return FocusResetVisitor.reset(resetExistingFocus, representation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFocus(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'clearFocus' must not be null";
        assert (!representation.getFocus().isEmpty()) : "Representation has no focus";
        ExplorationViewRepresentation explorationViewRepresentation = representation;
        synchronized (explorationViewRepresentation) {
            LOGGER.debug("Clear focus");
            RepresentationHandler.aboutToChangeStructure(false, representation);
            RepresentationHandler.removeAggregatedDependencies(false, representation);
            FocusResetVisitor.reset(true, representation);
            RepresentationHandler.createAggregatedDependencies(false, representation);
            RepresentationHandler.structureChanged(false, false, representation);
            LOGGER.debug("Clear focus - done");
        }
    }

    private static void createInitialFullFocus(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'createInitialFullFocus' must not be null";
        assert (representation.getFocus().isEmpty()) : "Focus not empty";
        LOGGER.debug("Create initial full focus");
        ExplorationViewFocus focus = representation.getFocus();
        for (ArchitecturalViewNode nextNode : representation.getVisibleNodeChildren()) {
            focus.addProgrammingElements(nextNode.getRelevantProgrammingElements(), ExplorationViewFocus.Mode.NO_ADDITIONAL);
        }
        LOGGER.debug("Create initial full focus");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyFocus(ExplorationViewFocusProperties focusProperties, ExplorationViewFocusRequest focusRequest) {
        ExplorationViewRepresentation representation;
        assert (focusProperties != null) : "Parameter 'focusProperties' of method 'applyFocus' must not be null";
        assert (focusProperties.isValid()) : "'focusProperties' not valid: " + String.valueOf(focusProperties);
        assert (focusRequest != null) : "Parameter 'focusRequest' of method 'applyFocus' must not be null";
        ExplorationViewRepresentation explorationViewRepresentation = representation = focusRequest.getRepresentation();
        synchronized (explorationViewRepresentation) {
            ExpandCollapseRequest request;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Apply focus with properties '" + String.valueOf(focusProperties) + "'");
            }
            String msg = ExplorationViewLogger.logInteraction("Apply User Focus", focusProperties.toString(), representation);
            RepresentationHandler.aboutToChangeStructure(false, representation);
            RepresentationHandler.removeAggregatedDependencies(false, representation);
            FocusHandler.resetFocus(false, representation);
            focusRequest.setPartialAlternative(focusProperties.getPartialAlternative());
            List<StrictPair<String, String>> dependenciesInfo = RepresentationHandler.getDependencyInfo(focusRequest.getDependencies());
            switch (focusProperties.getFocusType()) {
                case SET_FOCUS: {
                    representation.resetFocus();
                    FocusHandler.addToFocus(focusProperties, focusRequest, representation);
                    break;
                }
                case ADD_TO_FOCUS: {
                    assert (focusRequest.getDependencies().isEmpty()) : "Unexpected dependencies";
                    FocusHandler.addToFocus(focusProperties, focusRequest, representation);
                    break;
                }
                case REMOVE_FROM_FOCUS: {
                    if (representation.getFocus().isEmpty()) {
                        FocusHandler.createInitialFullFocus(representation);
                    }
                    FocusHandler.removeFromFocus(focusProperties, focusRequest, representation);
                    break;
                }
                default: {
                    assert (false) : "Unhandled focus operation: " + String.valueOf((Object)focusProperties.getFocusType());
                    break;
                }
            }
            FocusApplyVisitor.apply(representation);
            RepresentationHandler.createAggregatedDependencies(false, representation);
            List<ArchitecturalViewNode.ArchitecturalViewDependency> selectedDependencies = RepresentationHandler.selectDependencies(dependenciesInfo, representation);
            RepresentationHandler.structureChanged(false, false, representation);
            if (focusProperties.expandToAssignableToArtifactLevel() && (request = RepresentationHandler.isExpandToAssignableToArtifactsPossible(focusRequest.getNodes(), selectedDependencies, false)) != null) {
                RepresentationHandler.processExpandCollapseRequest(request);
            }
            focusRequest.setPartialAlternative(null);
            ExplorationViewLogger.logDone(msg, null);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Apply focus with properties '" + String.valueOf(focusProperties) + "' - done");
            }
        }
    }

    static void applyFocus(ExplorationViewFocus focus, ExplorationViewRepresentation representation) {
        assert (focus != null) : "Parameter 'focus' of method 'applyFocus' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'applyFocus' must not be null";
        FocusHandler.resetFocus(true, representation);
        if (!focus.isEmpty()) {
            DescriptorCache descriptorCache = focus.consumeDescriptorCache();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Create focus" + (descriptorCache != null ? " using descriptor cache" : "") + " based on [" + String.valueOf(focus) + "]");
            }
            ExplorationViewFocus updatedFocus = new ExplorationViewFocus();
            if (descriptorCache != null) {
                Element nextResolved;
                IElementResolver resolver = representation.getResolver();
                ExplorationViewFocus.Mode[] modeArray = ExplorationViewFocus.Mode.values();
                int n = modeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExplorationViewFocus.Mode nextMode = modeArray[n2];
                    for (ProgrammingElement next : focus.getProgrammingElements(nextMode)) {
                        if (next.isValid()) {
                            updatedFocus.addProgrammingElements(Collections.singleton(next), nextMode);
                            continue;
                        }
                        String nextDescriptor = descriptorCache.getDescriptor(next);
                        if (nextDescriptor != null && !nextDescriptor.isEmpty()) {
                            Element nextResolved2 = resolver.resolve(nextDescriptor);
                            if (nextResolved2 == null) {
                                LOGGER.debug("Unable to resolve: " + nextDescriptor);
                                continue;
                            }
                            if (nextResolved2 instanceof ProgrammingElement) {
                                updatedFocus.addProgrammingElements(Collections.singleton((ProgrammingElement)nextResolved2), nextMode);
                                continue;
                            }
                            LOGGER.debug("Resolved but was not a programming element: " + String.valueOf(nextResolved2));
                            continue;
                        }
                        LOGGER.warn("No descriptor found for: " + String.valueOf(next));
                    }
                    ++n2;
                }
                for (ProgrammingElement next : focus.getRemovedProgrammingElements()) {
                    if (next.isValid()) {
                        updatedFocus.removeProgrammingElements(Collections.singleton(next));
                        continue;
                    }
                    String nextDescriptor = descriptorCache.getDescriptor(next);
                    if (nextDescriptor != null && !nextDescriptor.isEmpty()) {
                        nextResolved = resolver.resolve(nextDescriptor);
                        if (nextResolved == null) {
                            LOGGER.debug("Unable to resolve: " + nextDescriptor);
                            continue;
                        }
                        if (nextResolved instanceof ProgrammingElement) {
                            updatedFocus.removeProgrammingElements(Collections.singleton((ProgrammingElement)nextResolved));
                            continue;
                        }
                        LOGGER.debug("Resolved but was not a programming element: " + String.valueOf(nextResolved));
                        continue;
                    }
                    LOGGER.warn("No descriptor found for: " + String.valueOf(next));
                }
                for (ParserDependency nextAdded : focus.getAddedParserDependencies()) {
                    if (nextAdded.isValid()) {
                        updatedFocus.addParserDependency(nextAdded);
                        continue;
                    }
                    String nextDescriptor = descriptorCache.getDescriptor(nextAdded);
                    if (nextDescriptor != null && !nextDescriptor.isEmpty()) {
                        nextResolved = resolver.resolve(nextDescriptor);
                        if (nextResolved == null) {
                            LOGGER.debug("Unable to resolve: " + nextDescriptor);
                            continue;
                        }
                        if (nextResolved instanceof ParserDependency) {
                            updatedFocus.addParserDependency((ParserDependency)nextResolved);
                            continue;
                        }
                        LOGGER.debug("Resolved but was not a parser dependency: " + String.valueOf(nextResolved));
                        continue;
                    }
                    LOGGER.warn("No descriptor found for: " + String.valueOf(nextAdded));
                }
                for (ParserDependency nextRemoved : focus.getRemovedParserDependencies()) {
                    if (nextRemoved.isValid()) {
                        updatedFocus.removeParserDependency(nextRemoved);
                        continue;
                    }
                    String nextDescriptor = descriptorCache.getDescriptor(nextRemoved);
                    if (nextDescriptor != null && !nextDescriptor.isEmpty()) {
                        nextResolved = resolver.resolve(nextDescriptor);
                        if (nextResolved == null) {
                            LOGGER.debug("Unable to resolve: " + nextDescriptor);
                            continue;
                        }
                        if (nextResolved instanceof ParserDependency) {
                            updatedFocus.removeParserDependency((ParserDependency)nextResolved);
                            continue;
                        }
                        LOGGER.debug("Resolved but was not a parser dependency: " + String.valueOf(nextResolved));
                        continue;
                    }
                    LOGGER.warn("No descriptor found for: " + String.valueOf(nextRemoved));
                }
            } else {
                ExplorationViewFocus.Mode[] modeArray = ExplorationViewFocus.Mode.values();
                int n = modeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ExplorationViewFocus.Mode nextMode = modeArray[n3];
                    updatedFocus.addProgrammingElements(focus.getProgrammingElements(nextMode), nextMode);
                    ++n3;
                }
                focus.getAddedParserDependencies().forEach(d -> updatedFocus.addParserDependency((ParserDependency)d));
                focus.getRemovedParserDependencies().forEach(d -> updatedFocus.removeParserDependency((ParserDependency)d));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Create focus" + (descriptorCache != null ? " using descriptor cache" : "") + " based on [" + String.valueOf(focus) + "] - done");
            }
            if (!updatedFocus.isEmpty()) {
                representation.getFocus().addFrom(updatedFocus);
                FocusApplyVisitor.apply(representation);
            }
        }
    }

    static ExplorationViewFocus startOperation(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'startOperation' must not be null";
        return !representation.inModification() ? FocusHandler.resetFocus(true, representation) : null;
    }

    static void finishOperation(ExplorationViewFocus focus, ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'finishOperation' must not be null";
        if (!representation.inModification()) {
            assert (focus != null) : "Parameter 'focus' of method 'finishOperation' must not be null";
            assert (representation.getFocus().isEmpty()) : "Representation already has a focus";
            focus.deleted(representation.getDeletedProgrammingElements(), representation.getDeletedParserDependencies());
            if (!focus.isEmpty()) {
                representation.getFocus().addFrom(focus);
                FocusApplyVisitor.apply(representation);
            }
        }
    }

    private static void addDescriptor(Element element, DescriptorCache cache, IElementResolver resolver) {
        assert (element != null) : "Parameter 'element' of method 'addDescriptor' must not be null";
        assert (cache != null) : "Parameter 'cache' of method 'addDescriptor' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'addDescriptor' must not be null";
        String nextDescriptor = resolver.getDescriptor(element);
        if (nextDescriptor != null && !nextDescriptor.isEmpty()) {
            cache.addDescriptor(element, nextDescriptor);
        } else {
            LOGGER.warn("No descriptor for: " + String.valueOf(element));
        }
    }

    public static void aboutToModifyParserModel(IElementResolver resolver, ExplorationViewRepresentation representation) {
        assert (resolver != null) : "Parameter 'resolver' of method 'aboutToModifyParserModel' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'aboutToModifyParserModel' must not be null";
        if (!representation.getFocus().isEmpty()) {
            ExplorationViewFocus focus = representation.getFocus();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Create descriptor cache for focus '" + String.valueOf(focus) + "'");
            }
            DescriptorCache descriptorCache = new DescriptorCache();
            ExplorationViewFocus.Mode[] modeArray = ExplorationViewFocus.Mode.values();
            int n = modeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExplorationViewFocus.Mode nextMode = modeArray[n2];
                focus.getProgrammingElements(nextMode).forEach(p -> FocusHandler.addDescriptor(p, descriptorCache, resolver));
                ++n2;
            }
            focus.getRemovedProgrammingElements().forEach(p -> FocusHandler.addDescriptor(p, descriptorCache, resolver));
            focus.getAddedParserDependencies().forEach(p -> FocusHandler.addDescriptor(p, descriptorCache, resolver));
            focus.getRemovedParserDependencies().forEach(p -> FocusHandler.addDescriptor(p, descriptorCache, resolver));
            focus.setDescriptorCache(descriptorCache);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Create descriptor cache for focus '" + String.valueOf(focus) + "' - done");
            }
        }
    }

    static void finishProgramminElementNodeCreation(List<ProgrammingElementNode> created, ExplorationViewRepresentation representation) {
        assert (created != null) : "Parameter 'created' of method 'finishProgramminElementNodeCreation' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'finishProgramminElementNodeCreation' must not be null";
        if (!(created.isEmpty() || representation.inModification() || representation.getFocus().isEmpty())) {
            FocusApplyVisitor.applyFocus(representation.getFocus(), created, representation);
        }
    }

    static void finishElementCreation(List<? extends ArchitecturalViewNode> created, ExplorationViewRepresentation representation) {
        assert (created != null) : "Parameter 'created' of method 'finishElementCreation' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'finishElementCreation' must not be null";
        if (!(created.isEmpty() || representation.inModification() || representation.getFocus().isEmpty())) {
            for (ArchitecturalViewNode architecturalViewNode : created) {
                representation.getFocus().addProgrammingElements(architecturalViewNode.getRelevantProgrammingElements(), ExplorationViewFocus.Mode.IN_OUT);
            }
        }
    }

    public static RevealRequest getRevealRequest(List<ArchitecturalViewNode> nodesToReveal, boolean forceFocus) {
        assert (nodesToReveal != null && !nodesToReveal.isEmpty()) : "Parameter 'nodesToReveal' of method 'getRevealRequest' must not be empty";
        ExplorationViewRepresentation representation = RepresentationHandler.getRepresentation(nodesToReveal);
        if (representation != null) {
            ArrayList<ArchitecturalViewNode> nodesRemovedByFocus = new ArrayList<ArchitecturalViewNode>();
            for (ArchitecturalViewNode nextNode : nodesToReveal) {
                assert (!nextNode.isDeleted()) : "Node deleted: " + String.valueOf(nextNode);
                if (!nextNode.isRemovedByFocus()) continue;
                nodesRemovedByFocus.add(nextNode);
            }
            ExplorationViewFocusProperties properties = null;
            if (forceFocus || !nodesRemovedByFocus.isEmpty()) {
                EnumSet<ExplorationViewFocusProperties.FocusType> availableFocusTypes = representation.getFocus().isEmpty() ? EnumSet.of(ExplorationViewFocusProperties.FocusType.SET_FOCUS) : EnumSet.of(ExplorationViewFocusProperties.FocusType.SET_FOCUS, ExplorationViewFocusProperties.FocusType.ADD_TO_FOCUS);
                properties = new ExplorationViewFocusProperties(ExplorationViewFocusProperties.FocusType.SET_FOCUS, availableFocusTypes, true, false, (Collection<IParserDependencyType>)new THashSet(Arrays.asList(CoreParserDependencyType.values())), FocusHandler.getFocusPropertiesInfo(nodesToReveal.size(), nodesRemovedByFocus.size()), FocusHandler.calculatePartialAlternative(nodesToReveal));
            }
            return new RevealRequest(representation, nodesToReveal, properties);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger reveal(RevealRequest request) {
        ExplorationViewRepresentation representation;
        assert (request != null) : "Parameter 'request' of method 'reveal' must not be null";
        ExplorationViewRepresentation explorationViewRepresentation = representation = request.getRepresentation();
        synchronized (explorationViewRepresentation) {
            RepresentationHandler.aboutToChangeStructure(false, representation);
            RepresentationHandler.removeAggregatedDependencies(false, representation);
            ExplorationViewFocusProperties focusProperties = request.getFocusProperties();
            if (focusProperties != null) {
                FocusHandler.resetFocus(false, representation);
                ExplorationViewFocusRequest focusRequest = new ExplorationViewFocusRequest(representation, request.getNodes(), Collections.emptyList());
                switch (focusProperties.getFocusType()) {
                    case SET_FOCUS: {
                        representation.resetFocus();
                        FocusHandler.addToFocus(focusProperties, focusRequest, representation);
                        break;
                    }
                    case ADD_TO_FOCUS: {
                        assert (focusRequest.getDependencies().isEmpty()) : "Unexpected dependencies";
                        FocusHandler.addToFocus(focusProperties, focusRequest, representation);
                        break;
                    }
                    case REMOVE_FROM_FOCUS: {
                        assert (false) : "Unexpected focus type: " + String.valueOf((Object)focusProperties.getFocusType());
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled focus type: " + String.valueOf((Object)focusProperties.getFocusType());
                        break;
                    }
                }
                FocusApplyVisitor.apply(representation);
            }
            NodeHandler.expandParentChainOf(request.getNodes(), true, representation, false);
            RepresentationHandler.createAggregatedDependencies(false, representation);
            RepresentationHandler.structureChanged(false, false, representation);
            return focusProperties != null ? ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.FOCUS : ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.REVEAL;
        }
    }

    public static ExplorationViewFocusProperties createOnDemandFocusProperties() {
        return new ExplorationViewFocusProperties(ExplorationViewFocusProperties.FocusType.SET_FOCUS, EnumSet.of(ExplorationViewFocusProperties.FocusType.SET_FOCUS), true, false, (Collection<IParserDependencyType>)new THashSet(Arrays.asList(CoreParserDependencyType.values())), "", null);
    }

    public static ExplorationViewFocus createOnDemandFocus(Set<ProgrammingElement> programmingElements, ExplorationViewFocusProperties properties, ExplorationViewRepresentation representation) {
        assert (programmingElements != null && !programmingElements.isEmpty()) : "Parameter 'programmingElements' of method 'createOnDemandFocus' must not be empty";
        assert (properties != null) : "Parameter 'focusProperties' of method 'createFocus' must not be null";
        assert (properties.isValid()) : "'focusProperties' not valid: " + String.valueOf(properties);
        assert (properties.getFocusType() == ExplorationViewFocusProperties.FocusType.SET_FOCUS) : "Unexpected 'onDemand' focus type:" + String.valueOf((Object)properties.getFocusType());
        assert (properties.getPartialAlternative() == null) : "No partial alternative expected";
        assert (representation != null) : "Parameter 'representation' of method 'createOnDemandFocus' must not be null";
        ExplorationViewFocus focus = new ExplorationViewFocus();
        switch (properties.getNodeInclusionMode()) {
            case NO_ADDITONAL_NODES: {
                focus.addProgrammingElements(programmingElements, ExplorationViewFocus.Mode.NO_ADDITIONAL);
                break;
            }
            case NODES_IN_AND_OUT: {
                FocusHandler.processNodesForFocus(properties, programmingElements, focus, ExplorationViewFocus.Mode.IN_OUT, representation, null);
                break;
            }
            case NODES_IN: {
                FocusHandler.processNodesForFocus(properties, programmingElements, focus, ExplorationViewFocus.Mode.IN, representation, null);
                break;
            }
            case NODES_OUT: {
                FocusHandler.processNodesForFocus(properties, programmingElements, focus, ExplorationViewFocus.Mode.OUT, representation, null);
                break;
            }
            case NODES_IN_AND_OUT_TRANSITIVELY: {
                FocusTransitivelyCollectorLeafBased transitivelyCollector = new FocusTransitivelyCollectorLeafBased(representation);
                FocusHandler.processNodesForFocus(properties, programmingElements, focus, ExplorationViewFocus.Mode.IN_OUT, representation, transitivelyCollector);
                FocusHandler.processTransitively(transitivelyCollector, properties, focus, representation);
                break;
            }
            case NODES_IN_TRANSITIVELY: {
                FocusTransitivelyCollectorLeafBased inCollector = new FocusTransitivelyCollectorLeafBased(representation);
                FocusHandler.processNodesForFocus(properties, programmingElements, focus, ExplorationViewFocus.Mode.IN, representation, inCollector);
                FocusHandler.processTransitively(inCollector, properties, focus, representation);
                break;
            }
            case NODES_OUT_TRANSITIVELY: {
                FocusTransitivelyCollectorLeafBased outCollector = new FocusTransitivelyCollectorLeafBased(representation);
                FocusHandler.processNodesForFocus(properties, programmingElements, focus, ExplorationViewFocus.Mode.OUT, representation, outCollector);
                FocusHandler.processTransitively(outCollector, properties, focus, representation);
                break;
            }
            case NODES_IN_AND_OUT_TRANSITIVELY_PEB: {
                FocusTransitivelyCollectorProgrammingElementBased transitivelyCollectorPeb = new FocusTransitivelyCollectorProgrammingElementBased();
                FocusHandler.processNodesForFocus(properties, programmingElements, focus, ExplorationViewFocus.Mode.IN_OUT, representation, transitivelyCollectorPeb);
                FocusHandler.processTransitively(transitivelyCollectorPeb, properties, focus, representation);
                break;
            }
            case NODES_IN_TRANSITIVELY_PEB: {
                FocusTransitivelyCollectorProgrammingElementBased inCollectorPeb = new FocusTransitivelyCollectorProgrammingElementBased();
                FocusHandler.processNodesForFocus(properties, programmingElements, focus, ExplorationViewFocus.Mode.IN, representation, inCollectorPeb);
                FocusHandler.processTransitively(inCollectorPeb, properties, focus, representation);
                break;
            }
            case NODES_OUT_TRANSITIVELY_PEB: {
                FocusTransitivelyCollectorProgrammingElementBased outCollectorPeb = new FocusTransitivelyCollectorProgrammingElementBased();
                FocusHandler.processNodesForFocus(properties, programmingElements, focus, ExplorationViewFocus.Mode.OUT, representation, outCollectorPeb);
                FocusHandler.processTransitively(outCollectorPeb, properties, focus, representation);
                break;
            }
            default: {
                assert (false) : "Unhandled focus node dependencies: " + String.valueOf((Object)properties.getNodeInclusionMode());
                break;
            }
        }
        return focus;
    }

    private static <T extends Element> void update(Set<T> from, Set<T> to) {
        assert (from != null) : "Parameter 'from' of method 'update' must not be null";
        assert (to != null) : "Parameter 'to' of method 'update' must not be null";
        assert (from != to) : "Same instances";
        for (Element next : from) {
            if (!next.isValid() || !(next instanceof EmptyNodeProgrammingElement) && next.getRefactoringState().hasBeenDeleted()) continue;
            to.add(next);
        }
    }

    public static ExplorationViewFocus updateFocus(ExplorationViewFocus focus, ExplorationViewRepresentation representation) {
        assert (focus != null) : "Parameter 'focus' of method 'updateFocus' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'updateFocus' must not be null";
        THashSet noAdditionalProgrammingElements = new THashSet();
        FocusHandler.update(focus.getProgrammingElements(ExplorationViewFocus.Mode.NO_ADDITIONAL), noAdditionalProgrammingElements);
        THashSet inProgrammingElements = new THashSet();
        FocusHandler.update(focus.getProgrammingElements(ExplorationViewFocus.Mode.IN), inProgrammingElements);
        THashSet outProgrammingElements = new THashSet();
        FocusHandler.update(focus.getProgrammingElements(ExplorationViewFocus.Mode.OUT), outProgrammingElements);
        THashSet inOutProgrammingElements = new THashSet();
        FocusHandler.update(focus.getProgrammingElements(ExplorationViewFocus.Mode.IN_OUT), inOutProgrammingElements);
        THashSet removedProgrammingElements = new THashSet();
        FocusHandler.update(focus.getRemovedProgrammingElements(), removedProgrammingElements);
        THashSet removedParserDependencies = new THashSet();
        FocusHandler.update(focus.getRemovedParserDependencies(), removedParserDependencies);
        THashSet addedParserDependencies = new THashSet();
        FocusHandler.update(focus.getAddedParserDependencies(), addedParserDependencies);
        return new ExplorationViewFocus((Set<ProgrammingElement>)noAdditionalProgrammingElements, (Set<ProgrammingElement>)inProgrammingElements, (Set<ProgrammingElement>)outProgrammingElements, (Set<ProgrammingElement>)inOutProgrammingElements, (Set<ProgrammingElement>)removedProgrammingElements, (Set<ParserDependency>)removedParserDependencies, (Set<ParserDependency>)addedParserDependencies);
    }
}

