/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.AssignableToArtifactCollector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IAssignmentToArtifactCheck;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IExplorationViewRepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.StructureHandler;
import com.hello2morrow.sonargraph.core.model.architecture.ParsedPatternInfo;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactFilterOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import com.hello2morrow.sonargraph.core.model.explorationview.ManualFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.ManualFilterOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.MoveElementsInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveRootNode;
import com.hello2morrow.sonargraph.core.model.explorationview.PatternFilterExclude;
import com.hello2morrow.sonargraph.core.model.explorationview.PatternFilterInclude;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilterHandler
implements IExplorationViewRepresentationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterHandler.class);

    static ArtifactNodeFilter createFilter(ExplorationViewRepresentation representation, ManualFilter manualFilter) {
        assert (representation != null) : "Parameter 'representation' of method 'createFilter' must not be null";
        ArtifactNodeFilter filter = new ArtifactNodeFilter(null);
        if (manualFilter != null) {
            ParsedPatternInfo nextInfo;
            for (String nextInclude : manualFilter.getIncludes()) {
                nextInfo = ParsedPatternInfo.parsePattern(nextInclude, false, false, representation);
                assert (nextInfo.isValid()) : "Not a valid include pattern: " + nextInclude + " -> " + nextInfo.getErrorMessage();
                filter.addChild(new PatternFilterInclude((NamedElement)filter, nextInfo.getRetriever(), nextInfo.getOriginalPattern(), nextInfo.getPattern(), nextInfo.isStrong(), nextInfo.getParams(), true));
            }
            for (String nextExclude : manualFilter.getExcludes()) {
                nextInfo = ParsedPatternInfo.parsePattern(nextExclude, false, false, representation);
                assert (nextInfo.isValid()) : "Not a valid exclude pattern: " + nextExclude + " -> " + nextInfo.getErrorMessage();
                filter.addChild(new PatternFilterExclude((NamedElement)filter, nextInfo.getRetriever(), nextInfo.getOriginalPattern(), nextInfo.getPattern(), nextInfo.isStrong(), nextInfo.getParams(), true));
            }
            filter.setIsManual(true);
        }
        return filter;
    }

    private FilterHandler() {
    }

    public static List<AssignableToArtifactNode> calculateMatchingPreview(IWorkerContext workerContext, AssignableTargetInfo targetInfo, ArtifactNodeFilter filter, Set<String> multipleAttributeInfoCollector, ArtifactNode toBeEdited, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateMatchingPreview' must not be null";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'calculateMatchingPreview' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'calculateMatchingPreview' must not be null";
        assert (multipleAttributeInfoCollector != null) : "Parameter 'multipleAttributeInfoCollector' of method 'calculateMatchingPreview' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'calculateMatchingPreview' must not be null";
        LOGGER.debug("Calculate matching preview using:\n\n" + String.valueOf(filter) + "\n\n" + String.valueOf(targetInfo) + "\n");
        ArrayList<IAssignableTarget> includeAssignablesFrom = new ArrayList<IAssignableTarget>();
        includeAssignablesFrom.add(targetInfo.getTarget());
        int posInParent = targetInfo.getRelativeIndex();
        ArchitecturalViewElement parent = targetInfo.getTarget().getArchitecturalViewElement();
        List<ArtifactNode> artifactChildrenOfParent = parent.getChildren(ArtifactNode.class);
        for (ArtifactNode nextArtifactChild : artifactChildrenOfParent) {
            if (workerContext.hasBeenCanceled()) {
                return Collections.emptyList();
            }
            if (nextArtifactChild.getRelativeIndex() < posInParent) continue;
            LOGGER.debug("Include artifact in match: " + nextArtifactChild.getName());
            includeAssignablesFrom.add(nextArtifactChild);
        }
        if (toBeEdited != null) {
            for (ArtifactNode next : toBeEdited.getChildrenRecursively(ArtifactNode.class, AssignableNode.class)) {
                LOGGER.debug("Include artifact in match: " + next.getName());
                includeAssignablesFrom.add(next);
            }
        }
        filter.reset();
        MatchPreviewVisitor matcher = new MatchPreviewVisitor(workerContext, filter, multipleAttributeInfoCollector);
        for (IAssignableTarget next : includeAssignablesFrom) {
            if (workerContext.hasBeenCanceled()) {
                return Collections.emptyList();
            }
            ArchitecturalViewElement nextElement = next.getArchitecturalViewElement();
            LOGGER.debug("Match assignables from: " + nextElement.getName());
            nextElement.accept(matcher);
        }
        LOGGER.debug("Calculate matching preview - done");
        return matcher.getMatched();
    }

    private static List<AssignableToArtifactNode> calculateMatching(AssignableTargetInfo targetInfo, ArtifactNodeFilter filter, ExplorationViewRepresentation representation) {
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'calculateMatching' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'calculateMatching' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'calculateMatching' must not be null";
        LOGGER.debug("Calculate matching");
        ArrayList<IAssignableTarget> includeAssignablesFrom = new ArrayList<IAssignableTarget>();
        includeAssignablesFrom.add(targetInfo.getTarget());
        int posInParent = targetInfo.getRelativeIndex();
        ArchitecturalViewElement parent = targetInfo.getTarget().getArchitecturalViewElement();
        List<ArtifactNode> artifactChildrenOfParent = parent.getChildren(ArtifactNode.class);
        for (ArtifactNode nextArtifactChild : artifactChildrenOfParent) {
            if (nextArtifactChild.getRelativeIndex() <= posInParent) continue;
            LOGGER.debug("Include artifact in match: " + nextArtifactChild.getName());
            includeAssignablesFrom.add(nextArtifactChild);
        }
        filter.reset();
        MatchOnFinishFilterUpdateVisitor matcher = new MatchOnFinishFilterUpdateVisitor(filter);
        for (IAssignableTarget next : includeAssignablesFrom) {
            ArchitecturalViewElement nextElement = next.getArchitecturalViewElement();
            LOGGER.debug("Match assignables from: " + nextElement.getName());
            nextElement.accept(matcher);
        }
        LOGGER.debug("Calculate matching - done");
        return matcher.getMatched();
    }

    private static IAssignableTarget getParentScope(ArtifactNode artifact, ExplorationViewRepresentation representation) {
        assert (artifact != null) : "Parameter 'artifact' of method 'getParentScope' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'getParentScope' must not be null";
        ArtifactNode current = artifact.getParent(ArtifactNode.class, ParentMode.ONLY_DIRECT_PARENT);
        while (current != null) {
            if (!current.hasManualFilter()) {
                return current;
            }
            current = current.getParent(ArtifactNode.class, ParentMode.ONLY_DIRECT_PARENT);
        }
        return representation;
    }

    public static String isFilterValid(ArtifactNodeFilter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'isFilterValid' must not be null";
        return filter.isEmpty() || filter.hasIncludes() ? null : "Filter must have at least 1 include pattern.";
    }

    public static void finishFilterOperationCreation(ArtifactFilterOperation operation, ArtifactNode artifact) {
        assert (operation != null) : "Parameter 'operation' of method 'finishFilterOperationCreation' must not be null";
        assert (artifact != null) : "Parameter 'artifact' of method 'finishFilterOperationCreation' must not be null";
        if (artifact.hasManualFilter()) {
            ArtifactNodeFilter filter = artifact.getFilter();
            LOGGER.debug("Adding manual filter to operation for artifact '" + artifact.getName() + "': " + String.valueOf(filter));
            List<String> includes = filter.getChildren(PatternFilterInclude.class).stream().filter(i -> i.isManual()).map(i -> i.getName()).collect(Collectors.toList());
            List<String> excludes = filter.getChildren(PatternFilterExclude.class).stream().filter(i -> i.isManual()).map(i -> i.getName()).collect(Collectors.toList());
            operation.setManualFilter(new ManualFilter(includes, excludes));
        } else {
            LOGGER.debug("No manual filter added to operation for artifact '" + artifact.getName() + "'");
        }
    }

    static void finishFilterOperation(ManualFilterOperation filterOperation, ArtifactNode artifact, ArtifactNodeFilter newFilter, ExplorationViewRepresentation representation) {
        assert (artifact != null) : "Parameter 'artifact' of method 'finishFilterOperation' must not be null";
        assert (filterOperation != null) : "Parameter 'filterOperation' of method 'finishFilterOperation' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'finishFilterOperation' must not be null";
        LOGGER.debug("Finish filter operation '" + String.valueOf((Object)filterOperation) + "'");
        ArtifactNodeFilter originalFilter = artifact.getFilter();
        switch (filterOperation) {
            case ADDED: 
            case MODIFIED: {
                assert (newFilter != null) : "Parameter 'newFilter' of method 'finishFilterOperation' must not be null";
                originalFilter.clear(false);
                for (PatternFilterInclude nextInclude : newFilter.getChildren(PatternFilterInclude.class)) {
                    originalFilter.addChild(nextInclude.copyOf(originalFilter, true));
                }
                for (PatternFilterExclude nextExclude : newFilter.getChildren(PatternFilterExclude.class)) {
                    originalFilter.addChild(nextExclude.copyOf(originalFilter, true));
                }
                originalFilter.setIsManual(true);
                break;
            }
            case REMOVED: {
                originalFilter.clear(false);
                break;
            }
            case NONE: {
                assert (false) : "Filter not affected";
                break;
            }
            default: {
                assert (false) : "Unhandled filter operation: " + String.valueOf((Object)filterOperation);
                break;
            }
        }
        LOGGER.debug("Finish filter operation '" + String.valueOf((Object)filterOperation) + "' - done");
    }

    static void finishFilterUpdate(ArtifactNode createdArtifact, ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'finishFilterUpdate' must not be null";
        LOGGER.debug("Finish filter update" + (String)(createdArtifact != null ? " for created artifact '" + createdArtifact.getName() + "'" : ""));
        ArrayList<ArtifactNode> manualArtifacts = new ArrayList<ArtifactNode>();
        ArtifactsWithManualFilterCollector collector = new ArtifactsWithManualFilterCollector(manualArtifacts);
        if (createdArtifact != null) {
            int posInParent = createdArtifact.getRelativeIndex();
            NamedElement parent = createdArtifact.getParent();
            assert (parent != null && parent instanceof IAssignableTarget) : "Unexpected class in method 'finishFilterUpdate': " + String.valueOf(parent);
            ArrayList<ArtifactNode> include = new ArrayList<ArtifactNode>();
            List<ArtifactNode> artifactChildrenOfParent = parent.getChildren(ArtifactNode.class);
            for (ArtifactNode nextArtifactChild : artifactChildrenOfParent) {
                if (nextArtifactChild.getRelativeIndex() < posInParent) continue;
                LOGGER.debug("Include in update '" + nextArtifactChild.getName() + "'");
                include.add(nextArtifactChild);
            }
            include.forEach(i -> i.accept(collector));
        } else {
            representation.accept(collector);
        }
        if (!manualArtifacts.isEmpty()) {
            LOGGER.debug("Reset manual filter assignment");
            Iterator iter = manualArtifacts.iterator();
            while (iter.hasNext()) {
                ArtifactNode nextArtifact = (ArtifactNode)iter.next();
                ArtifactNodeFilter nextFilter = nextArtifact.getFilter();
                nextFilter.reset();
                List<NonRecursiveRootNode> nextAssignedTopLevelNodes = nextArtifact.getChildren(NonRecursiveRootNode.class);
                if (!nextAssignedTopLevelNodes.isEmpty()) {
                    IAssignableTarget nextResetTarget = FilterHandler.getParentScope(nextArtifact, representation);
                    LOGGER.debug("Move " + nextAssignedTopLevelNodes.size() + " assignable top level node(s) into '" + nextResetTarget.getArchitecturalViewElement().getName() + "'");
                    StructureHandler.assign(null, nextAssignedTopLevelNodes, nextResetTarget, representation);
                }
                if (!nextFilter.isEmpty()) continue;
                LOGGER.debug("Convert manual artifact '" + nextArtifact.getName() + "' to automatic");
                nextFilter.setIsManual(false);
                iter.remove();
            }
            LOGGER.debug("Reset manual filter assignment - done");
            if (!manualArtifacts.isEmpty()) {
                LOGGER.debug("Perform manual filter assignment");
                for (ArtifactNode nextManualArtifact : manualArtifacts) {
                    LOGGER.debug("Calculate matching for manual artifact '" + nextManualArtifact.getName() + "'");
                    AssignableTargetInfo targetInfo = new AssignableTargetInfo(nextManualArtifact.getParent(IAssignableTarget.class, ParentMode.ONLY_DIRECT_PARENT), nextManualArtifact.getRelativeIndex());
                    List<AssignableToArtifactNode> assignables = FilterHandler.calculateMatching(targetInfo, nextManualArtifact.getFilter(), representation);
                    if (assignables.isEmpty()) continue;
                    StructureHandler.assign(null, assignables, nextManualArtifact, representation);
                }
                LOGGER.debug("Perform manual filter assignment - done");
            }
        }
        LOGGER.debug("Finish filter update" + (String)(createdArtifact != null ? " for created artifact '" + createdArtifact.getName() + "'" : "") + " - done");
    }

    static void finishFilterUpdate(ExplorationViewRepresentation representation) {
        FilterHandler.finishFilterUpdate(null, representation);
    }

    private static final class ArtifactsWithManualFilterCollector
    extends ArchitecturalViewVisitor
    implements ExplorationViewRepresentation.IVisitor,
    ArtifactNode.IVisitor {
        private final List<ArtifactNode> m_collector;

        ArtifactsWithManualFilterCollector(List<ArtifactNode> collector) {
            assert (collector != null) : "Parameter 'collector' of method 'ArtifactsWithManualFilterCollector' must not be null";
            this.m_collector = collector;
        }

        @Override
        public void visitArchitecturalViewElement(ArchitecturalViewElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewElement' must not be null";
        }

        @Override
        public void visitExplorationViewRepresentation(ExplorationViewRepresentation element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewRepresentation' must not be null";
            this.visitChildrenOf(element);
        }

        @Override
        public void visitArtifactNode(ArtifactNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArtifactNode' must not be null";
            if (element.hasManualFilter()) {
                this.m_collector.add(element);
            }
            this.visitChildrenOf(element);
        }
    }

    static final class AssignmentToArtifactCheck
    implements IAssignmentToArtifactCheck {
        AssignmentToArtifactCheck() {
        }

        @Override
        public boolean isPossible(AssignableNode assignable, ArtifactNode targetArtifact, MoveElementsInfo operationInfo) {
            assert (assignable != null) : "Parameter 'assignable' of method 'isPossible' must not be null";
            assert (targetArtifact != null) : "Parameter 'targetArtifact' of method 'isPossible' must not be null";
            assert (operationInfo != null) : "Parameter 'operationInfo' of method 'isPossible' must not be null";
            LOGGER.debug("Check if assignment is possible '" + assignable.getName() + "' to '" + targetArtifact.getName() + "'");
            if (targetArtifact.hasManualFilter()) {
                operationInfo.addNotMovable(assignable, "Target artifact '" + targetArtifact.getName() + "' has a manual filter.");
                return false;
            }
            ArtifactNode currentParentArtifact = assignable.getParent(ArtifactNode.class, ExplorationViewRepresentation.class);
            if (currentParentArtifact != null && currentParentArtifact.hasManualFilter()) {
                operationInfo.addNotMovable(assignable, "Parent artifact '" + targetArtifact.getName() + "' has a manual filter.");
                return false;
            }
            ArrayList<AssignableToArtifactNode> toBeMatched = new ArrayList<AssignableToArtifactNode>();
            AssignableToArtifactCollector visitor = new AssignableToArtifactCollector(toBeMatched);
            assignable.accept(visitor);
            if (toBeMatched.isEmpty()) {
                return true;
            }
            int available = toBeMatched.size();
            if (targetArtifact.hasManualFilter()) {
                LOGGER.debug("Processing target artifact '" + targetArtifact.getName() + "'");
                Iterator iter = toBeMatched.iterator();
                while (iter.hasNext()) {
                    AssignableToArtifactNode next = (AssignableToArtifactNode)iter.next();
                    if (!targetArtifact.getFilter().explicitlyExcludedByManualPatterns(next.getAssignableToArtifact())) continue;
                    operationInfo.addElementInfo("'" + next.getAssignableToArtifact().getNamedElement().getName() + "' explicitly excluded by manual filter artifact '" + targetArtifact.getName() + "'.");
                    iter.remove();
                }
            }
            if (!toBeMatched.isEmpty()) {
                List<ArtifactNode> parents = targetArtifact.getParents(ArtifactNode.class, ExplorationViewRepresentation.class);
                for (ArtifactNode nextParent : parents) {
                    if (nextParent.hasManualFilter()) {
                        LOGGER.debug("Processing parent artifact '" + nextParent.getName() + "'");
                        Iterator iter = toBeMatched.iterator();
                        while (iter.hasNext()) {
                            AssignableToArtifactNode next = (AssignableToArtifactNode)iter.next();
                            if (!nextParent.getFilter().explicitlyExcludedByManualPatterns(next.getAssignableToArtifact())) continue;
                            operationInfo.addElementInfo("'" + next.getAssignableToArtifact().getNamedElement().getName() + "' explicitly excluded by manual filter artifact '" + targetArtifact.getName() + "'.");
                            iter.remove();
                        }
                    }
                    if (toBeMatched.isEmpty()) break;
                }
            }
            LOGGER.debug("Check if assignment is possible '" + assignable.getName() + "' to '" + targetArtifact.getName() + "' - done");
            if (toBeMatched.isEmpty()) {
                operationInfo.addNotMovable(assignable, "Affected assignables (" + available + ") explicitly excluded by manual filter artifact structure.");
                return false;
            }
            return true;
        }
    }

    private static class MatchOnFinishFilterUpdateVisitor
    extends MatchVisitor {
        MatchOnFinishFilterUpdateVisitor(ArtifactNodeFilter filter) {
            super((IWorkerContext)DefaultWorkerContext.INSTANCE, filter, null);
        }
    }

    private static final class MatchPreviewVisitor
    extends MatchVisitor {
        MatchPreviewVisitor(IWorkerContext workerContext, ArtifactNodeFilter filter, Set<String> multipleAttributeInfoCollector) {
            super(workerContext, filter, multipleAttributeInfoCollector);
            assert (multipleAttributeInfoCollector != null) : "Parameter 'multipleAttributeInfoCollector' of method 'MatchPreviewVisitor' must not be null";
        }

        @Override
        protected boolean include(AssignableToArtifactNode element) {
            assert (element != null) : "Parameter 'element' of method 'include' must not be null";
            return !element.isDeleted();
        }
    }

    private static abstract class MatchVisitor
    extends ArchitecturalViewVisitor
    implements ExplorationViewRepresentation.IVisitor,
    ArtifactNode.IVisitor,
    AssignableToArtifactNode.IVisitor {
        private final List<AssignableToArtifactNode> m_matched = new ArrayList<AssignableToArtifactNode>();
        private final IWorkerContext m_workerContext;
        private final ArtifactNodeFilter m_filter;
        private final Set<String> m_multipleAttributeInfoCollector;

        MatchVisitor(IWorkerContext workerContext, ArtifactNodeFilter filter, Set<String> multipleAttributeInfoCollector) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'MatchVisitor' must not be null";
            assert (filter != null) : "Parameter 'filter' of method 'MatchAssignableToArtifactNodeVisitor' must not be null";
            this.m_workerContext = workerContext;
            this.m_filter = filter;
            this.m_multipleAttributeInfoCollector = multipleAttributeInfoCollector;
        }

        @Override
        protected final boolean done() {
            return this.m_workerContext.hasBeenCanceled();
        }

        @Override
        public final void visitExplorationViewRepresentation(ExplorationViewRepresentation element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewRepresentation' must not be null";
            for (NamedElement namedElement : element.getChildren(AssignableNode.class)) {
                if (this.done()) break;
                namedElement.accept(this);
            }
        }

        @Override
        public final void visitArtifactNode(ArtifactNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArtifactNode' must not be null";
            for (NamedElement namedElement : element.getChildren(AssignableNode.class)) {
                if (this.done()) break;
                namedElement.accept(this);
            }
        }

        protected boolean include(AssignableToArtifactNode element) {
            assert (element != null) : "Parameter 'element' of method 'include' must not be null";
            return true;
        }

        @Override
        public final void visitAssignableToArtifactNode(AssignableToArtifactNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitAssignableToArtifactNode' must not be null";
            if (!this.done()) {
                if (this.include(element) && this.m_filter.include(this.m_workerContext, element.getAssignableToArtifact(), this.m_multipleAttributeInfoCollector)) {
                    this.m_matched.add(element);
                }
                this.visitChildrenOf(element);
            }
        }

        final List<AssignableToArtifactNode> getMatched() {
            return this.m_matched;
        }
    }
}

