/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.AbstractIssueDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.SimpleIssueMatcher;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IssueDiff;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class SimpleIssueDiffProcessor<B extends IIssue, C extends Issue>
extends AbstractIssueDiffProcessor<B, C> {
    protected SimpleIssueDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, Set<IIssue> allBaselineIssues, SoftwareSystem currentSystem, Set<Issue> allCurrentIssues, Map<NamedElement, String> namedElementToFqNameCache, Class<B> baselineIssueClass, Class<C> currentIssueClass) {
        super(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, currentSystem, allCurrentIssues, namedElementToFqNameCache, baselineIssueClass, currentIssueClass);
    }

    protected abstract String getAffectedCurrentElementFqName(C var1);

    protected abstract SimpleIssueMatcher<B, C> getIssueMatcher();

    @Override
    protected Set<IssueCategory> getIgnoredIssueCategories() {
        return EnumSet.of(IssueCategory.DUPLICATE_CODE, IssueCategory.CYCLE_GROUP, IssueCategory.THRESHOLD_VIOLATION);
    }

    @Override
    protected final void computeDiffs(NamedElement parent, List<B> baselineIssues, List<C> currentIssues) {
        Map<String, Map<String, List<B>>> baselineIssueMap = this.collectBaselineIssues(baselineIssues);
        Map<String, Map<String, List<C>>> currentIssueMap = this.collectCurrentIssues(currentIssues);
        this.computeIssueDiffs(parent, baselineIssueMap, currentIssueMap);
    }

    private Map<String, Map<String, List<B>>> collectBaselineIssues(List<B> baselineIssues) {
        assert (baselineIssues != null) : "Parameter 'baselineIssues' of method 'collectBaselineIssues' must not be null";
        HashMap<String, Map<String, List<B>>> baselineIssuesMap = new HashMap<String, Map<String, List<B>>>();
        for (IIssue next : baselineIssues) {
            assert (next.getAffectedNamedElements().size() == 1) : "Unexpected composite issue '" + String.valueOf(next) + "'";
            INamedElement affectedElement = (INamedElement)next.getAffectedNamedElements().get(0);
            String affectedElementFqName = this.getBaselineOriginalFqName(affectedElement);
            Map issueTypeToIssue = baselineIssuesMap.computeIfAbsent(affectedElementFqName, name -> new HashMap());
            List issuesOfType = issueTypeToIssue.computeIfAbsent(next.getIssueType().getName(), name -> new ArrayList(2));
            issuesOfType.add(next);
        }
        for (Map issueTypeToIssue : baselineIssuesMap.values()) {
            for (List issuesOfType : issueTypeToIssue.values()) {
                issuesOfType.sort(new ISystemInfoProcessor.IIssueComparator());
            }
        }
        return baselineIssuesMap;
    }

    private Map<String, Map<String, List<C>>> collectCurrentIssues(List<C> currentIssues) {
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'collectCurrentSimpleIssues' must not be null";
        HashMap<String, Map<String, List<C>>> currentIssuesMap = new HashMap<String, Map<String, List<C>>>();
        for (Issue next : currentIssues) {
            String affectedElementFqName = this.getAffectedCurrentElementFqName(next);
            Map issueTypeToIssue = currentIssuesMap.computeIfAbsent(affectedElementFqName, name -> new HashMap());
            List issuesOfType = issueTypeToIssue.computeIfAbsent(next.getId().getStandardName(), name -> new ArrayList(2));
            issuesOfType.add(next);
        }
        for (Map issueTypeToIssue : currentIssuesMap.values()) {
            for (List issuesOfType : issueTypeToIssue.values()) {
                issuesOfType.sort(new AbstractIssueDiffProcessor.IssueComparator());
            }
        }
        return currentIssuesMap;
    }

    protected void computeIssueDiffs(NamedElement parent, Map<String, Map<String, List<B>>> baselineIssueMap, Map<String, Map<String, List<C>>> currentIssueMap) {
        assert (parent != null) : "Parameter 'parent' of method 'computeIssueDiffs' must not be null";
        assert (baselineIssueMap != null) : "Parameter 'baselineIssueMap' of method 'computeIssueDiffs' must not be null";
        assert (currentIssueMap != null) : "Parameter 'currentIssueMap' of method 'computeIssueDiffs' must not be null";
        SimpleIssueMatcher<B, C> issueMatcher = this.getIssueMatcher();
        for (Map.Entry<String, Map<String, List<B>>> entry : baselineIssueMap.entrySet()) {
            String baselineFqName = entry.getKey();
            Map<String, List<B>> baselineIssueTypeToIssuesMap = entry.getValue();
            Map<String, List<C>> currentIssueTypeToIssuesMap = currentIssueMap.remove(baselineFqName);
            if (currentIssueTypeToIssuesMap != null) {
                for (Map.Entry entry2 : baselineIssueTypeToIssuesMap.entrySet()) {
                    String issueType = (String)entry2.getKey();
                    List baselineIssues = (List)entry2.getValue();
                    List<C> currentIssues = currentIssueTypeToIssuesMap.remove(issueType);
                    if (currentIssues != null && !currentIssues.isEmpty()) {
                        issueMatcher.matchIssues(parent, baselineIssues, currentIssues);
                        continue;
                    }
                    this.handleRemovedIssues(parent, baselineIssues, issueMatcher);
                }
                for (Map.Entry entry3 : currentIssueTypeToIssuesMap.entrySet()) {
                    for (Issue nextCurrentIssue : (List)entry3.getValue()) {
                        IssueDiff<Object, Issue> diff = issueMatcher.createDiff(parent, null, nextCurrentIssue, IDiffElement.Change.ADDED, null);
                        parent.addChild(diff);
                    }
                }
                continue;
            }
            for (List list : baselineIssueTypeToIssuesMap.values()) {
                this.handleRemovedIssues(parent, list, issueMatcher);
            }
        }
        for (Map map : currentIssueMap.values()) {
            for (List nextCurrentIssues : map.values()) {
                for (Issue nextCurrentIssue : nextCurrentIssues) {
                    IssueDiff<Object, Issue> diff = issueMatcher.createDiff(parent, null, nextCurrentIssue, IDiffElement.Change.ADDED, null);
                    parent.addChild(diff);
                }
            }
        }
    }

    private void handleRemovedIssues(NamedElement parent, List<B> baselineIssues, SimpleIssueMatcher<B, C> issueMatcher) {
        assert (parent != null) : "Parameter 'parent' of method 'handleRemovedIssues' must not be null";
        assert (baselineIssues != null) : "Parameter 'baselineIssues' of method 'handleRemovedIssues' must not be null";
        assert (issueMatcher != null) : "Parameter 'issueMatcher' of method 'handleRemovedIssues' must not be null";
        for (IIssue nextBaseline : baselineIssues) {
            IssueDiff<IIssue, Object> diff = issueMatcher.createDiff(parent, nextBaseline, null, IDiffElement.Change.REMOVED, null);
            parent.addChild(diff);
        }
    }
}

