/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;

abstract class AbstractDiffProcessor {
    private final SoftwareSystem m_currentSystem;
    private final ISoftwareSystem m_baselineSystem;
    private final ISystemInfoProcessor m_baselineSystemInfoProcessor;

    public AbstractDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, SoftwareSystem currentSystem) {
        assert (baselineSystem != null) : "Parameter 'baselineSystem' of method 'AbstractSystemInfoDiffProcessor' must not be null";
        assert (baselineSystemInfoProcessor != null) : "Parameter 'baselineSystemInfoProcessor' of method 'AbstractDiffProcessor' must not be null";
        assert (currentSystem != null) : "Parameter 'softwareSystem' of method 'BasicSysteminfoDiffProcessor' must not be null";
        this.m_baselineSystem = baselineSystem;
        this.m_baselineSystemInfoProcessor = baselineSystemInfoProcessor;
        this.m_currentSystem = currentSystem;
    }

    public abstract void process(NamedElement var1);

    protected final ISoftwareSystem getBaselineSystem() {
        return this.m_baselineSystem;
    }

    protected final ISystemInfoProcessor getBaselineSystemInfoProcessor() {
        return this.m_baselineSystemInfoProcessor;
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return this.m_currentSystem;
    }

    protected final String getBaselineOriginalFqName(INamedElement baselineElement) {
        assert (baselineElement != null) : "Parameter 'baselineElement' of method 'getOriginalFqName' must not be null";
        return baselineElement.getOriginalFqName().orElse(baselineElement.getFqName());
    }
}

