/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.List;

final class CycleMetricsComputer {
    private final ElementWithIssues.IIssueManager m_issueManager;
    private final IWorkerContext m_workerContext;

    CycleMetricsComputer(ElementWithIssues.IIssueManager issueManager, IWorkerContext workerContext) {
        assert (issueManager != null) : "Parameter 'issueManager' of method 'CycleMetricsComputer' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'CycleMetricsComputer' must not be null";
        this.m_issueManager = issueManager;
        this.m_workerContext = workerContext;
    }

    private void setNumberOfCycleGroups(int n, IAdapter adapter) {
        if (adapter.getNumberOfCycleGroupsMetric() != null) {
            adapter.storeMetricValue(n, adapter.getNumberOfCycleGroupsMetric());
        }
    }

    private void setNumberOfCriticalCycleGroups(int n, IAdapter adapter) {
        if (adapter.getNumberOfCriticalCycleGroupsMetric() != null) {
            adapter.storeMetricValue(n, adapter.getNumberOfCriticalCycleGroupsMetric());
        }
    }

    private void setSizeOfBiggestCycleGroup(int n, IAdapter adapter) {
        if (adapter.getBiggestCycleGroupMetric() != null) {
            adapter.storeMetricValue(n, adapter.getBiggestCycleGroupMetric());
        }
    }

    private void setNumberOfIgnoredCyclicElements(int n, IAdapter adapter) {
        if (adapter.getNumberOfIgnoredCyclicElementsMetric() != null) {
            adapter.storeMetricValue(n, adapter.getNumberOfIgnoredCyclicElementsMetric());
        }
    }

    private void setNumberOfCyclicElements(int n, IAdapter adapter) {
        if (adapter.getNumberOfCyclicElementsMetric() != null) {
            adapter.storeMetricValue(n, adapter.getNumberOfCyclicElementsMetric());
        }
    }

    private void setReferencesToCutMetric(int val, IAdapter adapter) {
        IMetricDescriptor md = adapter.getReferencesToCutMetric();
        if (md != null) {
            adapter.storeMetricValue(val, md);
        }
    }

    private void setComponentDependenciesToCutMetric(int val, IAdapter adapter) {
        IMetricDescriptor md = adapter.getComponentDependenciesToCutMetric();
        if (md != null) {
            adapter.storeMetricValue(val, md);
        }
    }

    private void setStructuralDebtIndexMetric(int val, IAdapter adapter) {
        IMetricDescriptor md = adapter.getStructuralDebtIndexMetric();
        if (md != null) {
            adapter.storeMetricValue(val, md);
        }
    }

    private void setCyclicityMetric(int val, IAdapter adapter) {
        IMetricDescriptor md = adapter.getCyclicityMetric();
        if (md != null) {
            adapter.storeMetricValue(val, md);
        }
        this.setRelativeCyclicityMetric(val, adapter);
    }

    private void setRelativeCyclicityMetric(int cyclicity, IAdapter adapter) {
        IMetricDescriptor md = adapter.getRelativeCyclicityMetric();
        if (md != null) {
            int noElements = adapter.getNumberOfElements();
            if (noElements <= 0) {
                adapter.storeMetricValue(Float.valueOf(0.0f), md);
                return;
            }
            double val = 100.0 * Math.sqrt(cyclicity) / (double)noElements;
            adapter.storeMetricValue(Float.valueOf((float)val), md);
        }
    }

    void compute(IAdapter adapter) {
        assert (adapter != null) : "Parameter 'adapter' of method 'compute' must not be null";
        int cyclicElements = 0;
        int ignoredCyclicElements = 0;
        int cycleGroupCount = 0;
        int criticalCycleGroupCount = 0;
        int biggestCycleGroupSize = 0;
        int cyclicity = 0;
        int refsToCut = 0;
        int cdToCut = 0;
        int sdi = 0;
        for (AnalyzerCycleGroup nextCycleGroup : adapter.getCycleGroups()) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            ResolutionState resolutionState = ResolutionState.NONE;
            Issue issue = this.m_issueManager.getElementIssue(nextCycleGroup, nextCycleGroup.getCycleGroupIssueId());
            if (issue != null && issue.getResolution() != null) {
                ResolutionState resolutionState2 = resolutionState = issue.getResolution().ignores() ? ResolutionState.IGNORED : ResolutionState.TASK;
            }
            if (resolutionState == ResolutionState.IGNORED) {
                ignoredCyclicElements += nextCycleGroup.getNumberOfCyclicElements();
            }
            int size = nextCycleGroup.getNumberOfCyclicElements();
            cyclicElements += size;
            ++cycleGroupCount;
            if (nextCycleGroup.isCritical()) {
                ++criticalCycleGroupCount;
            }
            cyclicity += size * size;
            if (size > biggestCycleGroupSize) {
                biggestCycleGroupSize = size;
            }
            refsToCut += nextCycleGroup.getParserDependenciesToRemove();
            cdToCut += nextCycleGroup.getComponentDependenciesToRemove();
            sdi += nextCycleGroup.getStructuralDebtIndex();
        }
        this.setNumberOfIgnoredCyclicElements(ignoredCyclicElements, adapter);
        this.setNumberOfCycleGroups(cycleGroupCount, adapter);
        this.setNumberOfCriticalCycleGroups(criticalCycleGroupCount, adapter);
        this.setNumberOfCyclicElements(cyclicElements, adapter);
        this.setSizeOfBiggestCycleGroup(biggestCycleGroupSize, adapter);
        this.setCyclicityMetric(cyclicity, adapter);
        this.setReferencesToCutMetric(refsToCut, adapter);
        this.setComponentDependenciesToCutMetric(cdToCut, adapter);
        this.setStructuralDebtIndexMetric(sdi, adapter);
    }

    static interface IAdapter {
        public List<AnalyzerCycleGroup> getCycleGroups();

        public int getNumberOfElements();

        public IMetricDescriptor getNumberOfIgnoredCyclicElementsMetric();

        public IMetricDescriptor getNumberOfCycleGroupsMetric();

        public IMetricDescriptor getNumberOfCriticalCycleGroupsMetric();

        public IMetricDescriptor getNumberOfCyclicElementsMetric();

        public IMetricDescriptor getBiggestCycleGroupMetric();

        public IMetricDescriptor getReferencesToCutMetric();

        public IMetricDescriptor getComponentDependenciesToCutMetric();

        public IMetricDescriptor getStructuralDebtIndexMetric();

        public IMetricDescriptor getCyclicityMetric();

        public IMetricDescriptor getRelativeCyclicityMetric();

        public void storeMetricValue(Number var1, IMetricDescriptor var2);
    }

    private static enum ResolutionState {
        NONE,
        IGNORED,
        TASK;

    }
}

