/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis;

import com.hello2morrow.sonargraph.core.controller.system.analysis.IQualityGateFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.QualityGateCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.ThresholdViolationIssue;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.resolution.TaskDefinition;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricValueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IssuesDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.ThresholdViolationIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractCurrentIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElementCheckResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateIssueCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateResultElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentSystemConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentSystemConditionsResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.DiffAgainstBaselineConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.DiffAgainstBaselineConditionsResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.MetricValueDiffQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.Operator;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateDiffCheck;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilter;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilterResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateIssueConditionCheckResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateMetricConditionCheckResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResultStatus;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.issue.QualityGateConditionFailedIssue;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.issue.QualityGateIssueId;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.issue.QualityGateMissingMetricValueDiff;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.issue.QualityGateNotCheckedAgainstBaselineIssue;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.integration.access.model.IMetricValue;
import com.hello2morrow.sonargraph.integration.access.model.IThresholdViolationIssue;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QualityGateAnalyzerAdapter
extends AnalyzerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(QualityGateAnalyzerAdapter.class);
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.QUALITY_GATES;

    public QualityGateAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, ID);
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        List<AnalyzerResult> requiredResults = this.getController().getResultsFor(AnalyzerGroup.SYSTEM_DIFF);
        QualityGateAnalyzerJob job = new QualityGateAnalyzerJob(this.getGroup(), result, this.getController(), requiredResults);
        job.start();
    }

    @Override
    protected boolean clearResult(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'clearResult' must not be null";
        THashSet providerIds = new THashSet();
        for (QualityGateResult next : result.getChildren(QualityGateResult.class)) {
            QualityGate qualityGate = (QualityGate)next.getQualityGateElement();
            providerIds.add(qualityGate.getIssueProviderId());
            if (!qualityGate.isValid()) continue;
            qualityGate.removeIssues();
            qualityGate.resetResult();
            for (AbstractQualityGateElement nextElement : qualityGate.getChildrenRecursively(AbstractQualityGateElement.class, AbstractQualityGateElement.class)) {
                nextElement.removeIssues();
            }
        }
        Installation installation = this.getInstallation();
        installation.removeIssueIds(Collections.singleton(QualityGateIssueId.INSTANCE));
        installation.removeProviderIds((Set<IProviderId>)providerIds);
        return super.clearResult(result);
    }

    @Override
    protected List<IIssueId> getIssueIds(AnalyzerResult result) {
        ArrayList<IIssueId> ids = new ArrayList<IIssueId>(super.getIssueIds(result));
        ids.add(QualityGateIssueId.INSTANCE);
        return ids;
    }

    private final class QualityGateAnalyzerJob
    extends AnalyzerJob {
        public QualityGateAnalyzerJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, List<AnalyzerResult> requiredResults) {
            super(group, result, controller, requiredResults);
        }

        @Override
        protected void internalRun() {
            LOGGER.debug("Execute '" + String.valueOf(QualityGateAnalyzerAdapter.this.getAnalyzerId()) + "'");
            long start = System.currentTimeMillis();
            IQualityGateFileProvider qualityGateFileProvider = this.getSoftwareSystem().getExtension(IQualityGateFileProvider.class);
            QualityGateCheckConfiguration configuration = this.getAnalyzer().getConfiguration(QualityGateCheckConfiguration.class);
            assert (configuration != null) : "Parameter 'configuration' of method 'internalRun' must not be null";
            List<String> identifyingPaths = configuration.getIdentifyingPaths();
            if (identifyingPaths.isEmpty()) {
                return;
            }
            ArrayList<QualityGate> toBeChecked = new ArrayList<QualityGate>(identifyingPaths.size());
            for (String next : identifyingPaths) {
                QualityGate qualityGate = qualityGateFileProvider.getQualityGate(next);
                if (qualityGate == null) continue;
                toBeChecked.add(qualityGate);
            }
            if (toBeChecked.isEmpty()) {
                return;
            }
            IWorkerContext workerContext = this.getWorkerContext();
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.setNumberOfSteps(toBeChecked.size());
            IssueFilter issueFilter = new IssueFilter(new IStandardEnumeration[0]);
            List<Issue> allIssues = this.getSoftwareSystem().getCurrentModel().getIssueList(issueFilter).getIssues();
            SoftwareSystemDiff systemDiff = this.getSoftwareSystemDiff(this.getRequiredResults());
            int numberOfFailedQualityGates = 0;
            for (QualityGate next : toBeChecked) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                QualityGateResult result = this.checkQualityGate(workerContext, next, this.getResult(), allIssues, systemDiff);
                if (result.getResultStatus() == QualityGateResultStatus.FAILED) {
                    ++numberOfFailedQualityGates;
                }
                workerContext.endStep();
            }
            Installation installation = this.getInstallation();
            THashSet ids = new THashSet();
            ids.add(QualityGateIssueId.INSTANCE);
            installation.addIssueIds((Set<? extends IIssueId>)ids);
            installation.addProviderIds(toBeChecked.stream().map(qg -> qg.getIssueProviderId()).collect(Collectors.toSet()));
            LOGGER.debug("Execute '" + String.valueOf(QualityGateAnalyzerAdapter.this.getAnalyzerId()) + "' - done [failed gates:" + numberOfFailedQualityGates + ", " + (System.currentTimeMillis() - start) + " ms]");
        }

        private SoftwareSystemDiff getSoftwareSystemDiff(List<AnalyzerResult> requiredResults) {
            assert (requiredResults != null) : "Parameter 'requiredResults' of method 'getSoftwareSystemDiff' must not be null";
            for (AnalyzerResult next : requiredResults) {
                if (next.getId() != CoreAnalyzerId.SYSTEM_DIFF) continue;
                return next.getUniqueChild(SoftwareSystemDiff.class);
            }
            return null;
        }

        private QualityGateResult checkQualityGate(IWorkerContext workerContext, QualityGate qualityGate, AnalyzerResult analyzerResult, List<Issue> allIssues, SoftwareSystemDiff systemDiff) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'checkQualityGate' must not be null";
            assert (qualityGate != null) : "Parameter 'qualityGate' of method 'checkQualityGate' must not be null";
            assert (analyzerResult != null) : "Parameter 'analyzerResult' of method 'checkQualityGate' must not be null";
            assert (allIssues != null) : "Parameter 'allIssues' of method 'checkQualityGate' must not be null";
            LOGGER.debug("Checking quality gate {}", (Object)qualityGate.getShortName());
            qualityGate.removeIssues();
            QualityGateResult qualityGateResult = new QualityGateResult((NamedElement)analyzerResult, qualityGate);
            analyzerResult.addChild(qualityGateResult);
            this.checkCurrentConditions(allIssues, qualityGate, qualityGateResult);
            if (systemDiff != null) {
                this.checkDiffAgainstBaselineConditions(systemDiff, qualityGate, qualityGateResult);
            } else {
                DiffAgainstBaselineConditions diffAgainstBaselineConditions = qualityGate.getUniqueExistingChild(DiffAgainstBaselineConditions.class);
                if (diffAgainstBaselineConditions.getChildren(IQualityGateCondition.class).size() > 0) {
                    qualityGate.addIssue(new QualityGateNotCheckedAgainstBaselineIssue(qualityGate));
                }
            }
            qualityGate.setResult(qualityGateResult);
            return qualityGateResult;
        }

        private int checkCurrentConditions(List<Issue> allIssues, QualityGate qualityGate, QualityGateResult qualityGateResult) {
            assert (allIssues != null) : "Parameter 'allIssues' of method 'checkCurrentConditions' must not be null";
            assert (qualityGate != null) : "Parameter 'qualityGate' of method 'checkCurrentConditions' must not be null";
            assert (qualityGateResult != null) : "Parameter 'qualityGateResult' of method 'checkCurrentConditions' must not be null";
            CurrentSystemConditions currentConditions = qualityGate.getUniqueExistingChild(CurrentSystemConditions.class);
            CurrentSystemConditionsResult currentConditionsResult = new CurrentSystemConditionsResult((NamedElement)qualityGateResult, currentConditions);
            qualityGateResult.addChild(currentConditionsResult);
            LinkedHashSet<Issue> issuesWithoutExcluded = new LinkedHashSet<Issue>(allIssues);
            List<QualityGateExcludeFilter> excludeFilters = currentConditions.getChildren(QualityGateExcludeFilter.class);
            for (QualityGateExcludeFilter nextExclude : excludeFilters) {
                Set<Issue> matches;
                if (nextExclude.getMetricId() != null) {
                    matches = this.filterByMetricId(issuesWithoutExcluded, nextExclude.getMetricId());
                    matches = this.filterIssues(matches, nextExclude.getIssueType(), nextExclude.getSeverityList(), nextExclude.getResolutionList());
                } else {
                    matches = this.filterIssues(issuesWithoutExcluded, nextExclude.getIssueType(), nextExclude.getSeverityList(), nextExclude.getResolutionList());
                }
                QualityGateExcludeFilterResult excludeFilterResult = new QualityGateExcludeFilterResult(currentConditionsResult, nextExclude, new LinkedHashSet<Element>(matches));
                currentConditionsResult.addChild(excludeFilterResult);
                issuesWithoutExcluded.removeAll(matches);
            }
            int numberOfFailedConditions = 0;
            for (AbstractCurrentIssueQualityGateCondition nextCurrent : currentConditions.getChildren(AbstractCurrentIssueQualityGateCondition.class)) {
                Set<Issue> matches;
                nextCurrent.removeIssues();
                if (nextCurrent instanceof ThresholdIssueQualityGateCondition) {
                    matches = this.filterByMetricId(allIssues, ((ThresholdIssueQualityGateCondition)nextCurrent).getMetricId());
                    matches = this.filterIssues(matches, nextCurrent.getIssueType(), nextCurrent.getSeverityList(), nextCurrent.getResolutionList());
                } else {
                    assert (nextCurrent instanceof CurrentIssueQualityGateCondition) : "Unspported current condition: " + String.valueOf(nextCurrent);
                    matches = this.filterIssues(allIssues, nextCurrent.getIssueType(), nextCurrent.getSeverityList(), nextCurrent.getResolutionList());
                }
                LinkedHashSet<Element> matchedElements = new LinkedHashSet<Element>(matches);
                Set<Element> excluded = this.applyExcludeFilters(matchedElements, nextCurrent, currentConditionsResult.getChildren(QualityGateExcludeFilterResult.class));
                QualityGateResultStatus result = this.checkLimit(matchedElements.size(), nextCurrent.getOperator(), nextCurrent.getLimit());
                QualityGateIssueConditionCheckResult conditionResult = new QualityGateIssueConditionCheckResult(currentConditionsResult, nextCurrent, result, new LinkedHashSet<Element>(matches));
                conditionResult.setExcluded(excluded);
                currentConditionsResult.addChild(conditionResult);
                this.moveBeforeExcludeFilterResult(currentConditionsResult, conditionResult);
                if (result != QualityGateResultStatus.FAILED) continue;
                ++numberOfFailedConditions;
                nextCurrent.addIssue(new QualityGateConditionFailedIssue(nextCurrent, conditionResult.createIssueDescription(), qualityGate.getIssueProviderId()));
            }
            return numberOfFailedConditions;
        }

        private void moveBeforeExcludeFilterResult(NamedElement parent, AbstractQualityGateElementCheckResult conditionResult) {
            assert (parent != null) : "Parameter 'conditionsResult' of method 'moveBeforeExcludeFilterResult' must not be null";
            assert (conditionResult != null) : "Parameter 'conditionResult' of method 'moveBeforeExcludeFilterResult' must not be null";
            QualityGateExcludeFilterResult excludeFilterResult = parent.getFirstChild(QualityGateExcludeFilterResult.class);
            if (excludeFilterResult != null) {
                int position = parent.getIndexOf(AbstractQualityGateResultElement.class, excludeFilterResult);
                parent.moveChild(AbstractQualityGateResultElement.class, conditionResult, position);
            }
        }

        private int checkDiffAgainstBaselineConditions(SoftwareSystemDiff systemDiff, QualityGate qualityGate, QualityGateResult qualityGateResult) {
            assert (systemDiff != null) : "Parameter 'systemDiff' of method 'checkDiffAgainstBaselineConditions' must not be null";
            assert (qualityGate != null) : "Parameter 'qualityGate' of method 'checkDiffAgainstBaselineConditions' must not be null";
            assert (qualityGateResult != null) : "Parameter 'qualityGateResult' of method 'checkDiffAgainstBaselineConditions' must not be null";
            DiffAgainstBaselineConditions diffAgainstBaselineConditions = qualityGate.getUniqueExistingChild(DiffAgainstBaselineConditions.class);
            DiffAgainstBaselineConditionsResult baselineConditionsResult = new DiffAgainstBaselineConditionsResult((NamedElement)qualityGateResult, diffAgainstBaselineConditions);
            qualityGateResult.addChild(baselineConditionsResult);
            List<QualityGateExcludeFilter> excludeFilters = diffAgainstBaselineConditions.getChildren(QualityGateExcludeFilter.class);
            for (QualityGateExcludeFilter nextExclude : excludeFilters) {
                Set<IIssueDiff> matches = this.filterDiffIssues(systemDiff.getUniqueExistingChild(IssuesDiff.class), nextExclude.getIssueType(), nextExclude.getSeverityList(), nextExclude.getResolutionList(), nextExclude.getMetricId());
                LinkedHashSet<Element> matchedElements = new LinkedHashSet<Element>();
                matches.forEach(m -> {
                    boolean bl = matchedElements.add((Element)((Object)m));
                });
                QualityGateExcludeFilterResult excludeFilterResult = new QualityGateExcludeFilterResult(baselineConditionsResult, nextExclude, matchedElements);
                baselineConditionsResult.addChild(excludeFilterResult);
            }
            int numberOfFailedConditions = 0;
            for (IQualityGateCondition nextDiffCondition : diffAgainstBaselineConditions.getChildren(IQualityGateCondition.class)) {
                QualityGateResultStatus result;
                if (nextDiffCondition instanceof AbstractIssueDiffAgainstBaselineCondition) {
                    result = this.processIssueDiffCondition(qualityGate, systemDiff.getUniqueExistingChild(IssuesDiff.class), (AbstractIssueDiffAgainstBaselineCondition)nextDiffCondition, baselineConditionsResult);
                } else if (nextDiffCondition instanceof MetricValueDiffQualityGateCondition) {
                    result = this.processMetricValueDiffCondition(qualityGate, systemDiff.getUniqueExistingChild(MetricsDiff.class), (MetricValueDiffQualityGateCondition)nextDiffCondition, baselineConditionsResult);
                } else {
                    assert (false) : "Unsupported condition of type " + nextDiffCondition.getClass().getCanonicalName() + ", " + nextDiffCondition.getDebugInfo();
                    result = null;
                }
                if (result != QualityGateResultStatus.FAILED) continue;
                ++numberOfFailedConditions;
            }
            return numberOfFailedConditions;
        }

        private QualityGateResultStatus processIssueDiffCondition(QualityGate qualityGate, IssuesDiff issuesDiff, AbstractIssueDiffAgainstBaselineCondition issueDiffCondition, DiffAgainstBaselineConditionsResult baselineConditionsResult) {
            assert (qualityGate != null) : "Parameter 'qualityGate' of method 'processIssueDiffCondition' must not be null";
            assert (issuesDiff != null) : "Parameter 'issuesDiff' of method 'processIssueDiffCondition' must not be null";
            assert (issueDiffCondition != null) : "Parameter 'issueDiffCondition' of method 'processIssueDiffCondition' must not be null";
            assert (baselineConditionsResult != null) : "Parameter 'baselineConditionsResult' of method 'processIssueDiffCondition' must not be null";
            issueDiffCondition.removeIssues();
            String metricId = issueDiffCondition instanceof ThresholdIssueDiffAgainstBaselineCondition ? ((ThresholdIssueDiffAgainstBaselineCondition)issueDiffCondition).getMetricId() : null;
            Set<IIssueDiff> matches = this.filterDiffIssues(issuesDiff, issueDiffCondition.getIssueType(), issueDiffCondition.getSeverityList(), issueDiffCondition.getResolutionList(), metricId);
            LinkedHashSet<IIssueDiff> toleratedIssues = new LinkedHashSet<IIssueDiff>();
            boolean requiresToleratedIssues = false;
            if (issueDiffCondition instanceof ThresholdIssueDiffAgainstBaselineCondition) {
                ThresholdIssueDiffAgainstBaselineCondition thresholdCondition = (ThresholdIssueDiffAgainstBaselineCondition)issueDiffCondition;
                matches = this.filterDiffsByMetricId(matches, thresholdCondition.getMetricId());
                Set<IIssueDiff> omitted = this.determineToleratedThresholdViolationDiffs(matches, thresholdCondition);
                matches.removeAll(omitted);
                toleratedIssues.addAll(omitted);
                requiresToleratedIssues = true;
            }
            if (issueDiffCondition.getCheck() == QualityGateDiffCheck.RELAXED) {
                Set<IIssueDiff> omitted = this.omitIssuesForRelaxedCheck(matches, issueDiffCondition);
                toleratedIssues.addAll(omitted);
                matches.removeAll(omitted);
                requiresToleratedIssues = true;
            }
            LinkedHashSet<Element> matchedElements = new LinkedHashSet<Element>(matches.size());
            matches.forEach(m -> {
                boolean bl = matchedElements.add((Element)((Object)m));
            });
            Set<Element> excluded = this.applyExcludeFilters(matchedElements, issueDiffCondition, baselineConditionsResult.getChildren(QualityGateExcludeFilterResult.class));
            QualityGateResultStatus result = matchedElements.size() == 0 ? QualityGateResultStatus.PASSED : QualityGateResultStatus.FAILED;
            QualityGateIssueConditionCheckResult conditionResult = new QualityGateIssueConditionCheckResult(baselineConditionsResult, issueDiffCondition, result, matchedElements);
            baselineConditionsResult.addChild(conditionResult);
            this.moveBeforeExcludeFilterResult(baselineConditionsResult, conditionResult);
            conditionResult.setExcluded(excluded);
            if (requiresToleratedIssues) {
                LinkedHashSet<Element> toleratedElements = new LinkedHashSet<Element>(toleratedIssues.size());
                toleratedIssues.forEach(o -> {
                    boolean bl = toleratedElements.add((Element)((Object)o));
                });
                conditionResult.setToleratedElements(toleratedElements);
            }
            if (result == QualityGateResultStatus.FAILED) {
                issueDiffCondition.addIssue(new QualityGateConditionFailedIssue(issueDiffCondition, conditionResult.createIssueDescription(), qualityGate.getIssueProviderId()));
            }
            return result;
        }

        private QualityGateResultStatus processMetricValueDiffCondition(QualityGate qualityGate, MetricsDiff metricsDiff, MetricValueDiffQualityGateCondition metricCondition, DiffAgainstBaselineConditionsResult baselineConditionsResult) {
            assert (qualityGate != null) : "Parameter 'qualityGate' of method 'processMetricValueDiffCondition' must not be null";
            assert (metricsDiff != null) : "Parameter 'metricsDiff' of method 'processMetricValueDiffCondition' must not be null";
            assert (metricCondition != null) : "Parameter 'metricCondition' of method 'processMetricValueDiffCondition' must not be null";
            assert (baselineConditionsResult != null) : "Parameter 'baselineConditionsResult' of method 'processMetricValueDiffCondition' must not be null";
            QualityGateResultStatus result = null;
            metricCondition.removeIssues();
            MetricValueDiff match = this.findSystemMetricValueDiff(metricsDiff, metricCondition);
            if (match == null) {
                metricCondition.addIssue(new QualityGateMissingMetricValueDiff(metricCondition, "Metric value diff not found for '" + metricCondition.getMetricId()));
                return result;
            }
            assert (metricCondition.getDiffThreshold() != null || metricCondition.getDiffThresholdRelative() != null) : "Either absolute or relative diff value threshold must be defined in condition " + metricCondition.getDebugInfo();
            boolean checkAbsolute = false;
            boolean checkRelative = false;
            if (metricCondition.getDiffThreshold() != null) {
                result = this.checkThreshold(match.getValueDiffAbsolute().floatValue(), metricCondition.getOperator(), metricCondition.getDiffThreshold().floatValue());
                checkAbsolute = true;
            }
            if (metricCondition.getDiffThresholdRelative() != null) {
                Number valueDiff = match.getValueDiffRelative();
                if (valueDiff == null || Float.isNaN(valueDiff.floatValue())) {
                    metricCondition.addIssue(new QualityGateMissingMetricValueDiff(metricCondition, "No relative value diff exists for metric '" + metricCondition.getMetricId()));
                } else {
                    QualityGateResultStatus relativeResult = this.checkThreshold(valueDiff.floatValue(), metricCondition.getOperator(), metricCondition.getDiffThresholdRelative().floatValue());
                    checkRelative = true;
                    if (!checkAbsolute) {
                        result = relativeResult;
                    }
                }
            }
            if (result != null) {
                QualityGateMetricConditionCheckResult conditionResult = new QualityGateMetricConditionCheckResult(baselineConditionsResult, metricCondition, result, Collections.singleton(match), this.createMetricConditionResultInfo(match, checkAbsolute, checkRelative));
                baselineConditionsResult.addChild(conditionResult);
                this.moveBeforeExcludeFilterResult(baselineConditionsResult, conditionResult);
                if (result == QualityGateResultStatus.FAILED) {
                    metricCondition.addIssue(new QualityGateConditionFailedIssue(metricCondition, conditionResult.createIssueDescription(), qualityGate.getIssueProviderId()));
                }
            }
            return result;
        }

        private String createMetricConditionResultInfo(MetricValueDiff diff, boolean reportAbsolute, boolean reportRelative) {
            StringBuilder info = new StringBuilder();
            if (diff != null) {
                info.append(MetricValueDiff.getChangeDescription(diff, reportAbsolute, reportRelative));
            }
            return info.toString();
        }

        private MetricValueDiff findSystemMetricValueDiff(MetricsDiff metricsDiff, MetricValueDiffQualityGateCondition condition) {
            assert (metricsDiff != null) : "Parameter 'metricsDiff' of method 'filterSystemMetricValueDiffs' must not be null";
            assert (condition != null) : "Parameter 'condition' of method 'filterSystemMetricValueDiffs' must not be null";
            boolean any = condition.getMetricId().equalsIgnoreCase("Any");
            for (MetricValueDiff nextDiff : metricsDiff.getChildren(MetricValueDiff.class)) {
                if (!any && (nextDiff.getChange() == IDiffElement.Change.REMOVED || !((com.hello2morrow.sonargraph.core.model.analysis.IMetricValue)nextDiff.getCurrent()).getMetricDescriptor().getId().equals(condition.getMetricId())) && (nextDiff.getChange() == IDiffElement.Change.ADDED || !((IMetricValue)nextDiff.getBaseline()).getIdString().equals(condition.getMetricId()))) continue;
                if (nextDiff.getChange() == IDiffElement.Change.REMOVED || nextDiff.getChange() == IDiffElement.Change.ADDED) {
                    LOGGER.debug("Ignoring metric value change '{}' for metric id '{}'", (Object)nextDiff.getChange().getPresentationName(), (Object)condition.getMetricId());
                    condition.addIssue(new QualityGateMissingMetricValueDiff(condition, "Metric value diff not found for '" + condition.getMetricId()));
                    return null;
                }
                return nextDiff;
            }
            return null;
        }

        private Set<IIssueDiff> determineToleratedThresholdViolationDiffs(Set<IIssueDiff> matches, ThresholdIssueDiffAgainstBaselineCondition thresholdCondition) {
            assert (matches != null) : "Parameter 'matches' of method 'determineToleratedThresholdViolationDiffs' must not be null";
            assert (thresholdCondition != null) : "Parameter 'thresholdCondition' of method 'determineToleratedThresholdViolationDiffs' must not be null";
            LinkedHashSet<IIssueDiff> tolerated = new LinkedHashSet<IIssueDiff>();
            for (IIssueDiff next : matches) {
                assert (next instanceof ThresholdViolationIssueDiff) : "Unexpected class " + String.valueOf(next);
                ThresholdViolationIssueDiff thresholdIssueDiff = (ThresholdViolationIssueDiff)next;
                if (thresholdIssueDiff.getChange() == IDiffElement.Change.ADDED) continue;
                if (thresholdCondition.getOperator() == Operator.N_A) {
                    assert (thresholdCondition.getDiffThreshold() == null) : "If no operator is defined, no absolute threshold is expected. " + thresholdCondition.getDebugInfo();
                    assert (thresholdCondition.getDiffThresholdRelative() == null) : "If no operator is defined, no relative threshold is expected. " + thresholdCondition.getDebugInfo();
                    if (thresholdCondition.getCheck() != QualityGateDiffCheck.RELAXED || thresholdIssueDiff.getChange() != IDiffElement.Change.WORSENED) continue;
                    tolerated.add(thresholdIssueDiff);
                    continue;
                }
                Float absoluteValueDiff = thresholdIssueDiff.getValueDiff();
                if (thresholdCondition.getDiffThreshold() != null) {
                    assert (absoluteValueDiff != null) : "Missing diff for threshold violation";
                    QualityGateResultStatus result = this.checkThreshold(absoluteValueDiff.floatValue(), thresholdCondition.getOperator(), thresholdCondition.getDiffThreshold().floatValue());
                    if (result == QualityGateResultStatus.PASSED) {
                        tolerated.add(next);
                    } else {
                        LOGGER.trace("ThresholdViolationDiff {} failed absolute threshold {}", (Object)thresholdIssueDiff, (Object)thresholdCondition.getDiffThreshold());
                    }
                }
                if (thresholdCondition.getDiffThresholdRelative() == null) continue;
                assert (absoluteValueDiff != null) : "Missing diff for threshold violation";
                float baselineValue = ((IThresholdViolationIssue)thresholdIssueDiff.getBaseline()).getMetricValue().floatValue();
                if (baselineValue != 0.0f) {
                    float relativeDiff = absoluteValueDiff.floatValue() / baselineValue;
                    QualityGateResultStatus result = this.checkThreshold(relativeDiff, thresholdCondition.getOperator(), thresholdCondition.getDiffThresholdRelative().floatValue());
                    if (result == QualityGateResultStatus.PASSED) {
                        tolerated.add(next);
                        continue;
                    }
                    LOGGER.debug("ThresholdViolationDiff {} failed relative threshold {}", (Object)thresholdIssueDiff, (Object)thresholdCondition.getDiffThresholdRelative());
                    continue;
                }
                LOGGER.debug("Baseline value for metric {} is 0, relative threshold cannot be computed, threshold issue failed condition.", (Object)thresholdIssueDiff.getMetricIdStandardName());
            }
            return tolerated;
        }

        private Set<IIssueDiff> omitIssuesForRelaxedCheck(Set<IIssueDiff> matches, AbstractIssueDiffAgainstBaselineCondition diffCondition) {
            assert (matches != null) : "Parameter 'matches' of method 'excludeIssuesForRelaxedCheck' must not be null";
            assert (diffCondition != null) : "Parameter 'diffCondition' of method 'excludeIssuesForRelaxedCheck' must not be null";
            LinkedHashSet<IIssueDiff> omitted = new LinkedHashSet<IIssueDiff>();
            if (diffCondition instanceof ThresholdIssueDiffAgainstBaselineCondition) {
                if (((ThresholdIssueDiffAgainstBaselineCondition)diffCondition).getMetricId() == null) {
                    for (IIssueDiff next : matches) {
                        assert (next instanceof ThresholdViolationIssueDiff) : "Unexpected issue diff: " + next.getClass().getCanonicalName();
                        if (next.getChange() != IDiffElement.Change.WORSENED) continue;
                        omitted.add(next);
                    }
                }
                return omitted;
            }
            for (IIssueDiff next : matches) {
                if (next.getChange() != IDiffElement.Change.WORSENED) continue;
                if (next instanceof CycleGroupIssueDiff) {
                    CycleGroupIssueDiff cycleDiff = (CycleGroupIssueDiff)next;
                    if (cycleDiff.getCycleChange() != CycleGroupIssueDiff.CycleChange.PARSER_DEPENDENCIES_CHANGED) continue;
                    omitted.add(cycleDiff);
                    continue;
                }
                if (next instanceof DuplicateCodeBlockIssueDiff) {
                    DuplicateCodeBlockIssueDiff duplicateDiff = (DuplicateCodeBlockIssueDiff)next;
                    if (duplicateDiff.getDuplicateChange() != DuplicateCodeBlockIssueDiff.DuplicateChange.INVOLVED_LINES) continue;
                    omitted.add(duplicateDiff);
                    continue;
                }
                if (!(next instanceof ThresholdViolationIssueDiff)) continue;
                omitted.add(next);
            }
            return omitted;
        }

        private Set<IIssueDiff> filterDiffIssues(IssuesDiff issuesDiff, String issueType, List<String> severities, List<String> resolutions, String metricId) {
            assert (issuesDiff != null) : "Parameter 'issuesDiff' of method 'filterDiffIssues' must not be null";
            assert (issueType != null) : "Parameter 'issueType' of method 'filterDiffIssues' must not be null";
            assert (severities != null && !severities.isEmpty()) : "Parameter 'severities' of method 'filterDiffIssues' must not be empty";
            assert (resolutions != null && !resolutions.isEmpty()) : "Parameter 'resolutions' of method 'filterDiffIssues' must not be empty";
            LinkedHashSet<IIssueDiff> filtered = new LinkedHashSet<IIssueDiff>();
            Predicate<Issue> metricPredicate = QualityGateAnalyzerJob.createMetricIdPredicate(metricId, issueType);
            Predicate<Issue> issueTypePredicate = QualityGateAnalyzerJob.createIssueTypePredicate(issueType);
            Predicate<Issue> severityPredicate = QualityGateAnalyzerJob.createSeverityPredicate((Set<String>)new THashSet(severities));
            Predicate<Issue> resolutionPredicate = QualityGateAnalyzerJob.createResolutionPredicate((Set<String>)new THashSet(resolutions));
            for (IIssueDiff nextDiff : issuesDiff.getChildren(IIssueDiff.class)) {
                if (!this.isWorseOrAdded(nextDiff)) continue;
                Issue current = nextDiff.getCurrent();
                assert (current != null) : "'current' of method 'filterDiffIssues' must not be null";
                if (!issueTypePredicate.test(current) || !severityPredicate.test(current) || !resolutionPredicate.test(current) || !metricPredicate.test(current)) continue;
                filtered.add(nextDiff);
            }
            return filtered;
        }

        private boolean isWorseOrAdded(IIssueDiff diff) {
            assert (diff != null) : "Parameter 'diff' of method 'isWorseOrAdded' must not be null";
            return diff.getChange() == IDiffElement.Change.ADDED || diff.getChange() == IDiffElement.Change.WORSENED || diff.getChange() == IDiffElement.Change.RESOLUTION_REMOVED;
        }

        private Set<Issue> filterByMetricId(Collection<Issue> issues, String metricId) {
            assert (issues != null) : "Parameter 'issues' of method 'filterByMetricId' must not be null";
            assert (metricId != null && metricId.length() > 0) : "Parameter 'metricId' of method 'filterByMetricId' must not be empty";
            if (issues.isEmpty()) {
                return new LinkedHashSet<Issue>();
            }
            boolean any = metricId.equalsIgnoreCase("Any");
            LinkedHashSet<Issue> matches = new LinkedHashSet<Issue>();
            for (Issue next : issues) {
                if (!(next instanceof ThresholdViolationIssue)) continue;
                ThresholdViolationIssue issue = (ThresholdViolationIssue)next;
                if (!any && !issue.getMetricDescriptor().getId().equals(metricId)) continue;
                matches.add(next);
            }
            return matches;
        }

        private Set<IIssueDiff> filterDiffsByMetricId(Set<IIssueDiff> matches, String metricId) {
            assert (matches != null) : "Parameter 'matches' of method 'filterByMetricId' must not be null";
            assert (metricId != null && metricId.length() > 0) : "Parameter 'metricId' of method 'filterByMetricId' must not be empty";
            if (matches.isEmpty()) {
                return matches;
            }
            boolean any = metricId.equalsIgnoreCase("Any");
            LinkedHashSet<IIssueDiff> result = new LinkedHashSet<IIssueDiff>();
            for (IIssueDiff next : matches) {
                if (!(next instanceof ThresholdViolationIssueDiff)) continue;
                ThresholdViolationIssue issue = (ThresholdViolationIssue)((ThresholdViolationIssueDiff)next).getCurrent();
                assert (issue != null) : "'issue' must not be null";
                if (!any && !issue.getMetricDescriptor().getId().equals(metricId)) continue;
                result.add(next);
            }
            return result;
        }

        private Set<Element> applyExcludeFilters(Set<Element> matches, AbstractQualityGateIssueCondition condition, List<QualityGateExcludeFilterResult> excludeResults) {
            assert (matches != null) : "Parameter 'matches' of method 'applyExcludeFilters' must not be null";
            assert (condition != null) : "Parameter 'condition' of method 'applyExcludeFilters' must not be null";
            assert (excludeResults != null) : "Parameter 'excludeResults' of method 'applyExcludeFilters' must not be null";
            LinkedHashSet<Element> allExcluded = new LinkedHashSet<Element>();
            for (QualityGateExcludeFilterResult nextFilterResult : excludeResults) {
                if (nextFilterResult.getMatches().isEmpty()) continue;
                LinkedHashSet<Element> excluded = new LinkedHashSet<Element>(nextFilterResult.getMatches());
                excluded.retainAll(matches);
                if (excluded.isEmpty()) continue;
                nextFilterResult.addExcludeInfo(condition, excluded);
                matches.removeAll(excluded);
                allExcluded.addAll(excluded);
            }
            return allExcluded;
        }

        private QualityGateResultStatus checkLimit(int matchCount, Operator operator, int limit) {
            assert (operator != null) : "Parameter 'operator' of method 'checkLimit' must not be null";
            return (switch (operator) {
                case Operator.LESS -> matchCount < limit;
                case Operator.LESS_OR_EQUAL -> matchCount <= limit;
                case Operator.EQUAL -> matchCount == limit;
                case Operator.GREATER_OR_EQUAL -> matchCount >= limit;
                case Operator.GREATER -> matchCount > limit;
                default -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)("Unsupported operator " + String.valueOf((Object)operator)));
                    }
                    yield false;
                }
            }) ? QualityGateResultStatus.PASSED : QualityGateResultStatus.FAILED;
        }

        private QualityGateResultStatus checkThreshold(float diff, Operator operator, float threshold) {
            assert (operator != null) : "Parameter 'operator' of method 'checkThreshold' must not be null";
            return (switch (operator) {
                case Operator.LESS -> diff < threshold;
                case Operator.LESS_OR_EQUAL -> diff <= threshold;
                case Operator.EQUAL -> diff == threshold;
                case Operator.GREATER_OR_EQUAL -> diff >= threshold;
                case Operator.GREATER -> diff > threshold;
                default -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)("Unsupported operator " + String.valueOf((Object)operator)));
                    }
                    yield false;
                }
            }) ? QualityGateResultStatus.PASSED : QualityGateResultStatus.FAILED;
        }

        private Set<Issue> filterIssues(Collection<Issue> issues, String issueType, List<String> severities, List<String> resolutions) {
            assert (issues != null) : "Parameter 'issues' of method 'filterIssues' must not be null";
            assert (issueType != null && issueType.length() > 0) : "Parameter 'issueType' of method 'filterIssues' must not be empty";
            assert (severities != null && !severities.isEmpty()) : "Parameter 'severities' of method 'filterIssues' must not be empty";
            assert (resolutions != null && !resolutions.isEmpty()) : "Parameter 'resolutions' of method 'filterIssues' must not be empty";
            LinkedHashSet<Issue> filtered = new LinkedHashSet<Issue>();
            Predicate<Issue> issueTypePredicate = QualityGateAnalyzerJob.createIssueTypePredicate(issueType);
            Predicate<Issue> severityPredicate = QualityGateAnalyzerJob.createSeverityPredicate((Set<String>)new THashSet(severities));
            Predicate<Issue> resolutionPredicate = QualityGateAnalyzerJob.createResolutionPredicate((Set<String>)new THashSet(resolutions));
            for (Issue next : issues) {
                if (!issueTypePredicate.test(next) || !severityPredicate.test(next) || !resolutionPredicate.test(next)) continue;
                filtered.add(next);
            }
            return filtered;
        }

        private static Predicate<Issue> createResolutionPredicate(Set<String> resolutions) {
            Predicate<Issue> resolutionPredicate = i -> {
                if (i.getResolution() == null && resolutions.contains(ResolutionMode.NONE.getStandardName())) {
                    return true;
                }
                if (i.getResolution(IgnoreDefinition.class) != null && resolutions.contains(ResolutionMode.IGNORE.getStandardName())) {
                    return true;
                }
                return i.getResolution(TaskDefinition.class) != null && resolutions.contains(ResolutionMode.TASK.getStandardName());
            };
            return resolutionPredicate;
        }

        private static Predicate<Issue> createSeverityPredicate(Set<String> severities) {
            Predicate<Issue> severityPredicate = i -> severities.contains(i.getSeverity().getStandardName());
            return severityPredicate;
        }

        private static Predicate<Issue> createIssueTypePredicate(String issueType) {
            assert (issueType != null) : "Parameter 'issueType' of method 'createIssueTypePredicate' must not be null";
            int colonPos = issueType.indexOf(":");
            boolean containsProvider = colonPos > 1 && colonPos < issueType.length() - 1;
            Predicate<Issue> issueTypePredicate = i -> {
                if (issueType.equalsIgnoreCase("Any")) {
                    return true;
                }
                if (containsProvider) {
                    return issueType.equalsIgnoreCase(i.getType());
                }
                return issueType.equalsIgnoreCase(i.getId().getStandardName());
            };
            return issueTypePredicate;
        }

        private static Predicate<Issue> createMetricIdPredicate(String metricId, String issueId) {
            assert (issueId != null) : "Parameter 'issueId' of method 'createMetricIdPredicate' must not be null";
            Predicate<Issue> metricIdPredicate = i -> {
                if (metricId == null || metricId.trim().isEmpty()) {
                    return true;
                }
                if (issueId.equalsIgnoreCase("Any")) {
                    return true;
                }
                if (!issueId.equalsIgnoreCase("Any") && !issueId.equalsIgnoreCase(CoreIssueId.THRESHOLD_VIOLATION.getStandardName())) {
                    return true;
                }
                if (i.getId() == CoreIssueId.THRESHOLD_VIOLATION && i instanceof ThresholdViolationIssue) {
                    ThresholdViolationIssue thresholdViolation = (ThresholdViolationIssue)i;
                    return thresholdViolation.getMetricDescriptor().getId().equals(metricId);
                }
                return false;
            };
            return metricIdPredicate;
        }
    }
}

