/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.controller.system.analysis.SizeComputationUtility;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.base.IIssueParticipationProvider;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import java.util.Collection;
import java.util.List;

public final class IssueDensityAnalyzerAdapter
extends AnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.ISSUE_DENSITY;
    private final IMetricDescriptor m_densitySourceFile;
    private final IMetricDescriptor m_densityModule;
    private final IMetricDescriptor m_densitySystem;
    private final IMetricDescriptor m_sourceFileSizeMetricDescriptor;

    public IssueDensityAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, ID);
        IMetricsProvider metricsProvider = this.getInstallation().getExtension(IMetricsProvider.class);
        MetricProvider mp = metricsProvider.getMetricProvider(CoreProviderId.INSTANCE);
        this.m_densitySourceFile = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_ISSUE_DENSITY, CoreMetricLevel.SOURCE_FILE);
        this.m_densityModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_ISSUE_DENSITY, CoreMetricLevel.MODULE);
        this.m_densitySystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_ISSUE_DENSITY, CoreMetricLevel.SYSTEM);
        this.m_sourceFileSizeMetricDescriptor = this.findMetricDescriptor(mp, CoreMetricId.CORE_SOURCE_ELEMENT_COUNT, CoreMetricLevel.SOURCE_FILE);
        assert (this.m_sourceFileSizeMetricDescriptor != null) : "Metric descriptor 'source element count' for level 'source file' not found";
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        IMetricAccessor metricAccessor = this.getInstallation().getExtension(IMetricAccessor.class);
        IssueDensityJob job = new IssueDensityJob(this.getGroup(), result, this.getController(), metricAccessor, this.getRequiredResults());
        job.start();
    }

    private static final class IssueCollector
    extends NamedElementVisitor
    implements ProgrammingElement.IVisitor,
    SourceFile.IVisitor,
    RootDirectoryPath.IVisitor,
    Module.IVisitor {
        private final IssueFilter m_filter = new IssueFilter((IStandardEnumeration[])new Enum[]{ResolutionMode.NONE, Severity.ERROR, Severity.WARNING});
        private final IMetricStorage m_storage;
        private final IWorkerContext m_workerContext;
        private final IIssueParticipationProvider m_issueParticipationProvider;
        private final IssueDensity m_systemDensity;
        private IssueDensity m_moduleDensity;
        private IssueDensity m_sourceFileDensity;

        IssueCollector(IMetricStorage storage, SoftwareSystem softwareSystem, IWorkerContext workerContext) {
            assert (storage != null) : "Parameter 'storage' of method 'SourceVisitor' must not be null";
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'IssueCollector' must not be null";
            assert (workerContext != null) : "Parameter 'workerContext' of method 'IssueCollector' must not be null";
            this.m_storage = storage;
            this.m_systemDensity = new IssueDensity(softwareSystem);
            this.m_issueParticipationProvider = softwareSystem.getExtension(IIssueParticipationProvider.class);
            this.m_workerContext = workerContext;
        }

        @Override
        public boolean done() {
            return this.m_workerContext.hasBeenCanceled();
        }

        private void collectIssues(NamedElement namedElement) {
            assert (namedElement != null) : "Parameter 'namedElement' of method 'collectIssues' must not be null";
            for (Issue next : namedElement.getIssues()) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                if (!this.m_filter.accept(next)) continue;
                if (this.m_sourceFileDensity != null) {
                    this.m_sourceFileDensity.add(next);
                    continue;
                }
                if (this.m_moduleDensity != null) {
                    this.m_moduleDensity.add(next);
                    continue;
                }
                this.m_systemDensity.add(next);
            }
        }

        @Override
        public void visitNamedElement(NamedElement namedElement) {
            assert (namedElement != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
            this.collectIssues(namedElement);
            super.visitNamedElement(namedElement);
        }

        @Override
        public void visitRootDirectoryPath(RootDirectoryPath rootPath) {
            assert (rootPath != null) : "Parameter 'rootPath' of method 'visitRootDirectoryPath' must not be null";
            if (rootPath.mayContainSourceFiles()) {
                for (IComponent nextComponent : rootPath.getChildrenRecursively(IComponent.class, ProgrammingElement.class)) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    if (nextComponent.ignoreIssues()) continue;
                    List<SourceFile> sourceFiles = SizeComputationUtility.getInternalNotExcludedSourceFiles(nextComponent);
                    for (SourceFile nextSource : sourceFiles) {
                        if (this.m_workerContext.hasBeenCanceled()) {
                            return;
                        }
                        this.visitSourceFile(nextSource);
                    }
                }
            }
        }

        @Override
        public void visitModule(Module module) {
            assert (module != null) : "Parameter 'module' of method 'visitModule' must not be null";
            this.m_workerContext.working("Collect issues of module " + module.getName(), true);
            this.m_moduleDensity = new IssueDensity(module);
            this.visitNamedElement(module);
            for (WorkspaceDependency next : module.getOutgoingWorkspaceDependencies()) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                for (Issue nextIssue : next.getIssues()) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    if (!this.m_filter.accept(nextIssue)) continue;
                    this.m_moduleDensity.add(nextIssue);
                }
            }
            this.m_storage.storeDensity(this.m_moduleDensity);
            this.m_systemDensity.integrate(this.m_moduleDensity);
            this.m_moduleDensity = null;
        }

        @Override
        public void visitSourceFile(SourceFile sourceFile) {
            assert (sourceFile != null) : "Parameter 'sourceFile' of method 'visitSourceFile' must not be null";
            if (!sourceFile.isExcluded()) {
                this.m_sourceFileDensity = new IssueDensity(sourceFile);
                int sourceFileSize = this.m_storage.getSourceFileSize(sourceFile);
                if (sourceFileSize > 0) {
                    this.m_sourceFileDensity.incrementSize(sourceFileSize);
                }
                for (Issue issue : this.m_issueParticipationProvider.getParticipatingInCycleIssues(sourceFile)) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    if (!this.m_filter.accept(issue)) continue;
                    this.m_sourceFileDensity.add(issue);
                }
                for (Issue issue : this.m_issueParticipationProvider.getParticipatingInDuplicateCodeBlockIssues(sourceFile)) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    if (!this.m_filter.accept(issue)) continue;
                    this.m_sourceFileDensity.add(issue);
                }
                this.visitNamedElement(sourceFile);
                this.m_storage.storeDensity(this.m_sourceFileDensity);
                this.m_moduleDensity.integrate(this.m_sourceFileDensity);
            }
            this.m_sourceFileDensity = null;
        }

        @Override
        public void visitProgrammingElement(ProgrammingElement programmingElement) {
            assert (programmingElement != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            for (ParserDependency dependency : programmingElement.getOutgoingDependencies(new IParserDependencyType[0])) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                for (Issue next : dependency.getIssues()) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    if (!this.m_filter.accept(next)) continue;
                    this.m_sourceFileDensity.add(next);
                }
            }
            this.visitNamedElement(programmingElement);
        }

        void finish() {
            this.m_storage.storeDensity(this.m_systemDensity);
        }

        public static interface IMetricStorage {
            public void storeDensity(IssueDensity var1);

            public int getSourceFileSize(SourceFile var1);
        }
    }

    private static final class IssueDensity {
        private final NamedElement m_element;
        private int m_errorCount = 0;
        private int m_warningCount = 0;
        private int m_infoCount = 0;
        private int m_noneCount = 0;
        private int m_size = 0;

        IssueDensity(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'IssueDensity' must not be null";
            this.m_element = element;
        }

        void incrementSize(int increment) {
            this.m_size += increment;
        }

        int getSize() {
            return this.m_size;
        }

        void add(Issue issue) {
            assert (issue != null) : "Parameter 'issue' of method 'add' must not be null";
            switch (issue.getSeverity()) {
                case ERROR: {
                    ++this.m_errorCount;
                    break;
                }
                case WARNING: {
                    ++this.m_warningCount;
                    break;
                }
                case INFO: {
                    ++this.m_infoCount;
                    break;
                }
                case NONE: {
                    ++this.m_noneCount;
                    break;
                }
                default: {
                    assert (false) : "Unsupported severity: " + String.valueOf(issue);
                    break;
                }
            }
        }

        int getErrorCount() {
            return this.m_errorCount;
        }

        int getWarningCount() {
            return this.m_warningCount;
        }

        int getInfoCount() {
            return this.m_infoCount;
        }

        int getNoneCount() {
            return this.m_noneCount;
        }

        int getIssueCount() {
            return this.getErrorCount() + this.getWarningCount() + this.getInfoCount() + this.getNoneCount();
        }

        void integrate(IssueDensity other) {
            assert (other != null) : "Parameter 'other' of method 'integrate' must not be null";
            this.m_size += other.getSize();
            this.integrateIssues(other);
        }

        void integrateIssues(IssueDensity other) {
            assert (other != null) : "Parameter 'other' of method 'integrateIssues' must not be null";
            this.m_errorCount += other.getErrorCount();
            this.m_warningCount += other.getWarningCount();
            this.m_infoCount += other.getInfoCount();
            this.m_noneCount += other.getNoneCount();
        }

        NamedElement getNamedElement() {
            return this.m_element;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("IssueDensity [m_element=");
            builder.append(this.m_element.getShortName());
            builder.append(", m_errorCount=");
            builder.append(this.m_errorCount);
            builder.append(", m_warningCount=");
            builder.append(this.m_warningCount);
            builder.append(", m_infoCount=");
            builder.append(this.m_infoCount);
            builder.append(", m_noneCount=");
            builder.append(this.m_noneCount);
            builder.append(", m_size=");
            builder.append(this.m_size);
            builder.append("]");
            return builder.toString();
        }
    }

    private final class IssueDensityJob
    extends AnalyzerJob
    implements IssueCollector.IMetricStorage {
        private final IMetricAccessor m_metricAccessor;

        private IssueDensityJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, IMetricAccessor metricAccessor, Collection<AnalyzerResult> requiredResults) {
            super(group, result, controller, requiredResults);
            assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'IssueDensityJob' must not be null";
            this.m_metricAccessor = metricAccessor;
        }

        @Override
        public void storeDensity(IssueDensity density) {
            IMetricDescriptor descriptor;
            assert (density != null) : "Parameter 'density' of method 'storeDensity' must not be null";
            NamedElement element = density.getNamedElement();
            if (element instanceof SourceFile) {
                descriptor = IssueDensityAnalyzerAdapter.this.m_densitySourceFile;
            } else if (element instanceof Module) {
                descriptor = IssueDensityAnalyzerAdapter.this.m_densityModule;
            } else if (element instanceof SoftwareSystem) {
                descriptor = IssueDensityAnalyzerAdapter.this.m_densitySystem;
            } else {
                assert (false) : "Unsupported element for issue density: " + element.getClass().getCanonicalName() + ", " + String.valueOf(element);
                descriptor = null;
            }
            float value = density.getSize() > 0 ? (float)density.getIssueCount() * 1000.0f / (float)density.getSize() : -1.0f;
            IssueDensityAnalyzerAdapter.this.storeMetricValue(this.getResult(), element, Float.valueOf(value), descriptor);
        }

        @Override
        public int getSourceFileSize(SourceFile sourceFile) {
            Number value;
            assert (sourceFile != null) : "Parameter 'sourceFile' of method 'getSourceFileSize' must not be null";
            IMetricValue metricValue = this.m_metricAccessor.getMetricValue(this.getSoftwareSystem(), (IWorkerContext)DefaultWorkerContext.INSTANCE, sourceFile, IssueDensityAnalyzerAdapter.this.m_sourceFileSizeMetricDescriptor, false);
            if (metricValue != null && (value = metricValue.getValue()) != null) {
                return value.intValue();
            }
            return -1;
        }

        @Override
        protected void internalRun() {
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            IWorkerContext workerContext = this.getWorkerContext();
            workerContext.setNumberOfSteps(5 + softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class).size());
            IssueCollector issueCollector = new IssueCollector(this, softwareSystem, workerContext);
            for (Module nextModule : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                nextModule.accept(issueCollector);
            }
            issueCollector.finish();
        }
    }
}

