/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.SourceFileComparator;
import com.hello2morrow.sonargraph.core.foundation.common.base.RelevantSourceFile;
import com.hello2morrow.sonargraph.core.foundation.common.base.RelevantSourceLinesScanner;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.system.IRelevantSourceFileIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RelevantSourceFileIterator
implements IRelevantSourceFileIterator {
    private final List<SourceFile> m_sourcefiles;
    private final RelevantSourceLinesScanner m_scanner;
    private final int m_totalNumberOfRelevantSourceFiles;
    private RelevantSourceFile m_next;

    public RelevantSourceFileIterator(List<SourceFile> sourceFiles, RelevantSourceLinesScanner.ScannerInfo scannerInfo) {
        assert (sourceFiles != null) : "Parameter 'sourceFiles' of method 'RelevantSourceFileIterator' must not be null";
        assert (scannerInfo != null) : "Parameter 'scannerInfo' of method 'RelevantSourceFileIterator' must not be null";
        this.m_sourcefiles = new ArrayList<SourceFile>(sourceFiles.size());
        for (SourceFile nextSourceFile : sourceFiles) {
            if (nextSourceFile.isExcluded() || nextSourceFile.isExternal() || nextSourceFile.getFile() == null || !nextSourceFile.getFile().exists()) continue;
            this.m_sourcefiles.add(nextSourceFile);
        }
        Collections.sort(this.m_sourcefiles, SourceFileComparator.INSTANCE);
        this.m_scanner = new RelevantSourceLinesScanner(scannerInfo);
        this.m_totalNumberOfRelevantSourceFiles = this.m_sourcefiles.size();
        this.readNextSourceFile();
    }

    @Override
    public int getTotalNumberOfRelevantSourceFiles() {
        return this.m_totalNumberOfRelevantSourceFiles;
    }

    private void readNextSourceFile() {
        if (!this.m_sourcefiles.isEmpty()) {
            SourceFile nextSourceFile = this.m_sourcefiles.remove(0);
            this.m_next = this.m_scanner.read(nextSourceFile, nextSourceFile.getFile());
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_next != null;
    }

    @Override
    public RelevantSourceFile next() {
        RelevantSourceFile next = this.m_next;
        this.m_next = null;
        this.readNextSourceFile();
        return next;
    }

    @Override
    public void remove() {
        assert (false) : "'remove' not supported";
    }
}

