/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.IRefactoringTarget;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

final class RefactoringUtilities {
    private RefactoringUtilities() {
    }

    static Class<? extends PhysicalRecursiveElement> getPhysicalRecursiveComponentParentClass(Language language) {
        assert (language != null) : "Parameter 'language' of method 'getPhysicalRecursiveComponentParentClass' must not be null";
        return language.namespaceAndDirectoryStructureMatches() ? NamespaceFragment.class : DirectoryFragment.class;
    }

    static String getKind(MoveRenameRefactoringElementType elementType, Language language) {
        assert (elementType != null) : "Parameter 'elementType' of method 'getKind' must not be null";
        assert (language != null) : "Parameter 'language' of method 'getKind' must not be null";
        switch (elementType) {
            case ELEMENT: 
            case COMPONENT: 
            case DIRECTORY: {
                return elementType.getPresentationName();
            }
            case NAMESPACE: {
                return language.getNamespacePresentationName();
            }
        }
        assert (false) : "Unhandled: " + String.valueOf((Object)elementType);
        return "";
    }

    static String getPhysicalRecursiveElementKind(MoveRenameRefactoringElementType elementType, Language language) {
        assert (elementType != null) : "Parameter 'elementType' of method 'getPhysicalRecursiveElementKind' must not be null";
        assert (language != null) : "Parameter 'language' of method 'getPhysicalRecursiveElementKind' must not be null";
        switch (elementType) {
            case COMPONENT: {
                return language.namespaceAndDirectoryStructureMatches() ? language.getNamespacePresentationName() : "Directory";
            }
            case DIRECTORY: {
                return "Directory";
            }
            case ELEMENT: 
            case NAMESPACE: {
                return language.getNamespacePresentationName();
            }
        }
        assert (false) : "Unhandled: " + String.valueOf((Object)elementType);
        return null;
    }

    static String getPhysicalRecursiveElementImageResourceName(MoveRenameRefactoringElementType elementType, Language language) {
        assert (elementType != null) : "Parameter 'elementType' of method 'getPhysicalRecursiveElementImageResourceName' must not be null";
        assert (language != null) : "Parameter 'language' of method 'getPhysicalRecursiveElementImageResourceName' must not be null";
        switch (elementType) {
            case COMPONENT: {
                return language.namespaceAndDirectoryStructureMatches() ? "NamespaceFragment" : "DirectoryFragment";
            }
            case DIRECTORY: {
                return "DirectoryFragment";
            }
            case ELEMENT: 
            case NAMESPACE: {
                return "NamespaceFragment";
            }
        }
        assert (false) : "Unhandled: " + String.valueOf((Object)elementType);
        return null;
    }

    static String getMoveToParentName(List<NamedElement> namedElements, NamedElement target, MoveRenameRefactoringElementType elementType, Language language) {
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'getMoveToParentName' must not be empty";
        assert (elementType != null) : "Parameter 'elementType' of method 'getMoveToParentName' must not be null";
        assert (language != null) : "Parameter 'language' of method 'getMoveToParentName' must not be null";
        if (target == null) {
            NamedElement parent = null;
            NamedElement firstElement = namedElements.get(0);
            switch (elementType) {
                case COMPONENT: {
                    parent = firstElement.getParent(RefactoringUtilities.getPhysicalRecursiveComponentParentClass(language), new Class[0]);
                    break;
                }
                case DIRECTORY: {
                    parent = firstElement.getParent(DirectoryFragment.class, new Class[0]);
                    break;
                }
                case NAMESPACE: {
                    parent = firstElement.getParent(NamespaceFragment.class, new Class[0]);
                    break;
                }
                case ELEMENT: {
                    parent = firstElement.getParent(NamespaceFragment.class, new Class[0]);
                    break;
                }
                default: {
                    assert (false) : "Unhandled element type: " + String.valueOf((Object)elementType);
                    break;
                }
            }
            if (parent != null) {
                return parent.getName();
            }
        } else if (!(target instanceof RootDirectoryPath)) {
            return target.getName();
        }
        return "";
    }

    static IRefactoringTarget findRefactoringTarget(IRefactoringTarget parent, String name, String separator) {
        assert (parent != null) : "Parameter 'parent' of method 'findRefactoringTarget' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'findRefactoringTarget' must not be empty";
        assert (separator != null && separator.length() > 0) : "Parameter 'separator' of method 'findRefactoringTarget' must not be empty";
        StringTokenizer tokenizer = new StringTokenizer(name, separator);
        IRefactoringTarget current = parent;
        while (tokenizer.hasMoreTokens()) {
            String nextNamePart = tokenizer.nextToken();
            assert (nextNamePart != null && nextNamePart.length() > 0) : "'nextNamePart' of method 'findRefactoringTarget' must not be empty";
            IRefactoringTarget found = null;
            for (IRefactoringTarget nextRefactoringTarget : current.getNamedElement().getChildren(IRefactoringTarget.class)) {
                if (!nextRefactoringTarget.getNamedElement().getShortName().equals(nextNamePart)) continue;
                found = nextRefactoringTarget;
            }
            if (found == null) {
                return null;
            }
            current = found;
        }
        return current;
    }

    static List<String> getAvailableMoveToParentNames(Map<Module, List<RootDirectoryPath>> availableTargetRootDirectories, MoveRenameRefactoringElementType elementType, Language language) {
        assert (availableTargetRootDirectories != null && !availableTargetRootDirectories.isEmpty()) : "Parameter 'availableTargetRootDirectories' of method 'getAvailableMoveToParentNames' must not be empty";
        assert (elementType != null) : "Parameter 'elementType' of method 'getAvailableMoveToParentNames' must not be null";
        assert (language != null) : "Parameter 'language' of method 'getAvailableMoveToParentNames' must not be null";
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        all.add("");
        if (elementType == MoveRenameRefactoringElementType.ELEMENT) {
            for (List<RootDirectoryPath> nextTargetRootDirectories : availableTargetRootDirectories.values()) {
                for (RootDirectoryPath nextTargetRootDirectory : nextTargetRootDirectories) {
                    nextTargetRootDirectory.getChildrenRecursively(NamespaceFragment.class, ProgrammingElement.class).forEach(e -> {
                        boolean bl = all.add(e.getName());
                    });
                }
            }
        } else {
            for (List<RootDirectoryPath> nextTargetRootDirectories : availableTargetRootDirectories.values()) {
                for (RootDirectoryPath nextTargetRootDirectory : nextTargetRootDirectories) {
                    nextTargetRootDirectory.getChildrenRecursively(RefactoringUtilities.getPhysicalRecursiveComponentParentClass(language), IComponent.class).forEach(e -> {
                        boolean bl = all.add(e.getName());
                    });
                }
            }
        }
        return new ArrayList<String>(all);
    }
}

