/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IRefactoringProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElement;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IDependency;
import com.hello2morrow.sonargraph.core.model.element.IDependencyAdapter;
import com.hello2morrow.sonargraph.core.model.element.IDependencyWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.ILogicalElement;
import com.hello2morrow.sonargraph.core.model.element.INamedElementAdapter;
import com.hello2morrow.sonargraph.core.model.element.INamedElementNode;
import com.hello2morrow.sonargraph.core.model.element.IPhysicalElement;
import com.hello2morrow.sonargraph.core.model.element.ISingleIssueProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.IssueList;
import com.hello2morrow.sonargraph.core.model.element.IssueType;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.element.StructureMode;
import com.hello2morrow.sonargraph.core.model.element.pattern.DependencyWildcardPattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementWildcardPattern;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.Pattern;
import com.hello2morrow.sonargraph.core.model.metrics.ThresholdViolationIssue;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.refactoring.DeleteRefactoringData;
import com.hello2morrow.sonargraph.core.model.refactoring.DeleteRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.LanguageSpecificRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringInfo;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringData;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.PhysicalImpactCalculator;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class IssueProvider
extends Extension
implements IIssueProvider {
    private static Logger LOGGER = LoggerFactory.getLogger(IssueProvider.class);
    private final LanguageProviderAccessor m_languageProviderAccessor;
    private final SoftwareSystem m_softwareSystem;
    private final IRefactoringProvider m_refactoringProvider;

    IssueProvider(LanguageProviderAccessor accessor, SoftwareSystem softwareSystem, IRefactoringProvider refactoringProvider) {
        assert (accessor != null) : "Parameter 'accessor' of method 'IssueProvider' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'SoftwareIssueExtension' must not be null";
        assert (refactoringProvider != null) : "Parameter 'refactoringProvider' of method 'IssueProvider' must not be null";
        this.m_languageProviderAccessor = accessor;
        this.m_softwareSystem = softwareSystem;
        this.m_refactoringProvider = refactoringProvider;
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    protected final IRefactoringProvider getRefactoringProvider() {
        return this.m_refactoringProvider;
    }

    private boolean collectDependencyForTodo(WorkspaceDependency dependency, Collection<ElementWithIssues> wildcard) {
        assert (dependency != null) : "Parameter 'dependency' of method 'handleDependency' must not be null";
        assert (wildcard != null) : "Parameter 'wildcard' of method 'handleDependency' must not be null";
        wildcard.add(dependency);
        return true;
    }

    private void collectDependencyForTodo(ParserDependency dependency, Collection<Pair<NamedElement, NamedElement>> endpoint, Collection<ParserDependency> parserDependencies, boolean firstDependencyOnly) {
        assert (dependency != null) : "Parameter 'dependency' of method 'handleDependency' must not be null";
        assert (endpoint != null) : "Parameter 'endpoint' of method 'handleDependency' must not be null";
        assert (parserDependencies != null) : "Parameter 'parserDependencies' of method 'collectDependencyForTodo' must not be null";
        endpoint.add((Pair<NamedElement, NamedElement>)new Pair((Object)dependency.getUnderlyingFrom(), (Object)dependency.getUnderlyingTo()));
        Set<ParserDependency> affected = PhysicalImpactCalculator.getParserDependencies(dependency.getUnderlyingFrom(), dependency.getUnderlyingTo(), firstDependencyOnly, false);
        parserDependencies.addAll(affected);
    }

    private boolean mayHaveTodo(Element element) {
        return (element instanceof ILogicalElement || element instanceof IPhysicalElement || element instanceof IArchitectureElement) && element.getRefactoringState() != RefactoringState.DELETED;
    }

    protected final void collectElementsForTodo(ModifiableModel model, List<Element> elements, Set<ElementWithIssues> wildcard, Set<NamedElement> fqName, Set<Pair<NamedElement, NamedElement>> endpoint, Set<ParserDependency> parserDependencies, boolean firstDependencyOnly) {
        assert (model != null) : "Parameter 'model' of method 'collectElements' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'collectElements' must not be empty";
        assert (wildcard != null) : "Parameter 'wildcard' of method 'collectElements' must not be null";
        assert (fqName != null) : "Parameter 'fqName' of method 'collectElements' must not be null";
        assert (parserDependencies != null) : "Parameter 'parserDependencies' of method 'collectElementsForTodo' must not be null";
        for (Element nextElement : elements) {
            if (nextElement instanceof NamedElement) {
                NamedElement nextNamedElement = ((NamedElement)nextElement).getElement();
                if (!this.mayHaveTodo(nextNamedElement)) continue;
                fqName.add(nextNamedElement);
                continue;
            }
            if (nextElement instanceof ParserDependency) {
                if (!this.mayHaveTodo(nextElement)) continue;
                this.collectDependencyForTodo((ParserDependency)nextElement, endpoint, parserDependencies, firstDependencyOnly);
                continue;
            }
            if (nextElement instanceof WorkspaceDependency) {
                if (!this.mayHaveTodo(nextElement)) continue;
                this.collectDependencyForTodo((WorkspaceDependency)nextElement, wildcard);
                continue;
            }
            if (nextElement instanceof INamedElementNode) {
                NamedElement namedElement = ((INamedElementNode)((Object)nextElement)).getNamedElement();
                if (!this.mayHaveTodo(namedElement)) continue;
                fqName.add(namedElement);
                continue;
            }
            if (!(nextElement instanceof IDependency)) continue;
            this.collectDependenciesForTodo((IDependency)((Object)nextElement), wildcard, endpoint, parserDependencies, firstDependencyOnly);
        }
    }

    private void collectDependenciesForTodo(IDependency dependency, Set<ElementWithIssues> wildcard, Set<Pair<NamedElement, NamedElement>> endpoint, Set<ParserDependency> parserDependencies, boolean firstDependencyOnly) {
        Dependency firstDependency;
        if (this.mayHaveTodo(dependency.getFromEndPoint()) && this.mayHaveTodo(dependency.getToEndPoint()) && (firstDependency = dependency.getFirstDependency()) != null) {
            if (ParserDependency.class.isAssignableFrom(firstDependency.getClass()) && this.mayHaveTodo(firstDependency)) {
                endpoint.add((Pair<NamedElement, NamedElement>)new Pair((Object)dependency.getFromEndPoint(), (Object)dependency.getToEndPoint()));
                Set<ParserDependency> set = PhysicalImpactCalculator.getParserDependencies(dependency.getFromEndPoint(), dependency.getToEndPoint(), firstDependencyOnly, false);
                parserDependencies.addAll(set);
            } else {
                assert (firstDependency instanceof WorkspaceDependency) : "Unexpected class in method 'collectElementsForTodo': " + String.valueOf(firstDependency);
                for (Dependency dependency2 : dependency.getDependencies()) {
                    if (!this.mayHaveTodo(dependency2)) continue;
                    this.collectDependencyForTodo((WorkspaceDependency)dependency2, wildcard);
                }
            }
        }
    }

    @Override
    public final List<Element> isTodoPossible(List<Element> elements) {
        List<Element> collectedElements;
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isTodoPossible' must not be empty";
        ModifiableModel modifiableModel = this.m_softwareSystem.getCurrentModel(ModifiableModel.class);
        if (modifiableModel != null && !(collectedElements = this.collectElements(elements)).isEmpty()) {
            THashSet wildcard = new THashSet();
            THashSet fqName = new THashSet();
            THashSet endpoint = new THashSet();
            THashSet parserDependencies = new THashSet();
            this.collectElementsForTodo(modifiableModel, collectedElements, (Set<ElementWithIssues>)wildcard, (Set<NamedElement>)fqName, (Set<Pair<NamedElement, NamedElement>>)endpoint, (Set<ParserDependency>)parserDependencies, true);
            if (!(wildcard.isEmpty() && fqName.isEmpty() && parserDependencies.isEmpty())) {
                return collectedElements;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public final boolean isCreatePatternBasedCycleIgnoreFilterPossible() {
        return this.m_softwareSystem.getCurrentModel(ModifiableModel.class) != null;
    }

    @Override
    public final List<Resolution> getResolutions(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'areDeleteableResolutions' must not be empty";
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>(elements.size());
        for (Element nextElement : elements) {
            Element nextElementToCheck = nextElement instanceof INamedElementNode ? ((INamedElementNode)((Object)nextElement)).getNamedElement() : nextElement;
            if (!nextElementToCheck.isValid()) continue;
            if (nextElementToCheck instanceof ISingleIssueProvider) {
                Resolution resolution;
                Issue associatedIssue = ((ISingleIssueProvider)((Object)nextElementToCheck)).getAssociatedIssue();
                if (associatedIssue == null || (resolution = (Resolution)associatedIssue.getResolution()) == null) continue;
                resolutions.add(resolution);
                continue;
            }
            if (!(nextElementToCheck instanceof Resolution)) continue;
            resolutions.add((Resolution)nextElementToCheck);
        }
        return resolutions;
    }

    private static IIssueId getIssueId(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'getIssueId' must not be null";
        IssueType issueType = resolution.getUniqueChild(IssueType.class);
        assert (issueType != null) : "'issueType' of method 'getIssueId' must not be null";
        return issueType.getIssueId();
    }

    @Override
    public final List<String> getNamedElementPatterns(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'getNamedElementPatterns' must not be null";
        IIssueId issueId = IssueProvider.getIssueId(resolution);
        if (!issueId.isResolvable()) {
            return null;
        }
        switch (issueId.getPatternEditMode()) {
            case DEPENDENCY: 
            case UNEDITABLE: {
                return null;
            }
            case ELEMENT: 
            case ELEMENT_AND_DEPENDENCY: {
                ArrayList<String> patterns = new ArrayList<String>();
                for (NamedElementWildcardPattern nextPattern : resolution.getChildren(NamedElementWildcardPattern.class)) {
                    patterns.add(nextPattern.getName());
                }
                return patterns;
            }
        }
        assert (false) : "Edit mode not handled: " + String.valueOf((Object)issueId.getPatternEditMode());
        return null;
    }

    @Override
    public final boolean isPatternEditable(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'isGenerated' must not be null";
        IIssueId issueId = IssueProvider.getIssueId(resolution);
        if (!issueId.isResolvable()) {
            return false;
        }
        switch (issueId.getPatternEditMode()) {
            case UNEDITABLE: {
                return false;
            }
            case ELEMENT: 
            case DEPENDENCY: 
            case ELEMENT_AND_DEPENDENCY: {
                return true;
            }
        }
        assert (false) : "Edit mode not handled: " + String.valueOf((Object)issueId.getPatternEditMode());
        return false;
    }

    @Override
    public final List<Pair<String, String>> getDependencyPatterns(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'getDependencyPatterns' must not be null";
        IIssueId issueId = IssueProvider.getIssueId(resolution);
        if (!issueId.isResolvable()) {
            return null;
        }
        switch (issueId.getPatternEditMode()) {
            case ELEMENT: 
            case UNEDITABLE: {
                return null;
            }
            case DEPENDENCY: 
            case ELEMENT_AND_DEPENDENCY: {
                ArrayList<Pair<String, String>> patterns = new ArrayList<Pair<String, String>>();
                for (DependencyWildcardPattern nextPattern : resolution.getChildren(DependencyWildcardPattern.class)) {
                    patterns.add((Pair<String, String>)new Pair((Object)nextPattern.getFromPattern(), (Object)nextPattern.getToPattern()));
                }
                return patterns;
            }
        }
        assert (false) : "Edit mode not handled: " + String.valueOf((Object)issueId.getPatternEditMode());
        return null;
    }

    private boolean addIssue(Issue issue, Collection<Issue> collector) {
        assert (collector != null) : "Parameter 'collector' of method 'addIssue' must not be null";
        if (issue != null && issue.isValid() && !issue.getId().getCategory().isGenerated() && issue.getId().isResolvable() && issue.getResolution() == null && !issue.previewOnly()) {
            collector.add(issue);
            return true;
        }
        return false;
    }

    private Set<Issue> getAssociatedResolvableIssues(IContext context, List<Element> elements, boolean firstOnly) {
        assert (context != null) : "Parameter 'context' of method 'getAssociatedResolvableIssues' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getAssociatedResolvableIssue' must not be empty";
        THashSet issues = new THashSet();
        block0: for (Element nextElement : elements) {
            if (!nextElement.isValid()) continue;
            if (nextElement instanceof Issue) {
                if (!this.addIssue((Issue)nextElement, (Collection<Issue>)issues) || !firstOnly) continue;
                return issues;
            }
            if (nextElement instanceof ISingleIssueProvider) {
                if (!this.addIssue(((ISingleIssueProvider)((Object)nextElement)).getAssociatedIssue(), (Collection<Issue>)issues) || !firstOnly) continue;
                return issues;
            }
            if (nextElement instanceof IDependencyWithIssues) {
                for (Issue issue : ((IDependencyWithIssues)((Object)nextElement)).getRelevantIssues()) {
                    if (!this.addIssue(issue, (Collection<Issue>)issues) || !firstOnly) continue;
                    return issues;
                }
                continue;
            }
            if (nextElement instanceof INamedElementAdapter) {
                for (NamedElement nextAdaptedTo : ((INamedElementAdapter)((Object)nextElement)).getAdaptedTo()) {
                    for (Issue issue : nextAdaptedTo.getIssues()) {
                        if (!this.addIssue(issue, (Collection<Issue>)issues) || !firstOnly) continue;
                        return issues;
                    }
                }
                continue;
            }
            if (nextElement instanceof IMetricValue) {
                IMetricValue metricValue = (IMetricValue)((Object)nextElement);
                IMetricDescriptor metricDescriptor = metricValue.getMetricDescriptor();
                IssueFilter issueFilter = new IssueFilter(new IStandardEnumeration[0]);
                issueFilter.add(ResolutionMode.NONE);
                issueFilter.add(ResolutionMode.TASK);
                issueFilter.add(ResolutionMode.IGNORE);
                issueFilter.add(CoreIssueId.THRESHOLD_VIOLATION);
                IssueList issueList = this.m_softwareSystem.getCurrentModel().getIssueList(issueFilter);
                if (issueList.isEmpty()) continue;
                for (Issue nextIssue : issueList.getIssues()) {
                    assert (nextIssue != null && nextIssue instanceof ThresholdViolationIssue) : "Unexpected class in method 'getIssueFromIssueProvider': " + String.valueOf(nextIssue);
                    ThresholdViolationIssue nextThresholdViolationIssue = (ThresholdViolationIssue)nextIssue;
                    if (nextThresholdViolationIssue.getThreshold().getMetricDescriptor() != metricDescriptor || metricValue.getAssociatedElement() != nextThresholdViolationIssue.getAffectedElement()) continue;
                    if (!this.addIssue(nextThresholdViolationIssue, (Collection<Issue>)issues) || !firstOnly) continue block0;
                    return issues;
                }
                continue;
            }
            if (!(nextElement instanceof ElementWithIssues)) continue;
            for (Issue issue : context.collectIssues((ElementWithIssues)nextElement, false)) {
                if (!this.addIssue(issue, (Collection<Issue>)issues) || !firstOnly) continue;
                return issues;
            }
        }
        return issues;
    }

    @Override
    public boolean associatedResolvableIssuesExist(IContext context, List<Element> elements) {
        assert (context != null) : "Parameter 'context' of method 'associatedResolvableIssuesExist' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'associatedResolvableIssuesExist' must not be empty";
        return !this.getAssociatedResolvableIssues(context, elements, true).isEmpty();
    }

    @Override
    public List<Issue> getAssociatedResolvableIssues(IContext context, List<Element> elements) {
        assert (context != null) : "Parameter 'context' of method 'getAssociatedResolvableIssues' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getAssociatedResolvableIssue' must not be empty";
        LOGGER.debug("Collect resolvable issues");
        Set<Issue> issues = this.getAssociatedResolvableIssues(context, elements, false);
        LOGGER.debug("Collect resolvable issues - done [" + issues.size() + "]");
        return new ArrayList<Issue>(issues);
    }

    private List<Element> collectElements(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'collectElements' must not be empty";
        ArrayList<Element> collected = new ArrayList<Element>();
        for (Element nextElement : elements) {
            if (nextElement instanceof INamedElementAdapter) {
                for (NamedElement namedElement : ((INamedElementAdapter)((Object)nextElement)).getAdaptedTo()) {
                    collected.add(namedElement);
                }
                continue;
            }
            if (nextElement instanceof IDependencyAdapter) {
                for (IDependency iDependency : ((IDependencyAdapter)((Object)nextElement)).getAdaptedTo()) {
                    collected.add(iDependency.getDependency());
                }
                continue;
            }
            if (nextElement instanceof Filter || nextElement instanceof Pattern) {
                return Collections.emptyList();
            }
            collected.add(nextElement);
        }
        return collected;
    }

    @Override
    public final DeleteRefactoringData isDeleteRefactoringPossible(List<Element> elements, StructureMode structureMode) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isDeleteRefactoringPossible' must not be empty";
        assert (structureMode != null) : "Parameter 'structureMode' of method 'isDeleteRefactoringPossible' must not be null";
        List<Element> collectedElements = this.collectElements(elements);
        return collectedElements.isEmpty() ? null : this.m_refactoringProvider.isDeleteRefactoringPossible(collectedElements, structureMode);
    }

    @Override
    public final MoveRenameRefactoringInfo isMoveRenameRefactoringPossible(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isMoveRenameRefactoringPossible' must not be empty";
        List<Element> collectedElements = this.collectElements(elements);
        return collectedElements.isEmpty() ? null : this.m_refactoringProvider.isMoveRenameRefactoringPossible(collectedElements);
    }

    @Override
    public final MoveRenameRefactoringInfo isPossibleMoveRefactoringTarget(MoveRenameRefactoringInfo info, Element potentialTarget) {
        assert (info != null) : "Parameter 'info' of method 'isPossibleMoveRefactoringTarget' must not be null";
        assert (potentialTarget != null) : "Parameter 'potentialTarget' of method 'isPossibleMoveRefactoringTarget' must not be null";
        return this.m_refactoringProvider.isPossibleMoveRefactoringTarget(info, potentialTarget);
    }

    @Override
    public final RefactoringData getMoveRenameRefactoringData(MoveRenameRefactoringInfo info) {
        assert (info != null) : "Parameter 'info' of method 'getMoveRenameRefactoringData' must not be null";
        return this.m_refactoringProvider.getMoveRenameRefactoringData(info);
    }

    @Override
    public List<Element> getShowInViewElementsForResolutionBasedView(List<Element> elements, Class<? extends Resolution> clazz) {
        assert (elements != null) : "Parameter 'elements' of method 'getShowInViewElementsForResolutionBasedView' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'getShowInViewElementsForResolutionBasedView' must not be null";
        ArrayList<Element> relevantElements = new ArrayList<Element>(elements.size());
        if (!elements.isEmpty()) {
            for (Element nextElement : elements) {
                Element nextElementToCheck = nextElement instanceof INamedElementNode ? ((INamedElementNode)((Object)nextElement)).getNamedElement() : nextElement;
                if (clazz.isAssignableFrom(nextElementToCheck.getClass())) {
                    relevantElements.add(nextElementToCheck);
                    continue;
                }
                Issue associatedIssue = null;
                if (nextElementToCheck instanceof Issue) {
                    associatedIssue = (Issue)nextElementToCheck;
                } else if (nextElementToCheck instanceof AnalyzerCycleGroup) {
                    associatedIssue = ((AnalyzerCycleGroup)nextElementToCheck).getAssociatedIssue();
                } else if (nextElementToCheck instanceof DuplicateCodeBlock) {
                    associatedIssue = ((DuplicateCodeBlock)nextElementToCheck).getAssociatedIssue();
                } else {
                    return Collections.emptyList();
                }
                if (associatedIssue == null) continue;
                Resolution resolution = (Resolution)associatedIssue.getResolution();
                if (resolution != null && clazz.isAssignableFrom(resolution.getClass())) {
                    relevantElements.add(resolution);
                    continue;
                }
                return Collections.emptyList();
            }
            return relevantElements;
        }
        return Collections.emptyList();
    }

    @Override
    public List<FilePath> getAffectedPhysicalSourceFiles(Issue issue) {
        NamedElement namedElement;
        assert (issue != null) : "Parameter 'issue' of method 'getAffectedPhysicalSourceFiles' must not be null";
        if (issue instanceof NamedElementIssue) {
            namedElement = ((NamedElementIssue)issue).getAffectedElement();
        } else {
            assert (issue instanceof DependencyIssue) : "Unexpected class in method 'getAffectedPhysicalSourceFiles': " + String.valueOf(issue);
            namedElement = ((DependencyIssue)issue).getAffectedElement().getUnderlyingFrom();
        }
        assert (namedElement != null) : "'namedElement' of method 'getAffectedPhysicalSourceFiles' must not be null";
        if (namedElement instanceof DuplicateCodeBlock) {
            DuplicateCodeBlock duplicateCodeBlock = (DuplicateCodeBlock)namedElement;
            List<DuplicateCodeBlockOccurrence> occurrences = duplicateCodeBlock.getChildren(DuplicateCodeBlockOccurrence.class);
            ArrayList<FilePath> affected = new ArrayList<FilePath>(occurrences.size());
            for (DuplicateCodeBlockOccurrence nextOccurrence : occurrences) {
                FilePath nextPhysicalFilePath = nextOccurrence.getSourceFile().getPhysicalFilePath();
                if (nextPhysicalFilePath == null) continue;
                affected.add(nextPhysicalFilePath);
            }
            return affected;
        }
        if (namedElement instanceof AnalyzerCycleGroup) {
            AnalyzerCycleGroup analyzerCycleGroup = (AnalyzerCycleGroup)namedElement;
            if (analyzerCycleGroup.getCycleGroupIssueId() == CoreIssueId.COMPONENT_CYCLE_GROUP) {
                Set<NamedElement> cyclics = analyzerCycleGroup.getCyclicNamedElements();
                ArrayList<FilePath> affected = new ArrayList<FilePath>(cyclics.size());
                for (NamedElement nextCyclic : cyclics) {
                    FilePath nextPhysicalFilePath;
                    if (!(nextCyclic instanceof SourceFile) || (nextPhysicalFilePath = ((SourceFile)nextCyclic).getPhysicalFilePath()) == null) continue;
                    affected.add(nextPhysicalFilePath);
                }
                return affected;
            }
            return Collections.emptyList();
        }
        Language language = namedElement.getLanguage();
        if (language != null) {
            FilePath physicalFilePath;
            LanguageProvider languageProvider = this.m_languageProviderAccessor.getLanguageProvider(language);
            assert (languageProvider != null) : "Parameter 'languageProvider' of method 'getAffectedPhysicalSourceFiles' must not be null";
            FilePath sourceFile = languageProvider.getSourceFile(namedElement);
            if (sourceFile != null && sourceFile instanceof SourceFile && (physicalFilePath = ((SourceFile)sourceFile).getPhysicalFilePath()) != null) {
                return Collections.singletonList(physicalFilePath);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public final List<RefactoringDefinition> getRefactoringDefinitions(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getRefactoringDefinitions' must not be null";
        List<RefactoringDefinition> existingRefactoringDefinitions = this.m_softwareSystem.getCurrentModel().getChildren(RefactoringDefinition.class);
        THashSet matchingRefactoringDefinitions = new THashSet();
        for (Element element : elements) {
            Element candidate;
            if (element instanceof IDiffElement) {
                candidate = ((IDiffElement)((Object)element)).getCurrentElement();
                if (candidate == null) {
                    continue;
                }
            } else {
                candidate = element;
            }
            if (candidate instanceof RefactoringDefinition) {
                matchingRefactoringDefinitions.add((RefactoringDefinition)candidate);
                continue;
            }
            if (!candidate.hasBeenDirectlyRefactored()) continue;
            for (RefactoringDefinition nextRefactoringDefinition : existingRefactoringDefinitions) {
                for (IIssue nextIssueAccessor : nextRefactoringDefinition.getAssociatedIssues()) {
                    if (nextIssueAccessor.getAffectedElement() != candidate) continue;
                    matchingRefactoringDefinitions.add(nextRefactoringDefinition);
                }
            }
        }
        return new ArrayList<RefactoringDefinition>((Collection<RefactoringDefinition>)matchingRefactoringDefinitions);
    }

    @Override
    public List<Issue> getIssues(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getIssues' must not be null";
        ArrayList<Issue> issues = new ArrayList<Issue>();
        Iterator<Element> iterator = elements.iterator();
        while (iterator.hasNext()) {
            Issue issue;
            Element nextElement;
            Element element = nextElement = iterator.next();
            if (nextElement instanceof IIssueDiff) {
                element = ((IIssueDiff)((Object)nextElement)).getCurrent();
                if (element == null) {
                    continue;
                }
            } else if (nextElement instanceof IssueRank) {
                element = ((IssueRank)nextElement).getRankedElement();
            }
            if (!(element instanceof NamedElementIssue) && !(element instanceof DependencyIssue) || (issue = (Issue)element).getId().previewOnly() || issue.getResolution() != null) continue;
            issues.add(issue);
        }
        return issues;
    }

    @Override
    public List<Resolution> getResolutionsForMatchingInfoUpdate(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'isUpdateOfMatchingInfoPossible' must not be null";
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        List resolutions = elements.stream().filter(e -> e instanceof Resolution).map(e -> (Resolution)e).collect(Collectors.toList());
        List<Resolution> updatableResolutions = resolutions.stream().filter(r -> r.getResolutionMatchingConfidenceAsDouble() != null && Double.compare(r.getResolutionMatchingConfidenceAsDouble(), 0.0) > 0).collect(Collectors.toList());
        return updatableResolutions;
    }

    @Override
    public final List<NamedElement> getRelevantNamedElements(RefactoringDefinition refactoringDefinition) {
        assert (refactoringDefinition != null) : "Parameter 'refactoringDefinition' of method 'getRelevantNamedElements' must not be null";
        ArrayList<NamedElement> relevant = new ArrayList<NamedElement>();
        if (refactoringDefinition instanceof DeleteRefactoringDefinition) {
            for (IIssue issue : refactoringDefinition.getAssociatedIssues()) {
                Element element = issue.getAffectedElement();
                if (!(element instanceof NamedElement)) continue;
                relevant.add(((NamedElement)element).getOriginal());
            }
        } else {
            assert (refactoringDefinition != null && refactoringDefinition instanceof LanguageSpecificRefactoringDefinition) : "Unexpected class in method 'getRelevantNamedElements': " + String.valueOf(refactoringDefinition);
            MoveRenameRefactoringElementType elementType = ((LanguageSpecificRefactoringDefinition)refactoringDefinition).getRefactoringElementType();
            switch (elementType) {
                case COMPONENT: {
                    for (IIssue issue : refactoringDefinition.getAssociatedIssues()) {
                        Element element = issue.getAffectedElement();
                        if (!(element instanceof NamedElement) || !(element instanceof IComponent)) continue;
                        relevant.add(((NamedElement)element).getOriginal());
                    }
                    break;
                }
                case DIRECTORY: {
                    for (IIssue issue : refactoringDefinition.getAssociatedIssues()) {
                        Element element = issue.getAffectedElement();
                        if (!(element instanceof NamedElement) || !(element instanceof DirectoryFragment)) continue;
                        relevant.add(((NamedElement)element).getOriginal());
                    }
                    break;
                }
                case ELEMENT: {
                    for (IIssue issue : refactoringDefinition.getAssociatedIssues()) {
                        Element element = issue.getAffectedElement();
                        if (!(element instanceof NamedElement) || !(element instanceof ProgrammingElement)) continue;
                        relevant.add(((NamedElement)element).getOriginal());
                    }
                    break;
                }
                case NAMESPACE: {
                    for (IIssue issue : refactoringDefinition.getAssociatedIssues()) {
                        Element element = issue.getAffectedElement();
                        if (!(element instanceof NamedElement) || !(element instanceof NamespaceFragment)) continue;
                        relevant.add(((NamedElement)element).getOriginal());
                    }
                    break;
                }
                default: {
                    if ($assertionsDisabled) break;
                    throw new AssertionError((Object)("Unhandled element type: " + String.valueOf((Object)elementType)));
                }
            }
        }
        return relevant;
    }
}

