/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.FinishModelVisitor;
import com.hello2morrow.sonargraph.core.controller.system.IFinishModelRefreshProcessor;
import com.hello2morrow.sonargraph.core.controller.system.ISoftwareSystenClearProcessor;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.LogicalModelProvider;
import com.hello2morrow.sonargraph.core.controller.system.ModelValidator;
import com.hello2morrow.sonargraph.core.controller.system.NotificationExtension;
import com.hello2morrow.sonargraph.core.controller.system.RootDirectoryPathValidator;
import com.hello2morrow.sonargraph.core.controller.system.SizeCheck;
import com.hello2morrow.sonargraph.core.controller.system.TransactionContextUpdater;
import com.hello2morrow.sonargraph.core.controller.system.base.AnalyzerConfigurationChangeMode;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controller.system.base.ModelModificationInfo;
import com.hello2morrow.sonargraph.core.controllerinterface.common.ILicenseProvider;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableDirectoryPathCreatedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableDirectoryPathDeletedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableDirectoryPathModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileCreatedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileDeletedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.MultipleModifiableFileModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemClosedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemIssuesModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemOpenedEvent;
import com.hello2morrow.sonargraph.core.model.path.IModifiableDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.IssueDelta;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.NeedsReparse;
import com.hello2morrow.sonargraph.core.model.system.Notification;
import com.hello2morrow.sonargraph.core.model.system.ParserModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.transaction.TransactionContext;
import com.hello2morrow.sonargraph.core.model.transaction.TransactionType;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FinishModelProcessor
implements IFinishModelRefreshProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FinishModelProcessor.class);
    private final ArrayDeque<TransactionContext> m_transactionContexts = new ArrayDeque();
    private final List<ISoftwareSystemLifecycleListener> m_listeners = new ArrayList<ISoftwareSystemLifecycleListener>();
    private final ModelModificationInfo m_modelModificationInfo = new ModelModificationInfo();
    private final LanguageProviderAccessor m_accessor;
    private final ILicenseProvider m_licenseProvider;
    private final NotificationExtension m_notificationExtension;
    private final LogicalModelProvider m_logicalNamespaceProvider;
    private final ScriptOutputStreamProvider m_scriptOutputStreamProvider;
    private final SizeCheck m_sizeCheck;
    private Set<String> m_debugInfo;
    private long m_txCounter = 0L;

    FinishModelProcessor(LanguageProviderAccessor accessor, ILicenseProvider licenseProvider, NotificationExtension notificationExtension, ScriptOutputStreamProvider scriptOutputStreamProvider) {
        assert (accessor != null) : "Parameter 'accessor' of method 'FinishModelExtension' must not be null";
        assert (licenseProvider != null) : "Parameter 'licenseProvider' of method 'FinishModelExtension' must not be null";
        assert (notificationExtension != null) : "Parameter 'notificationExtension' of method 'FinishModelExtension' must not be null";
        assert (scriptOutputStreamProvider != null) : "Parameter 'scriptOutputStreamProvider' of method 'FinishModelProcessor' must not be null";
        this.m_accessor = accessor;
        this.m_licenseProvider = licenseProvider;
        this.m_notificationExtension = notificationExtension;
        this.m_scriptOutputStreamProvider = scriptOutputStreamProvider;
        this.m_logicalNamespaceProvider = new LogicalModelProvider(accessor);
        this.m_sizeCheck = new SizeCheck(accessor, licenseProvider, notificationExtension);
        this.m_licenseProvider.getUserInfo().forEach(i -> this.m_notificationExtension.add((String)i, Severity.INFO, Notification.Source.MODEL, true));
    }

    @Override
    public void addListener(ISoftwareSystemLifecycleListener listener) {
        assert (listener != null) : "Parameter 'listener' of method 'addListener' must not be null";
        assert (!this.m_listeners.contains(listener)) : "Already added: " + String.valueOf(listener);
        this.m_listeners.add(listener);
    }

    void release(Installation installation, SoftwareSystem softwareSystem) {
        assert (installation != null) : "Parameter 'installation' of method 'release' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'release' must not be null";
        for (ISoftwareSystemLifecycleListener nextExtension : softwareSystem.getExtensions(ISoftwareSystemLifecycleListener.class)) {
            if (installation.hasExtension(nextExtension)) continue;
            this.m_listeners.remove(nextExtension);
        }
    }

    ScriptOutputStreamProvider getScriptOutputStreamProvider() {
        return this.m_scriptOutputStreamProvider;
    }

    @Override
    public ILicenseProvider getLicenseProvider() {
        return this.m_licenseProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performFinishModelModification(IWorkerContext workerContext, SoftwareSystem softwareSystem, IFilePathListener filePathListener, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'process' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'process' must not be null";
        assert (result != null) : "Parameter 'result' of method 'performFinishModelModification' must not be null";
        if (softwareSystem.getState() == SoftwareSystemState.MODEL_LOADED) {
            workerContext.working("Finish model", true);
            FinishModelVisitor.process(softwareSystem, this.m_accessor, workerContext);
            workerContext.working("Perfom size check", false);
            this.m_sizeCheck.performSizeCheck(softwareSystem, filePathListener, result);
        }
        workerContext.working("Create logical namespaces", false);
        this.m_logicalNamespaceProvider.recreate(softwareSystem);
        FinishModelProcessor finishModelProcessor = this;
        synchronized (finishModelProcessor) {
            this.m_modelModificationInfo.logicalModelModified();
        }
    }

    @Override
    public synchronized void architectureModelModified() {
        this.m_modelModificationInfo.architectureModelModified();
    }

    private void dispatchEvents(SoftwareSystem softwareSystem, EnumSet<Modification> modification, List<IModifiableFile> createdFiles, List<IModifiableFile> modifiedFiles, List<IModifiableFile> modifiedAdditionalInfoFiles, List<IModifiableFile> reloadedFiles, List<IModifiableFile> savedFiles, List<IModifiableFile> deletedFiles, List<IModifiableDirectory> createdDirectories, List<IModifiableDirectory> modifiedDirectories, List<IModifiableDirectory> deletedDirectories, IOriginator originator) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'dispatchEvents' must not be null";
        assert (modification != null) : "Parameter 'modification' of method 'dispatchEvents' must not be null";
        assert (modifiedAdditionalInfoFiles != null) : "Parameter 'modifiedAdditionalInfoFiles' of method 'dispatchEvents' must not be null";
        assert (createdFiles != null) : "Parameter 'createdFiles' of method 'dispatchEvents' must not be null";
        assert (reloadedFiles != null) : "Parameter 'reloadedFiles' of method 'dispatchEvents' must not be null";
        assert (savedFiles != null) : "Parameter 'savedFiles' of method 'dispatchEvents' must not be null";
        assert (deletedFiles != null) : "Parameter 'deletedFiles' of method 'dispatchEvents' must not be null";
        assert (createdDirectories != null) : "Parameter 'createdDirectories' of method 'dispatchEvents' must not be null";
        assert (modifiedDirectories != null) : "Parameter 'modifiedDirectories' of method 'dispatchEvents' must not be null";
        assert (deletedDirectories != null) : "Parameter 'deletedDirectories' of method 'dispatchEvents' must not be null";
        ISoftwareSystemProvider provider = softwareSystem.getExtension(ISoftwareSystemProvider.class);
        if (!modification.isEmpty()) {
            EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(new SoftwareSystemModifiedEvent(provider, modification)));
        }
        if (!createdFiles.isEmpty()) {
            EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(new ModifiableFileCreatedEvent(provider, createdFiles)));
        }
        LinkedHashSet<IModifiableFile> allModifiedFiles = new LinkedHashSet<IModifiableFile>(modifiedFiles);
        allModifiedFiles.addAll(modifiedAdditionalInfoFiles);
        allModifiedFiles.addAll(reloadedFiles);
        allModifiedFiles.addAll(savedFiles);
        allModifiedFiles.removeAll(deletedFiles);
        if (!allModifiedFiles.isEmpty()) {
            MultipleModifiableFileModifiedEvent event = new MultipleModifiableFileModifiedEvent(provider);
            for (IModifiableFile next : allModifiedFiles) {
                EnumSet<MultipleModifiableFileModifiedEvent.Aspect> aspects = EnumSet.noneOf(MultipleModifiableFileModifiedEvent.Aspect.class);
                if (modifiedFiles.contains(next) || reloadedFiles.contains(next)) {
                    aspects.add(MultipleModifiableFileModifiedEvent.Aspect.CONTENT_MODIFIED);
                }
                if (modifiedAdditionalInfoFiles.contains(next)) {
                    aspects.add(MultipleModifiableFileModifiedEvent.Aspect.ADDITIONAL_INFO_MODIFIED);
                }
                if (savedFiles.contains(next)) {
                    aspects.add(MultipleModifiableFileModifiedEvent.Aspect.SAVED);
                }
                event.add(next, originator, aspects);
            }
            EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(event));
        }
        if (!deletedFiles.isEmpty()) {
            EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(new ModifiableFileDeletedEvent(provider, deletedFiles)));
        }
        if (!createdDirectories.isEmpty()) {
            EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(new ModifiableDirectoryPathCreatedEvent(provider, createdDirectories)));
        }
        if (!modifiedDirectories.isEmpty()) {
            EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(new ModifiableDirectoryPathModifiedEvent(provider, modifiedDirectories)));
        }
        if (!deletedDirectories.isEmpty()) {
            EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(new ModifiableDirectoryPathDeletedEvent(provider, deletedDirectories)));
        }
    }

    @Override
    public void aboutToPerformRefresh(IWorkerContext workerContext, SoftwareSystem softwareSystem) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'aboutToPerformRefresh' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToPerformRefresh' must not be null";
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        this.m_listeners.forEach(l -> l.aboutToRefresh(workerContext, softwareSystem, modifications));
        if (!modifications.isEmpty()) {
            this.finishModification(softwareSystem, modifications);
        }
    }

    @Override
    public VirtualModel aboutToPerformParserModelRefresh(IWorkerContext workerContext, SoftwareSystem softwareSystem) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'aboutToPerformParserModelRefresh' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToPerformParserModelRefresh' must not be null";
        this.m_listeners.forEach(l -> l.aboutToModifyParserModel(workerContext, softwareSystem));
        VirtualModel currentModel = softwareSystem.getCurrentModel();
        ParserModel factsModel = softwareSystem.getParserModel();
        if (currentModel != factsModel) {
            assert (currentModel instanceof ModifiableModel) : "Unexpected class in method 'aboutToPerformRefresh': " + String.valueOf(currentModel);
            softwareSystem.setModel(factsModel);
            return currentModel;
        }
        return null;
    }

    @Override
    public void parserModelRefreshPerformed(IWorkerContext workerContext, SoftwareSystem softwareSystem, VirtualModel resetTo, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'parserModelRefreshPerformed' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'parserModelRefreshPerformed' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshPerformed' must not be null";
        workerContext.setNumberOfSteps(this.m_listeners.size());
        for (ISoftwareSystemLifecycleListener listener : this.m_listeners) {
            workerContext.working("Execute " + listener.getClass().getSimpleName(), false);
            listener.parserModelRefreshPerformed(workerContext, softwareSystem, result);
            workerContext.endStep();
        }
        if (resetTo != null) {
            softwareSystem.setModel(resetTo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SoftwareSystemEvent> notifyModelModificationFinished(IWorkerContext workerContext, SoftwareSystem softwareSystem, EnumSet<Modification> modificationsForDispatch, List<SoftwareSystemEvent> eventsToDispatch, List<IModifiableFile> restoredFiles, INavigationState navigationState) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'notifyModelModificationFinished' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'notifyModelModificationFinished' must not be null";
        assert (modificationsForDispatch != null) : "Parameter 'modificationsForDispatch' of method 'notifyModelModificationFinished' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'notifyModelModificationFinished' must not be null";
        EnumSet<ModelModificationInfo.ModelModification> consumedModelModifications = null;
        FinishModelProcessor finishModelProcessor = this;
        synchronized (finishModelProcessor) {
            VirtualModel virtualModel = softwareSystem.getCurrentModel();
            consumedModelModifications = this.m_modelModificationInfo.consumeModelModifications(modificationsForDispatch, virtualModel.consumeRefactoringsModified(), virtualModel.haveIssuesBeenModified());
        }
        for (ISoftwareSystemLifecycleListener nextListener : this.m_listeners) {
            nextListener.modelModificationFinished(workerContext, softwareSystem, consumedModelModifications, eventsToDispatch, restoredFiles, navigationState);
        }
        workerContext.working("Model modification finished", true);
        return eventsToDispatch;
    }

    private void consumeIssuesDelta(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'consumeIssuesDelta' must not be null";
        IssueDelta issueDelta = softwareSystem.getCurrentModel().consumeIssueDelta();
        if (EventManager.getInstance().isEventHandled(SoftwareSystemIssuesModifiedEvent.class)) {
            EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(new SoftwareSystemIssuesModifiedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), issueDelta)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishParserModelModification(IWorkerContext workerContext, SoftwareSystem softwareSystem, IFilePathListener filePathListener, OperationResult result, boolean onSystemOpen) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishParserModelModification' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishParserModelModification' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishParserModelModification' must not be null";
        workerContext.working("Finish parser model modification", true);
        EnumSet<Modification> modificationsForDispatch = !onSystemOpen ? EnumSet.of(Modification.WORKSPACE_MODIFIED, Modification.PARSER_MODEL_MODIFIED) : EnumSet.noneOf(Modification.class);
        Files files = softwareSystem.getUniqueExistingChild(Files.class);
        List<IModifiableFile> createdFiles = null;
        List<IModifiableFile> modifiedFiles = null;
        Map<IModifiableFile, String> pathModifiedFiles = null;
        List<IModifiableFile> modifiedAdditionalInfoFiles = null;
        List<IModifiableFile> reloadedFiles = null;
        List<IModifiableFile> savedFiles = null;
        List<IModifiableFile> deletedFiles = null;
        List<IModifiableDirectory> createdDirectories = null;
        List<IModifiableDirectory> modifiedDirectories = null;
        List<IModifiableDirectory> deletedDirectories = null;
        this.m_scriptOutputStreamProvider.clearAllOutputStreams();
        ArrayList<SoftwareSystemEvent> eventsToDispatch = new ArrayList<SoftwareSystemEvent>();
        FinishModelProcessor finishModelProcessor = this;
        synchronized (finishModelProcessor) {
            this.m_listeners.forEach(l -> l.parserModelModified(workerContext, softwareSystem, onSystemOpen, result));
            ModifiableModel model = this.getModifiableModelNeedingApply(softwareSystem, !onSystemOpen);
            if (model != null) {
                model.startApplication(true);
                model.applyRefactoringResolutions(workerContext);
            }
            this.performFinishModelModification(workerContext, softwareSystem, filePathListener, result);
            this.m_listeners.forEach(l -> l.componentModelModified(workerContext, softwareSystem, onSystemOpen));
            this.m_modelModificationInfo.physicalModelModified();
            softwareSystem.removeIssuesOfInvalidElements();
            if (model != null) {
                model.applyNonRefactoringResolutions(workerContext, !onSystemOpen);
                model.finishApplication(workerContext);
            }
            if (!onSystemOpen) {
                this.notifyModelModificationFinished(workerContext, softwareSystem, modificationsForDispatch, eventsToDispatch, null, null);
                createdFiles = files.consumeCreatedModifiableFiles();
                modifiedFiles = files.consumeModifiedModifiableFiles();
                pathModifiedFiles = files.consumePathModifiedModifiableFiles();
                modifiedAdditionalInfoFiles = files.consumeAdditionalInformationModifiedModifiableFiles();
                reloadedFiles = files.consumeReloadedModifiableFiles();
                savedFiles = files.consumeSavedModifiableFiles();
                deletedFiles = files.consumeDeletedModifiableFiles();
                createdDirectories = files.consumeCreatedModifiableDirectoryPaths();
                modifiedDirectories = files.consumeModifiedModifiableDirectoryPaths();
                deletedDirectories = files.consumeDeletedModifiableDirectoryPaths();
                this.updateTransactionContext(softwareSystem, modificationsForDispatch, modifiedFiles, savedFiles, createdFiles, deletedFiles, reloadedFiles, softwareSystem.consumeNeedsReparseModification(), TransactionContext.ModelFinishedMode.PARSER_MODEL);
            } else {
                VirtualModel virtualModel = softwareSystem.getCurrentModel();
                this.m_modelModificationInfo.consumeModelModifications(null, virtualModel.consumeRefactoringsModified(), virtualModel.haveIssuesBeenModified());
                this.updateTransactionContext(softwareSystem, modificationsForDispatch, null, null, null, null, null, softwareSystem.consumeNeedsReparseModification(), TransactionContext.ModelFinishedMode.PARSER_MODEL);
            }
        }
        ModelValidator.validate(softwareSystem, true);
        if (!onSystemOpen) {
            this.consumeIssuesDelta(softwareSystem);
            eventsToDispatch.forEach(e -> EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(e)));
            this.dispatchEvents(softwareSystem, modificationsForDispatch, createdFiles, modifiedFiles, modifiedAdditionalInfoFiles, reloadedFiles, savedFiles, deletedFiles, createdDirectories, modifiedDirectories, deletedDirectories, null);
            this.updateScriptOutputStreams(pathModifiedFiles, deletedFiles);
        } else {
            softwareSystem.getCurrentModel().consumeIssueDelta();
        }
        this.clearDebugInfo();
    }

    @Override
    public void finishParserModelModification(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishParserModelModification' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishParserModelModification' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishParserModelModification' must not be null";
        this.finishParserModelModification(workerContext, softwareSystem, null, result, false);
    }

    void finishSoftwareSystemCreate(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishSoftwareSystemCreate' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishSoftwareSystemCreate' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemCreate' must not be null";
        this.m_listeners.forEach(l -> l.initialized(workerContext, softwareSystem, result));
        ModifiableModel model = this.getModifiableModelNeedingApply(softwareSystem, false);
        if (model != null) {
            model.startApplication(false);
            model.finishApplication(workerContext);
        }
        softwareSystem.getUniqueExistingChild(Files.class).consumeAllModifiablePaths();
        ModelValidator.validate(softwareSystem, false);
        EventManager.getInstance().dispatch((Object)this, (Event)new SoftwareSystemOpenedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishSoftwareSystemOpen(IWorkerContext workerContext, SoftwareSystem softwareSystem, IFilePathListener filePathListener, boolean snapshotApplied, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishSoftwareSystemOpen' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishSoftwareSystemOpen' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemOpen' must not be null";
        this.m_listeners.forEach(l -> l.initialized(workerContext, softwareSystem, result));
        if (snapshotApplied) {
            this.finishParserModelModification(workerContext, softwareSystem, filePathListener, result, true);
        } else {
            this.m_listeners.forEach(l -> l.componentModelModified(workerContext, softwareSystem, true));
            FinishModelProcessor finishModelProcessor = this;
            synchronized (finishModelProcessor) {
                this.m_modelModificationInfo.physicalModelModified();
            }
            ModifiableModel model = this.getModifiableModelNeedingApply(softwareSystem, true);
            if (model != null) {
                model.startApplication(false);
                model.applyNonRefactoringResolutions(workerContext, true);
                model.finishApplication(workerContext);
            }
            Workspace workspace = softwareSystem.getUniqueExistingChild(Workspace.class);
            workspace.getChildren(Module.class).forEach(m -> m.getChildren(RootDirectoryPath.class).forEach(r -> {
                boolean bl = RootDirectoryPathValidator.validate(r);
            }));
            workspace.getChildren(External.class).forEach(e -> e.getChildren(RootDirectoryPath.class).forEach(r -> {
                boolean bl = RootDirectoryPathValidator.validate(r);
            }));
            this.performFinishModelModification(workerContext, softwareSystem, filePathListener, result);
            ModelValidator.validate(softwareSystem, false);
        }
        softwareSystem.getUniqueExistingChild(Files.class).consumeAllModifiablePaths();
        EventManager.getInstance().dispatch((Object)this, (Event)new SoftwareSystemOpenedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishSoftwareSystemSaveAs(IWorkerContext workerContext, SoftwareSystem softwareSystem, EnumSet<Modification> modifications, OperationResult result, TFile oldSystemDirectory) {
        TFile newBaseDir;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishSoftwareSystemSaveAs' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishSoftwareSystemSaveAs' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'finishSoftwareSystemSaveAs' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemSaveAs' must not be null";
        assert (oldSystemDirectory != null) : "Parameter 'oldSystemDirectory' of method 'finishSoftwareSystemSaveAs' must not be null";
        EnumSet<Modification> modificationsForDispatch = EnumSet.copyOf(modifications);
        ArrayList<SoftwareSystemEvent> eventsToDispatch = new ArrayList<SoftwareSystemEvent>();
        TFile oldBaseDir = oldSystemDirectory.getParentFile();
        boolean baseDirChanged = !FileUtility.areEqual((TFile)oldBaseDir, (TFile)(newBaseDir = new TFile(softwareSystem.getBaseDirectory())));
        FinishModelProcessor finishModelProcessor = this;
        synchronized (finishModelProcessor) {
            this.notifyModelModificationFinished(workerContext, softwareSystem, modificationsForDispatch, eventsToDispatch, null, null);
            this.m_listeners.forEach(l -> l.savedAs(softwareSystem, eventsToDispatch, modificationsForDispatch, oldSystemDirectory, result, baseDirChanged));
            softwareSystem.getUniqueExistingChild(Files.class).consumeAllModifiablePaths();
        }
        ModelValidator.validate(softwareSystem, false);
        this.consumeIssuesDelta(softwareSystem);
        eventsToDispatch.forEach(e -> EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(e)));
        EventManager.getInstance().dispatch((Object)this, (Event)new SoftwareSystemModifiedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), modificationsForDispatch));
    }

    void notifyParserModelModification(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'notifyParserModelModification' must not be null";
        EventManager.getInstance().dispatch((Object)this, (Event)new SoftwareSystemModifiedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), EnumSet.of(Modification.PARSER_MODEL_MODIFIED)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishSoftwareSystemClose(SoftwareSystem softwareSystem, OperationResult result) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishSoftwareSystemOpen' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemClose' must not be null";
        this.m_accessor.getLanguageProviders(softwareSystem.getUsedLanguages()).forEach(lp -> lp.softwareSystemClosed(softwareSystem));
        this.m_scriptOutputStreamProvider.releaseAllOutputStreams();
        FinishModelVisitor.reset(this.m_accessor, null);
        ArrayList eventsToDispatch = new ArrayList();
        this.m_listeners.forEach(l -> l.released(softwareSystem, eventsToDispatch, result));
        eventsToDispatch.forEach(e -> EventManager.getInstance().dispatch((Object)this, (Event)e));
        softwareSystem.setState(SoftwareSystemState.CLOSED);
        FinishModelProcessor finishModelProcessor = this;
        synchronized (finishModelProcessor) {
            VirtualModel virtualModel = softwareSystem.getCurrentModel();
            this.m_modelModificationInfo.consumeModelModifications(null, virtualModel.consumeRefactoringsModified(), virtualModel.haveIssuesBeenModified());
        }
        EventManager.getInstance().dispatch((Object)this, (Event)new SoftwareSystemClosedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performSoftwareSystemClear(IWorkerContext workerContext, SoftwareSystem softwareSystem, boolean onSystemRefresh, OperationResult result, ISoftwareSystenClearProcessor processor) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'performSoftwareSystemClear' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'performSoftwareSystemClear' must not be null";
        assert (onSystemRefresh || !softwareSystem.getUniqueExistingChild(Files.class).modifiableFilesOrDirectoriesModified(false)) : "There are modifiable file modifications in 'performSoftwareSystemClear'";
        assert (result != null) : "Parameter 'result' of method 'performSoftwareSystemClear' must not be null";
        assert (processor != null) : "Parameter 'processor' of method 'performSoftwareSystemClear' must not be null";
        ArrayList eventsToDispatch = new ArrayList();
        EnumSet<Modification> modificationsForDispatch = EnumSet.of(Modification.WORKSPACE_MODIFIED, Modification.WORKSPACE_CLEARED);
        FinishModelProcessor finishModelProcessor = this;
        synchronized (finishModelProcessor) {
            ModifiableModel model = this.getModifiableModelNeedingApply(softwareSystem, true);
            if (model != null) {
                model.startApplication(true);
            }
            this.m_listeners.forEach(l -> l.aboutToClear(workerContext, softwareSystem, eventsToDispatch, result));
            processor.process();
            this.m_logicalNamespaceProvider.clear(softwareSystem);
            this.m_listeners.forEach(l -> l.cleared(workerContext, softwareSystem, eventsToDispatch, result));
            softwareSystem.removeIssuesOfInvalidElements();
            softwareSystem.getUniqueExistingChild(Workspace.class).getWorkspaceFilter().clear();
            this.m_licenseProvider.resetAdditionalLicenseInfo();
            FinishModelVisitor.reset(this.m_accessor, softwareSystem);
            if (model != null) {
                model.applyNonRefactoringResolutions(workerContext, true);
                model.finishApplication(workerContext);
            }
            VirtualModel virtualModel = softwareSystem.getCurrentModel();
            this.m_modelModificationInfo.consumeModelModifications(modificationsForDispatch, virtualModel.consumeRefactoringsModified(), virtualModel.haveIssuesBeenModified());
        }
        this.updateTransactionContext(softwareSystem, modificationsForDispatch, null, null, null, null, null, softwareSystem.consumeNeedsReparseModification(), null);
        this.m_scriptOutputStreamProvider.clearAllOutputStreams();
        this.m_notificationExtension.clear(Notification.Source.MODEL);
        ModelValidator.validate(softwareSystem, false);
        this.consumeIssuesDelta(softwareSystem);
        eventsToDispatch.forEach(e -> EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(e)));
        EventManager.getInstance().dispatch((Object)this, (Event)new SoftwareSystemModifiedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), modificationsForDispatch));
    }

    private ModifiableModel getModifiableModelNeedingApply(SoftwareSystem softwareSystem, boolean forceNeedsApply) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getModifiableModelNeedingApply' must not be null";
        ModifiableModel modifiableModel = softwareSystem.getCurrentModel(ModifiableModel.class);
        if (modifiableModel != null) {
            if (modifiableModel.needsApplication()) {
                return modifiableModel;
            }
            if (forceNeedsApply) {
                modifiableModel.setNeedsApplication();
                return modifiableModel;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishModification(IWorkerContext workerContext, SoftwareSystem softwareSystem, EnumSet<Modification> modifications, IOriginator originator, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishModification' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishModification' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'finishModification' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishModification' must not be null";
        EnumSet<Modification> modificationsForDispatch = EnumSet.copyOf(modifications);
        Files files = softwareSystem.getUniqueExistingChild(Files.class);
        List<IModifiableFile> createdFiles = null;
        List<IModifiableFile> modifiedFiles = null;
        List<IModifiableFile> modifiedAdditionalInfoFiles = null;
        List<IModifiableFile> reloadedFiles = null;
        List<IModifiableFile> savedFiles = null;
        List<IModifiableFile> deletedFiles = null;
        Map<IModifiableFile, String> pathModifiedFiles = null;
        List<IModifiableDirectory> createdDirectories = null;
        List<IModifiableDirectory> modifiedDirectories = null;
        List<IModifiableDirectory> deletedDirectories = null;
        boolean workspaceModified = modifications.contains((Object)Modification.WORKSPACE_MODIFIED) || modifications.contains((Object)Modification.WORKSPACE_FILTER_MODIFIED);
        ArrayList<SoftwareSystemEvent> eventsToDispatch = new ArrayList<SoftwareSystemEvent>();
        FinishModelProcessor finishModelProcessor = this;
        synchronized (finishModelProcessor) {
            ModifiableModel model = this.getModifiableModelNeedingApply(softwareSystem, false);
            if (model != null) {
                boolean applyRefactorings = workspaceModified || modifications.contains((Object)Modification.REFACTORINGS_MODIFIED) || modifications.contains((Object)Modification.VIRTUAL_MODEL_CHANGED);
                model.startApplication(applyRefactorings);
                if (applyRefactorings) {
                    model.applyRefactoringResolutions(workerContext);
                }
            }
            if (workspaceModified || this.m_modelModificationInfo.haveRefactoringsBeenModified() || softwareSystem.getCurrentModel().haveRefactoringsBeenModified()) {
                this.performFinishModelModification(workerContext, softwareSystem, null, result);
                this.m_listeners.forEach(l -> l.componentModelModified(workerContext, softwareSystem, false));
                softwareSystem.removeIssuesOfInvalidElements();
                this.m_modelModificationInfo.physicalModelModified();
            }
            if (model != null) {
                model.applyNonRefactoringResolutions(workerContext, !modifications.contains((Object)Modification.VIRTUAL_MODEL_CHANGED) && !modifications.contains((Object)Modification.VIRTUAL_MODEL_MODIFIED));
                model.finishApplication(workerContext);
            }
            this.notifyModelModificationFinished(workerContext, softwareSystem, modificationsForDispatch, eventsToDispatch, null, null);
            createdFiles = files.consumeCreatedModifiableFiles();
            modifiedFiles = files.consumeModifiedModifiableFiles();
            pathModifiedFiles = files.consumePathModifiedModifiableFiles();
            modifiedAdditionalInfoFiles = files.consumeAdditionalInformationModifiedModifiableFiles();
            reloadedFiles = files.consumeReloadedModifiableFiles();
            savedFiles = files.consumeSavedModifiableFiles();
            deletedFiles = files.consumeDeletedModifiableFiles();
            createdDirectories = files.consumeCreatedModifiableDirectoryPaths();
            modifiedDirectories = files.consumeModifiedModifiableDirectoryPaths();
            deletedDirectories = files.consumeDeletedModifiableDirectoryPaths();
            this.updateTransactionContext(softwareSystem, modificationsForDispatch, modifiedFiles, savedFiles, createdFiles, deletedFiles, reloadedFiles, softwareSystem.consumeNeedsReparseModification(), TransactionContext.ModelFinishedMode.NON_PARSER_MODEL);
        }
        ModelValidator.validate(softwareSystem, false);
        this.consumeIssuesDelta(softwareSystem);
        eventsToDispatch.forEach(e -> EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(e)));
        this.dispatchEvents(softwareSystem, modificationsForDispatch, createdFiles, modifiedFiles, modifiedAdditionalInfoFiles, reloadedFiles, savedFiles, deletedFiles, createdDirectories, modifiedDirectories, deletedDirectories, originator);
        this.updateScriptOutputStreams(pathModifiedFiles, deletedFiles);
        this.clearDebugInfo();
    }

    private void updateScriptOutputStreams(Map<IModifiableFile, String> pathModifiedFiles, List<IModifiableFile> deletedFiles) {
        assert (pathModifiedFiles != null) : "Parameter 'pathModifiedFiles' of method 'updateScriptOutputStreams' must not be null";
        assert (deletedFiles != null) : "Parameter 'deletedFiles' of method 'updateScriptOutputStreams' must not be null";
        if (!pathModifiedFiles.isEmpty()) {
            HashMap<GroovyScript, String> movedScripts = new HashMap<GroovyScript, String>();
            HashMap<FileBasedRunConfiguration, String> movedRunConfigs = new HashMap<FileBasedRunConfiguration, String>();
            for (Map.Entry entry : pathModifiedFiles.entrySet()) {
                IModifiableFile moved = (IModifiableFile)entry.getKey();
                String previousPath = (String)entry.getValue();
                if (moved instanceof GroovyScript) {
                    movedScripts.put((GroovyScript)moved, previousPath);
                    continue;
                }
                if (!(moved instanceof FileBasedRunConfiguration)) continue;
                movedRunConfigs.put((FileBasedRunConfiguration)moved, previousPath);
            }
            this.m_scriptOutputStreamProvider.renameOutputStreams(movedScripts, movedRunConfigs);
        }
        if (!deletedFiles.isEmpty()) {
            ArrayList<GroovyScript> deletedScripts = new ArrayList<GroovyScript>();
            ArrayList<FileBasedRunConfiguration> deletedRunConfigs = new ArrayList<FileBasedRunConfiguration>();
            for (IModifiableFile iModifiableFile : deletedFiles) {
                if (iModifiableFile instanceof GroovyScript) {
                    deletedScripts.add((GroovyScript)iModifiableFile);
                    continue;
                }
                if (!(iModifiableFile instanceof FileBasedRunConfiguration)) continue;
                deletedRunConfigs.add((FileBasedRunConfiguration)iModifiableFile);
            }
            this.m_scriptOutputStreamProvider.releaseOutputStreams(deletedScripts, deletedRunConfigs);
        }
    }

    @Override
    public void finishModification(IWorkerContext workerContext, SoftwareSystem softwareSystem, EnumSet<Modification> modification, OperationResult result) {
        this.finishModification(workerContext, softwareSystem, modification, null, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishRestore(IWorkerContext workerContext, SoftwareSystem softwareSystem, EnumSet<Modification> modifications, List<IModifiableFile> restoredFiles, INavigationState navigationState, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishRestore' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishRestore' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'finishRestore' must not be null";
        assert (restoredFiles != null) : "Parameter 'restoredFiles' of method 'finishRestore' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishRestore' must not be null";
        EnumSet<Modification> modificationsForDispatch = EnumSet.copyOf(modifications);
        Map<IModifiableFile, String> pathModifiedFiles = null;
        List<IModifiableFile> deletedFiles = null;
        List<IModifiableFile> createdFiles = null;
        ArrayList<SoftwareSystemEvent> eventsToDispatch = new ArrayList<SoftwareSystemEvent>();
        FinishModelProcessor finishModelProcessor = this;
        synchronized (finishModelProcessor) {
            boolean softwareSystemFileOrModifiableModified;
            ModifiableModel model;
            boolean softwareSystemFileRestored = false;
            boolean modifiableModelRestored = false;
            for (IModifiableFile next : restoredFiles) {
                if (next instanceof SoftwareSystemFile) {
                    softwareSystemFileRestored = true;
                }
                if (next instanceof ModifiableModel) {
                    modifiableModelRestored = true;
                }
                if (softwareSystemFileRestored && modifiableModelRestored) break;
            }
            if ((model = this.getModifiableModelNeedingApply(softwareSystem, softwareSystemFileOrModifiableModified = softwareSystemFileRestored || modifiableModelRestored)) != null) {
                model.startApplication(softwareSystemFileOrModifiableModified);
            }
            if (softwareSystemFileRestored) {
                this.m_listeners.forEach(l -> l.finishRestore(workerContext, softwareSystem, result));
            }
            if (softwareSystemFileOrModifiableModified) {
                if (model != null && softwareSystem.isClearable()) {
                    model.applyRefactoringResolutions(workerContext);
                }
                this.performFinishModelModification(workerContext, softwareSystem, null, result);
                this.m_listeners.forEach(l -> l.componentModelModified(workerContext, softwareSystem, false));
                this.m_modelModificationInfo.physicalModelModified();
            }
            if (model != null) {
                model.applyNonRefactoringResolutions(workerContext, !softwareSystemFileOrModifiableModified);
                model.finishApplication(workerContext);
            }
            this.notifyModelModificationFinished(workerContext, softwareSystem, modificationsForDispatch, eventsToDispatch, restoredFiles, navigationState);
            Files files = softwareSystem.getUniqueExistingChild(Files.class);
            pathModifiedFiles = files.consumePathModifiedModifiableFiles();
            deletedFiles = files.consumeDeletedModifiableFiles();
            createdFiles = files.consumeCreatedModifiableFiles();
            softwareSystem.getUniqueExistingChild(Files.class).consumeAllModifiablePaths();
        }
        TransactionContext currentTransactionContext = this.m_transactionContexts.peek();
        if (currentTransactionContext != null) {
            currentTransactionContext.setSoftwareSystem(softwareSystem);
            if (createdFiles != null && !createdFiles.isEmpty()) {
                currentTransactionContext.addCreatedFiles(createdFiles);
            }
        }
        ModelValidator.validate(softwareSystem, false);
        this.consumeIssuesDelta(softwareSystem);
        eventsToDispatch.forEach(e -> EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(e)));
        ISoftwareSystemProvider provider = softwareSystem.getExtension(ISoftwareSystemProvider.class);
        if (!modificationsForDispatch.isEmpty()) {
            EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(new SoftwareSystemModifiedEvent(provider, modificationsForDispatch, true)));
        }
        if (!restoredFiles.isEmpty()) {
            MultipleModifiableFileModifiedEvent event = new MultipleModifiableFileModifiedEvent(provider, navigationState);
            restoredFiles.forEach(modifiableFile -> event.add((IModifiableFile)modifiableFile));
            EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(event));
        }
        assert (pathModifiedFiles != null) : "'pathModifiedFiles' of method 'finishRestore' must not be null";
        assert (deletedFiles != null) : "'name' of method 'finishRestore' must not be null";
        this.updateScriptOutputStreams(pathModifiedFiles, deletedFiles);
        this.clearDebugInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishModification(SoftwareSystem softwareSystem, EnumSet<Modification> modifications) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishModification' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'finishModification' must not be null";
        EnumSet<Modification> modificationsForDispatch = EnumSet.copyOf(modifications);
        Files files = softwareSystem.getUniqueExistingChild(Files.class);
        List<IModifiableFile> additionalInformationModifiedFiles = null;
        ArrayList<SoftwareSystemEvent> eventsToDispatch = new ArrayList<SoftwareSystemEvent>();
        FinishModelProcessor finishModelProcessor = this;
        synchronized (finishModelProcessor) {
            this.notifyModelModificationFinished((IWorkerContext)DefaultWorkerContext.INSTANCE, softwareSystem, modificationsForDispatch, eventsToDispatch, null, null);
            additionalInformationModifiedFiles = files.consumeAdditionalInformationModifiedModifiableFiles();
        }
        assert (additionalInformationModifiedFiles != null) : "'additionalInformationModifiedFiles' of method 'finishModification' must not be null";
        ModelValidator.validate(softwareSystem, false);
        this.consumeIssuesDelta(softwareSystem);
        eventsToDispatch.forEach(e -> EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(e)));
        if (!modificationsForDispatch.isEmpty() || !additionalInformationModifiedFiles.isEmpty()) {
            ISoftwareSystemProvider provider = softwareSystem.getExtension(ISoftwareSystemProvider.class);
            if (!modificationsForDispatch.isEmpty()) {
                EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(new SoftwareSystemModifiedEvent(provider, modificationsForDispatch)));
            }
            if (!additionalInformationModifiedFiles.isEmpty()) {
                MultipleModifiableFileModifiedEvent event = new MultipleModifiableFileModifiedEvent(provider);
                additionalInformationModifiedFiles.forEach(a -> event.add((IModifiableFile)a, null, EnumSet.of(MultipleModifiableFileModifiedEvent.Aspect.ADDITIONAL_INFO_MODIFIED)));
                EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(event));
            }
        }
        this.clearDebugInfo();
    }

    @Override
    public void finishAnalyzerConfigurationChanged(IWorkerContext workerContext, AnalyzerConfigurationChangeMode mode, AnalyzerConfiguration configuration, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'analyzerConfigurationChanged' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'analyzerConfigurationChanged' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'analyzerConfigurationChanged' must not be null";
        assert (result != null) : "Parameter 'result' of method 'analyzerConfigurationChanged' must not be null";
        this.m_listeners.forEach(l -> l.analyzerConfigurationChanged(workerContext, mode, configuration, modifications, result));
    }

    @Override
    public void analyzersReset(Set<IAnalyzerId> analyzerIds) {
        assert (analyzerIds != null && !analyzerIds.isEmpty()) : "Parameter 'analyzerIds' of method 'analyzersReset' must not be empty";
        this.m_listeners.forEach(l -> l.analyzersReset(analyzerIds));
    }

    @Override
    public void finishAnalyzersReset(SoftwareSystem softwareSystem, Set<IAnalyzerId> analyzerIds, boolean onSystemClose) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'resetAnalyzers' must not be null";
        this.consumeIssuesDelta(softwareSystem);
        ArrayList eventsToDispatch = new ArrayList();
        this.m_listeners.forEach(l -> l.finishAnalyzersReset(softwareSystem, analyzerIds, onSystemClose, eventsToDispatch));
        eventsToDispatch.forEach(e -> EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(e)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishAnalyzerFinished(SoftwareSystem softwareSystem, IAnalyzerId analyzerId, boolean metricValuesAdded, boolean metricDescriptorAdded, boolean allFinished) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishAnalyzer' must not be null";
        if (allFinished) {
            this.m_listeners.forEach(l -> l.analyzersFinished(softwareSystem));
        }
        EnumSet<AnalyzerModificationEvent.AnalyzerModification> modificationForDispatch = EnumSet.noneOf(AnalyzerModificationEvent.AnalyzerModification.class);
        ArrayList<SoftwareSystemEvent> eventsToDispatch = new ArrayList<SoftwareSystemEvent>();
        boolean issuesModified = false;
        FinishModelProcessor finishModelProcessor = this;
        synchronized (finishModelProcessor) {
            issuesModified = softwareSystem.getCurrentModel().haveIssuesBeenModified();
            if (issuesModified || metricValuesAdded || metricDescriptorAdded) {
                if (issuesModified) {
                    modificationForDispatch.add(AnalyzerModificationEvent.AnalyzerModification.ISSUE_MODIFIED);
                }
                if (metricValuesAdded) {
                    modificationForDispatch.add(AnalyzerModificationEvent.AnalyzerModification.METRIC_VALUE_ADDED);
                }
                if (metricDescriptorAdded) {
                    modificationForDispatch.add(AnalyzerModificationEvent.AnalyzerModification.METRIC_DESCRIPTOR_ADDED);
                }
            }
        }
        if (analyzerId != null) {
            for (ISoftwareSystemLifecycleListener nextListener : this.m_listeners) {
                nextListener.analyzerFinished(softwareSystem, analyzerId, issuesModified, metricValuesAdded, metricDescriptorAdded, eventsToDispatch);
            }
        }
        this.consumeIssuesDelta(softwareSystem);
        if (!eventsToDispatch.isEmpty() || !modificationForDispatch.isEmpty()) {
            eventsToDispatch.forEach(e -> EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(e)));
            if (!modificationForDispatch.isEmpty()) {
                ISoftwareSystemProvider provider = softwareSystem.getExtension(ISoftwareSystemProvider.class);
                EventManager.getInstance().dispatch((Object)this, (Event)this.addDebugInfo(new AnalyzerModificationEvent(provider, modificationForDispatch, analyzerId)));
            }
        }
        this.clearDebugInfo();
    }

    @Override
    public synchronized void addDebugInfo(String info) {
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'addDebugInfo' must not be empty";
        if (this.m_debugInfo == null) {
            this.m_debugInfo = new LinkedHashSet<String>();
        }
        this.m_debugInfo.add(info);
    }

    private synchronized <T extends Event> T addDebugInfo(T event) {
        assert (event != null) : "Parameter 'event' of method 'addDebugInfo' must not be null";
        if (this.m_debugInfo != null && !this.m_debugInfo.isEmpty()) {
            event.addDebugInfo(this.m_debugInfo);
        }
        return event;
    }

    private synchronized void clearDebugInfo() {
        if (this.m_debugInfo != null && !this.m_debugInfo.isEmpty()) {
            this.m_debugInfo.clear();
        }
    }

    private void updateTransactionContext(SoftwareSystem softwareSystem, EnumSet<Modification> modifications, List<IModifiableFile> modifiedFiles, List<IModifiableFile> savedFiles, List<IModifiableFile> createdFiles, List<IModifiableFile> deletedFiles, List<IModifiableFile> reloadedFiles, NeedsReparse needsReparseFlagModification, TransactionContext.ModelFinishedMode mode) {
        TransactionContext currentTransactionContext = this.m_transactionContexts.peek();
        if (currentTransactionContext != null) {
            TransactionContextUpdater.update(currentTransactionContext, softwareSystem, modifications, modifiedFiles, savedFiles, createdFiles, deletedFiles, reloadedFiles, needsReparseFlagModification, mode, LOGGER.isTraceEnabled());
        }
    }

    @Override
    public synchronized long startTransaction(String name, boolean invalidatesParserModel, INavigationState navigationState, TransactionType transactionType) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'startTransaction' must not be empty";
        assert (transactionType != null) : "Parameter 'transactionType' of method 'startTransaction' must not be null";
        LOGGER.debug("Start transaction: " + name);
        TransactionContext transactionContext = new TransactionContext(name, invalidatesParserModel, navigationState, transactionType, this.m_txCounter++);
        this.m_transactionContexts.push(transactionContext);
        return transactionContext.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult finishTransaction(String name) {
        SoftwareSystem softwareSystem;
        TransactionContext transactionContext;
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'finishTransaction' must not be empty";
        assert (!this.m_transactionContexts.isEmpty()) : "No transaction running for method 'finishTransaction'";
        FinishModelProcessor finishModelProcessor = this;
        synchronized (finishModelProcessor) {
            transactionContext = this.m_transactionContexts.pop();
            assert (transactionContext.getName().equals(name)) : "transaction name mismatch: " + transactionContext.getName() + "/" + name;
            softwareSystem = transactionContext.getSoftwareSystem();
        }
        OperationResult result = new OperationResult("Finish transaction '" + name + "'");
        TransactionType transactionType = transactionContext.getTransactionType();
        if (softwareSystem != null) {
            LOGGER.debug("Transaction finished '" + transactionContext.getName() + "' [" + String.valueOf((Object)transactionType) + "]");
            this.m_listeners.forEach(l -> l.transactionFinished(softwareSystem, transactionContext, result));
        } else if (transactionType == TransactionType.UNDOABLE) {
            LOGGER.error("Transaction finished '" + name + "' [" + String.valueOf((Object)transactionType) + "] - there is no attached software system!");
        }
        return result;
    }

    @Override
    public void cancelTransaction() {
        assert (!this.m_transactionContexts.isEmpty()) : "No transaction running for method 'cancelTransaction'";
        TransactionContext currentTransactionContext = this.m_transactionContexts.pop();
        LOGGER.warn("Transaction cancelled - context removed without processing: " + currentTransactionContext.toString());
        SoftwareSystem softwareSystem = currentTransactionContext.getSoftwareSystem();
        if (softwareSystem != null) {
            softwareSystem.getUniqueExistingChild(Files.class).consumeAllModifiablePaths();
        }
    }

    @Override
    public TransactionContext createTxContextForFileHistoryInitialization() {
        return new TransactionContext("Initial state creation", false, null, TransactionType.UNDOABLE, this.m_txCounter++);
    }
}

