/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.ArchitectureProvider;
import com.hello2morrow.sonargraph.core.controller.system.representation.AssignedElementMatcher;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureBaseElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.DirectoryFragmentComponentContainer;
import com.hello2morrow.sonargraph.core.model.architecture.ElementAssignmentInfo;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureAssignmentElement;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedElements;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedExternal;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedInternal;
import com.hello2morrow.sonargraph.core.model.architecture.WorkspaceRootComponentContainer;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.IElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemNamespace;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.NamespaceUtility;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class ArchitectureTestSupport {
    private ArchitectureTestSupport() {
    }

    private static void collectAssignmentInfo(ElementAssignmentInfo info, ArchitectureFile architecture) {
        assert (info != null) : "Parameter 'info' of method 'collectAssignmentInfo' must not be null";
        assert (architecture != null) : "Parameter 'architecture' of method 'collectAssignmentInfo' must not be null";
        assert (architecture.isChecked()) : "architecture '" + architecture.getShortName() + "' must be checked!";
        for (Artifact nextArtifact : architecture.getChildren(Artifact.class)) {
            if (!ArchitectureProvider.findArtifact(info, nextArtifact)) continue;
            return;
        }
        if (info.getAssignable().isExternal()) {
            info.add(architecture.getUniqueExistingChild(UnassignedExternal.class));
        } else {
            info.add(architecture.getUniqueExistingChild(UnassignedInternal.class));
        }
    }

    private static IArchitectureAssignmentElement getAssignmentElement(IAssignableToArtifact assignable, ArchitectureBaseElement baseElement, IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        IAssignableToArtifact assignableToUse;
        assert (assignable != null) : "Parameter 'assignable' of method 'getAssinmentElement' must not be null";
        assert (baseElement != null) : "Parameter 'baseElement' of method 'getAssinmentElement' must not be null";
        assert (architectureModel != null) : "Parameter 'architectureModel' of method 'getAssignmentElement' must not be null";
        if (architectureModel == IArchitecturalModelProvider.ArchitectureModel.PHYSICAL && assignable instanceof LogicalModuleProgrammingElement) {
            NamedElement compilationUnit = ((LogicalModuleProgrammingElement)assignable).getPrimaryProgrammingElement().getParent();
            assert (compilationUnit instanceof IComponent) : "Unexpected class '" + compilationUnit.getClass().getCanonicalName();
            assignableToUse = (IComponent)((Object)compilationUnit);
        } else {
            assignableToUse = assignable;
        }
        AssignedElementMatcher matcher = new AssignedElementMatcher(baseElement, assignableToUse);
        baseElement.accept(matcher);
        return matcher.getMatchingAssignedComponent();
    }

    private static List<ElementAssignmentInfo> getAssignmentInfo(SoftwareSystem softwareSystem, final IElement element, Collection<ProgrammingElement> endpoints, ArchitectureFile architectureFile) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getAssignmentInfo' must not be null";
        assert (element != null) : "Parameter 'element' of method 'getAssignmentInfo' must not be null";
        assert (endpoints != null) : "Parameter 'endpoints' of method 'getAssignmentInfo' must not be null";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'getAssignmentInfo' must not be null";
        if (element instanceof IComponent) {
            IComponent component = (IComponent)element;
            if (!component.isExcluded() && !component.getNamedElement().getRefactoringState().hasBeenDeleted() && (endpoints.isEmpty() || endpoints.stream().anyMatch(e -> e.getParent(IComponent.class, ParentMode.FIRST_PARENT) == component))) {
                ElementAssignmentInfo info = new ElementAssignmentInfo(component, architectureFile.getModel());
                ArchitectureTestSupport.collectAssignmentInfo(info, architectureFile);
                assert (!info.isEmpty()) : "assignmentInfo for " + String.valueOf(element) + " in architecture " + architectureFile.getShortName() + " must not be empty!";
                return Arrays.asList(info);
            }
        } else if (element instanceof LogicalModuleProgrammingElement) {
            LogicalModuleProgrammingElement lpe = (LogicalModuleProgrammingElement)element;
            if (!(lpe.isExcluded() || lpe.getNamedElement().getRefactoringState().hasBeenDeleted() || lpe.getParent() instanceof LogicalModuleProgrammingElement)) {
                if (architectureFile.getModel() == IArchitecturalModelProvider.ArchitectureModel.PHYSICAL) {
                    IAssignableToArtifact assignable = lpe.getPrimaryProgrammingElement().getParent(IComponent.class, ParentMode.FIRST_PARENT);
                    return ArchitectureTestSupport.getAssignmentInfo(softwareSystem, assignable, endpoints, architectureFile);
                }
                if (endpoints.isEmpty() || endpoints.contains(lpe.getPrimaryProgrammingElement())) {
                    LogicalModuleProgrammingElement assignable = lpe;
                    ElementAssignmentInfo elementAssignmentInfo = new ElementAssignmentInfo(assignable, architectureFile.getModel());
                    ArchitectureTestSupport.collectAssignmentInfo(elementAssignmentInfo, architectureFile);
                    assert (!elementAssignmentInfo.isEmpty()) : "assignmentInfo for " + String.valueOf(element) + " in architecture " + architectureFile.getShortName() + " must not be empty!";
                    return Arrays.asList(elementAssignmentInfo);
                }
            }
        } else if (element instanceof LogicalModuleNamespace) {
            ArrayList<ElementAssignmentInfo> result = new ArrayList<ElementAssignmentInfo>();
            LogicalModuleNamespace namespace = (LogicalModuleNamespace)element;
            if (!namespace.isExcluded() && !namespace.getNamedElement().getRefactoringState().hasBeenDeleted()) {
                for (Element element2 : namespace.getNamedElement().getChildren(LogicalModuleProgrammingElement.class)) {
                    result.addAll(ArchitectureTestSupport.getAssignmentInfo(softwareSystem, element2, endpoints, architectureFile));
                }
                return result;
            }
        } else {
            if (element instanceof LogicalSystemNamespace) {
                ArrayList<ElementAssignmentInfo> result = new ArrayList<ElementAssignmentInfo>();
                LogicalSystemNamespace systemNamespace = (LogicalSystemNamespace)element;
                ArrayList arrayList = new ArrayList();
                systemNamespace.getRepresentativeSourceNamespaces().forEach(sourceNs -> {
                    boolean bl = moduleNamespaces.add(sourceNs.getModuleNamespace());
                });
                for (Element next : arrayList) {
                    result.addAll(ArchitectureTestSupport.getAssignmentInfo(softwareSystem, next, endpoints, architectureFile));
                }
                return result;
            }
            if (element instanceof DirectoryFragment) {
                DirectoryFragment directory = (DirectoryFragment)element;
                if (!directory.isExcluded() && !directory.getNamedElement().getRefactoringState().hasBeenDeleted()) {
                    ArrayList<ElementAssignmentInfo> result = new ArrayList<ElementAssignmentInfo>();
                    for (Element element3 : directory.getChildren(IComponent.class).stream().map(c -> (Element)((Object)c)).collect(Collectors.toList())) {
                        result.addAll(ArchitectureTestSupport.getAssignmentInfo(softwareSystem, element3, endpoints, architectureFile));
                    }
                    return result;
                }
            } else if (element instanceof Module) {
                Module module = (Module)element;
                ArrayList<ElementAssignmentInfo> result = new ArrayList<ElementAssignmentInfo>();
                if (architectureFile.getModel() == IArchitecturalModelProvider.ArchitectureModel.PHYSICAL) {
                    List list = module.getChildrenRecursively(IComponent.class, IComponent.class).stream().map(c -> (Element)((Object)c)).collect(Collectors.toList());
                    for (Element next : list) {
                        result.addAll(ArchitectureTestSupport.getAssignmentInfo(softwareSystem, next, endpoints, architectureFile));
                    }
                } else {
                    LogicalModuleNamespaces logicalModuleNamespaces = softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class);
                    ModuleBasedLogicalNamespaceRoot moduleNamespaceRoot = logicalModuleNamespaces.getUniqueChild(new NamedElement.IFilter(){

                        @Override
                        public boolean accept(NamedElement namedElement) {
                            return namedElement instanceof ModuleBasedLogicalNamespaceRoot && ((ModuleBasedLogicalNamespaceRoot)namedElement).getPhysicalElement() == element;
                        }
                    }, ModuleBasedLogicalNamespaceRoot.class);
                    assert (moduleNamespaceRoot != null) : "moduleNamespaceRoot for " + module.getName() + " must exist";
                    List assignables = moduleNamespaceRoot.getChildrenRecursively(LogicalModuleProgrammingElement.class, LogicalModuleProgrammingElement.class).stream().map(c -> c).collect(Collectors.toList());
                    for (Element next : assignables) {
                        result.addAll(ArchitectureTestSupport.getAssignmentInfo(softwareSystem, next, endpoints, architectureFile));
                    }
                }
                return result;
            }
        }
        return Collections.emptyList();
    }

    public static List<NamedElement> getArchitectureAssignmentElements(SoftwareSystem softwareSystem, List<IElement> elements, Set<ProgrammingElement> endpoints, ArchitectureFile architectureFile) {
        List<IElement> elementsToUse;
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getArchitectureAssignmentElements' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getArchitectureAssignmentElements' must not be empty";
        assert (endpoints != null) : "Parameter 'endpoints' of method 'getArchitectureAssignmentElements' must not be null";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'getArchitectureAssignmentElements' must not be null";
        assert (architectureFile.isChecked()) : "Not a checked architecture: " + architectureFile.getAbsolutePath();
        HashSet<IElement> originalElementsAsSet = new HashSet<IElement>(elements);
        if (architectureFile.getModel() == IArchitecturalModelProvider.ArchitectureModel.PHYSICAL) {
            elementsToUse = elements;
        } else {
            HashSet<LogicalProgrammingElement> logicalProgrammingElements = new HashSet<LogicalProgrammingElement>();
            elementsToUse = new ArrayList<IElement>();
            for (IElement next : elements) {
                NamedElement nextNamedElement = null;
                if (next instanceof IComponent) {
                    nextNamedElement = ((IComponent)next).getNamedElement();
                }
                if (next instanceof IDirectoryPath) {
                    nextNamedElement = ((IDirectoryPath)((Object)next)).getNamedElement();
                }
                if (nextNamedElement != null) {
                    for (ProgrammingElement nextProgrammingElement : nextNamedElement.getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                        LogicalProgrammingElement nextLogicalProgrammingElement;
                        if (!endpoints.isEmpty() && !endpoints.contains(nextProgrammingElement) || (nextLogicalProgrammingElement = NamespaceUtility.getLogicalProgrammingElement(nextProgrammingElement, false)) == null || !logicalProgrammingElements.add(nextLogicalProgrammingElement)) continue;
                        elementsToUse.add(nextLogicalProgrammingElement);
                    }
                    continue;
                }
                elementsToUse.add(next);
            }
        }
        LinkedHashSet<NamedElement> mappedElements = new LinkedHashSet<NamedElement>();
        for (IElement next : elementsToUse) {
            if (next.isExcluded()) {
                return Collections.emptyList();
            }
            List<ElementAssignmentInfo> assignmentInfos = ArchitectureTestSupport.getAssignmentInfo(softwareSystem, next, endpoints, architectureFile);
            for (ElementAssignmentInfo nextInfo : assignmentInfos) {
                IArchitectureAssignmentElement assignmentElement;
                Optional<Artifact> artifactMatch = nextInfo.getElements().stream().filter(e -> e instanceof Artifact).map(e -> (Artifact)e).findFirst();
                if (artifactMatch.isPresent()) {
                    Artifact artifact = artifactMatch.get();
                    assignmentElement = ArchitectureTestSupport.getAssignmentElement(nextInfo.getAssignable(), artifact, architectureFile.getModel());
                    assert (assignmentElement != null) : "No match for element " + String.valueOf(next) + " found in architecture " + String.valueOf(architectureFile);
                } else {
                    Optional<UnassignedElements> unassignedMatch = nextInfo.getElements().stream().filter(e -> e instanceof UnassignedElements).map(e -> (UnassignedElements)e).findFirst();
                    assert (unassignedMatch.isPresent()) : "No UnassignedElements class found for element " + String.valueOf(next) + " for architecture " + String.valueOf(architectureFile);
                    UnassignedElements unassigned = unassignedMatch.get();
                    assignmentElement = ArchitectureTestSupport.getAssignmentElement(nextInfo.getAssignable(), unassigned, architectureFile.getModel());
                }
                assert (assignmentElement != null) : "no architectureAssignmentElement found for " + String.valueOf(next);
                if (next instanceof IComponent) {
                    mappedElements.add(assignmentElement.getNamedElement());
                    continue;
                }
                if (next instanceof Module) {
                    mappedElements.add(assignmentElement.getNamedElement().getParent(WorkspaceRootComponentContainer.class, new Class[0]));
                    continue;
                }
                if (next instanceof DirectoryFragment) {
                    mappedElements.add(assignmentElement.getNamedElement().getParent(DirectoryFragmentComponentContainer.class, new Class[0]));
                    continue;
                }
                if (originalElementsAsSet.contains(next)) {
                    mappedElements.add(assignmentElement.getNamedElement().getParent());
                    continue;
                }
                mappedElements.add(assignmentElement.getNamedElement());
            }
        }
        return new ArrayList<NamedElement>(mappedElements);
    }
}

