/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.base.IIssueParticipationProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.IMetricAwareLanguageProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerJobElement;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.IAnalyzerJob;
import com.hello2morrow.sonargraph.core.model.common.BackgroundTaskException;
import com.hello2morrow.sonargraph.core.model.event.ExceptionEvent;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.IAnalyzerProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.Activity;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AnalyzerProvider
extends Extension
implements IAnalyzerProvider,
IAnalyzerController,
IIssueParticipationProvider {
    private final Map<AnalyzerJobElement, Integer> m_jobProgress = new HashMap<AnalyzerJobElement, Integer>();
    private final Map<AnalyzerResult, Integer> m_resultProgress = new ConcurrentHashMap<AnalyzerResult, Integer>();
    private final LanguageProviderAccessor m_languageProviderAccessor;
    private final SoftwareSystem m_softwareSystem;
    private final Installation m_installation;

    public AnalyzerProvider(LanguageProviderAccessor accessor, Installation installation, SoftwareSystem softwareSystem) {
        assert (accessor != null) : "Parameter 'accessor' of method 'AnalyzerProvider' must not be null";
        assert (installation != null) : "Parameter 'installation' of method 'AnalyzerProvider' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'AnalyzerProvider' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_installation = installation;
        this.m_languageProviderAccessor = accessor;
    }

    @Override
    public final IMetricAwareLanguageProvider getLanguageProvider(Language language) {
        assert (language != null) : "Parameter 'language' of method 'getLanguageProvider' must not be null";
        return this.m_languageProviderAccessor.getLanguageProvider(language);
    }

    @Override
    public Language getLanguageByName(String standardName) {
        return this.m_languageProviderAccessor.getLanguage(standardName);
    }

    @Override
    public final Collection<? extends IMetricAwareLanguageProvider> getUsedLanguageProviders() {
        return this.m_languageProviderAccessor.getLanguageProviders(this.m_softwareSystem.getUsedLanguages());
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.m_languageProviderAccessor.getClassLoader();
    }

    protected final LanguageProviderAccessor getLanguageProviderAccessor() {
        return this.m_languageProviderAccessor;
    }

    @Override
    public final SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    @Override
    public final Installation getInstallation() {
        return this.m_installation;
    }

    protected final void resetAnalyzerProgress() {
        this.m_jobProgress.clear();
        this.m_resultProgress.clear();
    }

    @Override
    public final int getProgress(AnalyzerResult analyzerResult) {
        assert (analyzerResult != null) : "Parameter 'analyzerResult' of method 'getProgress' must not be null";
        Integer progress = this.m_resultProgress.get(analyzerResult);
        return progress != null ? progress : 0;
    }

    @Override
    public final void handleJobActivity(IAnalyzerJob job, Activity activity) {
        assert (job != null) : "Parameter 'job' of method 'handleJobActivity' must not be null";
        assert (activity != null) : "Parameter 'activity' of method 'handleJobActivity' must not be null";
        this.m_jobProgress.put(job.getElement(), activity.getWorkedInPercent());
        int totalWorked = 0;
        int count = 0;
        for (AnalyzerJobElement jobElement : job.getResult().getChildren(AnalyzerJobElement.class)) {
            Integer progress = this.m_jobProgress.get(jobElement);
            if (progress != null) {
                totalWorked += progress.intValue();
            }
            ++count;
        }
        if (count > 0) {
            this.m_resultProgress.put(job.getResult(), totalWorked / count);
        }
    }

    @Override
    public final void uncaughtException(Thread thread, Throwable throwable) {
        assert (thread != null) : "Parameter 'thread' of method 'uncaughtException' must not be null";
        assert (throwable != null) : "Parameter 'throwable' of method 'uncaughtException' must not be null";
        EventManager.getInstance().dispatch((Object)this, (Event)new ExceptionEvent(this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class), new BackgroundTaskException("Exception caught during analyzer execution in thread: " + thread.getName(), throwable)));
    }

    @Override
    public final void exceptionCaught(String context, Throwable throwable) {
        assert (context != null && context.length() > 0) : "Parameter 'context' of method 'exceptionCaught' must not be empty";
        assert (throwable != null) : "Parameter 'throwable' of method 'exceptionCaught' must not be null";
        EventManager.getInstance().dispatch((Object)this, (Event)new ExceptionEvent(this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class), new BackgroundTaskException("Exception caught in analyzer execution: " + context, throwable)));
    }
}

