/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.script;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IGroovyExtension;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.RunConfigurationParameters;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class CreateGroovyScriptRunConfigurationCommand
extends SoftwareSystemBasedCommand<ICreateRunConfigurationInteraction> {
    public CreateGroovyScriptRunConfigurationCommand(ISoftwareSystemProvider provider, ICreateRunConfigurationInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_GROOVY_SCRIPT_RUN_CONFIGURATION;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        CreateRunConfigurationData data = new CreateRunConfigurationData();
        if (!((ICreateRunConfigurationInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        OperationResult result = this.getController().getSoftwareSystem().getExtension(IGroovyExtension.class).createRunConfiguration(workerContext, data.getScript(), data.getName(), data.getDescription(), data.getRunConfigurationParameters());
        ((ICreateRunConfigurationInteraction)this.getInteraction()).processCreationResult(result);
    }

    public static final class CreateRunConfigurationData
    implements ICommandInteractionData {
        private GroovyScript m_script;
        private String m_name = "";
        private String m_description = "";
        private RunConfigurationParameters m_parameters = new RunConfigurationParameters();

        public void setScript(GroovyScript script) {
            assert (script != null) : "Parameter 'script' of method 'setScript' must not be null";
            this.m_script = script;
        }

        public GroovyScript getScript() {
            return this.m_script;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        String getName() {
            return this.m_name;
        }

        public void setDescription(String description) {
            this.m_description = description;
        }

        String getDescription() {
            return this.m_description;
        }

        public RunConfigurationParameters getRunConfigurationParameters() {
            return this.m_parameters;
        }

        public void setRunConfigurationParameters(RunConfigurationParameters parameters) {
            this.m_parameters = parameters;
        }
    }

    public static interface ICreateRunConfigurationInteraction
    extends ICommandInteraction {
        public boolean collect(CreateRunConfigurationData var1);

        public void processCreationResult(OperationResult var1);
    }
}

