/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewRepresentationData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class SetPresentationModeCommand
extends ArchitecturalViewCommand<ISetPresentationModeInteraction> {
    public SetPresentationModeCommand(ISoftwareSystemProvider provider, ISetPresentationModeInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.SET_ARCHITECTURAL_VIEW_PRESENTATION_MODE;
    }

    @Override
    protected String getCommandName() {
        return "Set Presentation Mode";
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public boolean providesProgress() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        SetPresentationModeData data = new SetPresentationModeData();
        if (!((ISetPresentationModeInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        OperationResult result = extension.setPresentationMode(workerContext, data.getRepresentation(), data.getPresentationMode());
        ((ISetPresentationModeInteraction)this.getInteraction()).processSetPresentationModeResult(result);
    }

    public static interface ISetPresentationModeInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(SetPresentationModeData var1);

        public void processSetPresentationModeResult(OperationResult var1);
    }

    public static final class SetPresentationModeData
    extends ArchitecturalViewRepresentationData {
        private PresentationMode m_presentationMode;

        public void setPresentationMode(PresentationMode presentationMode) {
            assert (presentationMode != null) : "Parameter 'presentationMode' of method 'setPresentationMode' must not be null";
            this.m_presentationMode = presentationMode;
        }

        PresentationMode getPresentationMode() {
            assert (this.m_presentationMode != null) : "'m_presentationMode' of method 'getPresentationMode' must not be null";
            return this.m_presentationMode;
        }
    }
}

