/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArtifactPropertiesData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class EditArtifactsCommand
extends ArchitecturalViewCommand<IEditArtifactsInteraction> {
    public EditArtifactsCommand(ISoftwareSystemProvider provider, IEditArtifactsInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EDIT_ARCHITECTURAL_VIEW_ARTIFACTS;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        EditArtifactsData data = new EditArtifactsData();
        if (!((IEditArtifactsInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        OperationResult result = extension.editArtifacts(workerContext, data.getArtifacts(), data.getTargetInfo(), data.getArtifactProperties());
        ((IEditArtifactsInteraction)this.getInteraction()).processEditArtifactsResult(result);
    }

    public static final class EditArtifactsData
    extends ArtifactPropertiesData {
        private List<ArtifactNode> m_artifacts;

        public void setArtifacts(List<ArtifactNode> artifacts) {
            assert (artifacts != null && !artifacts.isEmpty()) : "Parameter 'artifacts' of method 'setArtifacts' must not be empty";
            this.m_artifacts = new ArrayList<ArtifactNode>(artifacts);
        }

        List<ArtifactNode> getArtifacts() {
            assert (this.m_artifacts != null && !this.m_artifacts.isEmpty()) : "Parameter 'm_artifacts' of method 'getArtifacts' must not be empty";
            return Collections.unmodifiableList(this.m_artifacts);
        }
    }

    public static interface IEditArtifactsInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(EditArtifactsData var1);

        public void processEditArtifactsResult(OperationResult var1);
    }
}

