/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DeleteDependenciesCommand
extends ArchitecturalViewCommand<IDeleteDependenciesInteraction> {
    public DeleteDependenciesCommand(ISoftwareSystemProvider provider, IDeleteDependenciesInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.DELETE_ARCHITECTURAL_VIEW_DEPENDENCIES;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        DependenciesData data = new DependenciesData();
        if (!((IDeleteDependenciesInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        OperationResult result = extension.deleteDependencies(workerContext, data.getDependencies());
        ((IDeleteDependenciesInteraction)this.getInteraction()).processDeleteDependenciesResult(result);
    }

    public static final class DependenciesData
    implements IArchitecturalViewCommandInteractionData {
        private List<ArchitecturalViewNode.ArchitecturalViewDependency> m_dependencies;

        DependenciesData() {
        }

        public void setDependencies(List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
            assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'setDependencies' must not be empty";
            this.m_dependencies = new ArrayList<ArchitecturalViewNode.ArchitecturalViewDependency>(dependencies);
        }

        List<ArchitecturalViewNode.ArchitecturalViewDependency> getDependencies() {
            assert (this.m_dependencies != null) : "Parameter 'm_dependencies' of method 'getDependencies' must not be null";
            return Collections.unmodifiableList(this.m_dependencies);
        }
    }

    public static interface IDeleteDependenciesInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(DependenciesData var1);

        public void processDeleteDependenciesResult(OperationResult var1);
    }
}

